/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.StringUtil;

public class Camera
extends Component
implements Runnable,
PlayerListener {
    private static int cameraPermission;
    private int defaultCaptureHeight = 480;
    private int defaultCaptureWidth = 640;
    private int[][] knownEncodingDimensions = new int[][]{{640, 480}, {480, 640}};
    private String[] knownEncodingFormats = new String[]{"jpeg", "jpg", "png", "gif", "bmp"};
    private Font font;
    private String waitingMessage = "";
    private int waitingMessageLength;
    private String snapshotEncoding;
    private String snapshotFileExt;
    private String playerLocator;
    private Thread cameraThread;
    private byte[] photoData;
    private boolean requestCapture;
    private final Object uiLock = new Object();
    private boolean running = true;
    private VideoControl videoCtrl;
    private Player player;
    private ActionListener actionListener;
    private String actionCommand;
    private boolean seBug = true;
    private static final String CAPTURE_ENCODING_STRING_RECORD_STORE = "cap_enc_str_rs";

    public Camera() {
        Logger.debug("CameraPanel() constructor");
        this.focusable = true;
        this.font = this.theme.getFont(0);
    }

    protected String getDefaultName() {
        return "Camera";
    }

    protected void workoutMinimumSize() {
        this.width = 10;
        this.height = 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics2D g) {
        Logger.debug("paintComponent: " + this.getWidth() + "x" + this.getHeight());
        int msgPosX = this.getWidth() / 2 - this.waitingMessageLength / 2;
        int msgPosY = this.getHeight() / 2 - this.font.getHeight() / 2;
        g.setColor(this.getForeground());
        g.drawString(this.waitingMessage, msgPosX, msgPosY);
        if (this.running) {
            if (this.cameraThread == null) {
                this.cameraThread = new Thread(this);
                this.cameraThread.start();
            } else {
                Object object = this.uiLock;
                synchronized (object) {
                    this.uiLock.notifyAll();
                }
            }
        }
    }

    public void setWaitingMessage(String message) {
        this.waitingMessage = message;
        this.waitingMessageLength = this.font.getWidth(this.waitingMessage);
    }

    public void focusGained() {
        this.running = true;
        super.focusGained();
    }

    public boolean processKeyEvent(KeyEvent keypad) {
        int keycode = keypad.getJustPressedKey();
        if (this.actionListener != null && (keycode == -24 || keycode == -25 || keycode == -26)) {
            this.capture();
            return true;
        }
        return false;
    }

    public void close() {
        if (!this.running) {
            return;
        }
        this.cameraThread = null;
        this.running = false;
        this.closePlayer();
    }

    public void setActionListener(ActionListener l) {
        this.actionListener = l;
    }

    public void setActionCommand(String ac) {
        this.actionCommand = ac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void capture() {
        Object object = this.uiLock;
        synchronized (object) {
            this.requestCapture = true;
            this.uiLock.notifyAll();
        }
    }

    public byte[] getSnapshotData() {
        byte[] res = this.photoData;
        this.photoData = null;
        return res;
    }

    public int getSnapshotWidth() {
        return Camera.getEncodingParameterInteger(this.snapshotEncoding, "width");
    }

    public int getSnapshotHeight() {
        return Camera.getEncodingParameterInteger(this.snapshotEncoding, "height");
    }

    public String getFileExtention() {
        return this.snapshotFileExt;
    }

    public void setDefaultCaptureResolution(int width, int height) {
        this.defaultCaptureHeight = height;
        this.defaultCaptureWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                Object object = this.uiLock;
                synchronized (object) {
                    if (Thread.currentThread() != this.cameraThread) {
                        break;
                    }
                    this.uiLock.wait(1000L);
                }
                if (this.player == null) {
                    Thread.yield();
                    this.init();
                    this.player = Manager.createPlayer((String)this.playerLocator);
                    if (this.seBug) {
                        this.player.realize();
                    } else {
                        this.player.prefetch();
                    }
                    this.videoCtrl = this.initVideoControl(this.player);
                    this.player.addPlayerListener((PlayerListener)this);
                    System.gc();
                    this.player.start();
                    if (Midlet.getPlatform() == 9) {
                        Display.getDisplay((MIDlet)Midlet.getMidlet()).setCurrent((Displayable)new DummyCanvas());
                    }
                }
                if (this.videoCtrl != null) {
                    this.setupBounds(this.videoCtrl);
                }
                if (!this.requestCapture || this.actionListener == null) continue;
                this.requestCapture = false;
                if (this.videoCtrl != null) {
                    this.photoData = null;
                    if (this.snapshotEncoding.indexOf("width") < 0) {
                        String encodingString = this.getEncodingStringFromRMS();
                        if (encodingString == null || encodingString.length() < 1) {
                            encodingString = this.snapshotEncoding + "&width=" + this.defaultCaptureWidth + "&height=" + this.defaultCaptureHeight;
                        }
                        this.photoData = this.getSnapshot(encodingString);
                        if (this.photoData == null) {
                            this.photoData = this.discoverEncodingDimensions(this.videoCtrl);
                        }
                    }
                    if (this.photoData == null) {
                        this.photoData = this.getSnapshot(this.snapshotEncoding);
                    }
                }
                if (cameraPermission < 0) {
                    this.photoData = null;
                } else {
                    try {
                        this.actionListener.actionPerformed(this.actionCommand);
                    }
                    catch (Exception e) {
                        Logger.warn(e);
                    }
                }
                cameraPermission = 1;
            }
        }
        catch (Throwable e) {
            Logger.error(e);
        }
        finally {
            try {
                this.closePlayer();
            }
            catch (Exception e) {
                Logger.warn(e);
            }
            Logger.debug("Camera Thread GONE.");
        }
    }

    private synchronized void closePlayer() {
        if (this.videoCtrl != null) {
            this.videoCtrl.setVisible(false);
        }
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    private int getCameraPermission() {
        Midlet midlet = Midlet.getMidlet();
        int perm = midlet.checkPermission("javax.microedition.media.control.VideoControl.getSnapshot");
        return perm;
    }

    private byte[] getSnapshot(String encoding) {
        byte[] data = null;
        try {
            Logger.debug("getSnapshot: Trying " + encoding);
            data = this.videoCtrl.getSnapshot(encoding);
        }
        catch (Exception e) {
            Logger.warn(e);
        }
        if (data != null) {
            this.snapshotEncoding = encoding;
        }
        Logger.debug("getSnapshot: " + (data == null ? "FAIL." : "OK."));
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerUpdate(Player player, String event, Object obj) {
        Logger.debug("playerUpdate: " + event);
        if ("started".equals(event)) {
            if (cameraPermission < 0) {
                Logger.debug("cameraPermission: " + cameraPermission);
                if (this.getCameraPermission() < 0) {
                    this.capture();
                }
            }
        } else if ("closed".equals(event)) {
            Object object = this.uiLock;
            synchronized (object) {
                this.uiLock.notifyAll();
            }
            this.getDesktopPane().repaint();
        }
    }

    public void setKnownEncodingDimensions(int[][] knownEncodingDimensions) {
        this.knownEncodingDimensions = knownEncodingDimensions;
    }

    private byte[] discoverEncodingDimensions(VideoControl videoCtrl) {
        byte[] data = null;
        block0: for (int f = 0; f < this.knownEncodingFormats.length; ++f) {
            for (int i = 0; i < this.knownEncodingDimensions.length; ++i) {
                String encodingStr = "encoding=" + this.knownEncodingFormats[f] + "&width=" + this.knownEncodingDimensions[i][0] + "&height=" + this.knownEncodingDimensions[i][1];
                data = this.getSnapshot(encodingStr);
                if (data == null) continue;
                this.setEncodingStringInRMS(encodingStr);
                continue block0;
            }
        }
        return data;
    }

    private void init() {
        this.snapshotEncoding = "encoding=png";
        this.snapshotFileExt = "png";
        this.playerLocator = "capture://video";
        String prop = System.getProperty("video.snapshot.encodings");
        if (prop != null) {
            String[][] encodinTable = new String[][]{{"jpeg", "jpg"}, {"jpg", "jpg"}, {"png", "png"}, {"gif", "gif"}, {"bmp", "bmp"}};
            String encodings = prop.toLowerCase().trim();
            String[] supportedEncs = StringUtil.split(encodings, ' ');
            for (int i = 0; i < encodinTable.length; ++i) {
                String format = encodinTable[i][0];
                String enc = this.getHighestResolutionEncoding(format, supportedEncs);
                if (enc == null || enc.length() <= 0) continue;
                this.snapshotEncoding = enc;
                this.snapshotFileExt = encodinTable[i][1];
                break;
            }
        }
        String[] contentTypes = Manager.getSupportedContentTypes((String)"capture");
        for (int i = 0; i < contentTypes.length; ++i) {
            Logger.debug("SupportedContentType = capture://" + contentTypes[i]);
            if (!"image".equals(contentTypes[i])) continue;
            this.playerLocator = "capture://image";
            this.snapshotEncoding = "encoding=image/jpeg&width=320&height=240";
            this.seBug = false;
            break;
        }
    }

    private VideoControl initVideoControl(Player player) throws MediaException {
        VideoControl videoCtrl = (VideoControl)player.getControl("VideoControl");
        if (videoCtrl != null) {
            DesktopPane playerCanvas = this.getDesktopPane();
            videoCtrl.initDisplayMode(1, (Object)playerCanvas);
            this.setupBounds(videoCtrl);
            Logger.debug("Video Size = " + this.getWidth() + "x" + this.getHeight());
            videoCtrl.setVisible(true);
        }
        return videoCtrl;
    }

    private String getHighestResolutionEncoding(String format, String[] supportedEncs) {
        String highestResEncoding = "";
        int prevHighResWidth = 0;
        int prevHighResHeight = 0;
        for (int i = 0; i < supportedEncs.length; ++i) {
            String encoding = supportedEncs[i];
            int encodingWidth = Camera.getEncodingParameterInteger(encoding, "width");
            int encodingHeight = Camera.getEncodingParameterInteger(encoding, "height");
            String encodingType = Camera.getEncodingParamString(encoding, "encoding").toLowerCase();
            if (encodingWidth < prevHighResWidth || encodingWidth > this.defaultCaptureWidth || encodingHeight < prevHighResHeight || encodingHeight > this.defaultCaptureHeight || !encodingType.equals(format) && !encodingType.equals("image/" + format)) continue;
            highestResEncoding = encoding;
            prevHighResWidth = encodingWidth;
            prevHighResHeight = encodingHeight;
        }
        Logger.debug("getHighestResolutionEncoding - determined highest resolution encoding format \"" + (format == null ? "UNSPECIFIED" : format) + "\" to be \"" + highestResEncoding + "\"");
        return highestResEncoding;
    }

    private void setupBounds(VideoControl videoCtrl) {
        int dispW = this.getWidth();
        int dispH = this.getHeight();
        if (videoCtrl.getDisplayWidth() != dispW || videoCtrl.getDisplayHeight() != dispH) {
            try {
                videoCtrl.setDisplaySize(dispW, dispH);
            }
            catch (MediaException mex) {
                Logger.debug(mex);
            }
        }
        int dispX = this.getXOnScreen() + (this.getWidth() - videoCtrl.getDisplayWidth()) / 2;
        int dispY = this.getYOnScreen() + (this.getHeight() - videoCtrl.getDisplayHeight()) / 2;
        if (videoCtrl.getDisplayX() != dispX || videoCtrl.getDisplayY() != dispY) {
            videoCtrl.setDisplayLocation(dispX, dispY);
        }
    }

    private static String getEncodingParamString(String encoding, String prefix) {
        String result = "";
        int prefixIdx = encoding.indexOf(prefix);
        if (prefixIdx > -1) {
            int ampersandIdx = encoding.indexOf(38, prefixIdx);
            if (ampersandIdx < 0) {
                ampersandIdx = encoding.length();
            }
            result = encoding.substring(prefixIdx + prefix.length() + 1, ampersandIdx);
        }
        return result;
    }

    private static int getEncodingParameterInteger(String encoding, String prefix) {
        try {
            String s = Camera.getEncodingParamString(encoding, prefix);
            if (s != null && s.length() > 0) {
                return Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            Logger.warn(e);
        }
        return 0;
    }

    public static boolean isCameraSupported() {
        return System.getProperty("video.snapshot.encodings") != null;
    }

    private void setEncodingStringInRMS(String encodingString) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)CAPTURE_ENCODING_STRING_RECORD_STORE, (boolean)true);
            rs.addRecord(encodingString.getBytes(), 0, encodingString.length());
        }
        catch (RecordStoreException ex) {
            Logger.info(ex);
        }
    }

    private String getEncodingStringFromRMS() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)CAPTURE_ENCODING_STRING_RECORD_STORE, (boolean)false);
            byte[] encodingStringBytes = rs.getRecord(1);
            if (encodingStringBytes != null && encodingStringBytes.length > 0) {
                return new String(encodingStringBytes);
            }
        }
        catch (Exception ex) {
            Logger.info(ex);
        }
        return null;
    }

    private static class DummyCanvas
    extends Canvas {
        private DummyCanvas() {
        }

        protected void paint(Graphics arg0) {
            DesktopPane playerCanvas = DesktopPane.getDesktopPane();
            Display.getDisplay((MIDlet)Midlet.getMidlet()).setCurrent((Displayable)playerCanvas);
        }
    }
}

