/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.FlowLayout;
import net.yura.mobile.gui.layout.Layout;

public class Panel
extends Component {
    private static Layout defaultLayout;
    private Layout layout;
    private Vector components = new Vector();
    private Hashtable constraints = new Hashtable(1);

    public Panel() {
        this.focusable = false;
        if (defaultLayout == null) {
            defaultLayout = new FlowLayout();
        }
        this.layout = defaultLayout;
    }

    public Panel(Layout n) {
        this();
        this.setLayout(n);
    }

    public void setLayout(Layout lt) {
        this.layout = lt;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public Hashtable getConstraints() {
        return this.constraints;
    }

    protected void addImpl(Component component, Object cons, int index) {
        if (this.components.contains(component)) {
            throw new RuntimeException("this panel already has this component, comp=" + component + " panel=" + this);
        }
        if (index == -1) {
            this.components.addElement(component);
        } else {
            this.components.insertElementAt(component, index);
        }
        if (cons != null) {
            this.constraints.put(component, cons);
        }
        super.addImpl(component, cons, index);
    }

    public void remove(Component component) {
        this.remove(this.components.indexOf(component));
    }

    public void remove(int c) {
        Component component = (Component)this.components.elementAt(c);
        Window win = component.getWindow();
        if (win != null) {
            for (Component f = win.focusedComponent; f != null; f = f.getParent()) {
                if (f != component) continue;
                win.setFocusedComponent(null);
                break;
            }
        }
        this.components.removeElementAt(c);
        component.removeParent(this);
        this.constraints.remove(component);
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public void paint(Graphics2D g) {
        super.paint(g);
        this.paintChildren(g);
    }

    public void paintChildren(Graphics2D g) {
        int[] clip = g.getClip();
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            if (!component.isVisible()) continue;
            int rx = component.getXWithBorder();
            int ry = component.getYWithBorder();
            if (rx > clip[0] + clip[2] || ry > clip[1] + clip[3] || rx + component.getWidthWithBorder() < clip[0] || ry + component.getHeightWithBorder() < clip[1]) continue;
            int cx = component.getX();
            int cy = component.getY();
            g.translate(cx, cy);
            component.paint(g);
            g.translate(-cx, -cy);
        }
    }

    public void paintComponent(Graphics2D g) {
    }

    protected void workoutMinimumSize() {
        for (int i = 0; i < this.components.size(); ++i) {
            Component component = (Component)this.components.elementAt(i);
            component.workoutPreferredSize();
        }
        if (this.layout != null) {
            this.width = this.layout.getPreferredWidth(this);
            this.height = this.layout.getPreferredHeight(this);
        } else {
            this.width = 0;
            this.height = 0;
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.doLayout();
    }

    protected void doLayout() {
        if (this.layout != null) {
            this.layout.layoutPanel(this);
        } else {
            for (int i = 0; i < this.components.size(); ++i) {
                Component component = (Component)this.components.elementAt(i);
                if (!(component instanceof Panel)) continue;
                ((Panel)component).doLayout();
            }
        }
    }

    public void validate() {
        for (int i = 0; i < this.components.size(); ++i) {
            ((Component)this.components.elementAt(i)).workoutPreferredSize();
        }
        this.doLayout();
    }

    public Component getNextComponent(Component component, int direction) {
        boolean right;
        int index = this.components.indexOf(component);
        boolean bl = right = direction == 5 || direction == 6;
        index = right ? (index == this.components.size() - 1 ? -1 : index + 1) : (index == -1 ? this.components.size() - 1 : (index == 0 ? -1 : index - 1));
        return index == -1 ? null : (Component)this.components.elementAt(index);
    }

    protected void breakOutAction(Component component, int direction, boolean scrolltothere, boolean forceFocus) {
        Component c;
        while ((c = this.getNextComponent(component, direction)) != null) {
            component = c;
            if (!component.isVisible()) continue;
            if (component.isFocusable()) {
                boolean requestFocus = false;
                if (this.getWindow().getFocusOwner() == null) {
                    if (component.isComponentVisible()) {
                        requestFocus = true;
                    } else {
                        this.breakOutAction(component, direction, scrolltothere, forceFocus);
                    }
                } else if (scrolltothere) {
                    requestFocus = this.scrollRectToVisible(component.getXWithBorder(), component.getYWithBorder(), component.getWidthWithBorder(), component.getHeightWithBorder(), !forceFocus);
                }
                if (requestFocus || component.isComponentVisible()) {
                    component.requestFocusInWindow();
                }
                return;
            }
            if (!(component instanceof Panel)) continue;
            ((Panel)component).breakOutAction(null, direction, scrolltothere, forceFocus);
            return;
        }
        boolean scrolled = false;
        if (scrolltothere && this instanceof ScrollPane && !component.isFocusable()) {
            scrolled = this.scrollUpDown(direction);
        }
        if (!scrolled) {
            if (this.parent != null) {
                ((Panel)this.parent).breakOutAction(this, direction, scrolltothere, forceFocus);
            } else if (this.getWindow().getFocusOwner() != null) {
                if (!Boolean.FALSE.equals(DesktopPane.get("LOOP_PANEL"))) {
                    this.breakOutAction(null, direction, scrolltothere, true);
                } else {
                    this.scrollUpDown(direction);
                }
            }
        }
    }

    protected boolean scrollUpDown(int direction) {
        for (int i = 0; i < this.components.size(); ++i) {
            boolean scrolled;
            Component component = (Component)this.components.elementAt(i);
            if (!component.isVisible() || !(component instanceof Panel) || !(scrolled = ((Panel)component).scrollUpDown(direction))) continue;
            return true;
        }
        return false;
    }

    public Vector getComponents() {
        return this.components;
    }

    public void removeAll() {
        while (!this.components.isEmpty()) {
            this.remove(this.components.size() - 1);
        }
    }

    public String toString() {
        return super.toString() + " " + this.components;
    }

    public Component getComponentAt(int x, int y) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            Component component = (Component)this.components.elementAt(i);
            if (!component.isVisible()) continue;
            int x1 = component.getXWithBorder();
            int y1 = component.getYWithBorder();
            int x2 = x1 + component.getWidthWithBorder();
            int y2 = y1 + component.getHeightWithBorder();
            if (x < x1 || x > x2 || y < y1 || y > y2) continue;
            if (component instanceof Panel) {
                return ((Panel)component).getComponentAt(x - component.getX(), y - component.getY());
            }
            return component;
        }
        return this;
    }

    protected String getDefaultName() {
        return "Panel";
    }

    public Button findMnemonicButton(int mnu) {
        for (int i = 0; i < this.components.size(); ++i) {
            Button button;
            Component component = (Component)this.components.elementAt(i);
            if (component instanceof Button) {
                Button button1;
                button = (Button)component;
                if (button.getMnemonic() == mnu) {
                    return button;
                }
                if (!(component instanceof Menu) || (button1 = ((Menu)component).findMneonicButton(mnu)) == null) continue;
                return button1;
            }
            if (!(component instanceof MenuBar ? (button = ((MenuBar)component).findMneonicButton(mnu)) != null : component instanceof Panel && (button = ((Panel)component).findMnemonicButton(mnu)) != null)) continue;
            return button;
        }
        return null;
    }
}

