/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.plaf.nimbus;

import java.util.Vector;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.plaf.nimbus.NimbusBorder;

public class NimbusIcon
extends Icon {
    int type;
    int color;
    Vector borders;

    public NimbusIcon(int size, int type, Vector borders, int color) {
        this.width = size;
        this.height = size;
        this.type = type;
        this.borders = borders;
        this.color = color;
    }

    public void paintIcon(Component c, Graphics2D g, int x, int y) {
        NimbusBorder.paintBorders(this.borders, g, x, y, this.getIconWidth(), this.getIconHeight());
        g.setColor(this.color);
        if (this.type == 1) {
            if ((c.getCurrentState() & 8) != 0) {
                int w = this.getIconWidth();
                int h = this.getIconHeight();
                for (int pad = 3; pad < 6; ++pad) {
                    g.drawLine(x + pad, y + h / 2, x + w / 3, y + h - pad);
                    g.drawLine(x + w / 3, y + h - pad, x + w - pad, y + pad);
                }
            }
        } else if (this.type == 0) {
            if ((c.getCurrentState() & 8) != 0) {
                int w = this.getIconWidth();
                int h = this.getIconHeight();
                int w2 = this.borders.size() + 1;
                int h2 = this.borders.size() + 1;
                g.fillArc(x + w2, y + h2, w - w2 * 2, h - h2 * 2, 0, 360);
            }
        } else if (this.type == 11) {
            int top = this.height / 2 - 3;
            int middle = this.width / 2;
            g.fillTriangle(x + middle, y + top, x + middle - 3, y + top + 6, x + middle + 3, y + top + 6);
        } else if (this.type == 12 || this.type == 2) {
            int top = this.height / 2 - 3;
            int middle = this.width / 2;
            g.fillTriangle(x + middle, y + top + 6, x + middle - 3, y + top, x + middle + 3, y + top);
        } else if (this.type == 3 || this.type == 14) {
            int top = this.height / 2 - 3;
            int middle = this.width / 2;
            g.fillTriangle(x + middle + 3, y + top, x + middle - 3, y + top + 3, x + middle + 3, y + top + 6);
        } else if (this.type == 4 || this.type == 13) {
            int top = this.height / 2 - 3;
            int middle = this.width / 2;
            g.fillTriangle(x + middle - 3, y + top + 6, x + middle - 3, y + top, x + middle + 3, y + top + 3);
        }
    }
}

