/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.yura.mobile.io.proto.CodedInputStream;
import net.yura.mobile.io.proto.CodedOutputStream;
import net.yura.mobile.io.proto.WireFormat;

public class ProtoUtil {
    protected static final String[] EMPTY = new String[0];
    protected static final String unknown = "unknown ";
    protected static final int VECTOR_ELEMENT = 1;
    protected static final int KEY_VALUE = 1;
    protected static final int HASHTABLE_KEY = 1;
    protected static final int HASHTABLE_VALUE = 2;

    public int save(OutputStream out, Object obj) throws IOException {
        int size = this.computeAnonymousObjectSize(obj);
        CodedOutputStream out2 = CodedOutputStream.newInstance(out);
        this.encodeAnonymousObject(out2, obj);
        out2.flush();
        return size;
    }

    public Object load(InputStream in, int size) throws IOException {
        CodedInputStream in2 = CodedInputStream.newInstance(in);
        in2.setSizeLimit(size);
        int lim = in2.pushLimit(size);
        Object obj = this.decodeAnonymousObject(in2);
        in2.popLimit(lim);
        return obj;
    }

    protected Object decodeAnonymousObject(CodedInputStream in2) throws IOException {
        Object obj = null;
        block12: while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int type = WireFormat.getTagFieldNumber(tag);
            if (obj != null) {
                throw new IOException("more then one field inside Anonymous Object, newFieldNo=" + type + " currentObject=" + obj);
            }
            switch (type) {
                case 1: {
                    obj = new Integer(in2.readInt32());
                    continue block12;
                }
                case 2: {
                    obj = new Double(in2.readDouble());
                    continue block12;
                }
                case 5: {
                    obj = in2.readString();
                    continue block12;
                }
                case 4: {
                    obj = in2.readBool() ? Boolean.TRUE : Boolean.FALSE;
                    continue block12;
                }
                case 9: {
                    obj = new Byte((byte)in2.readInt32());
                    continue block12;
                }
                case 8: {
                    obj = new Character((char)in2.readInt32());
                    continue block12;
                }
                case 6: {
                    obj = new Short((short)in2.readInt32());
                    continue block12;
                }
                case 7: {
                    obj = new Long(in2.readInt64());
                    continue block12;
                }
                case 3: {
                    obj = new Float(in2.readFloat());
                    continue block12;
                }
                case 13: {
                    obj = in2.readBytes();
                    continue block12;
                }
            }
            int size = in2.readBytesSize();
            int lim = in2.pushLimit(size);
            obj = this.decodeObject(in2, type);
            in2.popLimit(lim);
        }
        return obj;
    }

    protected Object decodeObject(CodedInputStream in2, int type) throws IOException {
        switch (type) {
            case 10: {
                return this.decodeVector(in2);
            }
            case 11: {
                Vector v = this.decodeVector(in2);
                Object[] array = new Object[v.size()];
                v.copyInto(array);
                return array;
            }
            case 12: {
                return this.decodeHashtable(in2);
            }
        }
        throw new IOException();
    }

    protected Vector decodeVector(CodedInputStream in2) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int fieldNo = WireFormat.getTagFieldNumber(tag);
            if (fieldNo == 1) {
                int size = in2.readBytesSize();
                int lim = in2.pushLimit(size);
                Object obj = this.decodeAnonymousObject(in2);
                vector.addElement(obj);
                in2.popLimit(lim);
                continue;
            }
            in2.skipField(tag);
        }
        return vector;
    }

    protected Hashtable decodeHashtable(CodedInputStream in2) throws IOException {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        while (!in2.isAtEnd()) {
            int tag = in2.readTag();
            int fieldNo = WireFormat.getTagFieldNumber(tag);
            if (fieldNo == 1) {
                int size = in2.readBytesSize();
                int lim = in2.pushLimit(size);
                Object key = null;
                Object value = null;
                block5: while (!in2.isAtEnd()) {
                    int tag2 = in2.readTag();
                    int fieldNo2 = WireFormat.getTagFieldNumber(tag2);
                    switch (fieldNo2) {
                        case 1: {
                            int size2 = in2.readBytesSize();
                            int lim2 = in2.pushLimit(size2);
                            key = this.decodeAnonymousObject(in2);
                            in2.popLimit(lim2);
                            continue block5;
                        }
                        case 2: {
                            int size2 = in2.readBytesSize();
                            int lim2 = in2.pushLimit(size2);
                            value = this.decodeAnonymousObject(in2);
                            in2.popLimit(lim2);
                            continue block5;
                        }
                    }
                    in2.skipField(tag2);
                }
                hashtable.put(key, value);
                in2.popLimit(lim);
                continue;
            }
            in2.skipField(tag);
        }
        return hashtable;
    }

    protected int computeObjectSize(Object obj, int type) {
        switch (type) {
            case 10: {
                return this.computeVectorSize(obj);
            }
            case 11: {
                return this.computeArraySize((Object[])obj);
            }
            case 12: {
                return this.computeHashtableSize(obj);
            }
        }
        throw new RuntimeException();
    }

    protected void encodeObject(CodedOutputStream out, Object obj, int type) throws IOException {
        switch (type) {
            case 10: {
                this.encodeVector(out, obj);
                break;
            }
            case 11: {
                this.encodeArray(out, (Object[])obj);
                break;
            }
            case 12: {
                this.encodeHashtable(out, obj);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    protected int computeByteArraySize(Object obj) {
        return ((byte[])obj).length;
    }

    protected void encodeByteArray(CodedOutputStream out, Object obj) throws IOException {
        out.writeRawBytes((byte[])obj);
    }

    public int computeAnonymousObjectSize(Object obj) {
        int type = this.getObjectTypeEnum(obj);
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return CodedOutputStream.computeInt32Size(type, (Integer)obj);
            }
            case 2: {
                return CodedOutputStream.computeDoubleSize(type, (Double)obj);
            }
            case 3: {
                return CodedOutputStream.computeFloatSize(type, ((Float)obj).floatValue());
            }
            case 5: {
                return CodedOutputStream.computeStringSize(type, (String)obj);
            }
            case 4: {
                return CodedOutputStream.computeBoolSize(type, (Boolean)obj);
            }
            case 9: {
                return CodedOutputStream.computeInt32Size(type, ((Byte)obj).byteValue());
            }
            case 8: {
                return CodedOutputStream.computeInt32Size(type, ((Character)obj).charValue());
            }
            case 6: {
                return CodedOutputStream.computeInt32Size(type, ((Short)obj).shortValue());
            }
            case 7: {
                return CodedOutputStream.computeInt64Size(type, (Long)obj);
            }
            case 13: {
                return CodedOutputStream.computeBytesSize(type, this.computeByteArraySize(obj));
            }
        }
        return CodedOutputStream.computeBytesSize(type, this.computeObjectSize(obj, type));
    }

    protected void encodeAnonymousObject(CodedOutputStream out, Object obj) throws IOException {
        int type = this.getObjectTypeEnum(obj);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                out.writeInt32(type, (Integer)obj);
                break;
            }
            case 2: {
                out.writeDouble(type, (Double)obj);
                break;
            }
            case 3: {
                out.writeFloat(type, ((Float)obj).floatValue());
                break;
            }
            case 5: {
                out.writeString(type, (String)obj);
                break;
            }
            case 4: {
                out.writeBool(type, (Boolean)obj);
                break;
            }
            case 9: {
                out.writeInt32(type, ((Byte)obj).byteValue());
                break;
            }
            case 8: {
                out.writeInt32(type, ((Character)obj).charValue());
                break;
            }
            case 6: {
                out.writeInt32(type, ((Short)obj).shortValue());
                break;
            }
            case 7: {
                out.writeInt64(type, (Long)obj);
                break;
            }
            case 13: {
                out.writeBytes(type, this.computeByteArraySize(obj));
                this.encodeByteArray(out, obj);
                break;
            }
            default: {
                out.writeBytes(type, this.computeObjectSize(obj, type));
                this.encodeObject(out, obj, type);
            }
        }
    }

    protected int computeVectorSize(Object list) {
        Vector vector = (Vector)list;
        int size = 0;
        for (int c = 0; c < vector.size(); ++c) {
            int s = this.computeAnonymousObjectSize(vector.elementAt(c));
            size += CodedOutputStream.computeBytesSize(1, s);
        }
        return size;
    }

    private int computeArraySize(Object[] vector) {
        int size = 0;
        for (int c = 0; c < vector.length; ++c) {
            int s = this.computeAnonymousObjectSize(vector[c]);
            size += CodedOutputStream.computeBytesSize(1, s);
        }
        return size;
    }

    protected int computeHashtableSize(Object map) {
        Hashtable hashtable = (Hashtable)map;
        int totalSize = 0;
        Enumeration enu = hashtable.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            Object value = hashtable.get(key);
            int keySize = this.computeAnonymousObjectSize(key);
            int valueSize = this.computeAnonymousObjectSize(value);
            int size1 = CodedOutputStream.computeBytesSize(1, keySize);
            int size2 = CodedOutputStream.computeBytesSize(2, valueSize);
            int s = CodedOutputStream.computeBytesSize(1, size1 + size2);
            totalSize += s;
        }
        return totalSize;
    }

    protected void encodeVector(CodedOutputStream out, Object list) throws IOException {
        Vector vector = (Vector)list;
        for (int c = 0; c < vector.size(); ++c) {
            Object obj = vector.elementAt(c);
            out.writeBytes(1, this.computeAnonymousObjectSize(obj));
            this.encodeAnonymousObject(out, obj);
        }
    }

    private void encodeArray(CodedOutputStream out, Object[] vector) throws IOException {
        for (int c = 0; c < vector.length; ++c) {
            Object obj = vector[c];
            out.writeBytes(1, this.computeAnonymousObjectSize(obj));
            this.encodeAnonymousObject(out, obj);
        }
    }

    protected void encodeHashtable(CodedOutputStream out, Object map) throws IOException {
        Hashtable hashtable = (Hashtable)map;
        Enumeration enu = hashtable.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            Object value = hashtable.get(key);
            int keySize = this.computeAnonymousObjectSize(key);
            int valueSize = this.computeAnonymousObjectSize(value);
            int size1 = CodedOutputStream.computeBytesSize(1, keySize);
            int size2 = CodedOutputStream.computeBytesSize(2, valueSize);
            out.writeBytes(1, size1 + size2);
            out.writeBytes(1, keySize);
            this.encodeAnonymousObject(out, key);
            out.writeBytes(2, valueSize);
            this.encodeAnonymousObject(out, value);
        }
    }

    protected int getObjectTypeEnum(Object obj) {
        if (obj instanceof Double) {
            return 2;
        }
        if (obj instanceof Integer) {
            return 1;
        }
        if (obj instanceof Vector) {
            return 10;
        }
        if (obj instanceof String) {
            return 5;
        }
        if (obj instanceof Float) {
            return 3;
        }
        if (obj instanceof Short) {
            return 6;
        }
        if (obj instanceof Long) {
            return 7;
        }
        if (obj instanceof Boolean) {
            return 4;
        }
        if (obj instanceof Byte) {
            return 9;
        }
        if (obj instanceof Object[]) {
            return 11;
        }
        if (obj instanceof Hashtable) {
            return 12;
        }
        if (obj instanceof byte[]) {
            return 13;
        }
        if (obj instanceof Character) {
            return 8;
        }
        if (obj == null) {
            return 0;
        }
        throw new RuntimeException();
    }

    public static boolean hashtableIsMessage(Hashtable hash, String[] required, String[] optional) {
        if (hash.size() < required.length || hash.size() > required.length + optional.length) {
            return false;
        }
        int found = 0;
        Enumeration enu = hash.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            if (ProtoUtil.canBeFoundIn(key, required)) {
                ++found;
                continue;
            }
            if (ProtoUtil.canBeFoundIn(key, optional)) continue;
            return false;
        }
        return required.length == found;
    }

    private static boolean canBeFoundIn(Object key, Object[] array) {
        for (int c = 0; c < array.length; ++c) {
            if (!array[c].equals(key)) continue;
            return true;
        }
        return false;
    }

    protected Object getObjetById(Object id, Class clas) {
        throw new RuntimeException();
    }

    protected Object getObjectId(Object object) {
        throw new RuntimeException();
    }
}

