/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.logging;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.yura.mobile.logging.Logger;

public class CallStack {
    private static final int INT_MASK = 240;
    private static final int OBJECT_MASK = 15;
    private static final int ARGS_MASK = 65280;
    private static final int STACK_SIZE = 512;
    private static final int MAX_THREADS = 16;
    private static CallStack[] callStacks = new CallStack[32];
    private static RecordStore crashMonitor;
    private final Thread thread;
    final int index;
    private int intPtr;
    private int objPtr;
    public int line;
    private final int[] intStack = new int[512];
    private final Object[] objStack = new Object[512];
    StringBuffer stacktrace = new StringBuffer();
    static /* synthetic */ Class class$net$yura$mobile$logging$CallStack;

    public static boolean startCrashMonitor() {
        try {
            crashMonitor = RecordStore.openRecordStore((String)"crash_log", (boolean)true);
            return crashMonitor.getNumRecords() > 0;
        }
        catch (RecordStoreException e) {
            Logger.warn(e);
            return false;
        }
    }

    public static byte[][] getCrashLog() {
        try {
            byte[][] crashLog = new byte[crashMonitor.getNumRecords()][];
            for (int i = 0; i < crashMonitor.getNumRecords(); ++i) {
                crashLog[i] = crashMonitor.getRecord(i);
            }
            return crashLog;
        }
        catch (RecordStoreException e) {
            Logger.warn(e);
            return null;
        }
    }

    public static void writeCrashLog(String dir) {
        try {
            long time = System.currentTimeMillis();
            for (int i = 0; i < crashMonitor.getNumRecords(); ++i) {
                FileConnection file = (FileConnection)Connector.open((String)(dir + time + "_" + i + ".tra"), (int)2);
                file.create();
                file.openOutputStream().write(crashMonitor.getRecord(i));
                file.close();
            }
        }
        catch (Exception e) {
            Logger.warn(e);
        }
    }

    public static void stopCrashMonitor() {
        try {
            crashMonitor.closeRecordStore();
            crashMonitor = null;
            RecordStore.deleteRecordStore((String)"crash_log");
        }
        catch (RecordStoreException e) {
            Logger.warn(e);
        }
    }

    public static String createStacktrace() {
        CallStack callStack = CallStack.getCallStack();
        callStack.printStacktrace(Thread.currentThread());
        return callStack.stacktrace.toString();
    }

    public static String getStacktrace() {
        CallStack stack = CallStack.getCallStack();
        if (stack.intPtr == 0) {
            CallStack.callStacks[stack.index] = null;
        }
        return stack.stacktrace.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CallStack getCallStack() {
        int i;
        int j = i = Math.abs(Thread.currentThread().hashCode() % 16);
        while (i < callStacks.length) {
            if (callStacks[i] != null && CallStack.callStacks[i].thread == Thread.currentThread()) {
                return callStacks[i];
            }
            ++i;
        }
        Class clazz = class$net$yura$mobile$logging$CallStack == null ? (class$net$yura$mobile$logging$CallStack = CallStack.class$("net.yura.mobile.logging.CallStack")) : class$net$yura$mobile$logging$CallStack;
        synchronized (clazz) {
            while (callStacks[j] != null) {
                ++j;
            }
            CallStack.callStacks[j] = crashMonitor == null ? new CallStack(Thread.currentThread(), j) : new MonitoredCallStack(Thread.currentThread(), j);
            return callStacks[j];
        }
    }

    CallStack(Thread thread, int index) {
        this.thread = thread;
        this.index = index;
    }

    void pushMethod(int method, int args) {
        this.intStack[this.intPtr++] = this.line << 16 | args;
        this.intStack[this.intPtr++] = method;
    }

    void pushInt(int value) {
        this.intStack[this.intPtr++] = value;
    }

    void pushObject(Object object) {
        this.objStack[this.objPtr++] = object;
    }

    public void pop() {
        this.intPtr -= 2;
        while ((this.intStack[this.intPtr] & 0xF) > 0) {
            this.objStack[--this.objPtr] = null;
            int n = this.intPtr;
            this.intStack[n] = this.intStack[n] - 1;
        }
        this.line = this.intStack[this.intPtr] >> 16;
        this.intPtr -= (this.intStack[this.intPtr] & 0xF0) >> 4;
        if (this.intPtr == 0) {
            CallStack.callStacks[this.index] = null;
        }
    }

    public void unwind(Throwable t, int method) {
        this.printStacktrace(t);
        while (this.intStack[this.intPtr - 1] != method) {
            this.intPtr -= 2;
            while ((this.intStack[this.intPtr] & 0xF) > 0) {
                this.objStack[--this.objPtr] = null;
                int n = this.intPtr;
                this.intStack[n] = this.intStack[n] - 1;
            }
            this.intPtr -= (this.intStack[this.intPtr] & 0xF0) >> 4;
        }
    }

    void printStacktrace(Object message) {
        this.stacktrace.setLength(0);
        this.stacktrace.append(message.toString().replace('\n', ' ')).append('\n');
        int intPtr = this.intPtr;
        int objPtr = this.objPtr;
        while (intPtr > 0) {
            this.stacktrace.append("\tat ").append(Integer.toString(this.intStack[--intPtr], 36)).append("(?:").append(this.line).append(')').append('\n');
            this.line = this.intStack[--intPtr] >> 16;
            int cfr_ignored_0 = this.intStack[intPtr] & 0xFF00;
        }
    }

    private static StringBuffer append(StringBuffer buffer, Object object) {
        if (object instanceof String) {
            buffer.append('\"').append(object).append('\"');
        } else if (object instanceof Vector) {
            buffer.append('{');
            Vector vector = (Vector)object;
            for (int i = 0; i < vector.size(); ++i) {
                CallStack.append(buffer, vector.elementAt(i)).append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length()).append('}');
        } else if (object instanceof Hashtable) {
            buffer.append('{');
            Hashtable hashtable = (Hashtable)object;
            Enumeration e = hashtable.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                CallStack.append(CallStack.append(buffer, key).append(" => "), hashtable.get(key)).append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length()).append('}');
        } else if (object instanceof int[]) {
            buffer.append('{');
            int[] array = (int[])object;
            for (int i = 0; i < array.length; ++i) {
                buffer.append(array[i]).append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length()).append('}');
        } else if (object instanceof Object[]) {
            buffer.append('{');
            Object[] array = (Object[])object;
            for (int i = 0; i < array.length; ++i) {
                CallStack.append(buffer, array[i]).append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length()).append('}');
        } else {
            buffer.append(object);
        }
        return buffer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MonitoredCallStack
    extends CallStack {
        MonitoredCallStack(Thread thread, int id) {
            super(thread, id);
        }

        void pushMethod(int method, int args) {
            super.pushMethod(method, args);
            this.saveStacktrace();
        }

        public void pop() {
            super.pop();
            this.saveStacktrace();
        }

        public void unwind(Throwable t, int method) {
            super.unwind(t, method);
            this.saveStacktrace();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveStacktrace() {
            block7: {
                try {
                    this.printStacktrace(Thread.currentThread());
                    byte[] bytes = this.stacktrace.toString().getBytes();
                    if (crashMonitor.getNextRecordID() > this.index) {
                        crashMonitor.setRecord(this.index, bytes, 0, bytes.length);
                        break block7;
                    }
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        while (crashMonitor.getNextRecordID() < this.index) {
                            crashMonitor.addRecord(null, 0, 0);
                        }
                        crashMonitor.addRecord(bytes, 0, bytes.length);
                    }
                }
                catch (RecordStoreException e) {
                    Logger.warn(e);
                }
            }
        }
    }
}

