// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: dstrings.h 869 2011-10-31 23:55:40Z wesleyjohnson $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: dstrings.h,v $
// Revision 1.3  2000/04/16 18:38:07  bpereira
// no message
//
// Revision 1.2  2000/02/27 00:42:10  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:32  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      DOOM strings, by language.
//
//-----------------------------------------------------------------------------


#ifndef __DSTRINGS__
#define __DSTRINGS__


// All important printed strings.
// Language selection (message strings).
// Use -DFRENCH etc.

#ifdef FRENCH
#include "d_french.h"
#else
#include "d_englsh.h"
#endif

// Misc. other strings.
#ifdef BEX_SAVEGAMENAME
#define SAVEGAMENAME    text[SAVEGAMENAME_NUM];
#else
#define SAVEGAMENAME    "doomsav"
#endif

//
// File locations,
//  relative to current position.
// Path names are OS-sensitive.
//
#define DEVMAPS "devmaps"
#define DEVDATA "devdata"


// Not done in french?

// QuitDOOM messages
  //added:02-01-98: "22 messages - 7 messages = 15 cool messages" !
#define NUM_QUITMESSAGES   15

extern char* endmsg[];


typedef enum {
 D_DEVSTR_NUM,
 D_CDROM_NUM,
 PRESSKEY_NUM,
 PRESSYN_NUM,
 LOADNET_NUM,
 QLOADNET_NUM,
 QSAVESPOT_NUM,
 SAVEDEAD_NUM,
 QSPROMPT_NUM,
 QLPROMPT_NUM,
 NEWGAME_NUM,
 NIGHTMARE_NUM,
 SWSTRING_NUM,
 MSGOFF_NUM,
 MSGON_NUM,
 NETEND_NUM,
 ENDGAME_NUM,
 DOSY_NUM,
 DETAILHI_NUM,
 DETAILLO_NUM,
 GAMMALVL0_NUM,
 GAMMALVL1_NUM,
 GAMMALVL2_NUM,
 GAMMALVL3_NUM,
 GAMMALVL4_NUM,
 EMPTYSTRING_NUM,
 GOTARMOR_NUM,
 GOTMEGA_NUM,
 GOTHTHBONUS_NUM,
 GOTARMBONUS_NUM,
 GOTSTIM_NUM,
 GOTMEDINEED_NUM,
 GOTMEDIKIT_NUM,
 GOTSUPER_NUM,
 GOTBLUECARD_NUM,
 GOTYELWCARD_NUM,
 GOTREDCARD_NUM,
 GOTBLUESKUL_NUM,
 GOTYELWSKUL_NUM,
 GOTREDSKULL_NUM,
 GOTINVUL_NUM,
 GOTBERSERK_NUM,
 GOTINVIS_NUM,
 GOTSUIT_NUM,
 GOTMAP_NUM,
 GOTVISOR_NUM,
 GOTMSPHERE_NUM,
 GOTCLIP_NUM,
 GOTCLIPBOX_NUM,
 GOTROCKET_NUM,
 GOTROCKBOX_NUM,
 GOTCELL_NUM,
 GOTCELLBOX_NUM,
 GOTSHELLS_NUM,
 GOTSHELLBOX_NUM,
 GOTBACKPACK_NUM,
 GOTBFG9000_NUM,
 GOTCHAINGUN_NUM,
 GOTCHAINSAW_NUM,
 GOTLAUNCHER_NUM,
 GOTPLASMA_NUM,
 GOTSHOTGUN_NUM,
 GOTSHOTGUN2_NUM,
 PD_BLUEO_NUM,
 PD_REDO_NUM,
 PD_YELLOWO_NUM,
 PD_BLUEK_NUM,
 PD_REDK_NUM,
 PD_YELLOWK_NUM,
 GGSAVED_NUM,
 HUSTR_MSGU_NUM,
 HUSTR_E1M1_NUM,
 HUSTR_E1M2_NUM,
 HUSTR_E1M3_NUM,
 HUSTR_E1M4_NUM,
 HUSTR_E1M5_NUM,
 HUSTR_E1M6_NUM,
 HUSTR_E1M7_NUM,
 HUSTR_E1M8_NUM,
 HUSTR_E1M9_NUM,
 HUSTR_E2M1_NUM,
 HUSTR_E2M2_NUM,
 HUSTR_E2M3_NUM,
 HUSTR_E2M4_NUM,
 HUSTR_E2M5_NUM,
 HUSTR_E2M6_NUM,
 HUSTR_E2M7_NUM,
 HUSTR_E2M8_NUM,
 HUSTR_E2M9_NUM,
 HUSTR_E3M1_NUM,
 HUSTR_E3M2_NUM,
 HUSTR_E3M3_NUM,
 HUSTR_E3M4_NUM,
 HUSTR_E3M5_NUM,
 HUSTR_E3M6_NUM,
 HUSTR_E3M7_NUM,
 HUSTR_E3M8_NUM,
 HUSTR_E3M9_NUM,
 HUSTR_E4M1_NUM,
 HUSTR_E4M2_NUM,
 HUSTR_E4M3_NUM,
 HUSTR_E4M4_NUM,
 HUSTR_E4M5_NUM,
 HUSTR_E4M6_NUM,
 HUSTR_E4M7_NUM,
 HUSTR_E4M8_NUM,
 HUSTR_E4M9_NUM,
 HUSTR_1_NUM,
 HUSTR_2_NUM,
 HUSTR_3_NUM,
 HUSTR_4_NUM,
 HUSTR_5_NUM,
 HUSTR_6_NUM,
 HUSTR_7_NUM,
 HUSTR_8_NUM,
 HUSTR_9_NUM,
 HUSTR_10_NUM,
 HUSTR_11_NUM,
 HUSTR_12_NUM,
 HUSTR_13_NUM,
 HUSTR_14_NUM,
 HUSTR_15_NUM,
 HUSTR_16_NUM,
 HUSTR_17_NUM,
 HUSTR_18_NUM,
 HUSTR_19_NUM,
 HUSTR_20_NUM,
 HUSTR_21_NUM,
 HUSTR_22_NUM,
 HUSTR_23_NUM,
 HUSTR_24_NUM,
 HUSTR_25_NUM,
 HUSTR_26_NUM,
 HUSTR_27_NUM,
 HUSTR_28_NUM,
 HUSTR_29_NUM,
 HUSTR_30_NUM,
 HUSTR_31_NUM,
 HUSTR_32_NUM,
 PHUSTR_1_NUM,
 PHUSTR_2_NUM,
 PHUSTR_3_NUM,
 PHUSTR_4_NUM,
 PHUSTR_5_NUM,
 PHUSTR_6_NUM,
 PHUSTR_7_NUM,
 PHUSTR_8_NUM,
 PHUSTR_9_NUM,
 PHUSTR_10_NUM,
 PHUSTR_11_NUM,
 PHUSTR_12_NUM,
 PHUSTR_13_NUM,
 PHUSTR_14_NUM,
 PHUSTR_15_NUM,
 PHUSTR_16_NUM,
 PHUSTR_17_NUM,
 PHUSTR_18_NUM,
 PHUSTR_19_NUM,
 PHUSTR_20_NUM,
 PHUSTR_21_NUM,
 PHUSTR_22_NUM,
 PHUSTR_23_NUM,
 PHUSTR_24_NUM,
 PHUSTR_25_NUM,
 PHUSTR_26_NUM,
 PHUSTR_27_NUM,
 PHUSTR_28_NUM,
 PHUSTR_29_NUM,
 PHUSTR_30_NUM,
 PHUSTR_31_NUM,
 PHUSTR_32_NUM,
 THUSTR_1_NUM,
 THUSTR_2_NUM,
 THUSTR_3_NUM,
 THUSTR_4_NUM,
 THUSTR_5_NUM,
 THUSTR_6_NUM,
 THUSTR_7_NUM,
 THUSTR_8_NUM,
 THUSTR_9_NUM,
 THUSTR_10_NUM,
 THUSTR_11_NUM,
 THUSTR_12_NUM,
 THUSTR_13_NUM,
 THUSTR_14_NUM,
 THUSTR_15_NUM,
 THUSTR_16_NUM,
 THUSTR_17_NUM,
 THUSTR_18_NUM,
 THUSTR_19_NUM,
 THUSTR_20_NUM,
 THUSTR_21_NUM,
 THUSTR_22_NUM,
 THUSTR_23_NUM,
 THUSTR_24_NUM,
 THUSTR_25_NUM,
 THUSTR_26_NUM,
 THUSTR_27_NUM,
 THUSTR_28_NUM,
 THUSTR_29_NUM,
 THUSTR_30_NUM,
 THUSTR_31_NUM,
 THUSTR_32_NUM,
 HUSTR_CHATMACRO1_NUM,
 HUSTR_CHATMACRO2_NUM,
 HUSTR_CHATMACRO3_NUM,
 HUSTR_CHATMACRO4_NUM,
 HUSTR_CHATMACRO5_NUM,
 HUSTR_CHATMACRO6_NUM,
 HUSTR_CHATMACRO7_NUM,
 HUSTR_CHATMACRO8_NUM,
 HUSTR_CHATMACRO9_NUM,
 HUSTR_CHATMACRO0_NUM,
 HUSTR_TALKTOSELF1_NUM,
 HUSTR_TALKTOSELF2_NUM,
 HUSTR_TALKTOSELF3_NUM,
 HUSTR_TALKTOSELF4_NUM,
 HUSTR_TALKTOSELF5_NUM,
 HUSTR_MESSAGESENT_NUM,
 AMSTR_FOLLOWON_NUM,
 AMSTR_FOLLOWOFF_NUM,
 AMSTR_GRIDON_NUM,
 AMSTR_GRIDOFF_NUM,
 AMSTR_MARKEDSPOT_NUM,
 AMSTR_MARKSCLEARED_NUM,
 STSTR_MUS_NUM,
 STSTR_NOMUS_NUM,
 STSTR_DQDON_NUM,
 STSTR_DQDOFF_NUM,
 STSTR_KFAADDED_NUM,
 STSTR_FAADDED_NUM,
 STSTR_NCON_NUM,
 STSTR_NCOFF_NUM,
 STSTR_BEHOLD_NUM,
 STSTR_BEHOLDX_NUM,
 STSTR_CHOPPERS_NUM,
 STSTR_CLEV_NUM,
 E1TEXT_NUM,
 E2TEXT_NUM,
 E3TEXT_NUM,
 E4TEXT_NUM,
 // sequential 1..6
 C1TEXT_NUM,
 C2TEXT_NUM,
 C3TEXT_NUM,
 C4TEXT_NUM,
 C5TEXT_NUM,
 C6TEXT_NUM,
 // sequential 1..6
 P1TEXT_NUM,
 P2TEXT_NUM,
 P3TEXT_NUM,
 P4TEXT_NUM,
 P5TEXT_NUM,
 P6TEXT_NUM,
 // sequential 1..6
 T1TEXT_NUM,
 T2TEXT_NUM,
 T3TEXT_NUM,
 T4TEXT_NUM,
 T5TEXT_NUM,
 T6TEXT_NUM,
 CC_ZOMBIE_NUM,
 CC_SHOTGUN_NUM,
 CC_HEAVY_NUM,
 CC_IMP_NUM,
 CC_DEMON_NUM,
 CC_LOST_NUM,
 CC_CACO_NUM,
 CC_HELL_NUM,
 CC_BARON_NUM,
 CC_ARACH_NUM,
 CC_PAIN_NUM,
 CC_REVEN_NUM,
 CC_MANCU_NUM,
 CC_ARCH_NUM,
 CC_SPIDER_NUM,
 CC_CYBER_NUM,
 CC_HERO_NUM,

 QUITMSG_NUM,
 QUITMSG1_NUM,
 QUITMSG2_NUM,
 QUITMSG3_NUM,
 QUITMSG4_NUM,
 QUITMSG5_NUM,
 QUITMSG6_NUM,
 QUITMSG7_NUM,

 QUIT2MSG_NUM,
 QUIT2MSG1_NUM,
 QUIT2MSG2_NUM,
 QUIT2MSG3_NUM,
 QUIT2MSG4_NUM,
 QUIT2MSG5_NUM,
 QUIT2MSG6_NUM,

 BGFLATE1_NUM,
 BGFLATE2_NUM,
 BGFLATE3_NUM,
 BGFLATE4_NUM,
 BGFLAT06_NUM,
 BGFLAT11_NUM,
 BGFLAT20_NUM,
 BGFLAT30_NUM,
 BGFLAT15_NUM,
 BGFLAT31_NUM,

 CREDIT_NUM,
 HELP2_NUM,
 VICTORY2_NUM,
 ENDPIC_NUM,

 MODIFIED_NUM,
 SHAREWARE_NUM,
 COMERCIAL_NUM,

 AUSTIN_NUM,
 M_LOAD_NUM,
 Z_INIT_NUM,
 W_INIT_NUM,
 M_INIT_NUM,
 R_INIT_NUM,
 P_INIT_NUM,
 I_INIT_NUM,
 D_CHECKNET_NUM,
 S_SETSOUND_NUM,
 HU_INIT_NUM,
 ST_INIT_NUM,
 STATREG_NUM,

 //SoM: 3/9/2000: Add boom messages.
 PD_BLUEC_NUM,
 PD_REDC_NUM,
 PD_YELLOWC_NUM,
 PD_BLUES_NUM,
 PD_REDS_NUM,
 PD_YELLOWS_NUM,
 PD_ANY_NUM,
 PD_ALL3_NUM,
 PD_ALL6_NUM,

 // heretic stuff

 TXT_ARTIHEALTH_NUM,
 TXT_ARTIFLY_NUM,
 TXT_ARTIINVULNERABILITY_NUM,
 TXT_ARTITOMEOFPOWER_NUM,
 TXT_ARTIINVISIBILITY_NUM,
 TXT_ARTIEGG_NUM,
 TXT_ARTISUPERHEALTH_NUM,
 TXT_ARTITORCH_NUM,
 TXT_ARTIFIREBOMB_NUM,
 TXT_ARTITELEPORT_NUM,

 TXT_AMMOGOLDWAND1_NUM,
 TXT_AMMOGOLDWAND2_NUM,
 TXT_AMMOMACE1_NUM,
 TXT_AMMOMACE2_NUM,
 TXT_AMMOCROSSBOW1_NUM,
 TXT_AMMOCROSSBOW2_NUM,
 TXT_AMMOBLASTER1_NUM,
 TXT_AMMOBLASTER2_NUM,
 TXT_AMMOSKULLROD1_NUM,
 TXT_AMMOSKULLROD2_NUM,
 TXT_AMMOPHOENIXROD1_NUM,
 TXT_AMMOPHOENIXROD2_NUM,

 TXT_WPNMACE_NUM,
 TXT_WPNCROSSBOW_NUM,
 TXT_WPNBLASTER_NUM,
 TXT_WPNSKULLROD_NUM,
 TXT_WPNPHOENIXROD_NUM,
 TXT_WPNGAUNTLETS_NUM,

 TXT_ITEMBAGOFHOLDING_NUM,

 TXT_CHEATGODON_NUM,
 TXT_CHEATGODOFF_NUM,
 TXT_CHEATNOCLIPON_NUM,
 TXT_CHEATNOCLIPOFF_NUM,
 TXT_CHEATWEAPONS_NUM,
 TXT_CHEATFLIGHTON_NUM,
 TXT_CHEATFLIGHTOFF_NUM,
 TXT_CHEATPOWERON_NUM,
 TXT_CHEATPOWEROFF_NUM,
 TXT_CHEATHEALTH_NUM,
 TXT_CHEATKEYS_NUM,
 TXT_CHEATSOUNDON_NUM,
 TXT_CHEATSOUNDOFF_NUM,
 TXT_CHEATTICKERON_NUM,
 TXT_CHEATTICKEROFF_NUM,
 TXT_CHEATARTIFACTS1_NUM,
 TXT_CHEATARTIFACTS2_NUM,
 TXT_CHEATARTIFACTS3_NUM,
 TXT_CHEATARTIFACTSFAIL_NUM,
 TXT_CHEATWARP_NUM,
 TXT_CHEATSCREENSHOT_NUM,
 TXT_CHEATCHICKENON_NUM,
 TXT_CHEATCHICKENOFF_NUM,
 TXT_CHEATMASSACRE_NUM,
 TXT_CHEATIDDQD_NUM,
 TXT_CHEATIDKFA_NUM,

 HERETIC_E1M1_NUM,
 HERETIC_E1M2_NUM,
 HERETIC_E1M3_NUM,
 HERETIC_E1M4_NUM,
 HERETIC_E1M5_NUM,
 HERETIC_E1M6_NUM,
 HERETIC_E1M7_NUM,
 HERETIC_E1M8_NUM,
 HERETIC_E1M9_NUM,
 HERETIC_E2M1_NUM,
 HERETIC_E2M2_NUM,
 HERETIC_E2M3_NUM,
 HERETIC_E2M4_NUM,
 HERETIC_E2M5_NUM,
 HERETIC_E2M6_NUM,
 HERETIC_E2M7_NUM,
 HERETIC_E2M8_NUM,
 HERETIC_E2M9_NUM,
 HERETIC_E3M1_NUM,
 HERETIC_E3M2_NUM,
 HERETIC_E3M3_NUM,
 HERETIC_E3M4_NUM,
 HERETIC_E3M5_NUM,
 HERETIC_E3M6_NUM,
 HERETIC_E3M7_NUM,
 HERETIC_E3M8_NUM,
 HERETIC_E3M9_NUM,
 HERETIC_E4M1_NUM,
 HERETIC_E4M2_NUM,
 HERETIC_E4M3_NUM,
 HERETIC_E4M4_NUM,
 HERETIC_E4M5_NUM,
 HERETIC_E4M6_NUM,
 HERETIC_E4M7_NUM,
 HERETIC_E4M8_NUM,
 HERETIC_E4M9_NUM,
 HERETIC_E5M1_NUM,
 HERETIC_E5M2_NUM,
 HERETIC_E5M3_NUM,
 HERETIC_E5M4_NUM,
 HERETIC_E5M5_NUM,
 HERETIC_E5M6_NUM,
 HERETIC_E5M7_NUM,
 HERETIC_E5M8_NUM,
 HERETIC_E5M9_NUM,

 HERETIC_E1TEXT,
 HERETIC_E2TEXT,
 HERETIC_E3TEXT,
 HERETIC_E4TEXT,
 HERETIC_E5TEXT,

 DEATHMSG_SUICIDE,
 DEATHMSG_TELEFRAG,
 DEATHMSG_FIST,
 DEATHMSG_GUN,
 DEATHMSG_SHOTGUN,
 DEATHMSG_MACHGUN,
 DEATHMSG_ROCKET,
 DEATHMSG_GIBROCKET,
 DEATHMSG_PLASMA,
 DEATHMSG_BFGBALL,
 DEATHMSG_CHAINSAW,
 DEATHMSG_SUPSHOTGUN,
 DEATHMSG_PLAYUNKNOW,
 DEATHMSG_HELLSLIME,
 DEATHMSG_NUKE,
 DEATHMSG_SUPHELLSLIME,
 DEATHMSG_SPECUNKNOW,
 DEATHMSG_BARRELFRAG,
 DEATHMSG_BARREL,
 DEATHMSG_POSSESSED,
 DEATHMSG_SHOTGUY,
 DEATHMSG_VILE,
 DEATHMSG_FATSO,
 DEATHMSG_CHAINGUY,
 DEATHMSG_TROOP,
 DEATHMSG_SERGEANT,
 DEATHMSG_SHADOWS,
 DEATHMSG_HEAD,
 DEATHMSG_BRUISER,
 DEATHMSG_UNDEAD,
 DEATHMSG_KNIGHT,
 DEATHMSG_SKULL,
 DEATHMSG_SPIDER,
 DEATHMSG_BABY,
 DEATHMSG_CYBORG,
 DEATHMSG_PAIN,
 DEATHMSG_WOLFSS,
 DEATHMSG_DEAD,

 SPECIALDEHACKED,

 DOOM2TITLE_NUM = SPECIALDEHACKED,
 DOOMUTITLE_NUM,
 DOOMTITLE_NUM,
 DOOM1TITLE_NUM,

#ifdef BEX_SAVEGAMENAME     
 SAVEGAMENAME_NUM, // [WDJ] Added 9/5/2011
#endif

 NUMTEXT
} text_enum;

#if 0
// [WDJ] These were removed from text, and are not changable
 DOOM2WAD_NUM,	    //UNUSED
 DOOMUWAD_NUM,      //UNUSED
 DOOMWAD_NUM,       //UNUSED
 DOOM1WAD_NUM,      //UNUSED

 CDROM_DIR_NUM,     //UNUSED
 CDROM_DEF_NUM,     //UNUSED
 CDROM_SAVE_NUM,    //UNUSED
 NORM_SAVE_NUM,     //UNUSED

 CDROM_SAVEI_NUM,
 NORM_SAVEI_NUM,
#endif


#endif
