/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.OperationCanceledException;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.SwingDocument;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDJDocument
extends SwingDocument
implements DJDocument,
OptionConstants {
    protected static final HashSet<String> _normEndings = AbstractDJDocument._makeNormEndings();
    protected static final HashSet<String> _keywords = AbstractDJDocument._makeKeywords();
    protected static final HashSet<String> _primTypes = AbstractDJDocument._makePrimTypes();
    protected int _indent = 2;
    public BraceReduction _reduced = new ReducedModelControl();
    protected int _currentLocation = 0;
    private final Hashtable<String, Object> _helperCache = new Hashtable();
    private final Vector<String> _helperCacheHistory = new Vector();
    protected boolean _cacheInUse;
    private static final int MAX_CACHE_SIZE = 10000;
    public static final int DOCSTART = 0;
    public static final int ERROR_INDEX = -1;
    private final Indenter _indenter;
    private OptionListener<Integer> _listener1;
    private OptionListener<Boolean> _listener2;

    protected AbstractDJDocument() {
        int ind = DrJava.getConfig().getSetting(INDENT_LEVEL);
        this._indenter = this.makeNewIndenter(ind);
        this._initNewIndenter();
    }

    protected AbstractDJDocument(Indenter indent) {
        this._indenter = indent;
    }

    protected abstract Indenter makeNewIndenter(int var1);

    @Override
    public int getIndent() {
        return this._indent;
    }

    @Override
    public void setIndent(int indent) {
        DrJava.getConfig().setSetting(INDENT_LEVEL, new Integer(indent));
        this._indent = indent;
    }

    protected void _removeIndenter() {
        DrJava.getConfig().removeOptionListener(INDENT_LEVEL, this._listener1);
        DrJava.getConfig().removeOptionListener(AUTO_CLOSE_COMMENTS, this._listener2);
    }

    private void _initNewIndenter() {
        this._listener1 = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                AbstractDJDocument.access$000(AbstractDJDocument.this).buildTree((Integer)oce.value);
            }
        };
        this._listener2 = new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                AbstractDJDocument.access$000(AbstractDJDocument.this).buildTree(DrJava.getConfig().getSetting(OptionConstants.INDENT_LEVEL));
            }
        };
        DrJava.getConfig().addOptionListener(INDENT_LEVEL, this._listener1);
        DrJava.getConfig().addOptionListener(AUTO_CLOSE_COMMENTS, this._listener2);
    }

    protected static HashSet<String> _makeNormEndings() {
        HashSet<String> normEndings = new HashSet<String>();
        normEndings.add(";");
        normEndings.add("{");
        normEndings.add("}");
        normEndings.add("(");
        return normEndings;
    }

    protected static HashSet<String> _makeKeywords() {
        String[] words = new String[]{"import", "native", "package", "goto", "const", "if", "else", "switch", "while", "for", "do", "true", "false", "null", "this", "super", "new", "instanceof", "return", "static", "synchronized", "transient", "volatile", "final", "strictfp", "throw", "try", "catch", "finally", "throws", "extends", "implements", "interface", "class", "break", "continue", "public", "protected", "private", "abstract", "case", "default", "assert", "enum"};
        HashSet<String> keywords = new HashSet<String>();
        for (int i = 0; i < words.length; ++i) {
            keywords.add(words[i]);
        }
        return keywords;
    }

    protected static HashSet<String> _makePrimTypes() {
        String[] words = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void"};
        HashSet<String> prims = new HashSet<String>();
        for (String w : words) {
            prims.add(w);
        }
        return prims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<HighlightStatus> getHighlightStatus(int start, int end) {
        Vector<HighlightStatus> v;
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.setCurrentLocation(start);
                v = this._reduced.getHighlightStatus(start, end - start);
                for (int i = 0; i < v.size(); ++i) {
                    HighlightStatus stat = v.get(i);
                    if (stat.getState() != 0) continue;
                    i = this._highlightKeywords(v, i);
                }
            }
        }
        finally {
            this.readUnlock();
        }
        return v;
    }

    private int _highlightKeywords(Vector<HighlightStatus> v, int i) {
        String text;
        String delimiters = " \t\n\r{}()[].+-/*;:=!@#$%^&*~<>?,\"`'<>|";
        HighlightStatus original = v.get(i);
        try {
            text = this.getText(original.getLocation(), original.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\n\r{}()[].+-/*;:=!@#$%^&*~<>?,\"`'<>|", true);
        int start = original.getLocation();
        int length = 0;
        v.remove(i);
        int index = i;
        int state = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean process = false;
            if (this._isType(token)) {
                state = 6;
                process = true;
            } else if (_keywords.contains(token)) {
                state = 4;
                process = true;
            } else if (this._isNum(token)) {
                state = 5;
                process = true;
            }
            if (process) {
                if (length != 0) {
                    HighlightStatus newStat = new HighlightStatus(start, length, original.getState());
                    v.add(index, newStat);
                    ++index;
                    start += length;
                    length = 0;
                }
                int keywordLength = token.length();
                v.add(index, new HighlightStatus(start, keywordLength, state));
                ++index;
                start += keywordLength;
                continue;
            }
            length += token.length();
        }
        if (length != 0) {
            HighlightStatus newStat = new HighlightStatus(start, length, original.getState());
            v.add(index, newStat);
            ++index;
            length = 0;
        }
        return index - 1;
    }

    private boolean _isNum(String x) {
        try {
            Double.parseDouble(x);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean _isType(String x) {
        if (_primTypes.contains(x)) {
            return true;
        }
        try {
            return Character.isUpperCase(x.charAt(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private boolean _hasOnlySpaces(String text) {
        return text.trim().length() == 0;
    }

    protected abstract void _styleChanged();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Hashtable<String, Object> hashtable = this._helperCache;
        synchronized (hashtable) {
            if (this._cacheInUse) {
                this._clearCache();
            }
        }
    }

    private void _clearCache() {
        this._helperCache.clear();
        this._helperCacheHistory.clear();
        this._cacheInUse = false;
    }

    private void _addCharToReducedModel(char curChar) {
        this.clearCache();
        this._reduced.insertChar(curChar);
    }

    @Override
    public int getCurrentLocation() {
        return this._currentLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentLocation(int loc) {
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.move(loc - this._currentLocation);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(int dist) {
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int newLoc = this._currentLocation + dist;
                if (newLoc < 0) {
                    newLoc = 0;
                } else if (newLoc > this.getLength()) {
                    newLoc = this.getLength();
                }
                this._currentLocation = newLoc;
                this._reduced.move(dist);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int balanceBackward() {
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int n = this._reduced.balanceBackward();
                return n;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int balanceForward() {
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int n = this._reduced.balanceForward();
                return n;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    public BraceReduction getReduced() {
        return this._reduced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndentInfo getIndentInformation() {
        IndentInfo info;
        String key = new StringBuffer().append("getIndentInformation:").append(this._currentLocation).toString();
        IndentInfo cached = (IndentInfo)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                info = this._reduced.getIndentInformation();
            }
        }
        finally {
            this.readUnlock();
        }
        this._storeInCache(key, info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReducedModelState stateAtRelLocation(int dist) {
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                ReducedModelState reducedModelState = this._reduced.moveWalkerGetState(dist);
                return reducedModelState;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReducedModelState getStateAtCurrent() {
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                ReducedModelState reducedModelState = this._reduced.getStateAtCurrent();
                return reducedModelState;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetReducedModelLocation() {
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this._reduced.resetLocation();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int findPrevDelimiter(int pos, char[] delims) throws BadLocationException {
        return this.findPrevDelimiter(pos, delims, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findPrevDelimiter(int pos, char[] delims, boolean skipParenPhrases) throws BadLocationException {
        int i;
        StringBuffer keyBuf = new StringBuffer("findPrevDelimiter:").append(pos);
        for (char ch : delims) {
            keyBuf.append(':').append(ch);
        }
        keyBuf.append(':').append(skipParenPhrases);
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int reducedPos = pos;
        this.readLock();
        try {
            String text = this.getText(0, pos);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int origLocation = this._currentLocation;
                this._reduced.move(pos - origLocation);
                for (i = pos - 1; i >= 0; --i) {
                    if (!AbstractDJDocument.match(text.charAt(i), delims)) continue;
                    this._reduced.move(i - reducedPos);
                    reducedPos = i;
                    ReducedModelState state = this._reduced.getStateAtCurrent();
                    if (state.equals(ReducedModelState.FREE) && !AbstractDJDocument._isStartOfComment(text, i) && (i <= 0 || !AbstractDJDocument._isStartOfComment(text, i - 1)) && (!skipParenPhrases || !this.posInParenPhrase())) break;
                }
                this._reduced.move(origLocation - reducedPos);
            }
        }
        finally {
            this.readUnlock();
        }
        if (i == -1) {
            reducedPos = -1;
        }
        this._storeInCache(key, new Integer(reducedPos));
        return reducedPos;
    }

    private static boolean match(char c, char[] delims) {
        for (char d : delims) {
            if (c != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean findCharInStmtBeforePos(char findChar, int position) {
        boolean found;
        if (position == -1) {
            String mesg = "Argument endChar to QuestionExistsCharInStmt must be a char that exists on the current line.";
            throw new UnexpectedException(new IllegalArgumentException(mesg));
        }
        char[] findCharDelims = new char[]{findChar, ';', '{', '}'};
        this.readLock();
        try {
            int prevFindChar = this.findPrevDelimiter(position, findCharDelims, false);
            if (prevFindChar == -1 || prevFindChar < 0) {
                boolean bl = false;
                return bl;
            }
            String foundString = this.getText(prevFindChar, 1);
            char foundChar = foundString.charAt(0);
            found = foundChar == findChar;
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.readUnlock();
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findPrevCharPos(int pos, char[] whitespace) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("findPrevCharPos:").append(pos);
        for (char ch : whitespace) {
            keyBuf.append(':').append(ch);
        }
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int reducedPos = pos;
        int i = pos - 1;
        this.readLock();
        try {
            String text = this.getText(0, pos);
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int origLocation = this._currentLocation;
                this._reduced.move(pos - origLocation);
                while (i >= 0) {
                    if (AbstractDJDocument.match(text.charAt(i), whitespace)) {
                        --i;
                        continue;
                    }
                    this._reduced.move(i - reducedPos);
                    reducedPos = i;
                    if (this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_LINE_COMMENT) || this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_BLOCK_COMMENT)) {
                        --i;
                        continue;
                    }
                    if (!AbstractDJDocument._isEndOfComment(text, i)) break;
                    i -= 2;
                }
                this._reduced.move(origLocation - reducedPos);
            }
        }
        finally {
            this.readUnlock();
        }
        int result = reducedPos;
        if (i < 0) {
            result = -1;
        }
        this._storeInCache(key, new Integer(result));
        return result;
    }

    protected Object _checkCache(String key) {
        Object result = this._helperCache.get(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _storeInCache(String key, Object result) {
        Hashtable<String, Object> hashtable = this._helperCache;
        synchronized (hashtable) {
            Object prev;
            this._cacheInUse = true;
            if (this._helperCache.size() >= 10000) {
                if (this._helperCacheHistory.size() > 0) {
                    this._helperCache.remove(this._helperCacheHistory.get(0));
                    this._helperCacheHistory.remove(0);
                } else {
                    throw new RuntimeException("Cache larger than cache history!");
                }
            }
            if ((prev = this._helperCache.put(key, result)) == null) {
                this._helperCacheHistory.add(key);
            }
        }
    }

    @Override
    public void indentLines(int selStart, int selEnd) {
        try {
            this.indentLines(selStart, selEnd, 0, null);
        }
        catch (OperationCanceledException oce) {
            throw new UnexpectedException(oce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indentLines(int selStart, int selEnd, int reason, ProgressMonitor pm) throws OperationCanceledException {
        this.writeLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                if (selStart == selEnd) {
                    Position oldCurrentPosition = this.createPosition(this._currentLocation);
                    if (this._indentLine(reason)) {
                        this.setCurrentLocation(oldCurrentPosition.getOffset());
                        if (this.onlyWhiteSpaceBeforeCurrent()) {
                            int space = this.getWhiteSpace();
                            this.move(space);
                        }
                    }
                } else {
                    this._indentBlock(selStart, selEnd, reason, pm);
                }
            }
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.writeUnlock();
        }
        this.endLastCompoundEdit();
    }

    private void _indentBlock(int start, int end, int reason, ProgressMonitor pm) throws OperationCanceledException, BadLocationException {
        Position endPos = this.createPosition(end);
        for (int walker = start; walker < endPos.getOffset(); walker += this._reduced.getDistToNextNewline() + 1) {
            this.setCurrentLocation(walker);
            Position walkerPos = this.createPosition(walker);
            this._indentLine(reason);
            this.setCurrentLocation(walkerPos.getOffset());
            walker = walkerPos.getOffset();
            if (pm == null) continue;
            pm.setProgress(walker);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    public boolean _indentLine(int reason) {
        return this._indenter.indent(this, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIntelligentBeginLinePos(int currPos) throws BadLocationException {
        int firstRealChar;
        int i;
        String prefix;
        int firstChar;
        this.readLock();
        try {
            firstChar = this.getLineStartPos(currPos);
            prefix = this.getText(firstChar, currPos - firstChar);
        }
        finally {
            this.readUnlock();
        }
        int len = prefix.length();
        for (i = 0; i < len && Character.isWhitespace(prefix.charAt(i)); ++i) {
        }
        if (i < len && (firstRealChar = firstChar + i) < currPos) {
            return firstRealChar;
        }
        return firstChar;
    }

    @Override
    public String getIndentOfCurrStmt(int pos) throws BadLocationException {
        char[] delims = new char[]{';', '{', '}'};
        char[] whitespace = new char[]{' ', '\t', '\n', ','};
        return this.getIndentOfCurrStmt(pos, delims, whitespace);
    }

    @Override
    public String getIndentOfCurrStmt(int pos, char[] delims) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n', ','};
        return this.getIndentOfCurrStmt(pos, delims, whitespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIndentOfCurrStmt(int pos, char[] delims, char[] whitespace) throws BadLocationException {
        String lineText;
        StringBuffer keyBuf = new StringBuffer("getIndentOfCurrStmt:").append(pos);
        for (char ch : delims) {
            keyBuf.append(':').append(ch);
        }
        String key = keyBuf.toString();
        String cached = (String)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.readLock();
        try {
            BraceReduction ch = this._reduced;
            synchronized (ch) {
                int nextNonWSChar;
                int lineStart = this.getLineStartPos(pos);
                boolean reachedStart = false;
                int prevDelim = lineStart;
                boolean ignoreParens = this.posInParenPhrase(prevDelim);
                while ((prevDelim = this.findPrevDelimiter(prevDelim, delims, ignoreParens)) <= 0 || prevDelim >= this.getLength() || this.getText(prevDelim, 1).charAt(0) != '{') {
                    if (prevDelim == -1) {
                        reachedStart = true;
                        break;
                    }
                    ignoreParens = this.posInParenPhrase(prevDelim);
                    if (ignoreParens) continue;
                }
                if ((nextNonWSChar = reachedStart ? this.getFirstNonWSCharPos(0) : this.getFirstNonWSCharPos(prevDelim + 1, whitespace, false)) == -1) {
                    nextNonWSChar = this.getLength();
                }
                int lineStartStmt = this.getLineStartPos(nextNonWSChar);
                int lineFirstNonWS = this.getLineFirstCharPos(lineStartStmt);
                lineText = this.getText(lineStartStmt, lineFirstNonWS - lineStartStmt);
            }
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.readUnlock();
        }
        this._storeInCache(key, lineText);
        return lineText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findCharOnLine(int pos, char findChar) {
        int matchIndex;
        int i;
        String key = new StringBuffer().append("findCharOnLine:").append(pos).append(":").append(findChar).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int here = this._currentLocation;
                int lineStart = this.getLineStartPos(pos);
                int lineEnd = this.getLineEndPos(pos);
                String lineText = this.getText(lineStart, lineEnd - lineStart);
                i = lineText.indexOf(findChar, 0);
                matchIndex = i + lineStart;
                while (i != -1) {
                    this._reduced.move(matchIndex - here);
                    if (this._reduced.getStateAtCurrent().equals(ReducedModelState.FREE)) {
                        this._reduced.move(here - matchIndex);
                        break;
                    }
                    this._reduced.move(here - matchIndex);
                    i = lineText.indexOf(findChar, i + 1);
                }
            }
        }
        catch (Throwable t) {
            throw new UnexpectedException(t);
        }
        finally {
            this.readUnlock();
        }
        if (i == -1) {
            matchIndex = -1;
        }
        this._storeInCache(key, new Integer(matchIndex));
        return matchIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineStartPos(int pos) {
        int dist;
        if (pos < 0 || pos > this.getLength()) {
            return -1;
        }
        String key = new StringBuffer().append("getLineStartPos:").append(pos).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int location = this._currentLocation;
                this._reduced.move(pos - location);
                dist = this._reduced.getDistToPreviousNewline(0);
                this._reduced.move(location - pos);
            }
        }
        finally {
            this.readUnlock();
        }
        if (dist == -1) {
            this._storeInCache(key, new Integer(0));
            return 0;
        }
        this._storeInCache(key, new Integer(pos - dist));
        return pos - dist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineEndPos(int pos) {
        int dist;
        if (pos < 0 || pos > this.getLength()) {
            return -1;
        }
        String key = new StringBuffer().append("getLineEndPos:").append(pos).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int location = this._currentLocation;
                this._reduced.move(pos - location);
                dist = this._reduced.getDistToNextNewline();
                this._reduced.move(location - pos);
            }
        }
        finally {
            this.readUnlock();
        }
        this._storeInCache(key, new Integer(pos + dist));
        return pos + dist;
    }

    @Override
    public int getLineFirstCharPos(int pos) throws BadLocationException {
        String key = new StringBuffer().append("getLineFirstCharPos:").append(pos).toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int startLinePos = this.getLineStartPos(pos);
        int endLinePos = this.getLineEndPos(pos);
        String text = this.getText(startLinePos, endLinePos - startLinePos);
        for (int walker = 0; walker < text.length(); ++walker) {
            if (text.charAt(walker) == ' ' || text.charAt(walker) == '\t') {
                continue;
            }
            this._storeInCache(key, new Integer(startLinePos + walker));
            return startLinePos + walker;
        }
        this._storeInCache(key, new Integer(endLinePos));
        return endLinePos;
    }

    @Override
    public int getFirstNonWSCharPos(int pos) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.getFirstNonWSCharPos(pos, whitespace, false);
    }

    @Override
    public int getFirstNonWSCharPos(int pos, boolean acceptComments) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.getFirstNonWSCharPos(pos, whitespace, acceptComments);
    }

    @Override
    public int getFirstNonWSCharPos(int pos, char[] whitespace, boolean acceptComments) throws BadLocationException {
        StringBuffer keyBuf = new StringBuffer("getFirstNonWSCharPos:").append(pos);
        for (char ch : whitespace) {
            keyBuf.append(':').append(ch);
        }
        String key = keyBuf.toString();
        Integer cached = (Integer)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        int i = pos;
        int endPos = this.getLength();
        String text = this.getText(pos, endPos - pos);
        int origLocation = this._currentLocation;
        this._reduced.move(pos - origLocation);
        int reducedPos = pos;
        while (i < endPos) {
            if (AbstractDJDocument.match(text.charAt(i - pos), whitespace)) {
                ++i;
                continue;
            }
            this._reduced.move(i - reducedPos);
            reducedPos = i;
            if (!acceptComments && (this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_LINE_COMMENT) || this._reduced.getStateAtCurrent().equals(ReducedModelState.INSIDE_BLOCK_COMMENT))) {
                ++i;
                continue;
            }
            if (acceptComments || !AbstractDJDocument._isStartOfComment(text, i - pos)) break;
            i += 2;
        }
        this._reduced.move(origLocation - reducedPos);
        int result = reducedPos;
        if (i == endPos) {
            result = -1;
        }
        this._storeInCache(key, new Integer(result));
        return result;
    }

    @Override
    public int findPrevNonWSCharPos(int pos) throws BadLocationException {
        char[] whitespace = new char[]{' ', '\t', '\n'};
        return this.findPrevCharPos(pos, whitespace);
    }

    protected static boolean _isStartOfComment(String text, int pos) {
        char currChar = text.charAt(pos);
        if (currChar == '/') {
            try {
                char afterCurrChar = text.charAt(pos + 1);
                if (afterCurrChar == '/' || afterCurrChar == '*') {
                    return true;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static boolean _isEndOfComment(String text, int pos) {
        char currChar = text.charAt(pos);
        if (currChar == '/') {
            try {
                char beforeCurrChar = text.charAt(pos - 1);
                if (beforeCurrChar == '/' || beforeCurrChar == '*') {
                    return true;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean posInParenPhrase(int pos) {
        boolean inParenPhrase;
        String key = new StringBuffer().append("posInParenPhrase:").append(pos).toString();
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                int here = this._currentLocation;
                this._reduced.move(pos - here);
                inParenPhrase = this.posInParenPhrase();
                this._reduced.move(here - pos);
            }
        }
        finally {
            this.readUnlock();
        }
        this._storeInCache(key, Autobox.valueOf(inParenPhrase));
        return inParenPhrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean posInParenPhrase() {
        IndentInfo info;
        this.readLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                info = this._reduced.getIndentInformation();
            }
        }
        finally {
            this.readUnlock();
        }
        return info.braceTypeCurrent.equals("(");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean posNotInBlock(int pos) {
        boolean notInParenPhrase;
        String key = new StringBuffer().append("posNotInBlock:").append(pos).toString();
        Boolean cached = (Boolean)this._checkCache(key);
        if (cached != null) {
            return cached;
        }
        BraceReduction braceReduction = this._reduced;
        synchronized (braceReduction) {
            int here = this._currentLocation;
            this._reduced.move(pos - here);
            IndentInfo info = this._reduced.getIndentInformation();
            notInParenPhrase = info.braceTypeCurrent.equals("");
            this._reduced.move(here - pos);
        }
        this._storeInCache(key, Autobox.valueOf(notInParenPhrase));
        return notInParenPhrase;
    }

    @Override
    public int getWhiteSpace() {
        try {
            return this.getWhiteSpaceBetween(0, this.getLength() - this._currentLocation);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int getWhiteSpaceBetween(int relStart, int relEnd) throws BadLocationException {
        int i;
        String text = this.getText(this._currentLocation - relStart, Math.abs(relStart - relEnd));
        int length = text.length();
        for (i = 0; i < length && text.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private boolean onlyWhiteSpaceBeforeCurrent() throws BadLocationException {
        int index;
        String text = this.getText(0, this._currentLocation);
        text = text.substring(text.lastIndexOf("\n") + 1);
        int lastChar = 32;
        for (index = text.length() - 1; lastChar == 32 && index >= 0; --index) {
            lastChar = text.charAt(index);
        }
        return index < 0;
    }

    @Override
    public void setTab(String tab, int pos) {
        try {
            int startPos = this.getLineStartPos(pos);
            int firstNonWSPos = this.getLineFirstCharPos(pos);
            int len = firstNonWSPos - startPos;
            boolean onlySpaces = this._hasOnlySpaces(tab);
            if (!onlySpaces || len != tab.length()) {
                if (onlySpaces) {
                    int diff = tab.length() - len;
                    if (diff > 0) {
                        this.insertString(firstNonWSPos, tab.substring(0, diff), null);
                    } else {
                        this.remove(firstNonWSPos + diff, -diff);
                    }
                } else {
                    this.remove(startPos, len);
                    this.insertString(startPos, tab, null);
                }
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        this.clearCache();
        super.insertUpdate(chng, attr);
        try {
            int offset = chng.getOffset();
            int length = chng.getLength();
            String str = this.getText(offset, length);
            InsertCommand doCommand = new InsertCommand(offset, str);
            RemoveCommand undoCommand = new RemoveCommand(offset, length);
            this.addUndoRedo(chng, undoCommand, doCommand);
            doCommand.run();
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        this.clearCache();
        try {
            int offset = chng.getOffset();
            int length = chng.getLength();
            String removedText = this.getText(offset, length);
            super.removeUpdate(chng);
            RemoveCommand doCommand = new RemoveCommand(offset, length);
            InsertCommand undoCommand = new InsertCommand(offset, removedText);
            this.addUndoRedo(chng, undoCommand, doCommand);
            doCommand.run();
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.writeLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.clearCache();
                super.insertString(offset, str, a);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offset, int len) throws BadLocationException {
        this.writeLock();
        try {
            BraceReduction braceReduction = this._reduced;
            synchronized (braceReduction) {
                this.clearCache();
                super.remove(offset, len);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public String getText() {
        this.readLock();
        try {
            String string = this.getText(0, this.getLength());
            return string;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock();
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected abstract int startCompoundEdit();

    protected abstract void endCompoundEdit(int var1);

    protected abstract void endLastCompoundEdit();

    protected abstract void addUndoRedo(AbstractDocument.DefaultDocumentEvent var1, Runnable var2, Runnable var3);

    static Indenter access$000(AbstractDJDocument x0) {
        return x0._indenter;
    }

    static void access$100(AbstractDJDocument x0, char x1) {
        x0._addCharToReducedModel(x1);
    }

    protected class RemoveCommand
    implements Runnable {
        private final int _offset;
        private final int _length;

        public RemoveCommand(int offset, int length) {
            this._offset = offset;
            this._length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractDJDocument.this.readLock();
            try {
                BraceReduction braceReduction = AbstractDJDocument.this._reduced;
                synchronized (braceReduction) {
                    AbstractDJDocument.this.setCurrentLocation(this._offset);
                    AbstractDJDocument.this._reduced.delete(this._length);
                    AbstractDJDocument.this._styleChanged();
                }
            }
            finally {
                AbstractDJDocument.this.readUnlock();
            }
        }
    }

    protected class InsertCommand
    implements Runnable {
        private final int _offset;
        private final String _text;

        public InsertCommand(int offset, String text) {
            this._offset = offset;
            this._text = text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractDJDocument.this.readLock();
            try {
                BraceReduction braceReduction = AbstractDJDocument.this._reduced;
                synchronized (braceReduction) {
                    AbstractDJDocument.this._reduced.move(this._offset - AbstractDJDocument.this._currentLocation);
                    int len = this._text.length();
                    for (int i = 0; i < len; ++i) {
                        char curChar = this._text.charAt(i);
                        AbstractDJDocument.access$100(AbstractDJDocument.this, curChar);
                    }
                    AbstractDJDocument.this._currentLocation = this._offset + len;
                    AbstractDJDocument.this._styleChanged();
                }
            }
            finally {
                AbstractDJDocument.this.readUnlock();
            }
        }
    }
}

