/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.FindResult;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.DocumentIterator;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public class FindReplaceMachine {
    private AbstractDocumentInterface _doc;
    private AbstractDocumentInterface _firstDoc;
    private Position _start;
    private Position _current;
    private String _findWord;
    private String _replaceWord;
    private boolean _wrapped;
    private boolean _allDocsWrapped = false;
    private boolean _checkAllDocsWrapped = false;
    private boolean _matchCase;
    private boolean _matchWholeWord;
    private boolean _searchBackwards;
    private boolean _searchAllDocuments;
    private boolean _ignoreCommentsAndStrings;
    private String _lastFindWord;
    private boolean _skipOneFind = false;
    private DocumentIterator _docIterator;
    private SingleDisplayModel _model;

    public FindReplaceMachine(SingleDisplayModel model, DocumentIterator docIterator) {
        this._model = model;
        this._docIterator = docIterator;
        this.setFindAnyOccurrence();
        this.setFindWord("");
        this.setReplaceWord("");
        this.setSearchBackwards(false);
        this.setMatchCase(true);
        this.setSearchAllDocuments(false);
        this.setIgnoreCommentsAndStrings(false);
    }

    public void cleanUp() {
        this._docIterator = null;
        this.setFindWord("");
        this._doc = null;
    }

    public void positionChanged() {
        this._lastFindWord = null;
        this._skipOneFind = false;
    }

    public void setLastFindWord() {
        this._lastFindWord = this._findWord;
    }

    public boolean getSearchBackwards() {
        return this._searchBackwards;
    }

    public void setSearchBackwards(boolean searchBackwards) {
        if (this._searchBackwards != searchBackwards) {
            this._skipOneFind = this.isOnMatch() && this._findWord.equals(this._lastFindWord);
        }
        this._searchBackwards = searchBackwards;
    }

    public void setMatchCase(boolean matchCase) {
        this._matchCase = matchCase;
    }

    public void setMatchWholeWord() {
        this._matchWholeWord = true;
    }

    public void setFindAnyOccurrence() {
        this._matchWholeWord = false;
    }

    public void setSearchAllDocuments(boolean searchAllDocuments) {
        this._searchAllDocuments = searchAllDocuments;
    }

    public void setIgnoreCommentsAndStrings(boolean ignoreCommentsAndStrings) {
        this._ignoreCommentsAndStrings = ignoreCommentsAndStrings;
    }

    public void setDocument(AbstractDocumentInterface doc) {
        this._doc = doc;
    }

    public void setFirstDoc(AbstractDocumentInterface firstDoc) {
        this._firstDoc = firstDoc;
    }

    public void setPosition(int pos) {
        try {
            this._current = this._doc.createPosition(pos);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public void setStart(int pos) {
        try {
            this._start = this._doc.createPosition(pos);
            this._wrapped = false;
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public int getStartOffset() {
        return this._start.getOffset();
    }

    public int getCurrentOffset() {
        return this._current.getOffset();
    }

    public void makeCurrentOffsetStart() {
        try {
            this._start = this._doc.createPosition(this.getCurrentOffset());
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public String getFindWord() {
        return this._findWord;
    }

    public String getReplaceWord() {
        return this._replaceWord;
    }

    public boolean getSearchAllDocuments() {
        return this._searchAllDocuments;
    }

    public AbstractDocumentInterface getDocument() {
        return this._doc;
    }

    public AbstractDocumentInterface getFirstDoc() {
        return this._firstDoc;
    }

    public void setFindWord(String word) {
        this._findWord = word;
    }

    public void setReplaceWord(String word) {
        this._replaceWord = word;
    }

    public boolean isOnMatch() {
        String matchSpace;
        String findWord = this._findWord;
        if (this._current == null) {
            return false;
        }
        int len = findWord.length();
        int off = !this._searchBackwards ? this._current.getOffset() - len : this._current.getOffset();
        if (off < 0) {
            return false;
        }
        this._doc.acquireReadLock();
        try {
            if (off + len > this._doc.getLength()) {
                boolean bl = false;
                return bl;
            }
            matchSpace = this._doc.getText(off, len);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this._doc.releaseReadLock();
        }
        if (!this._matchCase) {
            matchSpace = matchSpace.toLowerCase();
            findWord = findWord.toLowerCase();
        }
        return matchSpace.equals(findWord);
    }

    public boolean replaceCurrent() {
        if (!this.isOnMatch()) {
            return false;
        }
        this._doc.acquireWriteLock();
        try {
            boolean atStart = false;
            int position = this.getCurrentOffset();
            if (!this._searchBackwards) {
                position -= this._findWord.length();
            }
            this._doc.remove(position, this._findWord.length());
            if (position == 0) {
                atStart = true;
            }
            this._doc.insertString(this.getCurrentOffset(), this._replaceWord, null);
            if (atStart && !this._searchBackwards) {
                this.setPosition(this._replaceWord.length());
            } else if (!atStart && this._searchBackwards) {
                this.setPosition(this.getCurrentOffset() - this._replaceWord.length());
            }
            boolean bl = true;
            return bl;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this._doc.releaseWriteLock();
        }
    }

    public int replaceAll() {
        if (this._searchAllDocuments) {
            AbstractDocumentInterface startDoc = this._doc;
            this._searchAllDocuments = false;
            int count = this._replaceAllInCurrentDoc();
            this._doc = this._docIterator.getNextDocument(this._doc);
            int n = this._docIterator.getDocumentCount();
            for (int i = 1; i < n; ++i) {
                count += this._replaceAllInCurrentDoc();
                this._doc = this._docIterator.getNextDocument(this._doc);
            }
            this._searchAllDocuments = true;
            return count;
        }
        return this._replaceAllInCurrentDoc();
    }

    private int _replaceAllInCurrentDoc() {
        this._doc.acquireReadLock();
        try {
            if (!this._searchBackwards) {
                this._start = this._doc.createPosition(0);
                this.setPosition(0);
            } else {
                this._start = this._doc.createPosition(this._doc.getLength());
                this.setPosition(this._doc.getLength());
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this._doc.releaseReadLock();
        }
        int count = 0;
        FindResult fr = this.findNext();
        this._doc = fr.getDocument();
        while (!fr.getWrapped()) {
            this.replaceCurrent();
            ++count;
            fr = this.findNext();
            this._doc = fr.getDocument();
        }
        return count;
    }

    public FindResult findNext() {
        if (this._skipOneFind) {
            int wordLength = this._lastFindWord.length();
            if (!this._searchBackwards) {
                this.setPosition(this.getCurrentOffset() + wordLength);
            } else {
                this.setPosition(this.getCurrentOffset() - wordLength);
            }
            this.positionChanged();
        }
        if (!this._searchBackwards) {
            return this._findNext(this._current.getOffset(), this._doc.getLength() - this._current.getOffset());
        }
        return this._findNext(0, this._current.getOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindResult _findNext(int start, int end) {
        try {
            int foundOffset;
            String findSpace;
            int docLen;
            FindResult tempFr = new FindResult(this._doc, -1, false, false);
            String findWord = this._findWord;
            this._doc.acquireReadLock();
            try {
                docLen = this._doc.getLength();
                findSpace = this._doc.getText(start, end);
            }
            finally {
                this._doc.releaseReadLock();
            }
            if (!this._matchCase) {
                findSpace = findSpace.toLowerCase();
                findWord = findWord.toLowerCase();
            }
            int n = foundOffset = !this._searchBackwards ? findSpace.indexOf(findWord) : findSpace.lastIndexOf(findWord);
            if (foundOffset >= 0) {
                int locationToIgnore = foundOffset + start;
                this._model.getODDForDocument(this._doc).setCurrentLocation(locationToIgnore);
                if (this._shouldIgnore(locationToIgnore, this._doc)) {
                    foundOffset += start;
                    if (!this._searchBackwards) {
                        return this._findNext(foundOffset += findWord.length(), docLen - foundOffset);
                    }
                    return this._findNext(start, foundOffset);
                }
                foundOffset += start;
                if (!this._searchBackwards) {
                    foundOffset += findWord.length();
                }
                this._current = this._doc.createPosition(foundOffset);
            } else {
                if (this._searchAllDocuments) {
                    AbstractDocumentInterface nextDocToSearch = !this._searchBackwards ? this._docIterator.getNextDocument(this._doc) : this._docIterator.getPrevDocument(this._doc);
                    tempFr = this._findNextInAllDocs(nextDocToSearch, 0, nextDocToSearch.getLength());
                    foundOffset = tempFr.getFoundOffset();
                } else {
                    this._checkAllDocsWrapped = false;
                    this._allDocsWrapped = false;
                }
                if (foundOffset == -1) {
                    if (!this._searchBackwards) {
                        foundOffset = this._findWrapped(0, this._current.getOffset() + (this._findWord.length() - 1));
                    } else {
                        int startBackOffset = this._current.getOffset() - (this._findWord.length() - 1);
                        foundOffset = this._findWrapped(startBackOffset, docLen - startBackOffset);
                    }
                }
            }
            if (this._checkAllDocsWrapped && tempFr.getDocument() == this._firstDoc) {
                this._allDocsWrapped = true;
                this._checkAllDocsWrapped = false;
            }
            FindResult fr = new FindResult(tempFr.getDocument(), foundOffset, this._wrapped, this._allDocsWrapped);
            this._wrapped = false;
            this._allDocsWrapped = true;
            if (true) {
                this._allDocsWrapped = false;
            }
            return fr;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _findWrapped(int start, int end) {
        try {
            int foundOffset;
            String findSpace;
            int docLen;
            this._wrapped = true;
            this._doc.acquireReadLock();
            try {
                docLen = this._doc.getLength();
                if (!this._searchBackwards) {
                    if (end > docLen) {
                        end = docLen;
                    }
                } else if (start < 0) {
                    start = 0;
                    end = docLen;
                }
                findSpace = this._doc.getText(start, end);
            }
            finally {
                this._doc.releaseReadLock();
            }
            String findWord = this._findWord;
            if (!this._matchCase) {
                findSpace = findSpace.toLowerCase();
                findWord = findWord.toLowerCase();
            }
            int n = foundOffset = !this._searchBackwards ? findSpace.indexOf(findWord) : findSpace.lastIndexOf(findWord);
            if (foundOffset >= 0) {
                int locationToIgnore = start + foundOffset;
                this._model.getODDForDocument(this._doc).setCurrentLocation(locationToIgnore);
                if (this._shouldIgnore(locationToIgnore, this._doc)) {
                    foundOffset += start;
                    if (!this._searchBackwards) {
                        return this._findWrapped(foundOffset += findWord.length(), docLen - foundOffset);
                    }
                    return this._findWrapped(start, foundOffset - start);
                }
                foundOffset += start;
                if (!this._searchBackwards) {
                    foundOffset += findWord.length();
                }
                this._current = this._doc.createPosition(foundOffset);
            }
            return foundOffset;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindResult _findNextInAllDocs(AbstractDocumentInterface docToSearch, int start, int end) throws BadLocationException {
        this._checkAllDocsWrapped = true;
        while (docToSearch != this._doc) {
            int foundOffset;
            String text;
            int docLen;
            if (docToSearch == this._firstDoc) {
                this._allDocsWrapped = true;
                this._checkAllDocsWrapped = false;
            }
            docToSearch.acquireReadLock();
            try {
                docLen = docToSearch.getLength();
                text = docToSearch.getText(start, end);
            }
            finally {
                docToSearch.releaseReadLock();
            }
            String findWord = this._findWord;
            if (!this._matchCase) {
                text = text.toLowerCase();
                findWord = findWord.toLowerCase();
            }
            int n = foundOffset = !this._searchBackwards ? text.indexOf(findWord) : text.lastIndexOf(findWord);
            if (foundOffset >= 0) {
                int locationToIgnore = start + foundOffset;
                this._model.getODDForDocument(docToSearch).setCurrentLocation(locationToIgnore);
                if (this._shouldIgnore(locationToIgnore, docToSearch)) {
                    foundOffset += start;
                    if (!this._searchBackwards) {
                        return this._findNextInAllDocs(docToSearch, foundOffset += findWord.length(), docLen - foundOffset);
                    }
                    return this._findNextInAllDocs(docToSearch, start, foundOffset - start);
                }
                foundOffset += start;
                if (!this._searchBackwards) {
                    foundOffset += findWord.length();
                }
                return new FindResult(docToSearch, foundOffset, false, this._allDocsWrapped);
            }
            docToSearch = !this._searchBackwards ? this._docIterator.getNextDocument(docToSearch) : this._docIterator.getPrevDocument(docToSearch);
            start = 0;
            end = docToSearch.getLength();
        }
        return new FindResult(docToSearch, -1, false, this._allDocsWrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wholeWordFoundAtCurrent(AbstractDocumentInterface doc, int foundOffset) {
        String docText;
        doc.acquireReadLock();
        try {
            docText = doc.getText();
        }
        finally {
            doc.releaseReadLock();
        }
        Character leftOfMatch = null;
        Character rightOfMatch = null;
        int leftLocation = foundOffset - 1;
        int rightLocation = foundOffset + this._findWord.length();
        boolean leftOutOfBounds = false;
        boolean rightOutOfBounds = false;
        try {
            leftOfMatch = new Character(docText.charAt(leftLocation));
        }
        catch (IndexOutOfBoundsException e) {
            leftOutOfBounds = true;
        }
        try {
            rightOfMatch = new Character(docText.charAt(rightLocation));
        }
        catch (IndexOutOfBoundsException e) {
            rightOutOfBounds = true;
        }
        if (!leftOutOfBounds && !rightOutOfBounds) {
            return this.isDelimiter(rightOfMatch) && this.isDelimiter(leftOfMatch);
        }
        if (!leftOutOfBounds) {
            return this.isDelimiter(leftOfMatch);
        }
        if (!rightOutOfBounds) {
            return this.isDelimiter(rightOfMatch);
        }
        return true;
    }

    private boolean isDelimiter(Character ch) {
        return !Character.isLetterOrDigit(ch.charValue());
    }

    private boolean _shouldIgnore(int foundOffset, AbstractDocumentInterface doc) {
        return this._matchWholeWord && !this.wholeWordFoundAtCurrent(doc, foundOffset) || this._ignoreCommentsAndStrings && this._model.getODDForDocument(doc).getStateAtCurrent() != ReducedModelStates.FREE;
    }
}

