/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleAction;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

public class ActionStartPrevStmtPlus
extends IndentRuleAction {
    private String _suffix;
    private boolean _useColon;

    public ActionStartPrevStmtPlus(String suffix, boolean colonIsDelim) {
        this._suffix = suffix;
        this._useColon = colonIsDelim;
    }

    public boolean indentLine(AbstractDJDocument doc, int reason) {
        int prevDelimiterPos;
        boolean supResult = super.indentLine(doc, reason);
        String indent = "";
        int here = doc.getCurrentLocation();
        char[] delims = new char[]{';', '{', '}'};
        int lineStart = doc.getLineStartPos(here);
        try {
            prevDelimiterPos = doc.findPrevDelimiter(lineStart, delims);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        if (prevDelimiterPos <= 0) {
            doc.setTab(this._suffix, here);
            return supResult;
        }
        try {
            int testPos;
            char delim = doc.getText(prevDelimiterPos, 1).charAt(0);
            char[] ws = new char[]{' ', '\t', '\n', ';'};
            if (delim == ';' && doc.getText(testPos = doc.findPrevCharPos(prevDelimiterPos, ws), 1).charAt(0) == '}') {
                prevDelimiterPos = testPos;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        try {
            char delim = doc.getText(prevDelimiterPos, 1).charAt(0);
            if (delim == '}') {
                doc.resetReducedModelLocation();
                int dist = prevDelimiterPos - here + 1;
                doc.move(dist);
                prevDelimiterPos -= doc.balanceBackward() - 1;
                doc.move(-dist);
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        try {
            char[] indentDelimsWithColon = new char[]{';', '{', '}', ':'};
            char[] indentDelimsWithoutColon = new char[]{';', '{', '}'};
            char[] indentDelims = this._useColon ? indentDelimsWithColon : indentDelimsWithoutColon;
            indent = doc.getIndentOfCurrStmt(prevDelimiterPos, indentDelims);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        indent = indent + this._suffix;
        doc.setTab(indent, here);
        return supResult;
    }
}

