/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRule;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleQuestion;
import edu.rice.cs.util.UnexpectedException;
import javax.swing.text.BadLocationException;

public class QuestionNewParenPhrase
extends IndentRuleQuestion {
    public QuestionNewParenPhrase(IndentRule yesRule, IndentRule noRule) {
        super(yesRule, noRule);
    }

    boolean applyRule(AbstractDJDocument doc, int reason) {
        try {
            int here = doc.getCurrentLocation();
            int startLine = doc.getLineStartPos(here);
            if (startLine > 0) {
                char[] delims = new char[]{';', ',', '(', '[', '&', '|', '+', '-', '*', '/', '%', '=', '<', '>', '}'};
                int prevDelim = doc.findPrevDelimiter(startLine, delims, false);
                if (prevDelim == -1) {
                    return false;
                }
                int nextNonWS = doc.getFirstNonWSCharPos(prevDelim + 1);
                if (nextNonWS == -1) {
                    nextNonWS = startLine;
                }
                return nextNonWS >= startLine;
            }
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        return false;
    }
}

