/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceException;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;

class Brace
extends ReducedToken
implements ReducedModelStates {
    public static final String[] braces = new String[]{"{", "}", "(", ")", "[", "]", "/*", "*/", "//", "\n", "/", "*", "\"", "\"", "'", "'", "\\\\", "\\", "\\'", "\\\"", ""};
    public static final String BLK_CMT_BEG = "/*";
    public static final String BLK_CMT_END = "*/";
    public static final String EOLN = "\n";
    public static final String LINE_CMT = "//";
    public static final String SINGLE_QUOTE = "'";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String STAR = "*";
    public static final String SLASH = "/";
    protected int _type;

    public static Brace MakeBrace(String type, ReducedModelState state) {
        int index = Brace.findBrace(type);
        if (index == braces.length) {
            throw new BraceException("Invalid brace type \"" + type + DOUBLE_QUOTE);
        }
        return new Brace(index, state);
    }

    private Brace(int type, ReducedModelState state) {
        super(state);
        this._type = type;
    }

    public String getType() {
        return this._type == braces.length ? "!" : braces[this._type];
    }

    public int getSize() {
        return this.getType().length();
    }

    public String toString() {
        StringBuffer val = new StringBuffer();
        for (int i = 0; i < this.getSize(); ++i) {
            val.append(' ');
            val.append(this.getType().charAt(i));
        }
        return val.toString();
    }

    public void flip() {
        if (this.isOpen()) {
            ++this._type;
        } else if (this._type < braces.length - 1) {
            --this._type;
        }
    }

    public boolean isOpen() {
        return this._type % 2 == 0 && this._type < braces.length - 1;
    }

    public boolean isOpenBrace() {
        return this._type == 0 || this._type == 2 || this._type == 4;
    }

    public boolean isClosedBrace() {
        return this._type == 1 || this._type == 3 || this._type == 5;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public void setType(String type) {
        int index = Brace.findBrace(type);
        if (index == braces.length) {
            throw new BraceException("Invalid brace type \"" + type + DOUBLE_QUOTE);
        }
        this._type = index;
    }

    protected static int findBrace(String type) {
        int i;
        for (i = 0; i < braces.length && !type.equals(braces[i]); ++i) {
        }
        return i;
    }

    public boolean isMatch(ReducedToken other) {
        if (this.getType().equals("")) {
            return false;
        }
        int off = this.isOpen() ? 1 : -1;
        return braces[this._type + off].equals(other.getType());
    }

    public boolean isDoubleQuote() {
        return this.getType().equals(DOUBLE_QUOTE);
    }

    public boolean isSingleQuote() {
        return this.getType().equals(SINGLE_QUOTE);
    }

    public boolean isLineComment() {
        return this.getType().equals(LINE_CMT);
    }

    public boolean isBlockCommentStart() {
        return this.getType().equals(BLK_CMT_BEG);
    }

    public boolean isBlockCommentEnd() {
        return this.getType().equals(BLK_CMT_END);
    }

    public boolean isNewline() {
        return this.getType().equals(EOLN);
    }

    public boolean isMultipleCharBrace() {
        return this.isLineComment() || this.isBlockCommentStart() || this.isBlockCommentEnd() || this.isDoubleEscapeSequence();
    }

    public boolean isDoubleEscapeSequence() {
        return this.isDoubleEscape() || this.isEscapedDoubleQuote() || this.isEscapedSingleQuote();
    }

    public boolean isDoubleEscape() {
        return this.getType().equals("\\\\");
    }

    public boolean isEscapedDoubleQuote() {
        return this.getType().equals("\\\"");
    }

    public boolean isEscapedSingleQuote() {
        return this.getType().equals("\\'");
    }

    public boolean isGap() {
        return false;
    }

    public boolean isSlash() {
        return this.getType().equals(SLASH);
    }

    public boolean isStar() {
        return this.getType().equals(STAR);
    }

    public void grow(int delta) {
        throw new RuntimeException("Braces can't grow.");
    }

    public void shrink(int delta) {
        throw new RuntimeException("Braces can't shrink.");
    }
}

