/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelList<T> {
    private Node<T> _head = new Node();
    private Node<T> _tail = new Node();
    private int _length;
    private Set<Iterator> _listeners;

    ModelList() {
        this._head.pred = null;
        this._head.succ = this._tail;
        this._tail.pred = this._head;
        this._tail.succ = null;
        this._length = 0;
        this._listeners = new HashSet<Iterator>();
    }

    private void insert(Node<T> point, T item) {
        Node<T> ins = new Node<T>(item, point.pred, point);
        point.pred.succ = ins;
        point.pred = ins;
        ++this._length;
    }

    public void insertFront(T item) {
        Iterator it = new Iterator();
        it.insert(item);
        it.dispose();
    }

    private void remove(Node<T> point) {
        if (point == this._head || point == this._tail) {
            throw new RuntimeException("Can't remove head.");
        }
        point.succ.pred = point.pred;
        point.pred.succ = point.succ;
        --this._length;
    }

    private void addListener(Iterator thing) {
        this._listeners.add(thing);
    }

    private void removeListener(Iterator thing) {
        this._listeners.remove(thing);
    }

    public int listenerCount() {
        return this._listeners.size();
    }

    public boolean isEmpty() {
        return this._head.succ == this._tail;
    }

    public int length() {
        return this._length;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    static Node access$000(ModelList x0) {
        return x0._head;
    }

    static void access$100(ModelList x0, Iterator x1) {
        x0.addListener(x1);
    }

    static void access$200(ModelList x0, Iterator x1) {
        x0.removeListener(x1);
    }

    static Node access$300(ModelList x0) {
        return x0._tail;
    }

    static void access$400(ModelList x0, Node x1, Object x2) {
        x0.insert(x1, x2);
    }

    static void access$500(ModelList x0, Node x1) {
        x0.remove(x1);
    }

    static int access$620(ModelList x0, int x1) {
        return x0._length -= x1;
    }

    static Set access$700(ModelList x0) {
        return x0._listeners;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Iterator {
        private Node<T> _point;
        private int _pos;

        public Iterator() {
            this._point = ModelList.access$000(ModelList.this);
            this._pos = 0;
            ModelList.access$100(ModelList.this, this);
        }

        public Iterator(Iterator iter) {
            this._point = iter._point;
            this._pos = iter._pos;
            ModelList.access$100(ModelList.this, this);
        }

        public Iterator copy() {
            return new Iterator(this);
        }

        public boolean eq(Object thing) {
            return this._point == ((Iterator)thing)._point;
        }

        public void setTo(Iterator it) {
            this._point = it._point;
            this._pos = it._pos;
        }

        public void dispose() {
            ModelList.access$200(ModelList.this, this);
        }

        public boolean atStart() {
            return this._point == ModelList.access$000(ModelList.this);
        }

        public boolean atEnd() {
            return this._point == ModelList.access$300(ModelList.this);
        }

        public boolean atFirstItem() {
            return this._point.pred == ModelList.access$000(ModelList.this);
        }

        public boolean atLastItem() {
            return this._point.succ == ModelList.access$300(ModelList.this);
        }

        public T current() {
            if (this.atStart()) {
                throw new RuntimeException("Attempt to call current on an iterator in the initial position");
            }
            if (this.atEnd()) {
                throw new RuntimeException("Attempt to call current on an iterator in the final position");
            }
            return this._point.getItem();
        }

        public T prevItem() {
            if (this.atFirstItem() || this.atStart() || ModelList.this.isEmpty()) {
                throw new RuntimeException("No more previous items.");
            }
            return this._point.pred.getItem();
        }

        public T nextItem() {
            if (this.atLastItem() || this.atEnd() || ModelList.this.isEmpty()) {
                throw new RuntimeException("No more following items.");
            }
            return this._point.succ.getItem();
        }

        public void insert(T item) {
            if (this.atStart()) {
                this.next();
            }
            ModelList.access$400(ModelList.this, this._point, item);
            this._point = this._point.pred;
            this.notifyOfInsert(this._pos);
            --this._pos;
        }

        public void remove() {
            Node tempNode = this._point.succ;
            ModelList.access$500(ModelList.this, this._point);
            this._point = tempNode;
            this.notifyOfRemove(this._pos, this._point);
        }

        public void prev() {
            if (this.atStart()) {
                throw new RuntimeException("Can't cross list boundary.");
            }
            this._point = this._point.pred;
            --this._pos;
        }

        public void next() {
            if (this.atEnd()) {
                throw new RuntimeException("Can't cross list boundary.");
            }
            this._point = this._point.succ;
            ++this._pos;
        }

        public void collapse(Iterator iter) {
            if (this._pos > iter._pos) {
                int leftPos = iter._pos;
                int rightPos = this._pos;
                Node rightPoint = this._point;
                this._point.pred = iter._point;
                iter._point.succ = this._point;
                ModelList.access$620(ModelList.this, this._pos - iter._pos - 1);
                this.notifyOfCollapse(leftPos, rightPos, rightPoint);
            } else if (this._pos < iter._pos) {
                int leftPos = this._pos;
                int rightPos = iter._pos;
                Node rightPoint = iter._point;
                iter._point.pred = this._point;
                this._point.succ = iter._point;
                ModelList.access$620(ModelList.this, iter._pos - this._pos - 1);
                this.notifyOfCollapse(leftPos, rightPos, rightPoint);
            }
        }

        private void notifyOfInsert(int pos) {
            for (Iterator next : ModelList.access$700(ModelList.this)) {
                if (next._pos < pos) continue;
                ++next._pos;
            }
        }

        private void notifyOfRemove(int pos, Node<T> point) {
            for (Iterator next : ModelList.access$700(ModelList.this)) {
                if (next._pos < pos) continue;
                if (next._pos == pos) {
                    next._point = point;
                    continue;
                }
                --next._pos;
            }
        }

        private void notifyOfCollapse(int leftPos, int rightPos, Node<T> rightPoint) {
            for (Iterator next : ModelList.access$700(ModelList.this)) {
                if (next._pos <= leftPos) continue;
                if (next._pos > leftPos && next._pos <= rightPos) {
                    next._pos = leftPos + 1;
                    next._point = rightPoint;
                    continue;
                }
                next._pos -= rightPos - leftPos - 1;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        Node<T> pred;
        Node<T> succ;
        private T _item;

        Node() {
            this._item = null;
            this.pred = this;
            this.succ = this;
        }

        Node(T item, Node<T> previous, Node<T> successor) {
            this._item = item;
            this.pred = previous;
            this.succ = successor;
        }

        T getItem() {
            return this._item;
        }
    }
}

