/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.print;

import edu.rice.cs.drjava.model.print.DrJavaBook;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;

public class PagePrinter
implements Printable {
    private ArrayList<TextLayout> _textLayouts = new ArrayList();
    private ArrayList<TextLayout> _lineNumbers = new ArrayList();
    private String _filename;
    private DrJavaBook _parent;

    public PagePrinter(int page, String filename, DrJavaBook parent) {
        this._filename = filename;
        this._parent = parent;
    }

    public void add(TextLayout text, TextLayout lineNumber) {
        this._textLayouts.add(text);
        this._lineNumbers.add(lineNumber);
    }

    public int print(Graphics graphics, PageFormat format, int pageIndex) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(format.getImageableX(), format.getImageableY());
        g2d.setPaint(Color.black);
        float y = 0.0f;
        for (int i = 0; i < this._textLayouts.size(); ++i) {
            TextLayout layout = this._textLayouts.get(i);
            TextLayout lineNumber = this._lineNumbers.get(i);
            lineNumber.draw(g2d, 0.0f, y += layout.getAscent());
            layout.draw(g2d, this._parent.LINE_NUM_WIDTH, y);
            y += layout.getLeading();
        }
        this.printFooter(g2d, format, pageIndex + 1);
        return 0;
    }

    private void printFooter(Graphics2D g2d, PageFormat format, int page) {
        TextLayout footerFile = new TextLayout(this._filename, DrJavaBook.FOOTER_FONT, g2d.getFontRenderContext());
        float footerPlace = (float)(format.getImageableWidth() - (double)footerFile.getAdvance()) / 2.0f;
        footerFile.draw(g2d, footerPlace, (float)format.getImageableHeight() - footerFile.getDescent());
        TextLayout footerPageNo = new TextLayout(page + "", DrJavaBook.FOOTER_FONT, g2d.getFontRenderContext());
        footerPageNo.draw(g2d, (float)format.getImageableWidth() - footerPageNo.getAdvance(), (float)format.getImageableHeight() - footerPageNo.getDescent());
    }
}

