/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.model.FileOpenSelector;
import edu.rice.cs.drjava.model.OperationCanceledException;
import edu.rice.cs.drjava.model.repl.History;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsEventNotifier;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsModelCallback;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.Pair;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.EditDocumentException;
import edu.rice.cs.util.text.EditDocumentInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractionsModel
implements InteractionsModelCallback {
    protected final InteractionsEventNotifier _notifier = new InteractionsEventNotifier();
    protected static final String _newLine = System.getProperty("line.separator");
    protected final InteractionsDocument _document;
    protected boolean _waitingForFirstInterpreter;
    protected boolean _interpreterUsed;
    private final Object _interpreterLock;
    private final Object _writerLock;
    private int _writeDelay;
    private int _debugPort;
    private boolean _debugPortSet;
    private String _toAddToHistory = "";
    protected InputListener _inputListener;
    protected EditDocumentInterface _adapter;

    public InteractionsModel(EditDocumentInterface adapter, int historySize, int writeDelay) {
        this._writeDelay = writeDelay;
        this._document = new InteractionsDocument(adapter, historySize);
        this._adapter = adapter;
        this._waitingForFirstInterpreter = true;
        this._interpreterUsed = false;
        this._interpreterLock = new Object();
        this._writerLock = new Object();
        this._debugPort = -1;
        this._debugPortSet = false;
        this._inputListener = NoInputListener.ONLY;
    }

    public void addListener(InteractionsListener listener) {
        this._notifier.addListener(listener);
    }

    public void removeListener(InteractionsListener listener) {
        this._notifier.removeListener(listener);
    }

    public void removeAllInteractionListeners() {
        this._notifier.removeAllListeners();
    }

    public InteractionsDocument getDocument() {
        return this._document;
    }

    public void interactionContinues() {
        this._document.setInProgress(false);
        this._notifyInteractionEnded();
        this._notifyInteractionIncomplete();
    }

    public void setWaitingForFirstInterpreter(boolean waiting) {
        this._waitingForFirstInterpreter = waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpretCurrentInteraction() {
        Object object = this._interpreterLock;
        synchronized (object) {
            if (this._document.inProgress()) {
                return;
            }
            String text = this._document.getCurrentInteraction();
            String toEval = text.trim();
            if (toEval.startsWith("java ")) {
                toEval = InteractionsModel._testClassCall(toEval);
            }
            this._prepareToInterpret(text);
            this.interpret(toEval);
        }
    }

    private void _prepareToInterpret(String text) {
        this.addNewLine();
        this._notifyInteractionStarted();
        this._document.setInProgress(true);
        this._toAddToHistory = text;
    }

    public void addNewLine() {
        this._docAppend(_newLine, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interpret(String toEval) {
        Object object = this._interpreterLock;
        synchronized (object) {
            this._interpreterUsed = true;
            this._interpret(toEval);
        }
    }

    protected abstract void _interpret(String var1);

    protected abstract void _notifyInteractionIncomplete();

    protected abstract void _notifyInteractionStarted();

    public abstract String getVariableToString(String var1);

    public abstract String getVariableClassName(String var1);

    public final void resetInterpreter() {
        this._interpreterUsed = false;
        this._resetInterpreter();
    }

    protected abstract void _resetInterpreter();

    public boolean interpreterUsed() {
        return this._interpreterUsed;
    }

    public abstract void addProjectClassPath(URL var1);

    public abstract void addBuildDirectoryClassPath(URL var1);

    public abstract void addProjectFilesClassPath(URL var1);

    public abstract void addExternalFilesClassPath(URL var1);

    public abstract void addExtraClassPath(URL var1);

    protected abstract void _notifySyntaxErrorOccurred(int var1, int var2);

    protected ArrayList<String> _getHistoryText(FileOpenSelector selector) throws IOException, OperationCanceledException {
        File[] files = selector.getFiles();
        if (files == null) {
            throw new IOException("No Files returned from FileSelector");
        }
        ArrayList<String> histories = new ArrayList<String>();
        ArrayList<String> strings = new ArrayList<String>();
        for (File f : files) {
            if (f == null) {
                throw new IOException("File name returned from FileSelector is null");
            }
            try {
                String line;
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    strings.add(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                throw new IOException("File name returned from FileSelector is null");
            }
            StringBuffer text = new StringBuffer();
            boolean firstLine = true;
            int formatVersion = 1;
            for (String s : strings) {
                int sl = s.length();
                if (sl <= 0) continue;
                if (firstLine && s.trim().equals(History.HISTORY_FORMAT_VERSION_2.trim())) {
                    formatVersion = 2;
                }
                switch (formatVersion) {
                    case 1: {
                        text.append(s);
                        if (s.charAt(sl - 1) != ';') {
                            text.append(';');
                        }
                        text.append(_newLine);
                        break;
                    }
                    case 2: {
                        if (firstLine) break;
                        text.append(s).append(_newLine);
                    }
                }
                firstLine = false;
            }
            histories.add(text.toString());
        }
        return histories;
    }

    protected ArrayList<String> _removeSeparators(String text) {
        String sep = "//End of Interaction//";
        int len = sep.length();
        ArrayList<String> interactions = new ArrayList<String>();
        int index = text.indexOf(sep);
        int lastIndex = 0;
        while (index != -1) {
            interactions.add(text.substring(lastIndex, index).trim());
            lastIndex = index + len;
            index = text.indexOf(sep, lastIndex);
        }
        String last = text.substring(lastIndex, text.length()).trim();
        if (!"".equals(last)) {
            interactions.add(last);
        }
        return interactions;
    }

    public void loadHistory(FileOpenSelector selector) throws IOException {
        ArrayList<String> histories;
        try {
            histories = this._getHistoryText(selector);
        }
        catch (OperationCanceledException oce) {
            return;
        }
        this._document.clearCurrentInteraction();
        StringBuffer buf = new StringBuffer();
        for (String hist : histories) {
            ArrayList<String> interactions = this._removeSeparators(hist);
            for (String curr : interactions) {
                int len = curr.length();
                buf.append(curr);
                if (len > 0 && curr.charAt(len - 1) != ';') {
                    buf.append(';');
                }
                buf.append(_newLine);
            }
        }
        this._docAppend(buf.toString().trim(), "default");
        this.interpretCurrentInteraction();
    }

    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        ArrayList<String> histories = this._getHistoryText(selector);
        ArrayList<String> interactions = new ArrayList<String>();
        for (String hist : histories) {
            interactions.addAll(this._removeSeparators(hist));
        }
        return new InteractionsScriptModel(this, interactions);
    }

    @Override
    public int getDebugPort() throws IOException {
        if (!this._debugPortSet) {
            this._createNewDebugPort();
        }
        return this._debugPort;
    }

    protected void _createNewDebugPort() throws IOException {
        try {
            ServerSocket socket = new ServerSocket(0);
            this._debugPort = socket.getLocalPort();
            socket.close();
        }
        catch (SocketException se) {
            this._debugPort = -1;
        }
        this._debugPortSet = true;
        System.setProperty("drjava.debug.port", String.valueOf(this._debugPort));
    }

    public void setDebugPort(int port) {
        this._debugPort = port;
        this._debugPortSet = true;
    }

    @Override
    public void replSystemOutPrint(String s) {
        this._document.insertBeforeLastPrompt(s, "System.out");
    }

    @Override
    public void replSystemErrPrint(String s) {
        this._document.insertBeforeLastPrompt(s, "System.err");
    }

    @Override
    public String getConsoleInput() {
        return this._inputListener.getConsoleInput();
    }

    @Override
    public void setInputListener(InputListener listener) {
        if (this._inputListener != NoInputListener.ONLY) {
            throw new IllegalStateException("Cannot change the input listener until it is released.");
        }
        this._inputListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeInputListener(InputListener oldListener, InputListener newListener) {
        NoInputListener noInputListener = NoInputListener.ONLY;
        synchronized (noInputListener) {
            if (this._inputListener != oldListener) {
                throw new IllegalArgumentException("The given old listener is not installed!");
            }
            this._inputListener = newListener;
        }
    }

    protected void _interactionIsOver() {
        this._document.addToHistory(this._toAddToHistory);
        this._document.setInProgress(false);
        this._document.insertPrompt();
        this._notifyInteractionEnded();
    }

    protected abstract void _notifyInteractionEnded();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _docAppend(String s, String styleName) {
        Object object = this._writerLock;
        synchronized (object) {
            try {
                this._document.insertText(this._document.getLength(), s, styleName);
                this._writerLock.wait(this._writeDelay);
            }
            catch (EditDocumentException e) {
                throw new UnexpectedException(e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void replReturnedVoid() {
        this._interactionIsOver();
    }

    @Override
    public void replReturnedResult(String result, String style) {
        this._docAppend(new StringBuffer().append(result).append(_newLine).toString(), style);
        this._interactionIsOver();
    }

    @Override
    public void replThrewException(String exceptionClass, String message, String stackTrace, String shortMessage) {
        if (shortMessage != null && shortMessage.endsWith("<EOF>\"")) {
            this.interactionContinues();
            return;
        }
        this._document.appendExceptionResult(exceptionClass, message, stackTrace, "error");
        this._interactionIsOver();
    }

    @Override
    public void replReturnedSyntaxError(String errorMessage, String interaction, int startRow, int startCol, int endRow, int endCol) {
        if (errorMessage != null && errorMessage.endsWith("<EOF>\"")) {
            this.interactionContinues();
            return;
        }
        Pair<Integer, Integer> oAndL = StringOps.getOffsetAndLength(interaction, startRow, startCol, endRow, endCol);
        this._notifySyntaxErrorOccurred(this._document.getPromptPos() + oAndL.getFirst(), oAndL.getSecond());
        this._document.appendSyntaxErrorResult(errorMessage, interaction, startRow, startCol, endRow, endCol, "error");
        this._interactionIsOver();
    }

    @Override
    public void replCalledSystemExit(int status) {
        this._notifyInterpreterExited(status);
    }

    protected abstract void _notifyInterpreterExited(int var1);

    @Override
    public void interpreterResetting() {
        if (!this._waitingForFirstInterpreter) {
            this._document.insertBeforeLastPrompt(new StringBuffer().append("Resetting Interactions...").append(_newLine).toString(), "error");
            this._document.setInProgress(true);
            try {
                this._createNewDebugPort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._notifyInterpreterResetting();
        }
    }

    protected abstract void _notifyInterpreterResetting();

    @Override
    public void interpreterResetFailed(Throwable t) {
        this._interpreterResetFailed(t);
        this._document.setInProgress(false);
        this._notifyInterpreterResetFailed(t);
    }

    protected abstract void _interpreterResetFailed(Throwable var1);

    protected abstract void _notifyInterpreterResetFailed(Throwable var1);

    @Override
    public void interpreterReady() {
        if (!this._waitingForFirstInterpreter) {
            this._document.reset();
            this._document.setInProgress(false);
            this._notifyInterpreterReady();
        }
        this._waitingForFirstInterpreter = false;
    }

    protected abstract void _notifyInterpreterReady();

    protected static String _testClassCall(String s) {
        if (s.endsWith(";")) {
            s = InteractionsModel._deleteSemiColon(s);
        }
        List<String> args = ArgumentTokenizer.tokenize(s, true);
        boolean seenArg = false;
        String className = args.get(1);
        StringBuffer mainCall = new StringBuffer();
        mainCall.append(className.substring(1, className.length() - 1));
        mainCall.append(".main(new String[]{");
        for (int i = 2; i < args.size(); ++i) {
            if (seenArg) {
                mainCall.append(",");
            } else {
                seenArg = true;
            }
            mainCall.append(args.get(i));
        }
        mainCall.append("});");
        return mainCall.toString();
    }

    protected static String _deleteSemiColon(String s) {
        return s.substring(0, s.length() - 1);
    }

    public abstract ConsoleDocument getConsoleDocument();

    private static class NoInputListener
    implements InputListener {
        public static final NoInputListener ONLY = new NoInputListener();

        private NoInputListener() {
        }

        public String getConsoleInput() {
            throw new IllegalStateException("No input listener installed!");
        }
    }
}

