/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.debug.DebugModelCallback;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsModelCallback;
import edu.rice.cs.drjava.model.repl.newjvm.ExceptionResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpretResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpretResultVisitor;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.SyntaxErrorResult;
import edu.rice.cs.drjava.model.repl.newjvm.ValueResult;
import edu.rice.cs.drjava.model.repl.newjvm.VoidResult;
import edu.rice.cs.drjava.ui.AWTExceptionHandler;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.ClasspathVector;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.newjvm.AbstractMasterJVM;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import koala.dynamicjava.parser.wrapper.ParseError;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainJVM
extends AbstractMasterJVM
implements MainJVMRemoteI {
    private static final String SLAVE_CLASS_NAME = "edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVM";
    public static final String DEFAULT_INTERPRETER_NAME = "DEFAULT";
    private Log _log = new Log("MainJVMLog", false);
    private InteractionsModelCallback _interactionsModel;
    private JUnitModelCallback _junitModel;
    private DebugModelCallback _debugModel;
    private Object _interpreterLock = new Object();
    private boolean _restart = true;
    private boolean _cleanlyRestarting = false;
    private final ResultHandler _handler = new ResultHandler(null);
    private boolean _allowAssertions = false;
    private String _startupClasspath;
    private ClasspathVector _startupClasspathVector;
    private List<String> _optionArgs;
    private String _currentInterpreterName = "DEFAULT";

    public MainJVM() {
        super(SLAVE_CLASS_NAME);
        this._waitForQuitThreadName = "Wait for Interactions to Exit Thread";
        this._exportMasterThreadName = "Export DrJava to RMI Thread";
        this._interactionsModel = new DummyInteractionsModel();
        this._junitModel = new DummyJUnitModel();
        this._debugModel = new DummyDebugModel();
        this._startupClasspath = System.getProperty("java.class.path");
        this._parseStartupClasspath();
        this._optionArgs = new ArrayList<String>();
    }

    private void _parseStartupClasspath() {
        String separator = System.getProperty("path.separator");
        int index = this._startupClasspath.indexOf(separator);
        int lastIndex = 0;
        this._startupClasspathVector = new ClasspathVector();
        while (index != -1) {
            try {
                this._startupClasspathVector.add(new File(this._startupClasspath.substring(lastIndex, index)).toURL());
            }
            catch (MalformedURLException murle) {
                // empty catch block
            }
            lastIndex = index + separator.length();
            index = this._startupClasspath.indexOf(separator, lastIndex);
        }
        index = this._startupClasspath.length();
        try {
            this._startupClasspathVector.add(new File(this._startupClasspath.substring(lastIndex, index)).toURL());
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
    }

    public boolean isInterpreterRunning() {
        return this._interpreterJVM() != null;
    }

    public void setInteractionsModel(InteractionsModelCallback model) {
        this._interactionsModel = model;
    }

    public void setJUnitModel(JUnitModelCallback model) {
        this._junitModel = model;
    }

    public void setDebugModel(DebugModelCallback model) {
        this._debugModel = model;
    }

    public void setAllowAssertions(boolean allow) {
        this._allowAssertions = allow;
    }

    public void setOptionArgs(String argString) {
        this._optionArgs = ArgumentTokenizer.tokenize(argString);
    }

    public void interpret(String s) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._log.logTime(new StringBuffer().append("main.interp: ").append(s).toString());
            this._interpreterJVM().interpret(s);
        }
        catch (UnmarshalException ume) {
            this._log.logTime(new StringBuffer().append("main.interp: UnmarshalException, so interpreter is dead:\n").append(ume).toString());
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public String getVariableToString(String var) {
        if (!this._restart) {
            return null;
        }
        this.ensureInterpreterConnected();
        try {
            return this._interpreterJVM().getVariableToString(var);
        }
        catch (RemoteException re) {
            this._threwException(re);
            return null;
        }
    }

    public String getVariableClassName(String var) {
        if (!this._restart) {
            return null;
        }
        this.ensureInterpreterConnected();
        try {
            return this._interpreterJVM().getVariableClassName(var);
        }
        catch (RemoteException re) {
            this._threwException(re);
            return null;
        }
    }

    @Override
    public void interpretResult(InterpretResult result) throws RemoteException {
        this._log.logTime(new StringBuffer().append("main.interp result: ").append(result).toString());
        result.apply(this.getResultHandler());
    }

    public void addProjectClassPath(URL path) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().addProjectClassPath(path.toString());
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addBuildDirectoryClassPath(URL path) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().addBuildDirectoryClassPath(path.toString());
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addProjectFilesClassPath(URL path) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().addProjectFilesClassPath(path.toString());
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addExternalFilesClassPath(URL path) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().addExternalFilesClassPath(path.toString());
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addExtraClassPath(URL path) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().addExtraClassPath(path.toString());
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public ClasspathVector getClasspath() {
        if (this._restart) {
            this.ensureInterpreterConnected();
            try {
                Vector<String> strClasspath = new Vector<String>(this._interpreterJVM().getAugmentedClasspath());
                ClasspathVector classpath = new ClasspathVector(strClasspath.size() + this._startupClasspathVector.size());
                for (String s : strClasspath) {
                    classpath.add(s);
                }
                classpath.addAll(this._startupClasspathVector);
                return classpath;
            }
            catch (RemoteException re) {
                this._threwException(re);
            }
        }
        return new ClasspathVector();
    }

    public void setPackageScope(String packageName) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().setPackageScope(packageName);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void setShowMessageOnResetFailure(boolean show) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().setShowMessageOnResetFailure(show);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    @Override
    public void systemErrPrint(String s) throws RemoteException {
        this._interactionsModel.replSystemErrPrint(s);
    }

    @Override
    public void systemOutPrint(String s) throws RemoteException {
        this._interactionsModel.replSystemOutPrint(s);
    }

    public List<String> findTestClasses(List<String> classNames, List<File> files) throws RemoteException {
        return this._interpreterJVM().findTestClasses(classNames, files);
    }

    public boolean runTestSuite() throws RemoteException {
        return this._interpreterJVM().runTestSuite();
    }

    @Override
    public void nonTestCase(boolean isTestAll) throws RemoteException {
        this._junitModel.nonTestCase(isTestAll);
    }

    @Override
    public void classFileError(ClassFileError e) throws RemoteException {
        this._junitModel.classFileError(e);
    }

    @Override
    public void testSuiteStarted(int numTests) throws RemoteException {
        this._junitModel.testSuiteStarted(numTests);
    }

    @Override
    public void testStarted(String testName) throws RemoteException {
        this._junitModel.testStarted(testName);
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) throws RemoteException {
        this._junitModel.testEnded(testName, wasSuccessful, causedError);
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) throws RemoteException {
        this._junitModel.testSuiteEnded(errors);
    }

    @Override
    public File getFileForClassName(String className) throws RemoteException {
        return this._junitModel.getFileForClassName(className);
    }

    private InterpreterJVMRemoteI _interpreterJVM() {
        return (InterpreterJVMRemoteI)this.getSlave();
    }

    public void addJavaInterpreter(String name) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().addJavaInterpreter(name);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addDebugInterpreter(String name, String className) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().addDebugInterpreter(name, className);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void removeInterpreter(String name) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().removeInterpreter(name);
            if (name.equals(this._currentInterpreterName)) {
                this._currentInterpreterName = null;
            }
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public boolean setActiveInterpreter(String name) {
        if (!this._restart) {
            return false;
        }
        this.ensureInterpreterConnected();
        try {
            boolean result = this._interpreterJVM().setActiveInterpreter(name);
            this._currentInterpreterName = name;
            return result;
        }
        catch (RemoteException re) {
            this._threwException(re);
            return false;
        }
    }

    public boolean setToDefaultInterpreter() {
        if (!this._restart) {
            return false;
        }
        this.ensureInterpreterConnected();
        try {
            boolean result = this._interpreterJVM().setToDefaultInterpreter();
            this._currentInterpreterName = DEFAULT_INTERPRETER_NAME;
            return result;
        }
        catch (ConnectIOException ce) {
            this._log.logTime("Could not connect to the interpreterJVM after killing it", ce);
            return false;
        }
        catch (RemoteException re) {
            this._threwException(re);
            return false;
        }
    }

    public String getCurrentInterpreterName() {
        return this._currentInterpreterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killInterpreter(boolean shouldRestart) {
        Object object = this._masterJVMLock;
        synchronized (object) {
            try {
                this._restart = shouldRestart;
                this._cleanlyRestarting = true;
                if (shouldRestart) {
                    this._interactionsModel.interpreterResetting();
                }
                this.quitSlave();
            }
            catch (ConnectException ce) {
                this._log.logTime("Could not connect to the interpreterJVM while trying to kill it", ce);
            }
            catch (RemoteException re) {
                this._threwException(re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartupClasspath(String classpath) {
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._startupClasspath = classpath;
            this._parseStartupClasspath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInterpreterJVM() {
        Object object = this._masterJVMLock;
        synchronized (object) {
            if (this.isStartupInProgress() || this.isInterpreterRunning()) {
                return;
            }
        }
        ArrayList<String> jvmArgs = new ArrayList<String>();
        if (this.allowAssertions()) {
            jvmArgs.add("-ea");
        }
        int debugPort = this.getDebugPort();
        this._log.logTime(new StringBuffer().append("starting with debug port: ").append(debugPort).toString());
        if (debugPort > -1) {
            jvmArgs.add(new StringBuffer().append("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=").append(debugPort).toString());
            jvmArgs.add("-Xdebug");
            jvmArgs.add("-Xnoagent");
            jvmArgs.add("-Djava.compiler=NONE");
        }
        if (DrJava.usingJSR14v20()) {
            File jsr14 = DrJava.getConfig().getSetting(OptionConstants.JSR14_LOCATION);
            jvmArgs.add(new StringBuffer().append("-Xbootclasspath/p:").append(jsr14.getAbsolutePath()).toString());
        }
        jvmArgs.addAll(this._optionArgs);
        String[] jvmArgsArray = new String[jvmArgs.size()];
        for (int i = 0; i < jvmArgs.size(); ++i) {
            jvmArgsArray[i] = (String)jvmArgs.get(i);
        }
        try {
            this.invokeSlave(jvmArgsArray, this._startupClasspath);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
        catch (IOException ioe) {
            this._threwException(ioe);
        }
    }

    @Override
    protected void handleSlaveQuit(int status) {
        if (this._restart) {
            if (!this._cleanlyRestarting) {
                this._interactionsModel.interpreterResetting();
            }
            this.startInterpreterJVM();
        }
        if (!this._cleanlyRestarting) {
            this._interactionsModel.replCalledSystemExit(status);
        }
        this._cleanlyRestarting = false;
    }

    @Override
    protected void slaveQuitDuringStartup(int status) {
        this._restart = false;
        String msg = new StringBuffer().append("Interpreter JVM exited before registering, status: ").append(status).toString();
        IllegalStateException e = new IllegalStateException(msg);
        this._interactionsModel.interpreterResetFailed(e);
        this._cleanlyRestarting = false;
        throw e;
    }

    @Override
    public void errorStartingSlave(Throwable cause) throws RemoteException {
        new AWTExceptionHandler().handle(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quitFailed(Throwable th) throws RemoteException {
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._interactionsModel.interpreterResetFailed(th);
            this._cleanlyRestarting = false;
        }
    }

    @Override
    public boolean isStartupInProgress() {
        return super.isStartupInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSlaveConnected() {
        this._restart = true;
        this._cleanlyRestarting = false;
        Boolean allowAccess = DrJava.getConfig().getSetting(OptionConstants.ALLOW_PRIVATE_ACCESS);
        this.setPrivateAccessible(allowAccess);
        this._interactionsModel.interpreterReady();
        this._junitModel.junitJVMReady();
        this._log.logTime(new StringBuffer().append("thread in connected: ").append(Thread.currentThread()).toString());
        Object object = this._interpreterLock;
        synchronized (object) {
            this._interpreterLock.notify();
        }
    }

    protected InterpretResultVisitor<Object> getResultHandler() {
        return this._handler;
    }

    protected int getDebugPort() {
        int port = -1;
        try {
            port = this._interactionsModel.getDebugPort();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return port;
    }

    protected boolean allowAssertions() {
        String version = System.getProperty("java.version");
        return this._allowAssertions && version != null && "1.4.0".compareTo(version) <= 0;
    }

    private void _threwException(Throwable t) {
        String shortMsg = null;
        if (t instanceof ParseError && ((ParseError)t).getParseException() != null) {
            shortMsg = ((ParseError)t).getMessage();
        }
        this._interactionsModel.replThrewException(t.getClass().getName(), t.getMessage(), StringOps.getStackTrace(t), shortMsg);
    }

    public void setPrivateAccessible(boolean allow) {
        if (!this._restart) {
            return;
        }
        this.ensureInterpreterConnected();
        try {
            this._interpreterJVM().setPrivateAccessible(allow);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInterpreterConnected() {
        try {
            Object object = this._interpreterLock;
            synchronized (object) {
                while (this._interpreterJVM() == null) {
                    this._interpreterLock.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            throw new UnexpectedException(ie);
        }
    }

    @Override
    public String getConsoleInput() {
        return this._interactionsModel.getConsoleInput();
    }

    static InteractionsModelCallback access$100(MainJVM x0) {
        return x0._interactionsModel;
    }

    static class 1 {
    }

    public static class DummyDebugModel
    implements DebugModelCallback {
        public void notifyDebugInterpreterAssignment(String name) {
        }
    }

    public static class DummyJUnitModel
    implements JUnitModelCallback {
        public void nonTestCase(boolean isTestAll) {
        }

        public void classFileError(ClassFileError e) {
        }

        public void testSuiteStarted(int numTests) {
        }

        public void testStarted(String testName) {
        }

        public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        }

        public void testSuiteEnded(JUnitError[] errors) {
        }

        public File getFileForClassName(String className) {
            return null;
        }

        public ClasspathVector getClasspath() {
            return new ClasspathVector();
        }

        public void junitJVMReady() {
        }
    }

    public static class DummyInteractionsModel
    implements InteractionsModelCallback {
        public int getDebugPort() throws IOException {
            return -1;
        }

        public void replSystemOutPrint(String s) {
        }

        public void replSystemErrPrint(String s) {
        }

        public String getConsoleInput() {
            throw new IllegalStateException("Cannot request input from dummy interactions model!");
        }

        public void setInputListener(InputListener il) {
            throw new IllegalStateException("Cannot set the input listener of dummy interactions model!");
        }

        public void changeInputListener(InputListener from, InputListener to) {
            throw new IllegalStateException("Cannot change the input listener of dummy interactions model!");
        }

        public void replReturnedVoid() {
        }

        public void replReturnedResult(String result, String style) {
        }

        public void replThrewException(String exceptionClass, String message, String stackTrace, String specialMessage) {
        }

        public void replReturnedSyntaxError(String errorMessage, String interaction, int startRow, int startCol, int endRow, int endCol) {
        }

        public void replCalledSystemExit(int status) {
        }

        public void interpreterResetting() {
        }

        public void interpreterResetFailed(Throwable th) {
        }

        public void interpreterReady() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultHandler
    implements InterpretResultVisitor<Object> {
        private ResultHandler() {
        }

        @Override
        public Object forVoidResult(VoidResult that) {
            MainJVM.access$100(MainJVM.this).replReturnedVoid();
            return null;
        }

        @Override
        public Object forValueResult(ValueResult that) {
            String result = that.getValueStr();
            String style = that.getStyle();
            MainJVM.access$100(MainJVM.this).replReturnedResult(result, style);
            return null;
        }

        @Override
        public Object forExceptionResult(ExceptionResult that) {
            MainJVM.access$100(MainJVM.this).replThrewException(that.getExceptionClass(), that.getExceptionMessage(), that.getStackTrace(), that.getSpecialMessage());
            return null;
        }

        @Override
        public Object forSyntaxErrorResult(SyntaxErrorResult that) {
            MainJVM.access$100(MainJVM.this).replReturnedSyntaxError(that.getErrorMessage(), that.getInteraction(), that.getStartRow(), that.getStartCol(), that.getEndRow(), that.getEndCol());
            return null;
        }

        ResultHandler(1 x1) {
            this();
        }
    }
}

