/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.plugins.eclipse.views;

import edu.rice.cs.drjava.plugins.eclipse.repl.EclipseInteractionsModel;
import edu.rice.cs.drjava.plugins.eclipse.views.InteractionsController;
import edu.rice.cs.util.text.SWTDocumentAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class InteractionsView
extends ViewPart {
    protected InteractionsController _controller;
    protected StyledText _styledText;
    protected Cursor _arrowCursor;
    protected Cursor _waitCursor;
    protected Runnable _beep = new Runnable(){

        public void run() {
            InteractionsView.this._styledText.getDisplay().beep();
        }
    };
    protected IMenuManager _toolbarMenu;
    protected MenuManager _contextMenu;
    protected IActionBars _bars;

    public void dispose() {
        this._arrowCursor.dispose();
        this._waitCursor.dispose();
        this._controller.dispose();
        this._styledText.dispose();
        super.dispose();
    }

    public StyledText getTextPane() {
        return this._styledText;
    }

    public Runnable getBeep() {
        return this._beep;
    }

    public void setBeep(Runnable beep) {
        this._beep = beep;
    }

    public void updateFont() {
        Font font = JFaceResources.getFont((String)"edu.rice.cs.drjava.InteractionsFont");
        this._styledText.setFont(font);
    }

    public void createPartControl(Composite parent) {
        this.setTextPane(new StyledText(parent, 576));
        this._bars = this.getViewSite().getActionBars();
        this._toolbarMenu = this._bars.getMenuManager();
        this._contextMenu = new MenuManager("#PopupMenu");
        Menu menu = this._contextMenu.createContextMenu((Control)this._styledText);
        this._styledText.setMenu(menu);
        SWTDocumentAdapter adapter = new SWTDocumentAdapter(this._styledText);
        EclipseInteractionsModel model = new EclipseInteractionsModel(adapter);
        this.setController(new InteractionsController(model, adapter, this));
    }

    void setTextPane(StyledText text) {
        this._styledText = text;
        this._arrowCursor = new Cursor((Device)this._styledText.getDisplay(), 0);
        this._waitCursor = new Cursor((Device)this._styledText.getDisplay(), 1);
    }

    void setController(InteractionsController controller) {
        this._controller = controller;
    }

    public String getCurrentInteraction(int promptPos) {
        int length = this._styledText.getText().length();
        return this._styledText.getText(promptPos, length - 1);
    }

    public void setEditable(final boolean editable) {
        this._styledText.getDisplay().syncExec(new Runnable(){

            public void run() {
                InteractionsView.this._styledText.setEditable(editable);
            }
        });
    }

    public void setBusyCursorShown(final boolean busy) {
        this._styledText.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (busy) {
                    InteractionsView.this._styledText.setCursor(InteractionsView.this._waitCursor);
                } else {
                    InteractionsView.this._styledText.setCursor(InteractionsView.this._arrowCursor);
                }
            }
        });
    }

    public void showInfoDialog(final String title, final String msg) {
        this._styledText.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)InteractionsView.this._styledText.getShell(), (String)title, (String)msg);
            }
        });
    }

    public boolean showConfirmDialog(String title, String msg) {
        return MessageDialog.openQuestion((Shell)this._styledText.getShell(), (String)title, (String)msg);
    }

    public void setFocus() {
        this._styledText.setFocus();
    }

    public void addMenuItem(Action action) {
        this.addToolbarMenuItem(action);
        this.addContextMenuItem(action);
    }

    public void addAction(String op, Action action) {
        this._bars.setGlobalActionHandler(op, (IAction)action);
        this.addToolbarMenuItem(action);
        this.addContextMenuItem(action);
    }

    public void addToolbarMenuItem(Action action) {
        this._toolbarMenu.add((IAction)action);
    }

    public void addSelectionListener(SelectionListener listener) {
        this._styledText.addSelectionListener(listener);
    }

    public void addContextMenuItem(Action action) {
        this._contextMenu.add((IAction)action);
    }
}

