/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsModel;
import edu.rice.cs.drjava.ui.AbstractConsoleController;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.PopupConsole;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocument;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

public class InteractionsController
extends AbstractConsoleController {
    private InteractionsModel _model;
    private InteractionsDocument _doc;
    private SimpleAttributeSet _errStyle;
    private final SimpleAttributeSet _debugStyle;
    PopupConsole _popupConsole;
    private InputListener _inputListener = new InputListener(){

        public String getConsoleInput() {
            return InteractionsController.this._popupConsole.getConsoleInput();
        }
    };
    private InteractionsListener _viewListener = new InteractionsListener(){

        public void interactionStarted() {
        }

        public void interactionEnded() {
        }

        public void interactionErrorOccurred(int offset, int length) {
        }

        public void interpreterResetting() {
            Runnable command = new Runnable(){

                public void run() {
                    InteractionsController.this._adapter.clearColoring();
                    InteractionsController.this._pane.resetPrompts();
                }
            };
            Utilities.invokeLater(command);
        }

        public void interpreterReady() {
        }

        public void interpreterResetFailed(Throwable t) {
        }

        public void interpreterExited(int status) {
        }

        public void interpreterChanged(boolean inProgress) {
        }

        public void interactionIncomplete() {
        }
    };
    AbstractAction evalAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._adapter.isInCommentBlock()) {
                Thread command = new Thread("Evaluating Interaction"){

                    public void run() {
                        InteractionsController.access$200(InteractionsController.this).interpretCurrentInteraction();
                    }
                };
                command.start();
            } else {
                InteractionsController.access$200(InteractionsController.this).addNewLine();
                InteractionsController.access$200(InteractionsController.this).interactionContinues();
            }
        }
    };
    AbstractAction historyPrevAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.access$300(InteractionsController.this).recallPreviousInteractionInHistory()) {
                    InteractionsController.this.moveToEnd();
                }
                if (!InteractionsController.access$400(InteractionsController.this)) {
                    InteractionsController.this.moveToPrompt();
                }
            }
        }
    };
    AbstractAction historyNextAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!(InteractionsController.this._busy() || !InteractionsController.access$300(InteractionsController.this).recallNextInteractionInHistory() && InteractionsController.access$400(InteractionsController.this))) {
                InteractionsController.this.moveToPrompt();
            }
        }
    };
    AbstractAction moveUpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.access$500(InteractionsController.this, InteractionsController.access$300(InteractionsController.this).getPromptPos(), InteractionsController.this._pane.getCaretPosition())) {
                    InteractionsController.this.historyPrevAction.actionPerformed(e);
                } else {
                    InteractionsController.this.defaultUpAction.actionPerformed(e);
                    if (!InteractionsController.access$400(InteractionsController.this)) {
                        InteractionsController.this.moveToPrompt();
                    }
                }
            }
        }
    };
    AbstractAction moveDownAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                if (InteractionsController.access$500(InteractionsController.this, InteractionsController.this._pane.getCaretPosition(), InteractionsController.this._adapter.getLength())) {
                    InteractionsController.this.historyNextAction.actionPerformed(e);
                } else {
                    InteractionsController.this.defaultDownAction.actionPerformed(e);
                }
            }
        }
    };
    Action defaultUpAction;
    Action defaultDownAction;
    AbstractAction historyReverseSearchAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                InteractionsController.access$300(InteractionsController.this).reverseSearchInteractionsInHistory();
                InteractionsController.this.moveToEnd();
            }
        }
    };
    AbstractAction historyForwardSearchAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                InteractionsController.access$300(InteractionsController.this).forwardSearchInteractionsInHistory();
                InteractionsController.this.moveToEnd();
            }
        }
    };
    AbstractAction moveLeftAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            if (!InteractionsController.this._busy()) {
                int position = InteractionsController.this._pane.getCaretPosition();
                if (position < InteractionsController.access$300(InteractionsController.this).getPromptPos()) {
                    InteractionsController.this.moveToPrompt();
                } else if (position == InteractionsController.access$300(InteractionsController.this).getPromptPos()) {
                    InteractionsController.this.moveToEnd();
                } else {
                    InteractionsController.this._pane.setCaretPosition(position - 1);
                }
            }
        }
    };
    AbstractAction moveRightAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < InteractionsController.access$300(InteractionsController.this).getPromptPos()) {
                InteractionsController.this.moveToEnd();
            } else if (position >= InteractionsController.access$300(InteractionsController.this).getLength()) {
                InteractionsController.this.moveToPrompt();
            } else {
                InteractionsController.this._pane.setCaretPosition(position + 1);
            }
        }
    };
    AbstractAction prevWordAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int promptPos;
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < (promptPos = InteractionsController.access$300(InteractionsController.this).getPromptPos())) {
                InteractionsController.this.moveToPrompt();
            } else if (position == promptPos) {
                InteractionsController.this.moveToEnd();
            } else {
                InteractionsController.this._pane.getActionMap().get("caret-previous-word").actionPerformed(e);
            }
        }
    };
    AbstractAction nextWordAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            int promptPos;
            int position = InteractionsController.this._pane.getCaretPosition();
            if (position < (promptPos = InteractionsController.access$300(InteractionsController.this).getPromptPos())) {
                InteractionsController.this.moveToEnd();
            } else if (position >= InteractionsController.access$300(InteractionsController.this).getLength()) {
                InteractionsController.this.moveToPrompt();
            } else {
                InteractionsController.this._pane.getActionMap().get("caret-next-word").actionPerformed(e);
            }
        }
    };

    public InteractionsController(final InteractionsModel model, InteractionsDJDocument adapter) {
        this(model, adapter, new InteractionsPane(adapter){

            public int getPromptPos() {
                return model.getDocument().getPromptPos();
            }
        });
    }

    public InteractionsController(InteractionsModel model, InteractionsDJDocument adapter, InteractionsPane pane) {
        super(adapter, pane);
        StyledEditorKit d = InteractionsPane.EDITOR_KIT;
        Action[] arr$ = ((DefaultEditorKit)d).getActions();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Action a = arr$[i$];
            if (a.getValue("Name").equals("caret-up")) {
                this.defaultUpAction = a;
            }
            if (!a.getValue("Name").equals("caret-down")) continue;
            this.defaultDownAction = a;
        }
        this._model = model;
        this._doc = model.getDocument();
        this._errStyle = new SimpleAttributeSet();
        this._debugStyle = new SimpleAttributeSet();
        this._model.setInputListener(this._inputListener);
        this._model.addListener(this._viewListener);
        this._popupConsole = new PopupConsole(this._pane, this._doc, this._model.getConsoleDocument(), new InputBox(), "Standard Input (System.in)");
        this._init();
    }

    public InputListener getInputListener() {
        return this._inputListener;
    }

    public void notifyInputEnteredAction() {
        this._popupConsole.interruptConsole();
    }

    public void insertConsoleText(String input) {
        try {
            this._popupConsole.waitForConsoleReady();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._popupConsole.insertConsoleText(input);
    }

    public InteractionsModel getInteractionsModel() {
        return this._model;
    }

    public ConsoleDocument getConsoleDoc() {
        return this._doc;
    }

    public InteractionsDocument getDocument() {
        return this._doc;
    }

    protected void _addDocumentStyles() {
        super._addDocumentStyles();
        this._errStyle.addAttributes(this._defaultStyle);
        this._errStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.INTERACTIONS_ERROR_COLOR));
        this._errStyle.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this._adapter.setDocStyle("error", this._errStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.INTERACTIONS_ERROR_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                InteractionsController.access$000(InteractionsController.this).addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
        this._debugStyle.addAttributes(this._defaultStyle);
        this._debugStyle.addAttribute(StyleConstants.Foreground, DrJava.getConfig().getSetting(OptionConstants.DEBUG_MESSAGE_COLOR));
        this._debugStyle.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this._adapter.setDocStyle("debugger", this._debugStyle);
        DrJava.getConfig().addOptionListener(OptionConstants.DEBUG_MESSAGE_COLOR, new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oe) {
                InteractionsController.access$100(InteractionsController.this).addAttribute(StyleConstants.Foreground, oe.value);
            }
        });
    }

    protected void _updateStyles(AttributeSet newSet) {
        super._updateStyles(newSet);
        this._errStyle.addAttributes(newSet);
        StyleConstants.setBold(this._errStyle, true);
        this._debugStyle.addAttributes(newSet);
        StyleConstants.setBold(this._debugStyle, true);
    }

    protected void _setupModel() {
        this._adapter.addDocumentListener(new AbstractConsoleController.CaretUpdateListener());
        this._doc.setBeep(this._pane.getBeep());
    }

    protected void _setupView() {
        super._setupView();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this.evalAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 1), this.newLineAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(66, mask), this.clearCurrentAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(224, 0), this.moveUpAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), this.moveUpAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(38, mask), this.historyPrevAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(225, 0), this.moveDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), this.moveDownAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(40, mask), this.historyNextAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), this.historyReverseSearchAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(9, 1), this.historyForwardSearchAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(226, 0), this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), this.moveLeftAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(227, 0), this.moveRightAction);
        this._pane.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), this.moveRightAction);
        this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_WORD), this.prevWordAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_PREVIOUS_WORD, new OptionListener<KeyStroke>(){

            @Override
            public void optionChanged(OptionEvent<KeyStroke> oe) {
                InteractionsController.this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_PREVIOUS_WORD), InteractionsController.this.prevWordAction);
            }
        });
        this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_WORD), this.nextWordAction);
        DrJava.getConfig().addOptionListener(OptionConstants.KEY_NEXT_WORD, new OptionListener<KeyStroke>(){

            @Override
            public void optionChanged(OptionEvent<KeyStroke> oe) {
                InteractionsController.this._pane.addActionForKeyStroke(DrJava.getConfig().getSetting(OptionConstants.KEY_NEXT_WORD), InteractionsController.this.nextWordAction);
            }
        });
    }

    private boolean _shouldGoIntoHistory(int start, int end) {
        if (this._isCursorAfterPrompt() && end >= start) {
            String text = "";
            try {
                text = this._adapter.getText(start, end - start);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            if (text.indexOf("\n") != -1) {
                return false;
            }
        }
        return true;
    }

    private boolean _isCursorAfterPrompt() {
        return this._pane.getCaretPosition() >= this._doc.getPromptPos();
    }

    static SimpleAttributeSet access$000(InteractionsController x0) {
        return x0._errStyle;
    }

    static SimpleAttributeSet access$100(InteractionsController x0) {
        return x0._debugStyle;
    }

    static InteractionsModel access$200(InteractionsController x0) {
        return x0._model;
    }

    static InteractionsDocument access$300(InteractionsController x0) {
        return x0._doc;
    }

    static boolean access$400(InteractionsController x0) {
        return x0._isCursorAfterPrompt();
    }

    static boolean access$500(InteractionsController x0, int x1, int x2) {
        return x0._shouldGoIntoHistory(x1, x2);
    }

    private static class InputBox
    extends JTextArea {
        private static final int BORDER_WIDTH = 1;
        private static final int INNER_BUFFER_WIDTH = 3;
        private static final int OUTER_BUFFER_WIDTH = 2;
        private Color _bgColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_BACKGROUND_COLOR);
        private Color _fgColor = DrJava.getConfig().getSetting(OptionConstants.DEFINITIONS_NORMAL_COLOR);
        private Color _sysInColor = DrJava.getConfig().getSetting(OptionConstants.SYSTEM_IN_COLOR);
        private boolean _antiAliasText = DrJava.getConfig().getSetting(OptionConstants.TEXT_ANTIALIAS);

        public InputBox() {
            this.setForeground(this._sysInColor);
            this.setBackground(this._bgColor);
            this.setCaretColor(this._fgColor);
            this.setBorder(this._createBorder());
            this.setLineWrap(true);
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_NORMAL_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.access$602(InputBox.this, (Color)oe.value);
                    InputBox.this.setBorder(InputBox.access$700(InputBox.this));
                    InputBox.this.setCaretColor((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.access$802(InputBox.this, (Color)oe.value);
                    InputBox.this.setBorder(InputBox.access$700(InputBox.this));
                    InputBox.this.setBackground((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.SYSTEM_IN_COLOR, new OptionListener<Color>(){

                @Override
                public void optionChanged(OptionEvent<Color> oe) {
                    InputBox.access$902(InputBox.this, (Color)oe.value);
                    InputBox.this.setForeground((Color)oe.value);
                }
            });
            DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, new OptionListener<Boolean>(){

                @Override
                public void optionChanged(OptionEvent<Boolean> oce) {
                    InputBox.access$1002(InputBox.this, (Boolean)oce.value);
                    InputBox.this.repaint();
                }
            });
        }

        private Border _createBorder() {
            Border outerouter = BorderFactory.createLineBorder(this._bgColor, 2);
            Border outer = BorderFactory.createLineBorder(this._fgColor, 1);
            Border inner = BorderFactory.createLineBorder(this._bgColor, 3);
            CompoundBorder temp = BorderFactory.createCompoundBorder(outer, inner);
            return BorderFactory.createCompoundBorder(outerouter, temp);
        }

        protected void paintComponent(Graphics g) {
            if (this._antiAliasText && g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            super.paintComponent(g);
        }

        static Color access$602(InputBox x0, Color x1) {
            x0._fgColor = x1;
            return x0._fgColor;
        }

        static Border access$700(InputBox x0) {
            return x0._createBorder();
        }

        static Color access$802(InputBox x0, Color x1) {
            x0._bgColor = x1;
            return x0._bgColor;
        }

        static Color access$902(InputBox x0, Color x1) {
            x0._sysInColor = x1;
            return x0._sysInColor;
        }

        static boolean access$1002(InputBox x0, boolean x1) {
            x0._antiAliasText = x1;
            return x0._antiAliasText;
        }
    }
}

