/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.jar.JarBuilder;
import edu.rice.cs.util.jar.ManifestWriter;
import edu.rice.cs.util.swing.FileSelectorComponent;
import edu.rice.cs.util.swing.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class JarOptionsDialog
extends JDialog {
    private JCheckBox _jarClasses;
    private JCheckBox _jarSources;
    private JCheckBox _makeExecutable;
    private FileSelectorComponent _jarFileSelector;
    private JTextField _mainClassField;
    private JButton _okButton;
    private JButton _cancelButton;
    private SwingWorker _worker = null;
    private SingleDisplayModel _model;

    public JarOptionsDialog(JFrame parent, SingleDisplayModel mf) {
        super(parent, "Jar Options", false);
        this._model = mf;
        this.initComponents();
        this._loadSettings();
    }

    private void _loadSettings() {
        if (this._model.getBuildDirectory() == null) {
            this._jarClasses.setSelected(false);
            this._jarClasses.setEnabled(false);
            this._jarClasses.setToolTipText("A build directory must be specified in order to jar classes");
            this._disableExecutable();
            this._makeExecutable.setSelected(false);
        } else {
            this._jarClasses.setSelected(true);
            this._enableExecutable();
            this._makeExecutable.setSelected(false);
        }
        this._jarSources.setSelected(false);
    }

    private void initComponents() {
        JPanel main = this._makePanel();
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)main, "North");
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$000(JarOptionsDialog.this);
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$100(JarOptionsDialog.this);
            }
        };
        this._cancelButton = new JButton(cancelAction);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        super.getContentPane().add((Component)bottom, "South");
        super.setResizable(false);
        this.pack();
    }

    private JPanel _makePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 2;
        Insets labelInsets = new Insets(5, 10, 0, 10);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        c.fill = 2;
        JPanel dirPanel = this._makeClassesPanel();
        gridbag.setConstraints(dirPanel, c);
        panel.add(dirPanel);
        this._jarSources = new JCheckBox(new AbstractAction("Jar source files"){

            public void actionPerformed(ActionEvent e) {
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        gridbag.setConstraints(this._jarSources, c);
        panel.add(this._jarSources);
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = labelInsets;
        JLabel label = new JLabel("Jar File");
        label.setToolTipText("The file that the jar should be written to.");
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 0;
        c.insets = labelInsets;
        JPanel jarFilePanel = this._jarFileSelector();
        gridbag.setConstraints(jarFilePanel, c);
        panel.add(jarFilePanel);
        return panel;
    }

    private JPanel _makeClassesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this._jarClasses = new JCheckBox(new AbstractAction("Jar classes"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$200(JarOptionsDialog.this);
            }
        });
        this._makeExecutable = new JCheckBox(new AbstractAction("Make executable"){

            public void actionPerformed(ActionEvent e) {
                JarOptionsDialog.access$300(JarOptionsDialog.this);
            }
        });
        JPanel addclasses = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        panel.add((Component)this._jarClasses, gridBagConstraints);
        addclasses.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        addclasses.add((Component)this._makeExecutable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        addclasses.add((Component)this._mainFileSelector(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        panel.add((Component)addclasses, gridBagConstraints);
        return panel;
    }

    private JTextField _mainFileSelector() {
        this._mainClassField = new JTextField(18);
        this._mainClassField.setToolTipText("The fully qualified class name of the main document to be run");
        return this._mainClassField;
    }

    private JPanel _jarFileSelector() {
        JFileChooser fileChooser = new JFileChooser(this._model.getBuildDirectory());
        fileChooser.setDialogTitle("Select Jar Output File");
        fileChooser.setApproveButtonText("Select");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        this._jarFileSelector = new FileSelectorComponent(null, fileChooser, 20, 12.0f);
        this._jarFileSelector.setFileFilter(new javax.swing.filechooser.FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            public String getDescription() {
                return "Java Archive Files (*.jar)";
            }
        });
        return this._jarFileSelector;
    }

    private void _enableExecutable() {
        this._makeExecutable.setEnabled(true);
        if (this._makeExecutable.isSelected()) {
            this._mainClassField.setEnabled(true);
        } else {
            this._mainClassField.setEnabled(false);
        }
    }

    private void _disableExecutable() {
        this._makeExecutable.setEnabled(false);
        this._mainClassField.setEnabled(false);
    }

    private void _toggleClassOptions() {
        if (this._jarClasses.isSelected()) {
            this._enableExecutable();
        } else {
            this._disableExecutable();
        }
    }

    private void _toggleMainClass() {
        if (this._makeExecutable.isSelected()) {
            this._mainClassField.setEnabled(true);
        } else {
            this._mainClassField.setEnabled(false);
        }
    }

    private void _cancel() {
        if (this._worker != null) {
            this._worker.interrupt();
        }
        this.setVisible(false);
    }

    private void _ok() {
        this._saveSettings();
        this._worker = new SwingWorker(){

            private boolean jarBuildDirectory(File dir, JarBuilder jarFile) throws IOException {
                FileFilter classFilter = new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".class");
                    }
                };
                File[] files = dir.listFiles(classFilter);
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        jarFile.addDirectoryRecursive(files[i], files[i].getName(), classFilter);
                        continue;
                    }
                    jarFile.addFile(files[i], "", files[i].getName());
                }
                return true;
            }

            private boolean jarSources(SingleDisplayModel model, JarBuilder jar) {
                List<OpenDefinitionsDocument> srcs = model.getProjectDocuments();
                Iterator<OpenDefinitionsDocument> iter = srcs.iterator();
                while (iter.hasNext()) {
                    OpenDefinitionsDocument doc = iter.next();
                    if (!doc.inProject() || doc.isAuxiliaryFile()) continue;
                    try {
                        jar.addFile(doc.getFile(), this.packageNameToPath(doc.getPackageName()), doc.getFilename());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new UnexpectedException(e);
                    }
                    catch (InvalidPackageException e) {
                        e.printStackTrace();
                        throw new UnexpectedException(e);
                    }
                }
                return true;
            }

            private String packageNameToPath(String packageName) {
                return packageName.replaceAll("\\.", System.getProperty("file.separator").replaceAll("\\\\", "\\\\\\\\"));
            }

            public Object construct() {
                File jarOut = JarOptionsDialog.access$400(JarOptionsDialog.this).getFileFromField();
                if (jarOut == null) {
                    JOptionPane.showMessageDialog(JarOptionsDialog.this, "You must specify an output file", "Error: No File Specified", 0);
                    return null;
                }
                if (jarOut.exists()) {
                    if (JOptionPane.showConfirmDialog(JarOptionsDialog.this, "Are you sure you want to overwrite the file '" + jarOut.getPath() + "'?", "Overwrite file?", 0) != 0) {
                        return null;
                    }
                } else {
                    try {
                        jarOut.createNewFile();
                    }
                    catch (IOException e) {
                        JarOptionsDialog.this.setVisible(false);
                        e.printStackTrace();
                        throw new UnexpectedException(e);
                    }
                }
                if (JarOptionsDialog.access$500(JarOptionsDialog.this).isSelected()) {
                    try {
                        JarOptionsDialog.access$600(JarOptionsDialog.this).getCompilerModel().compileAll();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                if (JarOptionsDialog.access$500(JarOptionsDialog.this).isSelected() && JarOptionsDialog.access$700(JarOptionsDialog.this).isSelected()) {
                    try {
                        File classJarFile = File.createTempFile(JarOptionsDialog.access$600(JarOptionsDialog.this).getBuildDirectory().getName(), ".jar");
                        JarBuilder classJar = new JarBuilder(classJarFile);
                        this.jarBuildDirectory(JarOptionsDialog.access$600(JarOptionsDialog.this).getBuildDirectory(), classJar);
                        classJar.close();
                        JarBuilder mainJar = null;
                        if (JarOptionsDialog.access$800(JarOptionsDialog.this).isSelected()) {
                            ManifestWriter mw = new ManifestWriter();
                            mw.addClassPath(JarOptionsDialog.access$600(JarOptionsDialog.this).getBuildDirectory().getName() + ".jar");
                            mw.setMainClass(JarOptionsDialog.access$900(JarOptionsDialog.this).getText());
                            mainJar = new JarBuilder(jarOut, mw.getManifest());
                        } else {
                            ManifestWriter mw = new ManifestWriter();
                            mw.addClassPath(JarOptionsDialog.access$600(JarOptionsDialog.this).getBuildDirectory().getName() + ".jar");
                            mainJar = new JarBuilder(jarOut, mw.getManifest());
                        }
                        mainJar.addFile(classJarFile, "", JarOptionsDialog.access$600(JarOptionsDialog.this).getBuildDirectory().getName() + ".jar");
                        this.jarSources(JarOptionsDialog.access$600(JarOptionsDialog.this), mainJar);
                        mainJar.close();
                        classJarFile.delete();
                        JarOptionsDialog.this.setVisible(false);
                    }
                    catch (IOException e) {
                        JOptionPane.showConfirmDialog(JarOptionsDialog.this, "An error occured while writing the jar file. This could be becasue the file that you are writing to or the file you are reading from could not be opened.", "Error: File Access", 0);
                    }
                } else if (JarOptionsDialog.access$500(JarOptionsDialog.this).isSelected() && !JarOptionsDialog.access$700(JarOptionsDialog.this).isSelected()) {
                    try {
                        JarBuilder jb;
                        if (JarOptionsDialog.access$800(JarOptionsDialog.this).isSelected()) {
                            ManifestWriter mw = new ManifestWriter();
                            mw.setMainClass(JarOptionsDialog.access$900(JarOptionsDialog.this).getText());
                            jb = new JarBuilder(jarOut, mw.getManifest());
                        } else {
                            jb = new JarBuilder(jarOut);
                        }
                        this.jarBuildDirectory(JarOptionsDialog.access$600(JarOptionsDialog.this).getBuildDirectory(), jb);
                        jb.close();
                        JarOptionsDialog.this.setVisible(false);
                    }
                    catch (IOException e) {
                        JOptionPane.showConfirmDialog(JarOptionsDialog.this, "An error occured while writing the jar file. This could be becasue the file that you are writing to or the file you are reading from could not be opened.", "Error: File Access", 0);
                    }
                } else if (!JarOptionsDialog.access$500(JarOptionsDialog.this).isSelected() && JarOptionsDialog.access$700(JarOptionsDialog.this).isSelected()) {
                    try {
                        JarBuilder jb = new JarBuilder(jarOut);
                        this.jarSources(JarOptionsDialog.access$600(JarOptionsDialog.this), jb);
                        jb.close();
                        JarOptionsDialog.this.setVisible(false);
                    }
                    catch (IOException e) {
                        JOptionPane.showConfirmDialog(JarOptionsDialog.this, "An error occured while writing the jar file. This could be becasue the file that you are writing to or the file you are reading from could not be opened.", "Error: File Access", 0);
                    }
                } else if (!JarOptionsDialog.access$500(JarOptionsDialog.this).isSelected() && !JarOptionsDialog.access$700(JarOptionsDialog.this).isSelected()) {
                    JarOptionsDialog.this.setVisible(false);
                    return null;
                }
                JOptionPane.showConfirmDialog(JarOptionsDialog.this, "Jar file successfully written to '" + jarOut.getName() + "'", "Jar Creation Successful", 2);
                return null;
            }
        };
        this._worker.start();
    }

    private boolean _saveSettings() {
        return true;
    }

    public void setVisible(boolean vis) {
        if (vis) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        }
        super.setVisible(vis);
    }

    static void access$000(JarOptionsDialog x0) {
        x0._ok();
    }

    static void access$100(JarOptionsDialog x0) {
        x0._cancel();
    }

    static void access$200(JarOptionsDialog x0) {
        x0._toggleClassOptions();
    }

    static void access$300(JarOptionsDialog x0) {
        x0._toggleMainClass();
    }

    static FileSelectorComponent access$400(JarOptionsDialog x0) {
        return x0._jarFileSelector;
    }

    static JCheckBox access$500(JarOptionsDialog x0) {
        return x0._jarClasses;
    }

    static SingleDisplayModel access$600(JarOptionsDialog x0) {
        return x0._model;
    }

    static JCheckBox access$700(JarOptionsDialog x0) {
        return x0._jarSources;
    }

    static JCheckBox access$800(JarOptionsDialog x0) {
        return x0._makeExecutable;
    }

    static JTextField access$900(JarOptionsDialog x0) {
        return x0._mainClassField;
    }
}

