/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreviewFrame
extends JFrame {
    protected SingleDisplayModel _model;
    protected MainFrame _mainFrame;
    protected Pageable _print;
    protected int _pageNumber;
    private final PageChangerUpdater _pageChanger;
    private int PREVIEW_WIDTH;
    private int PREVIEW_HEIGHT;
    private int PREVIEW_PAGE_WIDTH;
    private int PREVIEW_PAGE_HEIGHT;
    private double PAGE_ZOOM = 0.7;
    private static int PAGE_BORDER = 20;
    private int TOOLBAR_HEIGHT = 35;
    private static final String ICON_PATH = "/edu/rice/cs/drjava/ui/icons/";
    private JToolBar _toolBar;
    private PagePreview _pagePreview;
    private final ActionListener _printListener = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.this._print();
            PreviewFrame.access$100(PreviewFrame.this);
        }
    };
    private Action _closeAction = new AbstractAction("Close"){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.access$100(PreviewFrame.this);
        }
    };
    private Action _nextPageAction = new AbstractAction("Next Page"){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.access$200(PreviewFrame.this);
        }
    };
    private Action _prevPageAction = new AbstractAction("Previous Page"){

        public void actionPerformed(ActionEvent ae) {
            PreviewFrame.access$300(PreviewFrame.this);
        }
    };
    private WindowListener _windowCloseListener = new WindowAdapter(){

        public void windowClosing(WindowEvent ev) {
            PreviewFrame.access$100(PreviewFrame.this);
        }
    };
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$PreviewFrame;
    private static final /* synthetic */ Class class$javax$swing$event$ChangeListener;
    private static final /* synthetic */ Class class$java$lang$Comparable;

    public PreviewFrame(SingleDisplayModel model, MainFrame mainFrame, boolean interactions) throws IllegalStateException {
        super("Print Preview");
        mainFrame.hourglassOn();
        this._model = model;
        this._mainFrame = mainFrame;
        this._toolBar = new JToolBar();
        this._print = this.setUpDocument(model, interactions);
        this._pageChanger = this.createPageChanger();
        this._setUpActions();
        this._setUpToolBar();
        this._setUpConstants();
        this._pagePreview = new PagePreview(this.PREVIEW_PAGE_WIDTH, this.PREVIEW_PAGE_HEIGHT);
        this._pageNumber = 0;
        PagePreviewContainer ppc = new PagePreviewContainer();
        ppc.add(this._pagePreview);
        JPanel tbCont = new JPanel(new BorderLayout());
        JPanel cp = new JPanel(new BorderLayout());
        tbCont.add((Component)this._toolBar, "North");
        tbCont.add(Box.createVerticalStrut(10), "South");
        tbCont.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.setContentPane(cp);
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        cp.add((Component)tbCont, "North");
        cp.add((Component)ppc, "South");
        this.addWindowListener(this._windowCloseListener);
        this.showPage();
        this._updateActions();
        this.setSize(this.PREVIEW_WIDTH, this.PREVIEW_HEIGHT);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    protected abstract void _print();

    protected abstract Pageable setUpDocument(SingleDisplayModel var1, boolean var2);

    private void _close() {
        this.dispose();
        this._mainFrame.hourglassOff();
    }

    private void _nextPage() {
        ++this._pageNumber;
        this._goToPage(this._pageNumber);
    }

    private void _previousPage() {
        --this._pageNumber;
        this._goToPage(this._pageNumber);
    }

    private void _goToPage(int pi) {
        this._pageNumber = pi;
        this.showPage();
        this._updateActions();
    }

    protected void _showError(Exception e, String title, String message) {
        JOptionPane.showMessageDialog(this, new StringBuffer().append(message).append("\n").append(e).toString(), title, 0);
    }

    private void _updateActions() {
        this._nextPageAction.setEnabled(this._print.getNumberOfPages() > this._pageNumber + 1);
        this._prevPageAction.setEnabled(this._pageNumber > 0);
        try {
            this._pageChanger.update(this._pageNumber + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setUpConstants() {
        PageFormat first = this._print.getPageFormat(0);
        this.PREVIEW_PAGE_WIDTH = (int)(this.PAGE_ZOOM * first.getWidth());
        this.PREVIEW_PAGE_HEIGHT = (int)(this.PAGE_ZOOM * first.getHeight());
        this.PREVIEW_WIDTH = this.PREVIEW_PAGE_WIDTH + 2 * PAGE_BORDER;
        this.PREVIEW_HEIGHT = this.PREVIEW_PAGE_HEIGHT + 2 * PAGE_BORDER + this.TOOLBAR_HEIGHT;
    }

    private void _setUpActions() {
        this._closeAction.putValue("ShortDescription", "Close");
        this._nextPageAction.putValue("SmallIcon", this._getIcon("Forward16.gif"));
        this._nextPageAction.putValue("ShortDescription", "Next Page");
        this._prevPageAction.putValue("SmallIcon", this._getIcon("Back16.gif"));
        this._prevPageAction.putValue("ShortDescription", "Previous Page");
    }

    private PageChangerUpdater createPageChanger() {
        try {
            Class<?> spinnerClass = Class.forName("javax.swing.JSpinner");
            final JComponent spinner = (JComponent)spinnerClass.newInstance();
            final Method getter = spinnerClass.getMethod("getValue", new Class[0]);
            Object model = PreviewFrame.callMethod(spinner, spinnerClass, "getModel", null, null);
            Class<?> modelClass = model.getClass();
            Class[] ca = new Class[]{class$java$lang$Comparable == null ? (class$java$lang$Comparable = PreviewFrame.class$("java.lang.Comparable")) : class$java$lang$Comparable};
            Object[] aa = new Object[]{new Integer(1)};
            PreviewFrame.callMethod(model, modelClass, "setMinimum", ca, aa);
            aa[0] = new Integer(this._print.getNumberOfPages());
            PreviewFrame.callMethod(model, modelClass, "setMaximum", ca, aa);
            ca[0] = class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PreviewFrame.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener;
            aa[0] = new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    int num = PreviewFrame.this._pageNumber;
                    try {
                        num = ((Number)getter.invoke((Object)spinner, new Object[0])).intValue() - 1;
                        if (num >= 0 && num < PreviewFrame.this._print.getNumberOfPages()) {
                            PreviewFrame.access$400(PreviewFrame.this, num);
                        } else {
                            PreviewFrame.access$500(PreviewFrame.this);
                        }
                    }
                    catch (Exception ex) {
                        PreviewFrame.access$500(PreviewFrame.this);
                    }
                }
            };
            PreviewFrame.callMethod(spinner, spinnerClass, "addChangeListener", ca, aa);
            return new JSpinnerChanger(spinnerClass, spinner, null);
        }
        catch (Exception e) {
            final JTextField tf = new JTextField();
            tf.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    try {
                        int pageToGoTo = Integer.parseInt(tf.getText()) - 1;
                        if (pageToGoTo < 0 || pageToGoTo >= PreviewFrame.this._print.getNumberOfPages()) {
                            PreviewFrame.access$500(PreviewFrame.this);
                        } else {
                            PreviewFrame.access$400(PreviewFrame.this, pageToGoTo);
                        }
                    }
                    catch (NumberFormatException e) {
                        PreviewFrame.access$500(PreviewFrame.this);
                    }
                }
            });
            return new JTextFieldChanger(tf, null);
        }
    }

    private static Object callMethod(Object rec, Class<?> c, String name, Class<?>[] ca, Object[] args) throws Exception {
        Method m = c.getMethod(name, ca);
        return m.invoke(rec, args);
    }

    private ImageIcon _getIcon(String name) {
        URL url = (class$edu$rice$cs$drjava$ui$PreviewFrame == null ? (class$edu$rice$cs$drjava$ui$PreviewFrame = PreviewFrame.class$("edu.rice.cs.drjava.ui.PreviewFrame")) : class$edu$rice$cs$drjava$ui$PreviewFrame).getResource(new StringBuffer().append(ICON_PATH).append(name).toString());
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    private void _setUpToolBar() {
        this._toolBar.setFloatable(false);
        JButton printButton = new JButton("Print...", this._getIcon("Print16.gif"));
        printButton.setToolTipText("Print this document");
        printButton.addActionListener(this._printListener);
        this._toolBar.add(printButton);
        this._toolBar.addSeparator();
        this._toolBar.add(this._closeAction);
        this._toolBar.add(Box.createHorizontalGlue());
        this._toolBar.add(this._prevPageAction);
        this._toolBar.add(this._nextPageAction);
        this._toolBar.addSeparator();
        JLabel gotop = new JLabel("Page");
        JLabel of = new JLabel(new StringBuffer().append(" of ").append(this._print.getNumberOfPages()).toString());
        this._toolBar.add(gotop);
        this._toolBar.addSeparator();
        JComponent c = this._pageChanger.getComponent();
        Dimension d = c.getPreferredSize();
        d = new Dimension(100, d.height);
        c.setMaximumSize(d);
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setToolTipText("Goto Page");
        this._toolBar.add(c);
        this._toolBar.add(of);
    }

    private void showPage() {
        BufferedImage img = new BufferedImage((int)this._model.getPageFormat().getWidth(), (int)this._model.getPageFormat().getHeight(), 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)this._model.getPageFormat().getWidth(), (int)this._model.getPageFormat().getHeight());
        try {
            this._print.getPrintable(this._pageNumber).print(g, this._model.getPageFormat(), this._pageNumber);
            this._pagePreview.setImage(img);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    static void access$100(PreviewFrame x0) {
        x0._close();
    }

    static void access$200(PreviewFrame x0) {
        x0._nextPage();
    }

    static void access$300(PreviewFrame x0) {
        x0._previousPage();
    }

    static void access$400(PreviewFrame x0, int x1) {
        x0._goToPage(x1);
    }

    static void access$500(PreviewFrame x0) {
        x0._updateActions();
    }

    static int access$800(PreviewFrame x0) {
        return x0.TOOLBAR_HEIGHT;
    }

    static PagePreview access$900(PreviewFrame x0) {
        return x0._pagePreview;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class PagePreview
    extends JPanel {
        protected int _width;
        protected int _height;
        protected Image _source;
        protected Image _image;

        public PagePreview(int width, int height) {
            this._width = width;
            this._height = height;
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
            this.setBackground(Color.white);
        }

        protected void updateScaled() {
            this._image = this._source.getScaledInstance(this._width, this._height, 4);
            this._image.flush();
        }

        public void setImage(Image i) {
            this._source = i;
            this.updateScaled();
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this._width, this._height);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this._width, this._height);
            g.drawImage(this._image, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PagePreviewContainer
    extends JPanel {
        PagePreviewContainer() {
        }

        public Dimension getPreferredSize() {
            return this.getParent().getSize();
        }

        public void doLayout() {
            Component cp = this.getComponent(0);
            Dimension dm = cp.getPreferredSize();
            int Hindent = (int)(this.getPreferredSize().getWidth() - dm.getWidth()) / 2;
            int Vindent = PreviewFrame.access$800(PreviewFrame.this) + (int)((this.getPreferredSize().getHeight() - dm.getHeight() - (double)PreviewFrame.access$800(PreviewFrame.this)) / 2.0);
            PreviewFrame.access$900(PreviewFrame.this).setBounds(Hindent, Vindent, (int)dm.getWidth(), (int)dm.getHeight());
        }
    }

    private class JSpinnerChanger
    extends PageChangerUpdater {
        private final JComponent spinner;
        private final Method setValueMethod;
        private final Object[] args;
        private static final /* synthetic */ Class class$java$lang$Object;

        private JSpinnerChanger(Class spinnerClass, JComponent spinnerObj) throws Exception {
            super(null);
            this.args = new Object[1];
            this.spinner = spinnerObj;
            this.setValueMethod = spinnerClass.getMethod("setValue", class$java$lang$Object == null ? (class$java$lang$Object = JSpinnerChanger.class$("java.lang.Object")) : class$java$lang$Object);
        }

        void update(int pageNumber) throws Exception {
            this.args[0] = new Integer(pageNumber);
            this.setValueMethod.invoke((Object)this.spinner, this.args);
        }

        JComponent getComponent() {
            return this.spinner;
        }

        JSpinnerChanger(Class x1, JComponent x2, 1 x3) throws Exception {
            this(x1, x2);
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    private class JTextFieldChanger
    extends PageChangerUpdater {
        private final JTextField textfield;

        private JTextFieldChanger(JTextField tf) {
            super(null);
            this.textfield = tf;
        }

        void update(int pageNumber) throws Exception {
            this.textfield.setText(String.valueOf(pageNumber));
        }

        JComponent getComponent() {
            return this.textfield;
        }

        JTextFieldChanger(JTextField x1, 1 x2) {
            this(x1);
        }
    }

    private static abstract class PageChangerUpdater {
        private PageChangerUpdater() {
        }

        abstract void update(int var1) throws Exception;

        abstract JComponent getComponent();

        PageChangerUpdater(1 x0) {
            this();
        }
    }
}

