/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.ClasspathFilter;
import edu.rice.cs.drjava.ui.DirectoryFilter;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.BooleanOptionComponent;
import edu.rice.cs.drjava.ui.config.ColorOptionComponent;
import edu.rice.cs.drjava.ui.config.ConfigPanel;
import edu.rice.cs.drjava.ui.config.DirectoryOptionComponent;
import edu.rice.cs.drjava.ui.config.FileOptionComponent;
import edu.rice.cs.drjava.ui.config.FontOptionComponent;
import edu.rice.cs.drjava.ui.config.ForcedChoiceOptionComponent;
import edu.rice.cs.drjava.ui.config.IntegerOptionComponent;
import edu.rice.cs.drjava.ui.config.KeyStrokeOptionComponent;
import edu.rice.cs.drjava.ui.config.LabelComponent;
import edu.rice.cs.drjava.ui.config.StringOptionComponent;
import edu.rice.cs.drjava.ui.config.ToolbarOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.util.swing.DirectoryChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConfigFrame
extends JFrame {
    private static final int FRAME_WIDTH = 750;
    private static final int FRAME_HEIGHT = 500;
    private MainFrame _mainFrame;
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private PanelTreeNode _rootNode;
    private JButton _okButton;
    private JButton _applyButton;
    private JButton _cancelButton;
    private JPanel _mainPanel;
    private JFileChooser _fileOptionChooser;
    private JFileChooser _browserChooser;
    private DirectoryChooser _dirChooser;

    public ConfigFrame(MainFrame frame) {
        super("Preferences");
        this._mainFrame = frame;
        File workDir = this._getWorkDir();
        this._fileOptionChooser = new JFileChooser(workDir);
        this._fileOptionChooser.setDialogTitle("Select");
        this._fileOptionChooser.setApproveButtonText("Select");
        this._fileOptionChooser.setFileSelectionMode(2);
        this._fileOptionChooser.setFileFilter(ClasspathFilter.ONLY);
        this._browserChooser = new JFileChooser(workDir);
        this._browserChooser.setDialogTitle("Select Web Browser");
        this._browserChooser.setApproveButtonText("Select");
        this._browserChooser.setFileSelectionMode(0);
        this._dirChooser = new DirectoryChooser(this);
        this._dirChooser.setSelectedDirectory(this._getWorkDir());
        this._dirChooser.setDialogTitle("Select");
        this._dirChooser.setApproveButtonText("Select");
        this._dirChooser.setMultiSelectionEnabled(false);
        this._createTree();
        this._createPanels();
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new BorderLayout());
        this._tree.addTreeSelectionListener(new PanelTreeSelectionListener(null));
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        if (this._rootNode.getChildCount() != 0) {
            PanelTreeNode firstChild = (PanelTreeNode)this._rootNode.getChildAt(0);
            Object[] firstChildPath = firstChild.getPath();
            TreePath path = new TreePath(firstChildPath);
            this._tree.expandPath(path);
            this._tree.setSelectionPath(path);
        }
        JScrollPane treeScroll = new JScrollPane(this._tree);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treeScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Categories"));
        treePanel.add((Component)treeScroll, "Center");
        cp.add((Component)treePanel, "West");
        cp.add((Component)this._mainPanel, "Center");
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                try {
                    successful = ConfigFrame.this.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (successful) {
                    ConfigFrame.this.setVisible(false);
                }
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction applyAction = new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent e) {
                try {
                    ConfigFrame.this.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this._applyButton = new JButton(applyAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._applyButton);
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        cp.add((Component)bottom, "South");
        this.setSize(750, 500);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setSize(frameSize);
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigFrame.this.cancel();
            }
        });
        this._tree.expandRow(0);
        this._tree.expandRow(1);
        this._tree.expandRow(2);
    }

    private File _getWorkDir() {
        File workDir = DrJava.getConfig().getSetting(OptionConstants.WORKING_DIRECTORY);
        if (workDir == FileOption.NULL_FILE) {
            workDir = new File(System.getProperty("user.dir"));
        }
        if (workDir.isFile() && workDir.getParent() != null) {
            workDir = workDir.getParentFile();
        }
        return workDir;
    }

    public boolean apply() {
        return PanelTreeNode.access$100(this._rootNode);
    }

    public void resetToCurrent() {
        this._rootNode.resetToCurrent();
    }

    public void cancel() {
        this.resetToCurrent();
        this.setVisible(false);
    }

    public boolean saveSettings() throws IOException {
        boolean successful = this.apply();
        if (successful) {
            try {
                DrJava.getConfig().saveConfiguration();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Could not save changes to your '.drjava' file in your home directory. \n\n" + ioe, "Could Not Save Changes", 0);
                throw ioe;
            }
        }
        return successful;
    }

    private void _displayPanel(ConfigPanel cf) {
        this._mainPanel.removeAll();
        this._mainPanel.add((Component)cf, "Center");
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    private void _createTree() {
        this._rootNode = new PanelTreeNode("Preferences");
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree = new JTree(this._treeModel);
        this._tree.setEditable(false);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();
        dtcr.setLeafIcon(null);
        dtcr.setOpenIcon(null);
        dtcr.setClosedIcon(null);
        this._tree.setCellRenderer(dtcr);
    }

    private PanelTreeNode _createPanel(String t, PanelTreeNode parent) {
        PanelTreeNode ptNode = new PanelTreeNode(t);
        this._treeModel.insertNodeInto(ptNode, parent, parent.getChildCount());
        Object[] pathArray = ptNode.getPath();
        TreePath path = new TreePath(pathArray);
        this._tree.expandPath(path);
        return ptNode;
    }

    private PanelTreeNode _createPanel(String t) {
        return this._createPanel(t, this._rootNode);
    }

    private void _createPanels() {
        PanelTreeNode resourceLocNode = this._createPanel("Resource Locations");
        this._setupResourceLocPanel(PanelTreeNode.access$200(resourceLocNode));
        PanelTreeNode displayNode = this._createPanel("Display Options");
        this._setupDisplayPanel(PanelTreeNode.access$200(displayNode));
        PanelTreeNode fontNode = this._createPanel("Fonts", displayNode);
        this._setupFontPanel(PanelTreeNode.access$200(fontNode));
        PanelTreeNode colorNode = this._createPanel("Colors", displayNode);
        this._setupColorPanel(PanelTreeNode.access$200(colorNode));
        PanelTreeNode keystrokesNode = this._createPanel("Key Bindings");
        this._setupKeyBindingsPanel(PanelTreeNode.access$200(keystrokesNode));
        PanelTreeNode compilerOptionsNode = this._createPanel("Compiler Options");
        this._setupCompilerPanel(PanelTreeNode.access$200(compilerOptionsNode));
        PanelTreeNode debugNode = this._createPanel("Debugger");
        this._setupDebugPanel(PanelTreeNode.access$200(debugNode));
        PanelTreeNode javadocNode = this._createPanel("Javadoc");
        this._setupJavadocPanel(PanelTreeNode.access$200(javadocNode));
        PanelTreeNode notificationsNode = this._createPanel("Notifications");
        this._setupNotificationsPanel(PanelTreeNode.access$200(notificationsNode));
        PanelTreeNode miscNode = this._createPanel("Miscellaneous");
        this._setupMiscPanel(PanelTreeNode.access$200(miscNode));
    }

    private void _setupResourceLocPanel(ConfigPanel panel) {
        FileOptionComponent browserLoc = new FileOptionComponent(OptionConstants.BROWSER_FILE, "Web Browser", this, "<html>Location of a web browser to use for Javadoc and Help links.<br>If left blank, only the Web Browser Command will be used.<br>This is not necessary if a default browser is available on your system.", this._browserChooser);
        panel.addComponent(browserLoc);
        StringOptionComponent browserCommand = new StringOptionComponent(OptionConstants.BROWSER_STRING, "Web Browser Command", this, "<html>Command to send to the web browser to view a web location.<br>The string <code>&lt;URL&gt;</code> will be replaced with the URL address.<br>This is not necessary if a default browser is available on your system.");
        panel.addComponent(browserCommand);
        FileOptionComponent javacLoc = new FileOptionComponent(OptionConstants.JAVAC_LOCATION, "Tools.jar Location", this, "Optional location of the JDK's tools.jar, which contains the compiler and debugger.", this._fileOptionChooser);
        javacLoc.setFileFilter(ClasspathFilter.ONLY);
        panel.addComponent(javacLoc);
        FileOptionComponent jsr14Loc = new FileOptionComponent(OptionConstants.JSR14_LOCATION, "JSR-14 Location", this, "Optional location of the JSR-14 compiler, for compiling with generics.", this._fileOptionChooser);
        jsr14Loc.setFileFilter(ClasspathFilter.ONLY);
        panel.addComponent(jsr14Loc);
        FileOptionComponent jsr14Col = new FileOptionComponent(OptionConstants.JSR14_COLLECTIONSPATH, "JSR-14 Collections Path", this, "Optional location of the JSR-14 collect.jar file, which contains the collection classes.", this._fileOptionChooser);
        jsr14Col.setFileFilter(ClasspathFilter.ONLY);
        panel.addComponent(jsr14Col);
        panel.addComponent(new VectorFileOptionComponent(OptionConstants.EXTRA_CLASSPATH, "Extra Classpath", (Frame)this, "<html>Any directories or jar files to add to the classpath<br>of the Compiler and Interactions Pane.</html>"));
        panel.displayComponents();
    }

    private void _setupDisplayPanel(ConfigPanel panel) {
        panel.addComponent(new ForcedChoiceOptionComponent(OptionConstants.LOOK_AND_FEEL, "Look and Feel", this, "Changes the general appearance of DrJava."));
        panel.addComponent(new ToolbarOptionComponent("Toolbar Buttons", this, "How to display the toolbar buttons."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.LINEENUM_ENABLED, "Show All Line Numbers", this, "Whether to show line numbers on the left side of the Definitions Pane."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.WINDOW_STORE_POSITION, "Save Main Window Position", this, "Whether to save amd restore the size and position of the main window."));
        panel.displayComponents();
    }

    private void _setupFontPanel(ConfigPanel panel) {
        panel.addComponent(new FontOptionComponent(OptionConstants.FONT_MAIN, "Main Font", this, "The font used for most text in DrJava."));
        panel.addComponent(new FontOptionComponent(OptionConstants.FONT_LINE_NUMBERS, "Line Numbers Font", this, "<html>The font for displaying line numbers on the left side of<br>the Definitions Pane if Show All Line Numbers is enabled.<br>Cannot be displayed larger than the Main Font.</html>"));
        panel.addComponent(new FontOptionComponent(OptionConstants.FONT_DOCLIST, "Document List Font", this, "The font used in the list of open documents."));
        panel.addComponent(new FontOptionComponent(OptionConstants.FONT_TOOLBAR, "Toolbar Font", this, "The font used in the toolbar buttons."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.TEXT_ANTIALIAS, "Use anti-aliased text", this, "Whether to graphically smooth the text."));
        panel.displayComponents();
    }

    private void _setupColorPanel(ConfigPanel panel) {
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_NORMAL_COLOR, "Normal Color", (Frame)this, "The default color for text in the Definitions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_KEYWORD_COLOR, "Keyword Color", (Frame)this, "The color for Java keywords in the Definitions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_TYPE_COLOR, "Type Color", (Frame)this, "The color for classes and types in the Definitions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_COMMENT_COLOR, "Comment Color", (Frame)this, "The color for comments in the Definitions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_DOUBLE_QUOTED_COLOR, "Double-quoted Color", (Frame)this, "The color for quoted strings (eg. \"...\") in the Definitions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_SINGLE_QUOTED_COLOR, "Single-quoted Color", (Frame)this, "The color for quoted characters (eg. 'a') in the Definitions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_NUMBER_COLOR, "Number Color", (Frame)this, "The color for numbers in the Definitions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, "Background Color", (Frame)this, "The background color of the Definitions Pane.", true));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEFINITIONS_MATCH_COLOR, "Brace-matching Color", (Frame)this, "The color for matching brace highlights in the Definitions Pane.", true));
        panel.addComponent(new ColorOptionComponent(OptionConstants.COMPILER_ERROR_COLOR, "Compiler Error Color", (Frame)this, "The color for compiler error highlights in the Definitions Pane.", true));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEBUG_BREAKPOINT_COLOR, "Debugger Breakpoint Color", (Frame)this, "The color for breakpoints in the Definitions Pane.", true));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEBUG_THREAD_COLOR, "Debugger Location Color", (Frame)this, "The color for the location of the current suspended thread in the Definitions Pane.", true));
        panel.addComponent(new ColorOptionComponent(OptionConstants.SYSTEM_OUT_COLOR, "System.out Color", (Frame)this, "The color for System.out in the Interactions and Console Panes."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.SYSTEM_ERR_COLOR, "System.err Color", (Frame)this, "The color for System.err in the Interactions and Console Panes."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.SYSTEM_IN_COLOR, "System.in Color", (Frame)this, "The color for System.in in the Interactions Pane."));
        panel.addComponent(new ColorOptionComponent(OptionConstants.INTERACTIONS_ERROR_COLOR, "Interactions Error Color", this, "The color for interactions errors in the Interactions Pane.", false, true));
        panel.addComponent(new ColorOptionComponent(OptionConstants.DEBUG_MESSAGE_COLOR, "Debug Message Color", this, "The color for debugger messages in the Interactions Pane.", false, true));
        panel.displayComponents();
    }

    private void _setupKeyBindingsPanel(ConfigPanel panel) {
        TreeSet<KeyStrokeOptionComponent> _comps = new TreeSet<KeyStrokeOptionComponent>();
        Enumeration e = KeyBindingManager.Singleton.getKeyStrokeData();
        while (e.hasMoreElements()) {
            KeyStrokeOptionComponent tmpKsoc;
            KeyBindingManager.KeyStrokeData tmpKsd = (KeyBindingManager.KeyStrokeData)e.nextElement();
            if (tmpKsd.getOption() == null) continue;
            Action a = tmpKsd.getAction();
            String desc = (String)a.getValue("ShortDescription");
            if (desc == null || desc.equals("")) {
                desc = tmpKsd.getName();
            }
            if ((tmpKsoc = new KeyStrokeOptionComponent((KeyStrokeOption)tmpKsd.getOption(), tmpKsd.getName(), this, desc)) == null) continue;
            _comps.add(tmpKsoc);
        }
        Iterator iter = _comps.iterator();
        while (iter.hasNext()) {
            KeyStrokeOptionComponent x = (KeyStrokeOptionComponent)iter.next();
            panel.addComponent(x);
        }
        panel.displayComponents();
    }

    private void _setupDebugPanel(ConfigPanel panel) {
        if (!this._mainFrame.getModel().getDebugger().isAvailable()) {
            String howto = "\nThe debugger is not currently active.  To use the debugger, you\nmust include Sun's tools.jar or jpda.jar on your classpath when\nstarting DrJava.  Do not use the \"-jar\" option, because it\noverrides the classpath and will not include tools.jar.\nFor example, in Windows you might type:\n\n  java -classpath drjava.jar;c:\\path\\tools.jar edu.rice.cs.drjava.DrJava\n\n(Substituting the correct path for tools.jar.)\nSee the user documentation for more details.\n";
            panel.addComponent(new LabelComponent(howto, this));
        }
        VectorFileOptionComponent sourcePath = new VectorFileOptionComponent(OptionConstants.DEBUG_SOURCEPATH, "Sourcepath", (Frame)this, "<html>Any directories in which to search for source<br>files when stepping in the Debugger.</html>");
        sourcePath.setFileFilter(new DirectoryFilter("Source Directories"));
        panel.addComponent(sourcePath);
        panel.addComponent(new BooleanOptionComponent(OptionConstants.DEBUG_STEP_JAVA, "Step Into Java Classes", this, "<html>Whether the Debugger should step into Java library classes,<br>including java.*, javax.*, sun.*, com.sun.*, and com.apple.mrj.*</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.DEBUG_STEP_INTERPRETER, "Step Into Interpreter Classes", this, "<html>Whether the Debugger should step into the classes<br>used by the Interactions Pane (DynamicJava).</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.DEBUG_STEP_DRJAVA, "Step Into DrJava Classes", this, "Whether the Debugger should step into DrJava's own class files."));
        panel.addComponent(new StringOptionComponent(OptionConstants.DEBUG_STEP_EXCLUDE, "Classes/Packages To Exclude", this, "<html>Any classes that the debuggger should not step into.<br>Should be a COMMA-separated list of fully-qualified class names.<br>To exclude a package, specify <code>packagename.*</code> in the list.</html>"));
        panel.displayComponents();
    }

    private void _setupJavadocPanel(ConfigPanel panel) {
        panel.addComponent(new ForcedChoiceOptionComponent(OptionConstants.JAVADOC_ACCESS_LEVEL, "Access Level", this, "<html>Fields and methods with access modifiers at this level<br>or higher will be included in the generated Javadoc.</html>"));
        panel.addComponent(new ForcedChoiceOptionComponent(OptionConstants.JAVADOC_LINK_VERSION, "Java Version for Javadoc Links", this, "The version of Java for generating links to online Javadoc documentation."));
        panel.addComponent(new StringOptionComponent(OptionConstants.JAVADOC_1_3_LINK, "Javadoc 1.3 URL", this, "The URL to the Java 1.3 API, for generating links to library classes."));
        panel.addComponent(new StringOptionComponent(OptionConstants.JAVADOC_1_4_LINK, "Javadoc 1.4 URL", this, "The URL to the Java 1.4 API, for generating links to library classes."));
        panel.addComponent(new StringOptionComponent(OptionConstants.JAVADOC_1_5_LINK, "Javadoc 1.5 URL", this, "The URL to the Java 1.5 API, for generating links to library classes."));
        panel.addComponent(new DirectoryOptionComponent(OptionConstants.JAVADOC_DESTINATION, "Default Destination Directory", this, "Optional default directory for saving Javadoc documentation.", this._dirChooser));
        panel.addComponent(new StringOptionComponent(OptionConstants.JAVADOC_CUSTOM_PARAMS, "Custom Javadoc Parameters", this, "Any extra flags or parameters to pass to Javadoc."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.JAVADOC_FROM_ROOTS, "Generate Javadoc From Source Roots", this, "<html>Whether 'Javadoc All' should generate Javadoc for all packages<br>in an open document's source tree, rather than just the document's<br>own package and sub-packages.</html>"));
        panel.displayComponents();
    }

    private void _setupNotificationsPanel(ConfigPanel panel) {
        panel.addComponent(new BooleanOptionComponent(OptionConstants.QUIT_PROMPT, "Prompt Before Quit", this, "Whether DrJava should prompt the user before quitting."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.INTERACTIONS_RESET_PROMPT, "Prompt Before Resetting Interactions Pane", this, "<html>Whether DrJava should prompt the user before<br>manually resetting the interactions pane.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.INTERACTIONS_EXIT_PROMPT, "Prompt if Interactions Pane Exits Unexpectedly", this, "<html>Whether DrJava should show a dialog box if a program<br>in the Interactions Pane exits without the user clicking Reset.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.JAVADOC_PROMPT_FOR_DESTINATION, "Prompt for Javadoc Destination", this, "<html>Whether Javadoc should always prompt the user<br>to select a destination directory.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.PROMPT_BEFORE_CLEAN, "Prompt before Cleaning Build Directory", this, "<html>Whether DrJava should prompt before cleaning the<br>build directory of a project</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_COMPILE, "Automatically Save Before Compiling", this, "<html>Whether DrJava should automatically save before<br>recompiling or ask the user each time.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.ALWAYS_COMPILE_BEFORE_JUNIT, "Automatically Compile Before Testing", this, "<html>Whether DrJava should automatically compile before<br>testing with JUnit or ask the user each time.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_JAVADOC, "Automatically Save Before Generating Javadoc", this, "<html>Whether DrJava should automatically save before<br>generating Javadoc or ask the user each time.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.WARN_BREAKPOINT_OUT_OF_SYNC, "Warn on Breakpoint if Out of Sync", this, "<html>Whether DrJava should warn the user if the class file<br>is out of sync before setting a breakpoint in that file.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.WARN_DEBUG_MODIFIED_FILE, "Warn if Debugging Modified File", this, "<html>Whether DrJava should warn the user if the file being<br>debugged has been modified since its last save.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.WARN_CHANGE_LAF, "Warn to Restart to Change Look and Feel", this, "<html>Whether DrJava should warn the user that look and feel<br>changes will not be applied until DrJava is restarted.</html>."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.WARN_PATH_CONTAINS_POUND, "Warn if File's Path Contains a '#' Symbol", this, "<html>Whether DrJava should warn the user if the file being<br>saved has a path that contains a '#' symbol.<br>Users cannot use such files in the Interactions Pane<br>because of a bug in Java.</html>"));
        panel.displayComponents();
    }

    private void _setupMiscPanel(ConfigPanel panel) {
        panel.addComponent(new IntegerOptionComponent(OptionConstants.INDENT_LEVEL, "Indent Level", this, "The number of spaces to use for each level of indentation."));
        panel.addComponent(new DirectoryOptionComponent(OptionConstants.WORKING_DIRECTORY, "Working Directory", this, "The directory that DrJava should consider the default working directory.", this._dirChooser));
        panel.addComponent(new IntegerOptionComponent(OptionConstants.HISTORY_MAX_SIZE, "Size of Interactions History", this, "The number of interactions to remember in the history."));
        panel.addComponent(new IntegerOptionComponent(OptionConstants.RECENT_FILES_MAX_SIZE, "Recent Files List Size", this, "<html>The number of files to remember in<br>the recently used files list in the File menu.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.AUTO_CLOSE_COMMENTS, "Automatically Close Block Comments", this, "<html>Whether to automatically insert a closing comment tag (\"*/\")<br>when the enter key is pressed after typing a new block comment<br>tag (\"/*\" or \"/**\").</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.JAVAC_ALLOW_ASSERT, "Allow Assert Keyword in Java 1.4", this, "<html>Whether to allow the <code>assert</code> keyword when compiling in Java 1.4.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.BACKUP_FILES, "Keep Emacs-style Backup Files", this, "<html>Whether DrJava should keep a backup copy of each file that<br>the user modifies, saved with a '~' at the end of the filename.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.RESET_CLEAR_CONSOLE, "Clear Console After Interactions Reset", this, "Whether to clear the Console output after resetting the Interactions Pane."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.ALLOW_PRIVATE_ACCESS, "Allow Access of Private Members in Interactions Pane", this, "Whether to allow users to access private (and protected) fields and methods."));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.SHOW_SOURCE_WHEN_SWITCHING, "Show sample of source code when fast switching", this, "Whether to show a sample of the source code under the document's filename when fast switching documents."));
        panel.addComponent(new StringOptionComponent(OptionConstants.JVM_ARGS, "JVM Args for Interactions", this, "The command-line arguments to pass to the Interactions JVM."));
        panel.displayComponents();
    }

    private void _setupCompilerPanel(ConfigPanel panel) {
        panel.addComponent(new LabelComponent("Note: Compiler warnings not shown if compiling any Java language level files", this));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.SHOW_UNCHECKED_WARNINGS, "Show Unchecked Warnings", this, "<html>Give more detail for unchecked conversion warnings that are mandated<br>by the Java Language Specification.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.SHOW_DEPRECATION_WARNINGS, "Show Deprecation Warnings", this, "<html>Show a description of each use or override of a deprecated member or class.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.SHOW_PATH_WARNINGS, "Show Path Warnings", this, "<html>Warn about nonexistent path (classpath, sourcepath, etc) directories.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.SHOW_SERIAL_WARNINGS, "Show Serial Warnings", this, "<html>Warn about missing <code>serialVersionUID</code> definitions on serializable classes.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.SHOW_FINALLY_WARNINGS, "Show Finally Warnings", this, "<html>Warn about <code>finally<code> clauses that cannot complete normally.</html>"));
        panel.addComponent(new BooleanOptionComponent(OptionConstants.SHOW_FALLTHROUGH_WARNINGS, "Show Fall-Through Warnings", this, "<html>Check <code>switch</code> blocks for fall-through cases and provide a warning message for any that are found.<br>Fall-through cases are cases in a <code>switch</code> block, other than the last case in the block,<br>whose code does not include a <code>break</code> statement, allowing code execution to \"fall through\"<br>from that case to the next case.</html>"));
        panel.displayComponents();
    }

    static JTree access$300(ConfigFrame x0) {
        return x0._tree;
    }

    static void access$400(ConfigFrame x0, ConfigPanel x1) {
        x0._displayPanel(x1);
    }

    private class PanelTreeSelectionListener
    implements TreeSelectionListener {
        private PanelTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Object o = ConfigFrame.access$300(ConfigFrame.this).getLastSelectedPathComponent();
            if (o instanceof PanelTreeNode) {
                PanelTreeNode child = (PanelTreeNode)ConfigFrame.access$300(ConfigFrame.this).getLastSelectedPathComponent();
                ConfigFrame.access$400(ConfigFrame.this, PanelTreeNode.access$200(child));
            }
        }

        PanelTreeSelectionListener(1 x1) {
            this();
        }
    }

    private class PanelTreeNode
    extends DefaultMutableTreeNode {
        private final ConfigPanel _panel;

        public PanelTreeNode(String t) {
            super(t);
            this._panel = new ConfigPanel(t);
        }

        public PanelTreeNode(ConfigPanel c) {
            super(c.getTitle());
            this._panel = c;
        }

        private ConfigPanel getPanel() {
            return this._panel;
        }

        private boolean update() {
            boolean isValidUpdate = this._panel.update();
            if (!isValidUpdate) {
                Object[] nodes = this.getPath();
                TreePath path = new TreePath(nodes);
                ConfigFrame.access$300(ConfigFrame.this).expandPath(path);
                ConfigFrame.access$300(ConfigFrame.this).setSelectionPath(path);
                return false;
            }
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                boolean isValidUpdateChildren = ((PanelTreeNode)childNodes.nextElement()).update();
                if (isValidUpdateChildren) continue;
                return false;
            }
            return true;
        }

        public void resetToCurrent() {
            this._panel.resetToCurrent();
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                ((PanelTreeNode)childNodes.nextElement()).resetToCurrent();
            }
        }

        static boolean access$100(PanelTreeNode x0) {
            return x0.update();
        }

        static ConfigPanel access$200(PanelTreeNode x0) {
            return x0.getPanel();
        }
    }
}

