/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VectorOptionComponent<T>
extends OptionComponent<Vector<T>>
implements OptionConstants {
    protected JScrollPane _listScrollPane;
    protected JPanel _panel;
    protected JList _list;
    protected JPanel _buttonPanel;
    protected JButton _addButton;
    protected JButton _removeButton;
    protected DefaultListModel _listModel = new DefaultListModel();
    protected static final int NUM_ROWS = 5;
    protected static final int PIXELS_PER_ROW = 18;

    public VectorOptionComponent(VectorOption<T> opt, String text, Frame parent) {
        super(opt, text, parent);
        this._list = new JList(this._listModel);
        this._list.setSelectionMode(0);
        this.resetToCurrent();
        this._addButton = new JButton(this._getAddAction());
        this._removeButton = new JButton(new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ae) {
                if (!VectorOptionComponent.this._list.isSelectionEmpty()) {
                    int index = VectorOptionComponent.this._list.getSelectedIndex();
                    VectorOptionComponent.this._listModel.remove(index);
                    if (index == VectorOptionComponent.this._listModel.getSize()) {
                        if (index > 0) {
                            VectorOptionComponent.this._list.setSelectedIndex(index - 1);
                        }
                    } else {
                        VectorOptionComponent.this._list.setSelectedIndex(index);
                    }
                }
            }
        });
        this._buttonPanel = new JPanel();
        this._buttonPanel.add(this._addButton);
        this._buttonPanel.add(this._removeButton);
        this._listScrollPane = new JScrollPane(this._list, 20, 30);
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this._listScrollPane, "Center");
        this._panel.add((Component)this._buttonPanel, "South");
        this._listScrollPane.setPreferredSize(new Dimension(0, 90));
    }

    public VectorOptionComponent(VectorOption<T> opt, String text, Frame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._listScrollPane.setToolTipText(description);
        this._list.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        Vector<T> current = this.getValue();
        DrJava.getConfig().setSetting(this._option, current);
        this.resetToCurrent();
        return true;
    }

    public Vector<T> getValue() {
        Vector current = new Vector();
        for (int i = 0; i < this._listModel.getSize(); ++i) {
            Object element = this._listModel.getElementAt(i);
            current.add(element);
        }
        return current;
    }

    @Override
    public void setValue(Vector<T> value) {
        this._listModel.clear();
        for (int i = 0; i < value.size(); ++i) {
            this._listModel.addElement(value.elementAt(i));
        }
    }

    @Override
    public JComponent getComponent() {
        return this._panel;
    }

    protected abstract Action _getAddAction();

    @Override
    public void setValue(Object x0) {
        this.setValue((Vector)x0);
    }
}

