/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels.tree;

import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.tree.Block;
import edu.rice.cs.javalanglevels.tree.CatchBlock;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor;
import edu.rice.cs.javalanglevels.tree.JExpressionIFVisitor_void;
import edu.rice.cs.javalanglevels.tree.TabPrintWriter;
import edu.rice.cs.javalanglevels.tree.TryCatchStatement;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalTryCatchStatement
extends TryCatchStatement {
    public NormalTryCatchStatement(SourceInfo in_sourceInfo, Block in_tryBlock, CatchBlock[] in_catchBlocks) {
        super(in_sourceInfo, in_tryBlock, in_catchBlocks);
    }

    @Override
    public <RetType> RetType visit(JExpressionIFVisitor<RetType> visitor) {
        return visitor.forNormalTryCatchStatement(this);
    }

    @Override
    public void visit(JExpressionIFVisitor_void visitor) {
        visitor.forNormalTryCatchStatement(this);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.output(w);
        return w.toString();
    }

    public void output(Writer writer) {
        this.outputHelp(new TabPrintWriter(writer, 2));
    }

    @Override
    public void outputHelp(TabPrintWriter writer) {
        writer.print("NormalTryCatchStatement:");
        writer.indent();
        writer.startLine("");
        writer.print("sourceInfo = ");
        SourceInfo temp_sourceInfo = this.getSourceInfo();
        if (temp_sourceInfo == null) {
            writer.print("null");
        } else {
            writer.print(temp_sourceInfo);
        }
        writer.startLine("");
        writer.print("tryBlock = ");
        Block temp_tryBlock = this.getTryBlock();
        if (temp_tryBlock == null) {
            writer.print("null");
        } else {
            temp_tryBlock.outputHelp(writer);
        }
        writer.startLine("");
        writer.print("catchBlocks = ");
        writer.print("{");
        writer.indent();
        for (int i = 0; i < this.getCatchBlocks().length; ++i) {
            CatchBlock temp_catchBlocks = this.getCatchBlocks()[i];
            writer.startLine(new StringBuffer().append("#").append(i).append(": ").toString());
            if (temp_catchBlocks == null) {
                writer.print("null");
                continue;
            }
            temp_catchBlocks.outputHelp(writer);
        }
        writer.unindent();
        if (this.getCatchBlocks().length > 0) {
            writer.startLine("");
        }
        writer.print("}");
        writer.unindent();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass() || obj.hashCode() != this.hashCode()) {
            return false;
        }
        NormalTryCatchStatement casted = (NormalTryCatchStatement)obj;
        if (!this.getTryBlock().equals(casted.getTryBlock())) {
            return false;
        }
        if (this.getCatchBlocks().length != casted.getCatchBlocks().length) {
            return false;
        }
        for (int i = 0; i < this.getCatchBlocks().length; ++i) {
            if (this.getCatchBlocks()[i].equals(casted.getCatchBlocks()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int generateHashCode() {
        int code = this.getClass().hashCode();
        code ^= 0;
        code ^= this.getTryBlock().hashCode();
        for (int i = 0; i < this.getCatchBlocks().length; ++i) {
            code ^= this.getCatchBlocks()[i].hashCode();
        }
        return code;
    }
}

