/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.util.Pair;
import java.io.PrintWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringOps {
    public static String replace(String fullString, String toReplace, String replacement) {
        int index = 0;
        int fullStringLength = fullString.length();
        int toReplaceLength = toReplace.length();
        if (toReplaceLength > 0) {
            int pos;
            int replacementLength = replacement.length();
            while (index < fullStringLength && (pos = fullString.indexOf(toReplace, index)) >= 0) {
                StringBuffer buff = new StringBuffer(fullString.substring(0, pos));
                buff.append(replacement);
                buff.append(fullString.substring(pos + toReplaceLength, fullStringLength));
                index = pos + replacementLength;
                fullString = buff.toString();
                fullStringLength = fullString.length();
            }
        }
        return fullString;
    }

    public static String convertToLiteral(String s) {
        String output = s;
        output = StringOps.replace(output, "\\", "\\\\");
        output = StringOps.replace(output, "\"", "\\\"");
        output = StringOps.replace(output, "\t", "\\t");
        output = StringOps.replace(output, "\n", "\\n");
        return new StringBuffer().append("\"").append(output).append("\"").toString();
    }

    private static void _ensureStartBeforeEnd(int startRow, int startCol, int endRow, int endCol) {
        if (startRow > endRow) {
            throw new IllegalArgumentException(new StringBuffer().append("end row before start row: ").append(startRow).append(" > ").append(endRow).toString());
        }
        if (startRow == endRow && startCol > endCol) {
            throw new IllegalArgumentException(new StringBuffer().append("end before start: (").append(startRow).append(", ").append(startCol).append(") > (").append(endRow).append(", ").append(endCol).append(")").toString());
        }
    }

    private static void _ensureColInRow(String fullString, int col, int rowStartIndex) {
        int endOfLine = fullString.indexOf("\n", rowStartIndex);
        if (endOfLine == -1) {
            endOfLine = fullString.length();
        }
        if (col > endOfLine - rowStartIndex) {
            throw new IllegalArgumentException("the given column is past the end of its row");
        }
    }

    public static Pair<Integer, Integer> getOffsetAndLength(String fullString, int startRow, int startCol, int endRow, int endCol) {
        int linesSeen;
        StringOps._ensureStartBeforeEnd(startRow, startCol, endRow, endCol);
        int currentChar = 0;
        for (linesSeen = 1; startRow > linesSeen; ++linesSeen) {
            if ((currentChar = fullString.indexOf("\n", currentChar)) == -1) {
                throw new IllegalArgumentException("startRow is beyond the end of the string");
            }
            ++currentChar;
        }
        StringOps._ensureColInRow(fullString, startCol, currentChar);
        int offset = currentChar + startCol - 1;
        while (endRow > linesSeen) {
            if ((currentChar = fullString.indexOf("\n", currentChar)) == -1) {
                throw new IllegalArgumentException("endRow is beyond the end of the string");
            }
            ++currentChar;
            ++linesSeen;
        }
        StringOps._ensureColInRow(fullString, endCol, currentChar);
        int length = currentChar + endCol - offset;
        if (offset + length > fullString.length()) {
            throw new IllegalArgumentException("Given positions beyond the end of the string");
        }
        return new Pair<Integer, Integer>(new Integer(offset), new Integer(length));
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

