/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.sexp;

import edu.rice.cs.util.sexp.Atom;
import edu.rice.cs.util.sexp.SExpVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberAtom
implements Atom {
    private double _num;
    private boolean _hasDecimals;

    public NumberAtom(int num) {
        this._num = num;
        this._hasDecimals = false;
    }

    public NumberAtom(double num) {
        this._num = num;
        this._hasDecimals = num % 1.0 < 1.0E-12;
    }

    public boolean hasDecimals() {
        return this._hasDecimals;
    }

    public int intValue() {
        return (int)this._num;
    }

    public double doubleValue() {
        return this._num;
    }

    @Override
    public <Ret> Ret accept(SExpVisitor<Ret> v) {
        return v.forNumberAtom(this);
    }

    public String toString() {
        if (this._hasDecimals) {
            return new StringBuffer().append("").append(this.doubleValue()).toString();
        }
        return new StringBuffer().append("").append(this.intValue()).toString();
    }
}

