/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.swing.DefaultFileDisplayManager;
import edu.rice.cs.util.swing.FileDisplay;
import edu.rice.cs.util.swing.FileDisplayManager;
import edu.rice.cs.util.swing.FileSelectionEvent;
import edu.rice.cs.util.swing.FileSelectionListener;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;

public class DirectoryChooser
extends JPanel {
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    protected JTree _tree;
    protected FileDisplayManager _fdManager;
    protected DefaultMutableTreeNode _root;
    protected File _rootFile;
    protected File _defaultSelectedFile;
    protected boolean _allowMultiple;
    protected boolean _showHidden;
    protected boolean _showFiles;
    protected boolean _isEditable;
    protected boolean _embedded;
    protected int _finalResult;
    protected Set<File> _offLimits;
    protected Window _owner;
    protected boolean _ownerIsDialog;
    protected String _dialogTitle;
    private TreeExpansionListener _expansionListener;
    private Hashtable<FileSelectionListener, TreeSelectionListener> _fileSelectionListeners;
    private LinkedList<FileFilter> _choosableDirs;
    private LinkedList<FileFilter> _normalFileFilters;
    private Action _cancelAction;
    private boolean _treeIsGenerated;
    private boolean _forceTreeGenerate;
    private JScrollPane _scroller;
    private JPanel _topComponentPanel;
    private JLabel _topLabel;
    private JPanel _northPanel;
    private JPanel _newButtonPanel;
    private JButton _newFolderButton;
    private JButton _approveButton;
    private JButton _cancelButton;
    private JPanel _buttonPanel;
    private JPanel _accessoryPanel;
    private JPanel _southPanel;
    private GlassPane _glassPane;
    protected JComponent _accessory;
    protected JPopupMenu _treePopup;
    protected JMenuItem _collapseItem;
    protected JMenuItem _expandItem;
    protected JMenuItem _refreshItem;
    protected JMenuItem _renameItem;
    protected JMenuItem _deleteItem;
    protected JMenuItem _newFolderItem;
    protected JPopupMenu.Separator _popSep;
    protected String _approveText = "Open";
    protected String _cancelText = "Cancel";
    protected String _topLabelText = "Select a directory:";
    protected CellEditorListener _cellEditorListener = new CellEditorListener(){

        public void editingCanceled(ChangeEvent e) {
            CustomCellEditor cce = (CustomCellEditor)e.getSource();
            TreePath tp = cce.getCurrentPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            FileDisplay fd = (FileDisplay)node.getUserObject();
            if (fd.isNew()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                DirectoryChooser.this.getModel().removeNodeFromParent(node);
            }
        }

        public void editingStopped(ChangeEvent e) {
            CustomCellEditor cce = (CustomCellEditor)e.getSource();
            TreePath tp = cce.getCurrentPath();
            if (DirectoryChooser.this._tree.getRowForPath(tp) < 0) {
                return;
            }
            DirectoryChooser.this.renameFileForPath(cce.getFileBeforeEdit(), tp);
        }
    };
    private int _hourglassDepth = 0;
    protected Comparator<File> _fileComparator = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            boolean d2;
            boolean d1 = f1.isDirectory();
            if (!(d1 ^ (d2 = f2.isDirectory()))) {
                return f1.getName().compareToIgnoreCase(f2.getName());
            }
            if (d1) {
                return -1;
            }
            return 1;
        }

        @Override
        public int compare(Object x0, Object x1) {
            return this.compare((File)x0, (File)x1);
        }
    };

    public DirectoryChooser() {
        this((Frame)null, null, false, false);
    }

    public DirectoryChooser(Dialog owner) {
        this(owner, null, false, false);
    }

    public DirectoryChooser(Frame owner) {
        this(owner, null, false, false);
    }

    public DirectoryChooser(Dialog owner, boolean allowMultiple) {
        this(owner, null, allowMultiple, false);
    }

    public DirectoryChooser(Frame owner, boolean allowMultiple) {
        this(owner, null, allowMultiple, false);
    }

    public DirectoryChooser(Dialog owner, File root) {
        this(owner, root, false, false);
    }

    public DirectoryChooser(Frame owner, File root) {
        this(owner, root, false, false);
    }

    public DirectoryChooser(Dialog owner, File root, boolean allowMultiple, boolean showHidden) {
        this._ownerIsDialog = true;
        this._init(owner, root, allowMultiple, showHidden);
    }

    public DirectoryChooser(Frame owner, File root, boolean allowMultiple, boolean showHidden) {
        this._ownerIsDialog = false;
        this._init(owner, root, allowMultiple, showHidden);
    }

    private void _init(Window owner, File root, boolean allowMultiple, boolean showHidden) {
        File[] shellRoots;
        if (root != null && !root.isDirectory()) {
            root = root.getAbsoluteFile().getParentFile();
        }
        this._owner = owner;
        this._treeIsGenerated = false;
        this._forceTreeGenerate = true;
        this._embedded = false;
        this._rootFile = root;
        this._defaultSelectedFile = null;
        this._allowMultiple = allowMultiple;
        this._showHidden = showHidden;
        this._finalResult = -1;
        this._choosableDirs = new LinkedList();
        this._normalFileFilters = new LinkedList();
        this._fileSelectionListeners = new Hashtable();
        this._fdManager = new DefaultFileDisplayManager();
        this._glassPane = new GlassPane();
        this._glassPane.setVisible(false);
        this._offLimits = new HashSet<File>();
        File[] arr$ = shellRoots = (File[])ShellFolder.get("fileChooserComboBoxFolders");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File f = arr$[i$];
            this._offLimits.add(f);
        }
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 16;
        this._topComponentPanel = new JPanel(layout);
        this._topComponentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this._topLabel = new JLabel(this._topLabelText);
        layout.setConstraints(this._topLabel, c);
        this._topComponentPanel.add(this._topLabel);
        this._northPanel = new JPanel(new BorderLayout());
        this._northPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this._northPanel.add((Component)this._topComponentPanel, "West");
        this._scroller = new JScrollPane();
        Border innerBorder = BorderFactory.createBevelBorder(1);
        this._scroller.setBorder(innerBorder);
        this._accessoryPanel = new JPanel(new BorderLayout());
        this._accessoryPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this._approveButton = new JButton(this._approveText);
        this._approveButton.setEnabled(false);
        this._cancelButton = new JButton(this._cancelText);
        JPanel _okCancelPanel = new JPanel(new FlowLayout());
        _okCancelPanel.add(this._approveButton);
        _okCancelPanel.add(this._cancelButton);
        this._newFolderButton = new JButton("Make New Folder");
        this._newFolderButton.setEnabled(false);
        this._newFolderButton.setMargin(new Insets(2, 2, 2, 2));
        this._newFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this.startCreateNewDirectory();
            }
        });
        this._newButtonPanel = new JPanel();
        this._newButtonPanel.add(this._newFolderButton);
        this._newButtonPanel.setVisible(false);
        this._buttonPanel = new JPanel(new BorderLayout());
        this._buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._buttonPanel.add((Component)_okCancelPanel, "East");
        this._buttonPanel.add((Component)this._newButtonPanel, "West");
        this._southPanel = new JPanel(new BorderLayout());
        this._southPanel.add((Component)this._accessoryPanel, "Center");
        this._southPanel.add((Component)this._buttonPanel, "South");
        this.setRootFile(this._rootFile);
        this._treePopup = new JPopupMenu();
        this._collapseItem = new JMenuItem("Collapse");
        this._treePopup.add(this._collapseItem);
        this._collapseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this._tree.collapsePath(DirectoryChooser.this._tree.getSelectionPath());
            }
        });
        this._expandItem = new JMenuItem("Expand");
        this._treePopup.add(this._expandItem);
        this._expandItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this._tree.expandPath(DirectoryChooser.this._tree.getSelectionPath());
            }
        });
        this._treePopup.addSeparator();
        this._popSep = (JPopupMenu.Separator)this._treePopup.getComponent(2);
        this._refreshItem = new JMenuItem("Refresh");
        this._treePopup.add(this._refreshItem);
        this._refreshItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this.startRefreshNode();
            }
        });
        this._renameItem = new JMenuItem("Rename");
        this._treePopup.add(this._renameItem);
        this._renameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this.startRename();
            }
        });
        this._deleteItem = new JMenuItem("Delete");
        this._treePopup.add(this._deleteItem);
        this._deleteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this.startDelete();
            }
        });
        this._newFolderItem = new JMenuItem("New Folder");
        this._treePopup.add(this._newFolderItem);
        this._newFolderItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this.startCreateNewDirectory();
            }
        });
        this.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this._scroller, "Center");
        this.setBackground(Color.blue);
    }

    protected void generateDirTree() {
        this._root = this.makeFileNode(this._rootFile);
        this._tree = new CustomJTree(this._root);
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                boolean enable;
                boolean canChoose = enable = DirectoryChooser.this._tree.getSelectionCount() > 0;
                File f = DirectoryChooser.this.getFileForTreePath(DirectoryChooser.this._tree.getSelectionPath());
                Iterator i$ = DirectoryChooser.access$000(DirectoryChooser.this).iterator();
                while (i$.hasNext()) {
                    FileFilter filter = (FileFilter)i$.next();
                    canChoose &= f != null && filter.accept(f);
                }
                DirectoryChooser.access$100(DirectoryChooser.this).setEnabled(canChoose && DirectoryChooser.this.isEnabled());
                boolean canSubDir = enable && f.isDirectory() && f.canWrite();
                DirectoryChooser.access$200(DirectoryChooser.this).setEnabled(canSubDir && DirectoryChooser.this.isEnabled());
            }
        });
        Iterator<TreeSelectionListener> i$ = this._fileSelectionListeners.values().iterator();
        while (i$.hasNext()) {
            TreeSelectionListener tsl = i$.next();
            this._tree.addTreeSelectionListener(tsl);
        }
        this._expansionListener = new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                DirectoryChooser.this.ensureHasChildren(node);
            }
        };
        this._tree.addTreeExpansionListener(this._expansionListener);
        this._tree.addMouseListener(new RightClickMouseAdapter(){

            protected void _popupAction(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath tp = DirectoryChooser.this._tree.getPathForLocation(e.getX(), e.getY());
                    if (tp == null) {
                        return;
                    }
                    boolean isExp = DirectoryChooser.this._tree.isExpanded(tp);
                    DirectoryChooser.this._collapseItem.setVisible(isExp);
                    DirectoryChooser.this._expandItem.setVisible(!isExp);
                    boolean canSubDir = false;
                    boolean canAlter = false;
                    try {
                        File f = DirectoryChooser.this.getFileForTreePath(tp);
                        boolean canWrite = f.canWrite();
                        canSubDir = canWrite && f.isDirectory();
                        canAlter = canWrite && !DirectoryChooser.this._offLimits.contains(f);
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                    DirectoryChooser.this._renameItem.setEnabled(canAlter && DirectoryChooser.this.isEnabled());
                    DirectoryChooser.this._deleteItem.setEnabled(canAlter && DirectoryChooser.this.isEnabled());
                    DirectoryChooser.this._newFolderItem.setEnabled(canSubDir && DirectoryChooser.this.isEnabled());
                    DirectoryChooser.access$200(DirectoryChooser.this).setEnabled(canSubDir && DirectoryChooser.this.isEnabled());
                    DirectoryChooser.this._tree.setSelectionPath(tp);
                    DirectoryChooser.this._treePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        CustomTreeCellRenderer _cellRenderer = new CustomTreeCellRenderer(null);
        this._tree.setCellRenderer(_cellRenderer);
        FileTextField textField = new FileTextField(null);
        CustomCellEditor cce = new CustomCellEditor(textField);
        CustomTreeCellEditor _cellEditor = new CustomTreeCellEditor(this._tree, _cellRenderer, cce);
        cce.addCellEditorListener(this._cellEditorListener);
        this._tree.setCellEditor(_cellEditor);
        this._tree.setEditable(this._isEditable);
        this._tree.setRowHeight(18);
        if (this._allowMultiple) {
            this._tree.getSelectionModel().setSelectionMode(4);
        } else {
            this._tree.getSelectionModel().setSelectionMode(1);
        }
        this._tree.collapseRow(0);
        this._tree.expandRow(0);
        this._scroller.setViewportView(this._tree);
        this._tree.setEnabled(this.isEnabled());
        this._scroller.setEnabled(this.isEnabled());
        this._scroller.getHorizontalScrollBar().setEnabled(this.isEnabled());
        this._scroller.getVerticalScrollBar().setEnabled(this.isEnabled());
        this._treeIsGenerated = true;
        this._forceTreeGenerate = false;
        this.ensureHasChildren(this._root);
        this.updateTreeSelectionPath();
    }

    protected JDialog createDialog() {
        ActionListener al;
        int i$;
        String title = null;
        title = this._dialogTitle != null ? this._dialogTitle : "Choose Directory";
        final JDialog dialog = this._ownerIsDialog ? new JDialog((Dialog)this._owner, title, true) : new JDialog((Frame)this._owner, title, true);
        Container cp = dialog.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel spanel = new JPanel(new BorderLayout());
        spanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        spanel.add((Component)this._scroller, "Center");
        ActionListener[] arr$ = this._approveButton.getActionListeners();
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            al = arr$[i$];
            this._approveButton.removeActionListener(al);
        }
        this._approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this._tree.cancelEditing();
                if (DirectoryChooser.this._tree.getSelectionCount() > 0) {
                    DirectoryChooser.this._finalResult = 0;
                }
                dialog.setVisible(false);
            }
        });
        arr$ = this._cancelButton.getActionListeners();
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            al = arr$[i$];
            this._cancelButton.removeActionListener(al);
        }
        this._cancelAction = new AbstractAction(this._cancelText){

            public void actionPerformed(ActionEvent e) {
                DirectoryChooser.this._finalResult = 1;
                DirectoryChooser.this._tree.cancelEditing();
                dialog.setVisible(false);
            }
        };
        this._cancelButton.setAction(this._cancelAction);
        this._cancelButton.setEnabled(this.isEnabled());
        String key = "dc_cancel";
        dialog.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(27, 0), key);
        dialog.getRootPane().getActionMap().put(key, this._cancelAction);
        dialog.getRootPane().setDefaultButton(this._approveButton);
        cp.add((Component)this._northPanel, "North");
        cp.add((Component)spanel, "Center");
        cp.add((Component)this._southPanel, "South");
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DirectoryChooser.this._finalResult = 1;
            }
        });
        dialog.setGlassPane(this._glassPane);
        dialog.setSize(330, 400);
        dialog.setLocationRelativeTo(this._owner);
        return dialog;
    }

    public void addChoosableFileFilter(FileFilter filter) {
        if (filter != null) {
            this._choosableDirs.add(filter);
        }
    }

    public void removeChoosableFileFilter(FileFilter filter) {
        if (filter != null) {
            this._choosableDirs.remove(filter);
        }
    }

    public void clearChoosableFileFilters() {
        this._choosableDirs.clear();
    }

    public void addFileFilter(FileFilter filter) {
        if (filter != null) {
            this._normalFileFilters.add(filter);
        }
    }

    public void removeFileFilter(FileFilter filter) {
        if (filter != null) {
            this._normalFileFilters.remove(filter);
        }
    }

    public void clearFileFilters() {
        this._normalFileFilters.clear();
    }

    public void addFileSelectionListener(final FileSelectionListener l) {
        TreeSelectionListener tsl = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                int n = e.getPaths().length;
                File[] changed = new File[n];
                boolean[] areNew = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    changed[i] = DirectoryChooser.this.getFileForTreePath(e.getPaths()[i]);
                    areNew[i] = e.isAddedPath(i);
                }
                File newLead = DirectoryChooser.this.getFileForTreePath(e.getNewLeadSelectionPath());
                File oldLead = DirectoryChooser.this.getFileForTreePath(e.getOldLeadSelectionPath());
                FileSelectionEvent fse = new FileSelectionEvent((Object)DirectoryChooser.this, changed, areNew, newLead, oldLead);
                l.valueChanged(fse);
            }
        };
        if (this._treeIsGenerated) {
            this._tree.addTreeSelectionListener(tsl);
        }
        this._fileSelectionListeners.put(l, tsl);
    }

    public void removeFileSelectionListener(FileSelectionListener l) {
        if (this._treeIsGenerated) {
            TreeSelectionListener tsl = this._fileSelectionListeners.get(l);
            this._tree.removeTreeSelectionListener(tsl);
        } else {
            this._forceTreeGenerate = true;
        }
        this._fileSelectionListeners.remove(l);
    }

    public void clearFileSelectionListener() {
        if (this._treeIsGenerated) {
            Iterator<TreeSelectionListener> i$ = this._fileSelectionListeners.values().iterator();
            while (i$.hasNext()) {
                TreeSelectionListener tsl = i$.next();
                this._tree.removeTreeSelectionListener(tsl);
            }
        } else {
            this._forceTreeGenerate = true;
        }
        this._fileSelectionListeners.clear();
    }

    public File getRootFile() {
        return this._rootFile;
    }

    public void setAllowMultipleSelection(boolean allow) {
        this.setMultiSelectionEnabled(allow);
    }

    public void setMultiSelectionEnabled(boolean allow) {
        this._allowMultiple = allow;
        if (this._treeIsGenerated) {
            if (this._allowMultiple) {
                this._tree.getSelectionModel().setSelectionMode(4);
            } else {
                this._tree.getSelectionModel().setSelectionMode(1);
            }
        }
    }

    public void setRootFile(File root) {
        if (root == null) {
            File[] roots = (File[])ShellFolder.get("fileChooserComboBoxFolders");
            if (roots != null && roots.length > 0) {
                this._rootFile = roots[0];
            }
        } else if (root.exists()) {
            this._rootFile = this.formatFile(root);
        } else {
            throw new IllegalArgumentException("The proposed root does not exist");
        }
        this.treeShouldBeRegenerated();
    }

    public boolean setSelectedDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        this._defaultSelectedFile = dir;
        return this.updateTreeSelectionPath();
    }

    public boolean setSelectedFile(File f) {
        if (f == null) {
            return false;
        }
        this._defaultSelectedFile = f;
        return this.updateTreeSelectionPath();
    }

    public void setFileDisplayManager(FileDisplayManager fdm) {
        if (fdm != this._fdManager) {
            this.treeShouldBeRegenerated();
            this._fdManager = fdm;
        }
    }

    public void setShowHiddenDirectories(boolean show) {
        if (this._showHidden != show) {
            this.treeShouldBeRegenerated();
            this._showHidden = show;
        }
    }

    public void setShowFiles(boolean show) {
        if (this._showFiles != show) {
            this.treeShouldBeRegenerated();
            this._showFiles = show;
        }
    }

    public boolean getShowFiles() {
        return this._showFiles;
    }

    public void setEditable(boolean editable) {
        this._isEditable = editable;
        if (this._treeIsGenerated) {
            this._tree.setEditable(editable);
        }
        this._newButtonPanel.setVisible(editable);
        this._popSep.setVisible(editable);
        this._newFolderItem.setVisible(editable);
        this._deleteItem.setVisible(editable);
        this._renameItem.setVisible(editable);
    }

    public void setApproveButtonText(String text) {
        this._approveText = text;
        this._approveButton.setText(text);
    }

    public void setTopMessage(String msg) {
        this._topLabelText = msg;
        this._topLabel.setText(msg);
    }

    public void setTopComponent(JComponent comp) {
        this._topComponentPanel.removeAll();
        if (comp == null) {
            this._topComponentPanel.add(this._topLabel);
        } else {
            this._topComponentPanel.add(comp);
        }
    }

    public void setAccessory(JComponent comp) {
        if (this._accessory != null) {
            this._accessoryPanel.remove(this._accessory);
        }
        this._accessory = comp;
        this._accessory.setEnabled(this.isEnabled());
        this._accessoryPanel.add((Component)comp, "Center");
    }

    public JComponent getAccessory() {
        return this._accessory;
    }

    public void setDialogTitle(String txt) {
        this._dialogTitle = txt;
    }

    public int showDialog(File initialSelection) {
        if (this._embedded) {
            return -1;
        }
        if (initialSelection != null) {
            this._defaultSelectedFile = initialSelection;
        }
        if (!this._treeIsGenerated || this._forceTreeGenerate) {
            this.generateDirTree();
        } else {
            this.collapseAll();
            this.updateTreeSelectionPath();
        }
        boolean enable = this._tree.getSelectionCount() > 0;
        JDialog dialog = this.createDialog();
        this._approveButton.setEnabled(enable && this.isEnabled());
        this._newFolderButton.setEnabled(enable && this.isEnabled());
        dialog.setVisible(true);
        int res = this._finalResult;
        this._finalResult = -1;
        return res;
    }

    public int showDialog() {
        return this.showDialog(null);
    }

    public File[] getSelectedDirectories() {
        if (!this._treeIsGenerated) {
            return new File[0];
        }
        TreePath[] sels = this._tree.getSelectionPaths();
        if (sels == null) {
            return new File[0];
        }
        Vector<File> v = new Vector<File>();
        TreePath[] arr$ = sels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TreePath tp = arr$[i$];
            v.add(this.getFileForTreePath(tp));
        }
        return v.toArray(new File[v.size()]);
    }

    public File getSelectedDirectory() {
        if (!this._treeIsGenerated) {
            return null;
        }
        return this.getFileForTreePath(this._tree.getSelectionPath());
    }

    public boolean startCreateNewDirectory() {
        if (!this._treeIsGenerated) {
            return false;
        }
        TreePath tp = this._tree.getSelectionPath();
        if (tp != null && this._isEditable && this._newFolderItem.isEnabled()) {
            this.launchCreateNewDirectory(tp);
            return true;
        }
        return false;
    }

    public boolean startRename() {
        if (!this._treeIsGenerated) {
            return false;
        }
        TreePath tp = this._tree.getSelectionPath();
        if (tp != null && this._isEditable && this._renameItem.isEnabled()) {
            this._tree.startEditingAtPath(tp);
            return true;
        }
        return false;
    }

    public boolean startDelete() {
        if (!this._treeIsGenerated) {
            return false;
        }
        TreePath tp = this._tree.getSelectionPath();
        if (tp != null && this._isEditable && this._deleteItem.isEnabled()) {
            return this.tryToDeletePath(tp);
        }
        return false;
    }

    public boolean startRefreshNode() {
        if (!this._treeIsGenerated) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node != null) {
            this.refreshNode(node);
            return true;
        }
        return false;
    }

    public void refreshTree() {
        if (!this._treeIsGenerated) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        if (this._rootFile.exists()) {
            this.refreshNode(root);
        } else {
            this.setRootFile(null);
        }
    }

    private File refreshNode(DefaultMutableTreeNode node) {
        if (node instanceof EmptyTreeNode) {
            return null;
        }
        File f = ((FileDisplay)node.getUserObject()).getFile();
        if (!f.exists()) {
            return null;
        }
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof EmptyTreeNode) {
            return f;
        }
        Enumeration<TreeNode> e = node.children();
        HashSet<File> set = new HashSet<File>();
        LinkedList<DefaultMutableTreeNode> nodesToRemove = new LinkedList<DefaultMutableTreeNode>();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (this.nodeShouldBeRemoved(n)) {
                nodesToRemove.add(n);
                continue;
            }
            set.add(this.refreshNode(n));
        }
        Iterator i$ = nodesToRemove.iterator();
        while (i$.hasNext()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)i$.next();
            this.getModel().removeNodeFromParent(n);
        }
        Object[] childFiles = f.listFiles();
        if (childFiles.length > node.getChildCount()) {
            Arrays.sort(childFiles);
            int j = 0;
            for (int i = 0; i < childFiles.length; ++i) {
                if (!this.shouldDisplay((File)childFiles[i])) continue;
                if (!set.contains(childFiles[i])) {
                    this.getModel().insertNodeInto(this.makeFileNode((File)childFiles[i]), node, j);
                }
                ++j;
            }
        }
        return f;
    }

    private boolean nodeShouldBeRemoved(DefaultMutableTreeNode node) {
        Object dat = node.getUserObject();
        return dat instanceof FileDisplay && !((FileDisplay)dat).getFile().exists();
    }

    public void addNotify() {
        super.addNotify();
        this._embedded = true;
        this.generateDirTree();
    }

    public void removeNotify() {
        super.removeNotify();
        this._embedded = false;
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this._treeIsGenerated) {
            this._tree.setEnabled(enable);
        }
        this._scroller.setEnabled(enable);
        this._scroller.getHorizontalScrollBar().setEnabled(enable);
        this._scroller.getVerticalScrollBar().setEnabled(enable);
        this._newFolderButton.setEnabled(enable);
        this._approveButton.setEnabled(enable);
        this._cancelButton.setEnabled(enable);
        this._expandItem.setEnabled(enable);
        this._collapseItem.setEnabled(enable);
        this._newFolderItem.setEnabled(enable);
        this._deleteItem.setEnabled(enable);
        this._renameItem.setEnabled(enable);
        this._accessory.setEnabled(enable);
    }

    protected synchronized void hourglassOn() {
        ++this._hourglassDepth;
        this._glassPane.setVisible(true);
        if (this._treeIsGenerated) {
            this._tree.setEnabled(false);
        }
    }

    protected synchronized void hourglassOff() {
        --this._hourglassDepth;
        if (this._hourglassDepth <= 0) {
            this._glassPane.setVisible(false);
            if (this._treeIsGenerated) {
                this._tree.setEnabled(this.isEnabled());
            }
        }
    }

    protected void treeShouldBeRegenerated() {
        if (this._treeIsGenerated) {
            this.generateDirTree();
        } else {
            this._forceTreeGenerate = true;
        }
    }

    protected File getFileForTreeNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        Object o = node.getUserObject();
        if (o instanceof FileDisplay) {
            return ((FileDisplay)o).getFile();
        }
        if (o instanceof String) {
            return null;
        }
        throw new IllegalArgumentException("The tree node didn't have a file display: " + node);
    }

    protected File getFileForTreePath(TreePath tp) {
        if (tp == null) {
            return null;
        }
        DefaultMutableTreeNode comp = (DefaultMutableTreeNode)tp.getLastPathComponent();
        if (comp instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = comp;
            return this.getFileForTreeNode(node);
        }
        throw new IllegalArgumentException("The tree path does not yeild a mutable tree node: " + tp);
    }

    protected File formatFile(File f) {
        try {
            return ShellFolder.getShellFolder(f);
        }
        catch (FileNotFoundException fnfe) {
            try {
                return f.getCanonicalFile();
            }
            catch (IOException ioe) {
                return f.getAbsoluteFile();
            }
        }
    }

    protected void collapseAll() {
        if (!this._treeIsGenerated) {
            return;
        }
        int n = this._tree.getRowCount();
        for (int i = 0; i < n; ++i) {
            this._tree.collapseRow(n);
        }
    }

    protected DefaultMutableTreeNode findMatchingChild(DefaultMutableTreeNode node, File theFile) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            try {
                File f = this.getFileForTreeNode(child);
                if (f == null || !f.equals(theFile)) continue;
                return child;
            }
            catch (IllegalArgumentException iae) {
            }
        }
        return null;
    }

    protected boolean updateTreeSelectionPath() {
        if (!this._treeIsGenerated || this._defaultSelectedFile == null) {
            return false;
        }
        File dir = this._defaultSelectedFile;
        LinkedList<File> path = new LinkedList<File>();
        File tmp = this.formatFile(dir);
        do {
            path.addFirst(tmp);
        } while ((tmp = tmp.getParentFile()) != null);
        HashSet<File> rootSet = new HashSet<File>();
        tmp = this._rootFile;
        do {
            rootSet.add(tmp);
        } while ((tmp = tmp.getParentFile()) != null);
        ListIterator it = path.listIterator();
        while (it.hasNext()) {
            tmp = (File)it.next();
            if (!rootSet.contains(tmp)) continue;
            it.remove();
        }
        DefaultMutableTreeNode currNode = this._root;
        Iterator i$ = path.iterator();
        while (i$.hasNext()) {
            File currFile = (File)i$.next();
            DefaultMutableTreeNode n = this.findMatchingChild(currNode, currFile);
            if (n == null) {
                this.ensureHasChildren(currNode);
            }
            if ((n = this.findMatchingChild(currNode, currFile)) == null) {
                return false;
            }
            currNode = n;
        }
        TreePath tp = new TreePath(currNode.getPath());
        this._tree.setSelectionPath(tp);
        Rectangle bounds = this._tree.getPathBounds(tp);
        int x = 0;
        int y = bounds.y - 100;
        int w = bounds.width + bounds.x;
        int h = bounds.height + 200;
        Rectangle scrollBounds = new Rectangle(x, y, w, h);
        this._tree.makeVisible(tp);
        this._tree.scrollRectToVisible(scrollBounds);
        this._tree.repaint();
        return true;
    }

    protected void ensureHasChildren(DefaultMutableTreeNode node) {
        if (!this._treeIsGenerated) {
            return;
        }
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof EmptyTreeNode) {
            this.hourglassOn();
            File parentFile = this.getFileForTreeNode(node);
            node.removeAllChildren();
            File[] childFiles = parentFile.listFiles();
            if (childFiles != null) {
                Arrays.sort(childFiles, this._fileComparator);
                File[] arr$ = childFiles;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    File f = arr$[i$];
                    if (!this.shouldDisplay(f)) continue;
                    DefaultMutableTreeNode n = this.makeFileNode(f);
                    this.addNode(n, node);
                }
            }
            this.getModel().nodeStructureChanged(node);
            this.hourglassOff();
        }
    }

    protected boolean tryToDeletePath(TreePath tp) {
        if (!this._treeIsGenerated) {
            return false;
        }
        File f = this.getFileForTreePath(tp);
        String type = f.isDirectory() ? "directory" : "file";
        String msg = "Are you sure you want to delete this " + type + "?";
        int res = JOptionPane.showConfirmDialog(this, msg, "Delete " + type + "?", 0);
        if (res != 0) {
            return false;
        }
        boolean couldDelete = false;
        try {
            couldDelete = f.delete();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (couldDelete) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
            TreeNode parent = node.getParent();
            node.removeFromParent();
            this.getModel().nodeStructureChanged(parent);
            return true;
        }
        String errMsg = f.isDirectory() ? "The directory was unable to be deleted.\nDirectories may only be deleted if they are\nempty and if there is sufficient access to\nto the directory." : "The file was unable to be deleted.\nMake sure you have sufficient permissions.";
        JOptionPane.showMessageDialog(this, errMsg, "Unable to delete", 2);
        return false;
    }

    protected boolean shouldDisplay(File f) {
        return (f.isDirectory() || this._showFiles && this.allowFile(f)) && (this._showHidden || !f.isHidden());
    }

    protected boolean allowFile(File f) {
        try {
            Iterator i$ = this._normalFileFilters.iterator();
            while (i$.hasNext()) {
                FileFilter ff = (FileFilter)i$.next();
                if (ff.accept(f)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void launchCreateNewDirectory(TreePath tp) {
        if (!this._treeIsGenerated) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tp.getLastPathComponent();
        File f = this.getFileForTreeNode(parent);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this._fdManager.makeNewFolderDisplay(f));
        this.ensureHasChildren(parent);
        this.getModel().insertNodeInto(newNode, parent, 0);
        TreePath newPath = new TreePath(newNode.getPath());
        this._tree.startEditingAtPath(newPath);
    }

    protected void renameFileForPath(File prev, TreePath tp) {
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)tp.getLastPathComponent();
        File f = this.getFileForTreeNode(top);
        if (prev == null) {
            try {
                f.mkdir();
            }
            catch (SecurityException se) {
                top.removeFromParent();
            }
        } else {
            if (prev.equals(f)) {
                return;
            }
            if (f.equals(prev.getParentFile())) {
                top.setUserObject(this._fdManager.makeFileDisplay(prev));
            } else {
                try {
                    prev.renameTo(f);
                }
                catch (SecurityException se) {
                    top.setUserObject(this._fdManager.makeFileDisplay(prev));
                }
            }
        }
        this.resortNode(top);
        this._fdManager.update();
        this.updateChildFiles(top);
    }

    protected void updateChildFiles(DefaultMutableTreeNode parent) {
        if (parent.getChildCount() == 1 && parent.getChildAt(0) instanceof EmptyTreeNode) {
            return;
        }
        File parentFile = ((FileDisplay)parent.getUserObject()).getFile();
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            File oldFile = this.getFileForTreeNode(child);
            File newFile = new File(parentFile, oldFile.getName());
            child.setUserObject(this._fdManager.makeFileDisplay(newFile));
            this.updateChildFiles(child);
        }
    }

    protected void resortNode(DefaultMutableTreeNode node) {
        if (!this._treeIsGenerated) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        node.removeFromParent();
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            if (node.toString().compareTo(child.toString()) >= 0) continue;
            int idx = parent.getIndex(child);
            this.getModel().insertNodeInto(node, parent, idx);
            return;
        }
        this.addNode(node, parent);
    }

    protected DefaultMutableTreeNode makeFileNode(File f) {
        DefaultMutableTreeNode n = new DefaultMutableTreeNode(this._fdManager.makeFileDisplay(f));
        if (f.isDirectory()) {
            n.add(new EmptyTreeNode());
        }
        return n;
    }

    protected DefaultTreeModel getModel() {
        return (DefaultTreeModel)this._tree.getModel();
    }

    protected void addNode(DefaultMutableTreeNode child, DefaultMutableTreeNode parent) {
        this.getModel().insertNodeInto(child, parent, parent.getChildCount());
    }

    public static void main(String[] args) {
        try {
            String lafName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            LookAndFeel laf = (LookAndFeel)Class.forName(lafName).newInstance();
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.out.println("unable to set windows laf");
        }
        File dir = null;
        if (args.length > 0) {
            dir = new File(args[0]);
        }
        final DirectoryChooser d = new DirectoryChooser((Frame)null, dir);
        d.setShowFiles(true);
        final JCheckBox cb = new JCheckBox("Enable edits");
        cb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                d.setEditable(cb.isSelected());
            }
        });
        cb.setSelected(true);
        d.setAccessory(cb);
        d.setTopComponent(new JLabel("Select a folder", UIManager.getIcon("OptionPane.informationIcon"), 2));
        d.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                try {
                    return !f.isDirectory();
                }
                catch (Exception e) {
                    System.out.println(f);
                    throw new RuntimeException(e);
                }
            }

            public String getDescription() {
                return "Only select the file whose name is foo";
            }
        });
        d.addFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String name = f.getName();
                int idx = name.lastIndexOf(".");
                return name.substring(idx + 1).equalsIgnoreCase("java");
            }

            public String getDescription() {
                return "Only allow java files";
            }
        });
        d.setSelectedDirectory(new File("/home/jlugo/junk/elechw6/newfolder2"));
        d.addFileSelectionListener(new FileSelectionListener(){

            public void valueChanged(FileSelectionEvent e) {
                System.out.println("Selected(" + (e.isAddedFile() ? "+" : "-") + ") " + e.getFile());
            }
        });
        int res = d.showDialog();
        System.exit(1);
    }

    static LinkedList access$000(DirectoryChooser x0) {
        return x0._choosableDirs;
    }

    static JButton access$100(DirectoryChooser x0) {
        return x0._approveButton;
    }

    static JButton access$200(DirectoryChooser x0) {
        return x0._newFolderButton;
    }

    static class EmptyTreeNode
    extends DefaultMutableTreeNode {
        public EmptyTreeNode() {
            super("[empty]");
        }
    }

    private static class GlassPane
    extends JComponent {
        public GlassPane() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private static class FileTextField
    extends JTextField {
        File _parent;

        private FileTextField() {
        }

        public void setFile(FileDisplay fd) {
            if (fd.isNew()) {
                this._parent = fd.getFile();
                this.setText(fd.toString());
            } else {
                File f = fd.getFile();
                this._parent = f.getParentFile();
                this.setText(f.getName());
            }
        }

        public void setFile(File f) {
            this._parent = f.getParentFile();
            this.setText(f.getName());
        }

        public void noFileAvailable(Object value) {
            this._parent = null;
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
            }
        }

        public File getFile() {
            if (this._parent == null) {
                return null;
            }
            return new File(this._parent, this.getText());
        }

        FileTextField(1 x0) {
            this();
        }
    }

    private static class CustomJTree
    extends JTree {
        public CustomJTree(TreeNode node) {
            super(node);
        }

        public boolean isPathEditable(TreePath path) {
            if (!this.isEditable()) {
                return false;
            }
            try {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
                FileDisplay fd = (FileDisplay)n.getUserObject();
                return fd.isNew() || fd.getFile().canWrite();
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private class CustomCellEditor
    extends DefaultCellEditor {
        TreePath _currentPath;
        File _currentFile;

        public CustomCellEditor(final FileTextField textField) {
            super(textField);
            this._currentPath = null;
            this._currentFile = null;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    if (value != null && value instanceof FileDisplay) {
                        FileDisplay fd = (FileDisplay)value;
                        CustomCellEditor.this._currentFile = fd.isNew() ? null : fd.getFile();
                        textField.setFile(fd);
                    } else {
                        CustomCellEditor.this._currentFile = null;
                        textField.noFileAvailable(value);
                    }
                }

                public Object getCellEditorValue() {
                    File f = textField.getFile();
                    if (f == null) {
                        return textField.getText();
                    }
                    return DirectoryChooser.this._fdManager.makeFileDisplay(f);
                }
            };
            textField.addActionListener(this.delegate);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this._currentPath = tree.getPathForRow(row);
            Object userValue = value;
            if (value instanceof DefaultMutableTreeNode) {
                userValue = ((DefaultMutableTreeNode)value).getUserObject();
            }
            this.delegate.setValue(userValue);
            return this.editorComponent;
        }

        public TreePath getCurrentPath() {
            return this._currentPath;
        }

        public File getFileBeforeEdit() {
            return this._currentFile;
        }
    }

    private class CustomTreeCellEditor
    extends DefaultTreeCellEditor {
        public CustomTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
            super(tree, renderer, editor);
        }

        protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            File f = null;
            try {
                f = DirectoryChooser.this.getFileForTreeNode((DefaultMutableTreeNode)value);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.renderer != null) {
                this.editingIcon = f != null ? DirectoryChooser.this._fdManager.getIcon(f) : this.renderer.getOpenIcon();
                this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
            } else {
                this.editingIcon = null;
                this.offset = 0;
            }
        }
    }

    private class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private WeakHashMap<File, Icon> _iconCache = new WeakHashMap();

        private CustomTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            File f = DirectoryChooser.this.getFileForTreeNode(node);
            Icon ico = this._iconCache.get(f);
            if (ico == null) {
                ico = DirectoryChooser.this._fdManager.getIcon(f);
                this._iconCache.put(f, ico);
            }
            this.setIcon(ico);
            return this;
        }

        CustomTreeCellRenderer(1 x1) {
            this();
        }
    }
}

