/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.util.AmbiguousFieldException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoUtilities {
    static /* synthetic */ Class class$java$lang$Object;

    public static ConstructorInfo lookupConstructor(ClassInfo cl, ClassInfo[] ac) throws NoSuchMethodException {
        List<ConstructorInfo> ms = ClassInfoUtilities.getConstructors(cl, ac.length);
        LinkedList<ConstructorInfo> mm = new LinkedList<ConstructorInfo>();
        for (ConstructorInfo m : ms) {
            if (!ClassInfoUtilities.hasCompatibleSignatures(m.getParameterTypes(), ac)) continue;
            mm.add(m);
        }
        if (mm.isEmpty()) {
            throw new NoSuchMethodException(new StringBuffer().append(cl.getName()).append(" constructor").toString());
        }
        Iterator<ConstructorInfo> it = mm.iterator();
        ConstructorInfo result = it.next();
        while (it.hasNext()) {
            result = ClassInfoUtilities.selectTheMostSpecificConstructor(result, it.next());
        }
        return result;
    }

    public static boolean isAssignableFrom(ClassInfo c1, ClassInfo c2) {
        if (c1.isPrimitive()) {
            if (!c1.equals(c2)) {
                if (c2 == null || !c2.isPrimitive()) {
                    return false;
                }
                Class<?> cl1 = c1.getJavaClass();
                Class<?> cl2 = c2.getJavaClass();
                if (cl1 == Short.TYPE) {
                    return cl2 == Byte.TYPE;
                }
                if (cl1 == Integer.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Character.TYPE;
                }
                if (cl1 == Long.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Integer.TYPE;
                }
                if (cl1 == Float.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Integer.TYPE || cl2 == Float.TYPE;
                }
                if (cl1 == Double.TYPE) {
                    return cl2 == Byte.TYPE || cl2 == Short.TYPE || cl2 == Integer.TYPE || cl2 == Float.TYPE || cl2 == Double.TYPE;
                }
                return false;
            }
            return true;
        }
        if (c2 == null || c1.equals(c2)) {
            return true;
        }
        return ClassInfoUtilities.isAncestorOf(c1, c2) || ClassInfoUtilities.isInterfaceOf(c1, c2);
    }

    public static FieldInfo getField(ClassInfo cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        for (ClassInfo c = cl; c != null; c = c.getSuperclass()) {
            FieldInfo[] fs = c.getFields();
            for (int i = 0; i < fs.length; ++i) {
                if (!fs[i].getName().equals(name)) continue;
                return fs[i];
            }
            ClassInfo[] ints = c.getInterfaces();
            FieldInfo f = null;
            for (int i = 0; i < ints.length; ++i) {
                FieldInfo tmp = null;
                try {
                    tmp = ClassInfoUtilities.getField(ints[i], name);
                }
                catch (NoSuchFieldException ex) {
                    // empty catch block
                }
                if (tmp == null) continue;
                if (f != null && !f.equals(tmp)) {
                    throw new AmbiguousFieldException(name);
                }
                f = tmp;
            }
            if (f == null) continue;
            return f;
        }
        throw new NoSuchFieldException(name);
    }

    public static FieldInfo getOuterField(ClassInfo cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        ClassInfo c;
        boolean sc = Modifier.isStatic(cl.getModifiers());
        ClassInfo classInfo = c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                FieldInfo f = ClassInfoUtilities.getField(c, name);
                if (!sc || Modifier.isStatic(f.getModifiers())) {
                    return f;
                }
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchFieldException(name);
    }

    public static MethodInfo lookupMethod(ClassInfo cl, String name, ClassInfo[] ac) throws NoSuchMethodException {
        List<MethodInfo> ms = ClassInfoUtilities.getMethods(cl, name, ac.length);
        LinkedList<MethodInfo> mm = new LinkedList<MethodInfo>();
        for (MethodInfo m : ms) {
            if (!ClassInfoUtilities.hasCompatibleSignatures(m.getParameterTypes(), ac)) continue;
            mm.add(m);
        }
        if (mm.isEmpty()) {
            throw new NoSuchMethodException(name);
        }
        Iterator<MethodInfo> it = mm.iterator();
        MethodInfo result = it.next();
        while (it.hasNext()) {
            result = ClassInfoUtilities.selectTheMostSpecificMethod(result, it.next());
        }
        return result;
    }

    public static MethodInfo lookupOuterMethod(ClassInfo cl, String name, ClassInfo[] ac) throws NoSuchMethodException {
        ClassInfo c;
        boolean sc = Modifier.isStatic(cl.getModifiers());
        ClassInfo classInfo = c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                MethodInfo m = ClassInfoUtilities.lookupMethod(c, name, ac);
                if (!sc || Modifier.isStatic(m.getModifiers())) {
                    return m;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchMethodException(name);
    }

    public static List<MethodInfo> getMethods(ClassInfo cl, String name, int params) {
        LinkedList<MethodInfo> result = new LinkedList<MethodInfo>();
        if (cl.isInterface()) {
            MethodInfo[] ms = cl.getMethods();
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(name) || ms[i].getParameterTypes().length != params) continue;
                result.add(ms[i]);
            }
            ClassInfo[] cs = cl.getInterfaces();
            for (int i = 0; i < cs.length; ++i) {
                result.addAll(ClassInfoUtilities.getMethods(cs[i], name, params));
            }
        } else {
            for (ClassInfo c = cl; c != null; c = c.getSuperclass()) {
                MethodInfo[] ms = c.getMethods();
                for (int i = 0; i < ms.length; ++i) {
                    if (!ms[i].getName().equals(name) || ms[i].getParameterTypes().length != params) continue;
                    result.add(ms[i]);
                }
            }
        }
        return result;
    }

    private static List<ConstructorInfo> getConstructors(ClassInfo cl, int params) {
        LinkedList<ConstructorInfo> result = new LinkedList<ConstructorInfo>();
        ConstructorInfo[] ms = cl.getConstructors();
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i].getParameterTypes().length != params) continue;
            result.add(ms[i]);
        }
        return result;
    }

    private static ConstructorInfo selectTheMostSpecificConstructor(ConstructorInfo m1, ConstructorInfo m2) {
        ClassInfo[] a1 = m1.getParameterTypes();
        ClassInfo[] a2 = m2.getParameterTypes();
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return ClassInfoUtilities.isAssignableFrom(a1[i], a2[i]) ? m2 : m1;
        }
        return m1;
    }

    private static MethodInfo selectTheMostSpecificMethod(MethodInfo m1, MethodInfo m2) {
        ClassInfo[] a1 = m1.getParameterTypes();
        ClassInfo[] a2 = m2.getParameterTypes();
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return ClassInfoUtilities.isAssignableFrom(a1[i], a2[i]) ? m2 : m1;
        }
        return m1;
    }

    private static boolean hasCompatibleSignatures(ClassInfo[] a1, ClassInfo[] a2) {
        for (int i = 0; i < a1.length; ++i) {
            if (ClassInfoUtilities.isAssignableFrom(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAncestorOf(ClassInfo c1, ClassInfo c2) {
        ClassInfo ci;
        for (ci = c2.getSuperclass(); ci != null && !ci.equals(new JavaClassInfo(class$java$lang$Object == null ? ClassInfoUtilities.class$("java.lang.Object") : class$java$lang$Object)); ci = ci.getSuperclass()) {
            if (!ci.equals(c1)) continue;
            return true;
        }
        return ci != null && ci.equals(c1);
    }

    private static boolean isInterfaceOf(ClassInfo c1, ClassInfo c2) {
        if (c1.isInterface()) {
            for (ClassInfo ci = c2; ci != null && !ci.equals(new JavaClassInfo(class$java$lang$Object == null ? ClassInfoUtilities.class$("java.lang.Object") : class$java$lang$Object)); ci = ci.getSuperclass()) {
                ClassInfo[] intf = ci.getInterfaces();
                for (int i = 0; i < intf.length; ++i) {
                    if (intf[i].equals(c1)) {
                        return true;
                    }
                    if (!ClassInfoUtilities.isInterfaceOf(c1, intf[i])) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private ClassInfoUtilities() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

