/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.classinfo.TreeConstructorInfo;
import koala.dynamicjava.classinfo.TreeFieldInfo;
import koala.dynamicjava.classinfo.TreeMethodInfo;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeClassInfo
implements ClassInfo {
    private static final String DECLARING_CLASS = "declaringClass";
    public static final String ANONYMOUS_DECLARING_CLASS = "anonymousDeclaringClass";
    private static final String TREE_VISITED = "treeVisited";
    private TypeDeclaration classTree;
    private ClassFinder classFinder;
    private int dimension;
    private String name;
    private ClassInfo superclass;
    private boolean interfaceInfo;
    private ClassInfo[] interfaces;
    private Map<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
    private Map<String, List<MethodInfo>> methods = new HashMap<String, List<MethodInfo>>();
    private List<ConstructorInfo> constructors = new LinkedList<ConstructorInfo>();
    private List<ClassInfo> classes = new LinkedList<ClassInfo>();
    private boolean compilable = true;
    private int methodCount;

    public TreeClassInfo(TypeDeclaration cd, ClassFinder cf) {
        this.classFinder = cf;
        this.classTree = cd;
        this.name = this.fullName();
        this.interfaceInfo = cd instanceof InterfaceDeclaration;
        new MembersVisitor();
        this.classTree.setProperty(TREE_VISITED, null);
    }

    public TreeClassInfo(TreeClassInfo ci) {
        this.classFinder = ci.classFinder;
        this.classTree = ci.classTree;
        this.dimension = ci.dimension + 1;
        this.name = new StringBuffer().append("[").append(ci.isArray() ? ci.getName() : new StringBuffer().append("L").append(ci.getName()).append(";").toString()).toString();
        new MembersVisitor();
    }

    @Override
    public Class<?> getJavaClass() {
        throw new IllegalStateException();
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.classTree;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    @Override
    public boolean isCompilable() {
        return this.compilable;
    }

    @Override
    public void setCompilable(boolean b) {
        this.compilable = b;
    }

    @Override
    public ClassInfo getDeclaringClass() {
        return this.dimension == 0 ? (ClassInfo)this.classTree.getProperty(DECLARING_CLASS) : null;
    }

    @Override
    public ClassInfo getAnonymousDeclaringClass() {
        return this.dimension == 0 ? (ClassInfo)this.classTree.getProperty(ANONYMOUS_DECLARING_CLASS) : null;
    }

    @Override
    public int getModifiers() {
        return this.dimension == 0 ? this.classTree.getAccessFlags() : 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClassInfo getSuperclass() {
        if (this.superclass == null) {
            if (this.interfaceInfo) {
                this.superclass = this.lookupClass("java.lang.Object");
            } else {
                ClassDeclaration cd = (ClassDeclaration)this.classTree;
                this.superclass = this.lookupClass(cd.getSuperclass(), this.getDeclaringClass());
            }
        }
        return this.superclass;
    }

    @Override
    public ClassInfo[] getInterfaces() {
        if (this.interfaces == null) {
            if (this.dimension > 0) {
                this.interfaces = new ClassInfo[]{this.lookupClass("java.lang.Cloneable"), this.lookupClass("java.io.Serializable")};
            } else {
                List<String> l = this.classTree.getInterfaces();
                if (l != null) {
                    this.interfaces = new ClassInfo[l.size()];
                    Iterator<String> it = l.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        String s = it.next();
                        this.interfaces[i++] = this.lookupClass(s, this.getDeclaringClass());
                    }
                } else {
                    this.interfaces = new ClassInfo[0];
                }
            }
        }
        return (ClassInfo[])this.interfaces.clone();
    }

    public FieldInfo getField(FieldDeclaration node) {
        return (TreeFieldInfo)this.fields.get(node.getName());
    }

    @Override
    public FieldInfo[] getFields() {
        if (this.dimension == 0) {
            Set<String> keys = this.fields.keySet();
            Iterator<String> it = keys.iterator();
            FieldInfo[] result = new FieldInfo[keys.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = this.fields.get(it.next());
            }
            return result;
        }
        return new FieldInfo[0];
    }

    @Override
    public ConstructorInfo[] getConstructors() {
        if (this.dimension == 0) {
            Iterator<ConstructorInfo> it = this.constructors.iterator();
            ConstructorInfo[] result = new ConstructorInfo[this.constructors.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = it.next();
            }
            return result;
        }
        return new ConstructorInfo[0];
    }

    public MethodInfo getMethod(MethodDeclaration node) {
        Set<String> keys = this.methods.keySet();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            List<MethodInfo> l = this.methods.get(it.next());
            for (TreeMethodInfo treeMethodInfo : l) {
                if (treeMethodInfo.getMethodDeclaration() != node) continue;
                return treeMethodInfo;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public MethodInfo[] getMethods() {
        if (this.dimension == 0) {
            MethodInfo[] result = new MethodInfo[this.methodCount];
            Iterator<List<MethodInfo>> it = this.methods.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                Iterator<MethodInfo> lit = it.next().iterator();
                while (lit.hasNext()) {
                    result[i++] = lit.next();
                }
            }
            return result;
        }
        return new MethodInfo[0];
    }

    @Override
    public ClassInfo[] getDeclaredClasses() {
        if (this.dimension == 0) {
            Iterator<ClassInfo> it = this.classes.iterator();
            ClassInfo[] result = new ClassInfo[this.classes.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = it.next();
            }
            return result;
        }
        return new ClassInfo[0];
    }

    @Override
    public ClassInfo getArrayType() {
        return new TreeClassInfo(this);
    }

    @Override
    public boolean isInterface() {
        return this.classTree instanceof InterfaceDeclaration;
    }

    @Override
    public boolean isArray() {
        return this.dimension > 0;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public ClassInfo getComponentType() {
        if (!this.isArray()) {
            throw new IllegalStateException();
        }
        TreeClassInfo bt = new TreeClassInfo(this.classTree, this.classFinder);
        for (int i = 0; i < this.dimension - 1; ++i) {
            bt = new TreeClassInfo(bt);
        }
        return bt;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassInfo)) {
            return false;
        }
        return this.getName().equals(((ClassInfo)obj).getName());
    }

    private String fullName() {
        String s;
        ClassInfo ci = (ClassInfo)this.classTree.getProperty(DECLARING_CLASS);
        if (ci != null) {
            s = new StringBuffer().append(ci.getName()).append("$").toString();
        } else {
            s = this.classFinder.getCurrentPackage();
            if (!s.equals("")) {
                s = new StringBuffer().append(s).append(".").toString();
            }
        }
        return new StringBuffer().append(s).append(this.classTree.getName()).toString();
    }

    private ClassInfo lookupClass(String s) {
        try {
            return this.classFinder.lookupClass(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private ClassInfo lookupClass(String s, ClassInfo c) {
        try {
            if (c != null) {
                return this.classFinder.lookupClass(s, c);
            }
            return this.classFinder.lookupClass(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private int getNestingLevel() {
        int result = -1;
        ClassInfo ci = this;
        while (!Modifier.isStatic(ci.getModifiers()) && (ci = ci.getDeclaringClass()) != null) {
            ++result;
        }
        return result;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MembersVisitor
    extends VisitorObject<Void> {
        MembersVisitor() {
            if (!TreeClassInfo.this.isArray()) {
                Iterator<Node> it = TreeClassInfo.this.classTree.getMembers().iterator();
                while (it.hasNext()) {
                    it.next().acceptVisitor(this);
                }
                if (!TreeClassInfo.this.classTree.hasProperty(TreeClassInfo.TREE_VISITED)) {
                    ClassInfo dc = TreeClassInfo.this.getDeclaringClass();
                    if (dc != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                        FieldDeclaration fd = new FieldDeclaration(1, new ReferenceType(dc.getName()), new StringBuffer().append("this$").append(TreeClassInfo.this.getNestingLevel()).toString(), null);
                        fd.acceptVisitor(this);
                        TreeClassInfo.this.classTree.getMembers().add(fd);
                    }
                    if (TreeClassInfo.this.constructors.size() == 0 && !TreeClassInfo.this.isInterface() && !TreeClassInfo.this.isPrimitive()) {
                        ConstructorInvocation ci = new ConstructorInvocation(null, null, true);
                        ConstructorDeclaration cd = new ConstructorDeclaration(1, TreeClassInfo.this.classTree.getName(), new LinkedList<FormalParameter>(), new LinkedList(), ci, new LinkedList<Node>());
                        cd.acceptVisitor(this);
                        TreeClassInfo.this.classTree.getMembers().add(cd);
                    }
                }
            }
        }

        @Override
        public Void visit(ClassDeclaration node) {
            node.setProperty(TreeClassInfo.DECLARING_CLASS, TreeClassInfo.this);
            TreeClassInfo.this.classes.add(TreeClassInfo.this.classFinder.addClassInfo(new StringBuffer().append(TreeClassInfo.this.getName()).append("$").append(node.getName()).toString(), node));
            return null;
        }

        @Override
        public Void visit(InterfaceDeclaration node) {
            node.setProperty(TreeClassInfo.DECLARING_CLASS, TreeClassInfo.this);
            TreeClassInfo.this.classes.add(TreeClassInfo.this.classFinder.addClassInfo(new StringBuffer().append(TreeClassInfo.this.getName()).append("$").append(node.getName()).toString(), node));
            return null;
        }

        @Override
        public Void visit(FieldDeclaration node) {
            TreeClassInfo.this.fields.put(node.getName(), new TreeFieldInfo(node, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            return null;
        }

        @Override
        public Void visit(ConstructorDeclaration node) {
            if (node.getConstructorInvocation() == null) {
                ConstructorInvocation ci = new ConstructorInvocation(null, null, true);
                node.setConstructorInvocation(ci);
            }
            ClassInfo dc = TreeClassInfo.this.getDeclaringClass();
            if (!TreeClassInfo.this.classTree.hasProperty(TreeClassInfo.TREE_VISITED) && dc != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                ReferenceType t = new ReferenceType(dc.getName());
                node.getParameters().add(0, new FormalParameter(false, t, "param$0"));
            }
            if (dc != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                LinkedList<IdentifierToken> l1 = new LinkedList<IdentifierToken>();
                l1.add(new Identifier(new StringBuffer().append("this$").append(TreeClassInfo.this.getNestingLevel()).toString()));
                LinkedList<IdentifierToken> l2 = new LinkedList<IdentifierToken>();
                l2.add(new Identifier("param$0"));
                SimpleAssignExpression sae = new SimpleAssignExpression(new QualifiedName(l1), new QualifiedName(l2));
                node.getStatements().add(0, sae);
            }
            TreeClassInfo.this.constructors.add(new TreeConstructorInfo(node, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            return null;
        }

        @Override
        public Void visit(MethodDeclaration node) {
            LinkedList<TreeMethodInfo> l = (LinkedList<TreeMethodInfo>)TreeClassInfo.this.methods.get(node.getName());
            if (l == null) {
                l = new LinkedList<TreeMethodInfo>();
            }
            l.add(new TreeMethodInfo(node, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            TreeClassInfo.this.methods.put(node.getName(), l);
            TreeClassInfo.this.methodCount++;
            return null;
        }

        @Override
        public /* synthetic */ Object visit(InstanceInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(VariableDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FieldDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FormalParameter x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MethodDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InterfaceDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BlockStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConditionalExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(OrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InstanceOfExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MinusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PlusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ComplementExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CastExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TypeExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReferenceType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PrimitiveType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorInvocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FunctionCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(QualifiedName x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThisExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(Literal x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AssertStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenElseStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ContinueStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SynchronizedStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReturnStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThrowStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CatchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TryStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BreakStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LabeledStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchBlock x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DoStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForEachStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(WhileStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EmptyStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ImportDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PackageDeclaration x0) {
            return super.visit(x0);
        }
    }
}

