/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import koala.dynamicjava.gui.Editor;
import koala.dynamicjava.gui.JTextComponentOutputStream;
import koala.dynamicjava.gui.OptionsDialog;
import koala.dynamicjava.gui.StatusBar;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.JComponentModifier;
import koala.dynamicjava.gui.resource.MenuFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceManager;
import koala.dynamicjava.gui.resource.ToolBarFactory;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;

public class Main
extends JFrame
implements ActionMap {
    public static final String OPEN_ACTION = "OpenAction";
    public static final String SAVE_ACTION = "SaveAction";
    public static final String SAVE_AS_ACTION = "SaveAsAction";
    public static final String EXIT_ACTION = "ExitAction";
    public static final String UNDO_ACTION = "UndoAction";
    public static final String REDO_ACTION = "RedoAction";
    public static final String CUT_ACTION = "CutAction";
    public static final String COPY_ACTION = "CopyAction";
    public static final String PASTE_ACTION = "PasteAction";
    public static final String CLEAR_ACTION = "ClearAction";
    public static final String OPTIONS_ACTION = "OptionsAction";
    public static final String EVAL_ACTION = "EvalAction";
    public static final String EVAL_S_ACTION = "EvalSAction";
    public static final String STOP_ACTION = "StopAction";
    public static final String REINIT_ACTION = "ReinitAction";
    public static final String ABOUT_ACTION = "AboutAction";
    protected static int instances;
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.main";
    protected static ResourceBundle bundle;
    protected static ResourceManager rManager;
    protected Editor editor;
    protected JTextArea output;
    protected BoundedRangeModel scrollBarModel;
    protected StatusBar status;
    protected OptionsDialog options;
    protected Interpreter interpreter;
    protected int selectionStart = -1;
    protected int selectionEnd = -1;
    protected EvalAction evalAction = new EvalAction();
    protected EvalSelectionAction evalSelection = new EvalSelectionAction();
    protected StopAction stopAction = new StopAction();
    protected Thread thread;
    protected boolean isRunning;
    protected OptionsDialog.OptionSet optionSet;
    protected PrintStream textComponentStream;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    protected Map<String, Action> listeners = new HashMap<String, Action>();

    public static void main(String[] args) {
        new Main().show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Main() {
        ++instances;
        this.setTitle(rManager.getString("Frame.title"));
        this.setSize(rManager.getInteger("Frame.width"), rManager.getInteger("Frame.height"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Main.this.exit();
            }
        });
        this.status = new StatusBar(rManager);
        this.getContentPane().add("South", this.status);
        JScrollPane scroll1 = new JScrollPane();
        this.editor = new Editor(this.status);
        scroll1.getViewport().add(this.editor);
        scroll1.setVerticalScrollBarPolicy(22);
        this.editor.addCaretListener(new EditorCaretListener());
        JScrollPane scroll2 = new JScrollPane();
        this.output = new JTextArea();
        scroll2.getViewport().add(this.output);
        scroll2.setVerticalScrollBarPolicy(22);
        this.scrollBarModel = scroll2.getVerticalScrollBar().getModel();
        this.scrollBarModel.addChangeListener(new ScrollBarModelChangeListener());
        this.output.setEditable(false);
        this.output.setLineWrap(true);
        this.output.setBackground(Color.lightGray);
        JSplitPane split = new JSplitPane(0, true, scroll1, scroll2);
        split.setDividerLocation(rManager.getInteger("Frame.divider"));
        this.getContentPane().add(split);
        this.listeners.put(OPEN_ACTION, this.editor.getAction(OPEN_ACTION));
        this.listeners.put(SAVE_ACTION, this.editor.getAction(SAVE_ACTION));
        this.listeners.put(SAVE_AS_ACTION, this.editor.getAction(SAVE_AS_ACTION));
        this.listeners.put(EXIT_ACTION, new ExitAction());
        this.listeners.put(UNDO_ACTION, this.editor.getAction(UNDO_ACTION));
        this.listeners.put(REDO_ACTION, this.editor.getAction(REDO_ACTION));
        this.listeners.put(CUT_ACTION, this.editor.getAction("cut-to-clipboard"));
        this.listeners.put(COPY_ACTION, this.editor.getAction("copy-to-clipboard"));
        this.listeners.put(PASTE_ACTION, this.editor.getAction("paste-from-clipboard"));
        this.listeners.put(CLEAR_ACTION, new ClearAction());
        this.listeners.put(OPTIONS_ACTION, new OptionsAction());
        this.listeners.put(EVAL_ACTION, this.evalAction);
        this.listeners.put(EVAL_S_ACTION, this.evalSelection);
        this.listeners.put(STOP_ACTION, this.stopAction);
        this.listeners.put(REINIT_ACTION, new ReinitAction());
        this.listeners.put(ABOUT_ACTION, new AboutAction());
        MenuFactory mf = new MenuFactory(bundle, this);
        try {
            this.setJMenuBar(mf.createJMenuBar("MenuBar"));
        }
        catch (MissingResourceException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
        ToolBarFactory tbf = new ToolBarFactory(bundle, this);
        try {
            JToolBar tb = tbf.createJToolBar("ToolBar");
            tb.setFloatable(false);
            this.getContentPane().add("North", tb);
        }
        catch (MissingResourceException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
        this.textComponentStream = new PrintStream(new JTextComponentOutputStream(this.output));
        this.options = new OptionsDialog(this);
        this.loadOptions();
        if (this.options.isStartupInitializationSelected()) {
            this.interpreter = this.createInterpreter();
            this.applyOptions();
            String s = this.options.getStartupInitializationFilename();
            InputStreamReader r = null;
            PrintStream oldout = System.out;
            PrintStream olderr = System.err;
            System.setOut(this.out);
            System.setErr(this.err);
            try {
                try {
                    r = new InputStreamReader(new URL(s).openStream());
                }
                catch (Exception e) {
                    r = new FileReader(s);
                }
                this.interpreter.interpret(r, s);
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(this, rManager.getString("InterpreterInitializationError.text") + "\n" + e.getMessage(), rManager.getString("InterpreterInitializationError.title"), 0);
            }
            finally {
                System.setOut(oldout);
                System.setErr(olderr);
            }
        }
        this.interpreter = this.createInterpreter();
        this.applyOptions();
    }

    public void setOptions(OptionsDialog.OptionSet opt) {
        this.options.setOptions(opt);
    }

    public OptionsDialog.OptionSet getOptions() {
        return this.options.getOptions();
    }

    public void saveOptions() throws IOException {
        int i;
        OptionsDialog.OptionSet opt = this.options.getOptions();
        String dirName = System.getProperty("user.home") + "/.djava";
        File f = new File(dirName);
        if (!f.exists()) {
            f.mkdir();
        }
        String ls = System.getProperty("line.separator");
        FileWriter w = new FileWriter(dirName + "/options");
        w.write("// Generated by DynamicJava" + ls);
        w.write("import koala.dynamicjava.gui.*;" + ls + ls);
        w.write("OptionsDialog.OptionSet optionSet = new OptionsDialog.OptionSet();" + ls + ls);
        w.write("optionSet.classPath = new String[] { " + ls);
        if (opt.classPath.length > 0) {
            w.write("    " + this.stringToJavaString(opt.classPath[0]));
        }
        for (i = 1; i < opt.classPath.length; ++i) {
            w.write("," + ls + "    " + this.stringToJavaString(opt.classPath[i]));
        }
        w.write(" };" + ls + ls);
        w.write("optionSet.libraryPath = new String[] { " + ls);
        if (opt.libraryPath.length > 0) {
            w.write("    " + this.stringToJavaString(opt.libraryPath[0]));
        }
        for (i = 1; i < opt.libraryPath.length; ++i) {
            w.write("," + ls + "    " + this.stringToJavaString(opt.libraryPath[i]));
        }
        w.write(" };" + ls + ls);
        w.write("optionSet.isInterpreterSelected = " + opt.isInterpreterSelected + ";" + ls);
        w.write("optionSet.interpreterName = \"" + opt.interpreterName + "\";" + ls + ls);
        w.write("optionSet.interpreterFileSelected = " + opt.interpreterFileSelected + ";" + ls);
        w.write("optionSet.interpreterFilename = " + this.stringToJavaString(opt.interpreterFilename) + ";" + ls + ls);
        w.write("optionSet.isGUISelected = " + opt.isGUISelected + ";" + ls);
        w.write("optionSet.guiName = \"" + opt.guiName + "\";" + ls + ls);
        w.write("optionSet.isOutputSelected = " + opt.isOutputSelected + ";" + ls + ls);
        w.write("optionSet.isErrorSelected = " + opt.isErrorSelected + ";" + ls + ls);
        w.write("optionSet.guiFileSelected = " + opt.guiFileSelected + ";" + ls);
        w.write("optionSet.guiFilename = " + this.stringToJavaString(opt.guiFilename) + ";" + ls + ls);
        w.write("gui.setOptions(optionSet);" + ls);
        ((Writer)w).flush();
    }

    protected String stringToJavaString(String s) {
        String result = "\"";
        block3: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\"': 
                case '\\': {
                    result = result + "\\" + s.charAt(i);
                    continue block3;
                }
                default: {
                    result = result + s.charAt(i);
                }
            }
        }
        return result + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOptions() {
        PrintStream oldout = System.out;
        PrintStream olderr = System.err;
        System.setOut(this.out);
        System.setErr(this.err);
        Interpreter interpreter = this.createInterpreter();
        try {
            File f = new File(System.getProperty("user.home") + "/.djava/options");
            if (f.exists()) {
                interpreter.defineVariable("gui", this);
                interpreter.interpret(new FileReader(f), "options");
            }
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        finally {
            System.setOut(oldout);
            System.setErr(olderr);
        }
    }

    public OptionsDialog getOptionsDialog() {
        return this.options;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public JTextArea getOutputArea() {
        return this.output;
    }

    protected void exit() {
        this.editor.closeProcedure();
        if (--instances == 0) {
            System.exit(0);
        }
    }

    protected void reinitializeInterpreter() {
        this.interpreter = this.createInterpreter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyOptions() {
        String[] classpath = this.options.getClassPath();
        for (int i = 0; i < classpath.length; ++i) {
            String s = classpath[i];
            try {
                this.interpreter.addClassURL(new URL(s));
                continue;
            }
            catch (MalformedURLException e) {
                this.interpreter.addClassPath(s);
            }
        }
        String[] libpath = this.options.getLibraryPath();
        for (int i = 0; i < libpath.length; ++i) {
            this.interpreter.addLibraryPath(libpath[i]);
        }
        if (this.options.isInterpreterDefined()) {
            this.interpreter.defineVariable(this.options.getInterpreterName(), this.interpreter);
        }
        if (this.options.isGUIDefined()) {
            this.interpreter.defineVariable(this.options.getGUIName(), this);
        }
        this.out = this.options.isOutputSelected() ? this.textComponentStream : System.out;
        PrintStream printStream = this.err = this.options.isErrorSelected() ? this.textComponentStream : System.err;
        if (this.options.isInitializationSelected()) {
            String s = this.options.getInitializationFilename();
            InputStreamReader r = null;
            PrintStream oldout = System.out;
            PrintStream olderr = System.err;
            System.setOut(this.out);
            System.setErr(this.err);
            try {
                try {
                    r = new InputStreamReader(new URL(s).openStream());
                }
                catch (Exception e) {
                    r = new FileReader(s);
                }
                this.interpreter.interpret(r, s);
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(this, rManager.getString("InterpreterInitializationError.text") + "\n" + e.getMessage(), rManager.getString("InterpreterInitializationError.title"), 0);
            }
            finally {
                System.setOut(oldout);
                System.setErr(olderr);
            }
        }
    }

    protected int getCurrentLine(int p) {
        String t = this.editor.getText();
        int result = 1;
        for (int i = 0; i < p; ++i) {
            if (t.charAt(i) != '\n') continue;
            ++result;
        }
        return result;
    }

    protected void restoreOptions() {
        this.options.setOptions(this.optionSet);
    }

    protected Interpreter createInterpreter() {
        TreeInterpreter result = new TreeInterpreter(new JavaCCParserFactory());
        result.addLibrarySuffix(".java");
        return result;
    }

    public Action getAction(String key) throws MissingListenerException {
        return this.listeners.get(key);
    }

    static {
        bundle = ResourceBundle.getBundle(RESOURCE, Locale.getDefault());
        rManager = new ResourceManager(bundle);
    }

    protected class ScrollBarModelChangeListener
    implements ChangeListener {
        int oldMax;

        protected ScrollBarModelChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (this.oldMax != Main.this.scrollBarModel.getMaximum()) {
                this.oldMax = Main.this.scrollBarModel.getMaximum();
                Main.this.scrollBarModel.setValue(this.oldMax);
            }
        }
    }

    protected class EditorCaretListener
    implements CaretListener {
        protected EditorCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            int p1 = e.getDot();
            int p2 = e.getMark();
            Main.this.status.setLine(Main.this.getCurrentLine(p1));
            if (p1 != p2) {
                if (p1 > p2) {
                    int t = p2;
                    p2 = p1;
                    p1 = t;
                }
                Main.this.selectionStart = p1;
                Main.this.selectionEnd = p2;
            } else {
                Main.this.selectionStart = -1;
                Main.this.selectionEnd = -1;
            }
            Main.this.evalSelection.update();
        }
    }

    protected class AboutAction
    extends AbstractAction {
        protected AboutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Main.this, bundle.getString("AboutMessage"));
        }
    }

    protected class ReinitAction
    extends AbstractAction {
        protected ReinitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Main.this.reinitializeInterpreter();
            Main.this.applyOptions();
            Main.this.status.setMessage("Status.interpreter.reinitialized");
        }
    }

    protected class StopAction
    extends AbstractAction
    implements JComponentModifier {
        List<JComponent> components = new LinkedList<JComponent>();

        protected StopAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            Main.this.thread.stop();
            Main.this.isRunning = false;
            this.update();
            Main.this.evalAction.update();
            Main.this.evalSelection.update();
            Main.this.status.setMessage("Status.evaluation.stopped");
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            Iterator<JComponent> it = this.components.iterator();
            while (it.hasNext()) {
                it.next().setEnabled(Main.this.isRunning);
            }
        }
    }

    protected class EvalSelectionAction
    extends AbstractAction
    implements JComponentModifier {
        List<JComponent> components = new LinkedList<JComponent>();

        protected EvalSelectionAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            String s = Main.this.editor.getSelectedText();
            if (s != null) {
                StringReader sr = new StringReader(s);
                Main.this.thread = new InterpreterThread(sr);
                Main.this.thread.start();
            }
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            Iterator<JComponent> it = this.components.iterator();
            while (it.hasNext()) {
                it.next().setEnabled(Main.this.selectionStart != -1 && !Main.this.isRunning);
            }
        }
    }

    protected class InterpreterThread
    extends Thread {
        Reader reader;

        InterpreterThread(Reader r) {
            this.reader = r;
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadDeath td = null;
            PrintStream oldout = System.out;
            PrintStream olderr = System.err;
            System.setOut(Main.this.out);
            System.setErr(Main.this.err);
            try {
                Main.this.isRunning = true;
                Main.this.stopAction.update();
                Main.this.evalAction.update();
                Main.this.evalSelection.update();
                Main.this.output.append("==> " + Main.this.interpreter.interpret(this.reader, "buffer") + "\n");
            }
            catch (InterpreterException e) {
                Main.this.output.append(" *** " + e.getMessage() + "\n");
            }
            catch (ThreadDeath e) {
                td = e;
            }
            catch (Throwable e) {
                Main.this.output.append(e + "\n");
            }
            finally {
                System.setOut(oldout);
                System.setErr(olderr);
            }
            Main.this.isRunning = false;
            Main.this.stopAction.update();
            Main.this.evalAction.update();
            Main.this.evalSelection.update();
            if (td != null) {
                throw td;
            }
        }
    }

    protected class EvalAction
    extends AbstractAction
    implements JComponentModifier {
        List<JComponent> components = new LinkedList<JComponent>();

        protected EvalAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            StringReader sr = new StringReader(Main.this.editor.getText());
            Main.this.thread = new InterpreterThread(sr);
            Main.this.thread.start();
        }

        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(true);
        }

        protected void update() {
            Iterator<JComponent> it = this.components.iterator();
            while (it.hasNext()) {
                it.next().setEnabled(!Main.this.isRunning);
            }
        }
    }

    protected class OptionsAction
    extends AbstractAction {
        protected OptionsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Main.this.optionSet = Main.this.options.getOptions();
            Rectangle fr = Main.this.getBounds();
            Dimension od = Main.this.options.getSize();
            Main.this.options.setLocation(fr.x + (fr.width - od.width) / 2, fr.y + (fr.height - od.height) / 2);
            Main.this.options.show();
        }
    }

    protected class ClearAction
    extends AbstractAction {
        protected ClearAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Main.this.output.setText("");
        }
    }

    protected class ExitAction
    extends AbstractAction {
        protected ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Main.this.exit();
        }
    }
}

