/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.model.DocumentClosedException;
import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.model.FileGroupingState;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.FinalizationListener;
import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.GlobalModelListener;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.model.SimpleDocumentRegion;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.cache.DCacheAdapter;
import edu.rice.cs.drjava.model.cache.DDReconstructor;
import edu.rice.cs.drjava.model.cache.DocumentCache;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.DefinitionsEditorKit;
import edu.rice.cs.drjava.model.definitions.DocumentUIListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.junit.JUnitModel;
import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsDocument;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.drjava.project.ProjectFileParser;
import edu.rice.cs.drjava.project.ProjectProfile;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Lambda;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.NullFile;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.ReaderWriterLock;
import edu.rice.cs.util.SRunnable;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.docnavigation.AWTContainerNavigatorFactory;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.docnavigation.NodeData;
import edu.rice.cs.util.docnavigation.NodeDataVisitor;
import edu.rice.cs.util.swing.AsyncCompletionArgs;
import edu.rice.cs.util.swing.AsyncTask;
import edu.rice.cs.util.swing.DocumentIterator;
import edu.rice.cs.util.swing.IAsyncProgress;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import edu.rice.cs.util.text.ConsoleDocument;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractGlobalModel
implements SingleDisplayModel,
OptionConstants,
DocumentIterator {
    public static Log _log;
    protected DocumentCache _cache;
    static final String DOCUMENT_OUT_OF_SYNC_MSG = "Current document is out of sync with the Interactions Pane and should be recompiled!\n";
    static final String CLASSPATH_OUT_OF_SYNC_MSG = "Interactions Pane is out of sync with the current classpath and should be reset!\n";
    public final GlobalEventNotifier _notifier = new GlobalEventNotifier();
    protected final DefinitionsEditorKit _editorKit = new DefinitionsEditorKit(this._notifier);
    private final AbstractMap<File, OpenDefinitionsDocument> _documentsRepos = new LinkedHashMap<File, OpenDefinitionsDocument>();
    protected final ConsoleDocument _consoleDoc;
    protected final InteractionsDJDocument _consoleDocAdapter;
    public static final int WRITE_DELAY = 5;
    protected volatile PageFormat _pageFormat = new PageFormat();
    private volatile OpenDefinitionsDocument _activeDocument;
    private volatile File _activeDirectory;
    private volatile boolean classPathChanged = false;
    protected volatile IDocumentNavigator<OpenDefinitionsDocument> _documentNavigator = new AWTContainerNavigatorFactory().makeListNavigator();
    protected final ConcreteRegionManager<Breakpoint> _breakpointManager;
    protected final ConcreteRegionManager<DocumentRegion> _bookmarkManager;
    protected final LinkedList<RegionManager<MovingDocumentRegion>> _findResultsManagers;
    protected final ConcreteRegionManager<DocumentRegion> _browserHistoryManager;
    protected volatile FileGroupingState _state;
    private static volatile int ID_COUNTER;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$AbstractGlobalModel;

    @Override
    public void addAuxiliaryFile(OpenDefinitionsDocument doc) {
        this._state.addAuxFile(doc.getRawFile());
    }

    @Override
    public void removeAuxiliaryFile(OpenDefinitionsDocument doc) {
        this._state.remAuxFile(doc.getRawFile());
    }

    @Override
    public RegionManager<Breakpoint> getBreakpointManager() {
        return this._breakpointManager;
    }

    @Override
    public RegionManager<DocumentRegion> getBookmarkManager() {
        return this._bookmarkManager;
    }

    @Override
    public List<RegionManager<MovingDocumentRegion>> getFindResultsManagers() {
        return new LinkedList<RegionManager<MovingDocumentRegion>>(this._findResultsManagers);
    }

    @Override
    public RegionManager<MovingDocumentRegion> createFindResultsManager() {
        ConcreteRegionManager<MovingDocumentRegion> rm = new ConcreteRegionManager<MovingDocumentRegion>();
        this._findResultsManagers.add(rm);
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            doc.addFindResultsManager(rm);
        }
        return rm;
    }

    @Override
    public void disposeFindResultsManager(RegionManager<MovingDocumentRegion> rm) {
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            doc.removeFindResultsManager(rm);
        }
        this._findResultsManagers.remove(rm);
    }

    @Override
    public RegionManager<DocumentRegion> getBrowserHistoryManager() {
        return this._browserHistoryManager;
    }

    public AbstractGlobalModel() {
        this._cache = new DocumentCache();
        this._consoleDocAdapter = new InteractionsDJDocument();
        this._consoleDoc = new ConsoleDocument(this._consoleDocAdapter);
        this._bookmarkManager = new ConcreteRegionManager();
        this._findResultsManagers = new LinkedList();
        this._browserHistoryManager = new ConcreteRegionManager();
        this._breakpointManager = new ConcreteRegionManager<Breakpoint>(){

            public boolean changeRegionHelper(Breakpoint oldBP, Breakpoint newBP) {
                if (oldBP.isEnabled() != newBP.isEnabled()) {
                    oldBP.setEnabled(newBP.isEnabled());
                    return true;
                }
                return false;
            }
        };
        this._registerOptionListeners();
        this.setFileGroupingState(this.makeFlatFileGroupingState());
        this._notifier.projectRunnableChanged();
        this._init();
    }

    private void _init() {
        final NodeDataVisitor<OpenDefinitionsDocument, Boolean> _gainVisitor = new NodeDataVisitor<OpenDefinitionsDocument, Boolean>(){

            @Override
            public Boolean itemCase(OpenDefinitionsDocument doc, Object ... p) {
                Boolean modelInitiated = (Boolean)p[0];
                OpenDefinitionsDocument oldDoc = AbstractGlobalModel.this.getActiveDocument();
                AbstractGlobalModel.access$000(AbstractGlobalModel.this, doc);
                File oldDir = AbstractGlobalModel.access$100(AbstractGlobalModel.this);
                File dir = doc.getParentDirectory();
                if (dir != null && !dir.equals(oldDir)) {
                    AbstractGlobalModel.access$102(AbstractGlobalModel.this, dir);
                    AbstractGlobalModel.this._notifier.currentDirectoryChanged(AbstractGlobalModel.access$100(AbstractGlobalModel.this));
                }
                return Autobox.valueOf(true);
            }

            @Override
            public Boolean fileCase(File f, Object ... p) {
                if (!f.isAbsolute()) {
                    File root = AbstractGlobalModel.this._state.getProjectFile().getParentFile().getAbsoluteFile();
                    f = new File(root, f.getPath());
                }
                AbstractGlobalModel.access$102(AbstractGlobalModel.this, f);
                AbstractGlobalModel.this._notifier.currentDirectoryChanged(f);
                return Autobox.valueOf(true);
            }

            @Override
            public Boolean stringCase(String s, Object ... p) {
                return Autobox.valueOf(false);
            }

            @Override
            public Object itemCase(INavigatorItem x0, Object[] x1) {
                return this.itemCase((OpenDefinitionsDocument)x0, x1);
            }

            @Override
            public Object stringCase(String x0, Object[] x1) {
                return this.stringCase(x0, x1);
            }

            @Override
            public Object fileCase(File x0, Object[] x1) {
                return this.fileCase(x0, x1);
            }
        };
        this._documentNavigator.addNavigationListener(new INavigationListener<OpenDefinitionsDocument>(){

            @Override
            public void gainedSelection(NodeData<? extends OpenDefinitionsDocument> dat, boolean modelInitiated) {
                dat.execute(_gainVisitor, Autobox.valueOf(modelInitiated));
            }

            @Override
            public void lostSelection(NodeData<? extends OpenDefinitionsDocument> dat, boolean modelInitiated) {
            }
        });
        this._documentNavigator.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AbstractGlobalModel.this._notifier.focusOnDefinitionsPane();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this._ensureNotEmpty();
        this.setActiveFirstDocument();
        OptionListener<Integer> clipboardHistorySizeListener = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                ClipboardHistoryModel.singleton().resize((Integer)oce.value);
            }
        };
        DrJava.getConfig().addOptionListener(CLIPBOARD_HISTORY_SIZE, clipboardHistorySizeListener);
        ClipboardHistoryModel.singleton().resize(DrJava.getConfig().getSetting(CLIPBOARD_HISTORY_SIZE));
        OptionListener<Integer> browserHistoryMaxSizeListener = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                AbstractGlobalModel.this.getBrowserHistoryManager().setMaximumSize((Integer)oce.value);
            }
        };
        DrJava.getConfig().addOptionListener(BROWSER_HISTORY_MAX_SIZE, browserHistoryMaxSizeListener);
        this.getBrowserHistoryManager().setMaximumSize(DrJava.getConfig().getSetting(BROWSER_HISTORY_MAX_SIZE));
    }

    public void setFileGroupingState(FileGroupingState state) {
        this._state = state;
        this._notifier.projectRunnableChanged();
        this._notifier.projectBuildDirChanged();
        this._notifier.projectWorkDirChanged();
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected FileGroupingState makeProjectFileGroupingState(File pr, File main, File bd, File wd, File project, File[] srcFiles, File[] auxFiles, Iterable_ cp, File cjf, int cjflags) {
        return new ProjectFileGroupingState(this, pr, main, bd, wd, project, srcFiles, auxFiles, cp, cjf, cjflags);
    }

    public boolean isClassPathChanged() {
        return this.classPathChanged;
    }

    public void setClassPathChanged(boolean changed) {
        this.classPathChanged = changed;
    }

    @Override
    public void setProjectChanged(boolean changed) {
        this._state.setProjectChanged(changed);
    }

    @Override
    public boolean isProjectChanged() {
        return this._state.isProjectChanged();
    }

    @Override
    public boolean isProjectActive() {
        return this._state.isProjectActive();
    }

    @Override
    public File getProjectFile() {
        return this._state.getProjectFile();
    }

    @Override
    public File[] getProjectFiles() {
        return this._state.getProjectFiles();
    }

    @Override
    public boolean inProject(File f) {
        return this._state.inProject(f);
    }

    @Override
    public boolean inProjectPath(OpenDefinitionsDocument doc) {
        return this._state.inProjectPath(doc);
    }

    @Override
    public void setMainClass(File f) {
        this._state.setMainClass(f);
        this._notifier.projectRunnableChanged();
        this.setProjectChanged(true);
    }

    @Override
    public File getMainClass() {
        return this._state.getMainClass();
    }

    @Override
    public void setCreateJarFile(File f) {
        this._state.setCreateJarFile(f);
        this.setProjectChanged(true);
    }

    @Override
    public File getCreateJarFile() {
        return this._state.getCreateJarFile();
    }

    @Override
    public void setCreateJarFlags(int f) {
        this._state.setCreateJarFlags(f);
        this.setProjectChanged(true);
    }

    @Override
    public int getCreateJarFlags() {
        return this._state.getCreateJarFlags();
    }

    @Override
    public File getProjectRoot() {
        return this._state.getProjectRoot();
    }

    @Override
    public void setProjectRoot(File f) {
        this._state.setProjectRoot(f);
        this.setProjectChanged(true);
    }

    @Override
    public void setProjectFile(File f) {
        this._state.setProjectFile(f);
    }

    @Override
    public File getBuildDirectory() {
        return this._state.getBuildDirectory();
    }

    @Override
    public void setBuildDirectory(File f) {
        this._state.setBuildDirectory(f);
        this._notifier.projectBuildDirChanged();
        this.setProjectChanged(true);
    }

    @Override
    public File getMasterWorkingDirectory() {
        File file;
        try {
            file = FileOps.getValidDirectory(DrJava.getConfig().getSetting(LAST_DIRECTORY));
        }
        catch (RuntimeException e) {
            DrJava.getConfig().setSetting(LAST_DIRECTORY, FileOption.NULL_FILE);
            file = FileOps.getValidDirectory(new File(System.getProperty("user.home", ".")));
        }
        DrJava.getConfig().setSetting(LAST_DIRECTORY, file);
        return file;
    }

    @Override
    public File getWorkingDirectory() {
        return this._state.getWorkingDirectory();
    }

    @Override
    public void setWorkingDirectory(File f) {
        this._state.setWorkingDirectory(f);
        this._notifier.projectWorkDirChanged();
        this.setProjectChanged(true);
        DrJava.getConfig().setSetting(LAST_INTERACTIONS_DIRECTORY, this._state.getWorkingDirectory());
    }

    @Override
    public void cleanBuildDirectory() {
        this._state.cleanBuildDirectory();
    }

    @Override
    public List<File> getClassFiles() {
        return this._state.getClassFiles();
    }

    protected static String getPackageName(String classname) {
        int index = classname.lastIndexOf(".");
        if (index != -1) {
            return classname.substring(0, index);
        }
        return "";
    }

    protected FileGroupingState makeFlatFileGroupingState() {
        return new FlatFileGroupingState();
    }

    @Override
    public String getSourceBinTitle() {
        return "[ Source Files ]";
    }

    @Override
    public String getExternalBinTitle() {
        return "[ External Files ]";
    }

    @Override
    public String getAuxiliaryBinTitle() {
        return "[ Included External Files ]";
    }

    @Override
    public void addListener(GlobalModelListener listener) {
        this._notifier.addListener(listener);
    }

    @Override
    public void removeListener(GlobalModelListener listener) {
        this._notifier.removeListener(listener);
    }

    @Override
    public DefinitionsEditorKit getEditorKit() {
        return this._editorKit;
    }

    @Override
    public DefaultInteractionsModel getInteractionsModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public InteractionsDJDocument getSwingInteractionsDocument() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public InteractionsDocument getInteractionsDocument() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interaction");
    }

    @Override
    public ConsoleDocument getConsoleDocument() {
        return this._consoleDoc;
    }

    @Override
    public InteractionsDJDocument getSwingConsoleDocument() {
        return this._consoleDocAdapter;
    }

    @Override
    public PageFormat getPageFormat() {
        return this._pageFormat;
    }

    @Override
    public void setPageFormat(PageFormat format) {
        this._pageFormat = format;
    }

    @Override
    public CompilerModel getCompilerModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    @Override
    public int getNumCompErrors() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    @Override
    public void setNumCompErrors(int num) {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
    }

    @Override
    public JUnitModel getJUnitModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support unit testing");
    }

    @Override
    public JavadocModel getJavadocModel() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support javadoc");
    }

    @Override
    public IDocumentNavigator<OpenDefinitionsDocument> getDocumentNavigator() {
        return this._documentNavigator;
    }

    @Override
    public void setDocumentNavigator(IDocumentNavigator<OpenDefinitionsDocument> newnav) {
        this._documentNavigator = newnav;
    }

    public OpenDefinitionsDocument newFile(File parentDir) {
        ConcreteOpenDefDoc doc = this._createOpenDefinitionsDocument(new NullFile());
        doc.setParentDirectory(parentDir);
        this.addDocToNavigator(doc);
        this._notifier.newFileCreated(doc);
        return doc;
    }

    @Override
    public OpenDefinitionsDocument newFile() {
        File dir = this._activeDirectory;
        if (dir == null) {
            dir = this.getMasterWorkingDirectory();
        }
        OpenDefinitionsDocument doc = this.newFile(dir);
        this.setActiveDocument(doc);
        return doc;
    }

    @Override
    public OpenDefinitionsDocument newTestCase(String name, boolean makeSetUp, boolean makeTearDown) {
        boolean elementary = DrJava.getConfig().getSetting(LANGUAGE_LEVEL) == 1;
        StringBuffer buf = new StringBuffer();
        if (!elementary) {
            buf.append("import junit.framework.TestCase;\n\n");
        }
        buf.append("/**\n");
        buf.append("* A JUnit test case class.\n");
        buf.append("* Every method starting with the word \"test\" will be called when running\n");
        buf.append("* the test with JUnit.\n");
        buf.append("*/\n");
        if (!elementary) {
            buf.append("public ");
        }
        buf.append("class ");
        buf.append(name);
        buf.append(" extends TestCase {\n\n");
        if (makeSetUp) {
            buf.append("/**\n");
            buf.append("* This method is called before each test method, to perform any common\n");
            buf.append("* setup if necessary.\n");
            buf.append("*/\n");
            if (!elementary) {
                buf.append("public ");
            }
            buf.append("void setUp() throws Exception {\n}\n\n");
        }
        if (makeTearDown) {
            buf.append("/**\n");
            buf.append("* This method is called after each test method, to perform any common\n");
            buf.append("* clean-up if necessary.\n");
            buf.append("*/\n");
            if (!elementary) {
                buf.append("public ");
            }
            buf.append("void tearDown() throws Exception {\n}\n\n");
        }
        buf.append("/**\n");
        buf.append("* A test method.\n");
        buf.append("* (Replace \"X\" with a name describing the test.  You may write as\n");
        buf.append("* many \"testSomething\" methods in this class as you wish, and each\n");
        buf.append("* one will be called when running JUnit over this class.)\n");
        buf.append("*/\n");
        if (!elementary) {
            buf.append("public ");
        }
        buf.append("void testX() {\n}\n\n");
        buf.append("}\n");
        String test = buf.toString();
        OpenDefinitionsDocument openDoc = this.newFile();
        try {
            openDoc.insertString(0, test, null);
            openDoc.indentLines(0, test.length());
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        return openDoc;
    }

    public DocumentCache getDocumentCache() {
        return this._cache;
    }

    @Override
    public OpenDefinitionsDocument openFile(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        boolean closeUntitled = this._hasOneEmptyDocument();
        OpenDefinitionsDocument oldDoc = this._activeDocument;
        OpenDefinitionsDocument openedDoc = this.openFileHelper(com);
        if (closeUntitled) {
            this.closeFileHelper(oldDoc);
        }
        this.setActiveDocument(openedDoc);
        this.setProjectChanged(true);
        return openedDoc;
    }

    protected OpenDefinitionsDocument openFileHelper(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        File file = com.getFiles()[0].getCanonicalFile();
        OpenDefinitionsDocument odd = this._openFile(file);
        try {
            File classPath = odd.getSourceRoot();
            this.addDocToClassPath(odd);
            this.setClassPathChanged(true);
        }
        catch (InvalidPackageException e) {
            // empty catch block
        }
        return odd;
    }

    @Override
    public OpenDefinitionsDocument[] openFiles(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        boolean closeUntitled = this._hasOneEmptyDocument();
        OpenDefinitionsDocument oldDoc = this._activeDocument;
        OpenDefinitionsDocument[] openedDocs = this.openFilesHelper(com);
        if (openedDocs.length > 0) {
            if (closeUntitled) {
                this.closeFileHelper(oldDoc);
            }
            this.setActiveDocument(openedDocs[0]);
        }
        return openedDocs;
    }

    protected OpenDefinitionsDocument[] openFilesHelper(FileOpenSelector com) throws IOException, OperationCanceledException, AlreadyOpenException {
        File[] files = com.getFiles();
        if (files == null) {
            throw new IOException("No Files returned from FileSelector");
        }
        OpenDefinitionsDocument[] docs = this._openFiles(files);
        return docs;
    }

    private OpenDefinitionsDocument[] _openFiles(File[] files) throws IOException, OperationCanceledException, AlreadyOpenException {
        ArrayList<OpenDefinitionsDocument> alreadyOpenDocuments = new ArrayList<OpenDefinitionsDocument>();
        ArrayList<OpenDefinitionsDocument> retDocs = new ArrayList<OpenDefinitionsDocument>();
        LinkedList<File> filesNotFound = new LinkedList<File>();
        LinkedList<OpenDefinitionsDocument> filesOpened = new LinkedList<OpenDefinitionsDocument>();
        for (File f : files) {
            if (f == null) {
                throw new IOException("File name returned from FileSelector is null");
            }
            try {
                OpenDefinitionsDocument d = this._rawOpenFile(IOUtil.attemptCanonicalFile(f));
                retDocs.add(d);
                filesOpened.add(d);
            }
            catch (AlreadyOpenException aoe) {
                OpenDefinitionsDocument d = aoe.getOpenDocument();
                retDocs.add(d);
                alreadyOpenDocuments.add(d);
            }
            catch (FileNotFoundException e) {
                filesNotFound.add(f);
            }
        }
        for (OpenDefinitionsDocument d : filesOpened) {
            this._completeOpenFile(d);
        }
        if (filesNotFound.size() > 0) {
            this._notifier.filesNotFound(filesNotFound.toArray(new File[filesNotFound.size()]));
        }
        if (!alreadyOpenDocuments.isEmpty()) {
            for (OpenDefinitionsDocument d : alreadyOpenDocuments) {
                this._notifier.handleAlreadyOpenDocument(d);
                this._notifier.fileOpened(d);
            }
        }
        if (retDocs != null) {
            return retDocs.toArray(new OpenDefinitionsDocument[0]);
        }
        throw new OperationCanceledException();
    }

    @Override
    public void openFolder(File dir, boolean rec) throws IOException, OperationCanceledException, AlreadyOpenException {
        if (dir == null) {
            return;
        }
        if (dir.isDirectory()) {
            String extension = DrJavaRoot.LANGUAGE_LEVEL_EXTENSIONS[DrJava.getConfig().getSetting(LANGUAGE_LEVEL)];
            Predicate<File> match = LambdaUtil.and(IOUtil.IS_FILE, IOUtil.extensionFilePredicate(extension));
            Iterable_ filesIterable = rec ? IOUtil.listFilesRecursively((File)dir, match) : IOUtil.attemptListFilesAsIterable((File)dir, match);
            List files = IterUtil.asList(filesIterable);
            if (this.isProjectActive()) {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return -o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                    }

                    @Override
                    public int compare(Object x0, Object x1) {
                        return this.compare((File)x0, (File)x1);
                    }
                });
            } else {
                Collections.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return -o1.getName().compareTo(o2.getName());
                    }

                    @Override
                    public int compare(Object x0, Object x1) {
                        return this.compare((File)x0, (File)x1);
                    }
                });
            }
            int ct = files.size();
            final File[] sfiles = files.toArray(new File[ct]);
            this.openFiles(new FileOpenSelector(){

                public File[] getFiles() {
                    return sfiles;
                }
            });
            if (ct > 0 && this._state.inProjectPath(dir)) {
                this.setProjectChanged(true);
            }
        }
    }

    @Override
    public void saveAllFiles(FileSaveSelector com) throws IOException {
        OpenDefinitionsDocument curdoc = this.getActiveDocument();
        this.saveAllFilesHelper(com);
        this.setActiveDocument(curdoc);
    }

    protected void saveAllFilesHelper(FileSaveSelector com) throws IOException {
        boolean isProjActive = this.isProjectActive();
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            if (doc.isUntitled() && (isProjActive || !doc.isModifiedSinceSave())) continue;
            this.aboutToSaveFromSaveAll(doc);
            doc.saveFile(com);
        }
    }

    @Override
    public void createNewProject(File projFile) {
        this.setFileGroupingState(new ProjectFileGroupingState(this, projFile));
    }

    @Override
    public void configNewProject() throws IOException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        File projFile = this.getProjectFile();
        ProjectProfile builder = new ProjectProfile(projFile);
        ArrayList<DocFile> srcFileList = new ArrayList<DocFile>();
        LinkedList<DocFile> auxFileList = new LinkedList<DocFile>();
        ArrayList<File> extFileList = new ArrayList<File>();
        File projectRoot = builder.getProjectRoot();
        LinkedList exCp = new LinkedList();
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            DocFile file;
            File f = doc.getFile();
            if (doc.isUntitled()) {
                extFileList.add(f);
                continue;
            }
            if (IOUtil.isMember(f, projectRoot)) {
                file = new DocFile(f);
                file.setPackage(doc.getPackageName());
                builder.addSourceFile(file);
                srcFileList.add(file);
                continue;
            }
            if (doc.isAuxiliaryFile()) {
                file = new DocFile(f);
                file.setPackage(doc.getPackageName());
                builder.addAuxiliaryFile(new DocFile(f));
                auxFileList.add(file);
                continue;
            }
            extFileList.add(f);
        }
        builder.write();
        this._loadProject(builder);
    }

    public ProjectProfile _makeProjectProfile(File file, Hashtable<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        int createJarFlags;
        File createJarFile;
        File mainClass;
        File wd;
        File bd;
        Iterable_ exCp;
        ProjectProfile builder = new ProjectProfile(file);
        File pr = this.getProjectRoot();
        if (pr != null) {
            builder.setProjectRoot(pr);
        }
        ArrayList<File> srcFileList = new ArrayList<File>();
        LinkedList<File> auxFileList = new LinkedList<File>();
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            DocumentInfoGetter g;
            if (doc.inProjectPath()) {
                g = info.get(doc);
                builder.addSourceFile(g);
                srcFileList.add(g.getFile());
                continue;
            }
            if (!doc.isAuxiliaryFile()) continue;
            g = info.get(doc);
            builder.addAuxiliaryFile(g);
            auxFileList.add(g.getFile());
        }
        if (this._documentNavigator instanceof JTreeSortNavigator) {
            String[] paths;
            for (String s : paths = ((JTreeSortNavigator)this._documentNavigator).getCollapsedPaths()) {
                builder.addCollapsedPath(s);
            }
        }
        if ((exCp = this.getExtraClassPath()) != null) {
            Iterator i$ = IterableMethods.iterator(exCp);
            while (i$.hasNext()) {
                File f = (File)i$.next();
                builder.addClassPathFile(f);
            }
        }
        if ((bd = this.getBuildDirectory()) != null) {
            builder.setBuildDirectory(bd);
        }
        if ((wd = this.getWorkingDirectory()) != null) {
            builder.setWorkingDirectory(wd);
        }
        if ((mainClass = this.getMainClass()) != null) {
            builder.setMainClass(mainClass);
        }
        if ((createJarFile = this.getCreateJarFile()) != null) {
            builder.setCreateJarFile(createJarFile);
        }
        if ((createJarFlags = this.getCreateJarFlags()) != 0) {
            builder.setCreateJarFlags(createJarFlags);
        }
        ArrayList<Breakpoint> l = new ArrayList<Breakpoint>();
        for (Breakpoint bp : this.getBreakpointManager().getRegions()) {
            l.add(bp);
        }
        builder.setBreakpoints(l);
        try {
            builder.setWatches(this.getDebugger().getWatches());
        }
        catch (DebugException de) {
            // empty catch block
        }
        builder.setBookmarks(this.getBookmarkManager().getRegions());
        return builder;
    }

    @Override
    public void saveProject(File file, Hashtable<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        ProjectProfile builder = this._makeProjectProfile(file, info);
        builder.write();
        this.setFileGroupingState(this.makeProjectFileGroupingState(builder.getProjectRoot(), builder.getMainClass(), builder.getBuildDirectory(), builder.getWorkingDirectory(), file, builder.getSourceFiles(), builder.getAuxiliaryFiles(), builder.getClassPaths(), builder.getCreateJarFile(), builder.getCreateJarFlags()));
    }

    @Override
    public void reloadProject(File file, Hashtable<OpenDefinitionsDocument, DocumentInfoGetter> info) throws IOException {
        boolean projChanged = this.isProjectChanged();
        ProjectProfile builder = this._makeProjectProfile(file, info);
        this._loadProject(builder);
        this.setProjectChanged(projChanged);
    }

    @Override
    public void openProject(File projectFile) throws IOException, MalformedProjectFileException {
        this._loadProject(ProjectFileParser.ONLY.parse(projectFile));
    }

    private void _loadProject(ProjectFileIR ir) throws IOException {
        List<OpenDefinitionsDocument> projDocs;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        File[] srcFiles = ir.getSourceFiles();
        File[] auxFiles = ir.getAuxiliaryFiles();
        File projectFile = ir.getProjectFile();
        File projectRoot = ir.getProjectRoot();
        File buildDir = ir.getBuildDirectory();
        File workDir = ir.getWorkingDirectory();
        File mainClass = ir.getMainClass();
        Iterable_ projectClassPaths = ir.getClassPaths();
        File createJarFile = ir.getCreateJarFile();
        int createJarFlags = ir.getCreateJarFlags();
        this.getBrowserHistoryManager().clearRegions();
        this.getBreakpointManager().clearRegions();
        for (DebugBreakpointData dbd : ir.getBreakpoints()) {
            try {
                this.getDebugger().toggleBreakpoint(this.getDocumentForFile(dbd.getFile()), dbd.getOffset(), dbd.getLineNumber(), dbd.isEnabled());
            }
            catch (DebugException de) {
                // empty catch block
            }
        }
        try {
            this.getDebugger().removeAllWatches();
        }
        catch (DebugException de) {
            // empty catch block
        }
        for (DebugWatchData dwd : ir.getWatches()) {
            try {
                this.getDebugger().addWatch(dwd.getName());
            }
            catch (DebugException de) {
                // empty catch block
            }
        }
        this.getBookmarkManager().clearRegions();
        for (DocumentRegion bm : ir.getBookmarks()) {
            OpenDefinitionsDocument odd = this.getDocumentForFile(bm.getFile());
            this.getBookmarkManager().addRegion(new SimpleDocumentRegion(odd, odd.getFile(), bm.getStartOffset(), bm.getEndOffset()));
        }
        String projfilepath = projectRoot.getCanonicalPath();
        LinkedList l = new LinkedList();
        l.add(new Pair<String, 10>(this.getSourceBinTitle(), new INavigatorItemFilter<OpenDefinitionsDocument>(){

            @Override
            public boolean accept(OpenDefinitionsDocument d) {
                return d.inProjectPath();
            }

            @Override
            public boolean accept(INavigatorItem x0) {
                return this.accept((OpenDefinitionsDocument)x0);
            }
        }));
        l.add(new Pair<String, 11>(this.getAuxiliaryBinTitle(), new INavigatorItemFilter<OpenDefinitionsDocument>(){

            @Override
            public boolean accept(OpenDefinitionsDocument d) {
                return d.isAuxiliaryFile();
            }

            @Override
            public boolean accept(INavigatorItem x0) {
                return this.accept((OpenDefinitionsDocument)x0);
            }
        }));
        l.add(new Pair<String, 12>(this.getExternalBinTitle(), new INavigatorItemFilter<OpenDefinitionsDocument>(){

            @Override
            public boolean accept(OpenDefinitionsDocument d) {
                return !d.inProject() && !d.isAuxiliaryFile() || d.isUntitled();
            }

            @Override
            public boolean accept(INavigatorItem x0) {
                return this.accept((OpenDefinitionsDocument)x0);
            }
        }));
        IDocumentNavigator<OpenDefinitionsDocument> newNav = new AWTContainerNavigatorFactory<OpenDefinitionsDocument>().makeTreeNavigator(projfilepath, this.getDocumentNavigator(), l);
        this.setDocumentNavigator(newNav);
        this.setFileGroupingState(this.makeProjectFileGroupingState(projectRoot, mainClass, buildDir, workDir, projectFile, srcFiles, auxFiles, projectClassPaths, createJarFile, createJarFlags));
        this.resetInteractions(this.getWorkingDirectory());
        ArrayList<File> projFiles = new ArrayList<File>();
        Object active = null;
        ArrayList<DocumentRegion> expiredBookmarks = new ArrayList<DocumentRegion>();
        ArrayList<Breakpoint> expiredBreakpoints = new ArrayList<Breakpoint>();
        for (File f : srcFiles) {
            if (f.lastModified() > ((DocFile)f).getSavedModDate()) {
                for (DocumentRegion documentRegion : this.getBookmarkManager().getRegions()) {
                    if (!documentRegion.getFile().equals(f)) continue;
                    expiredBookmarks.add(documentRegion);
                }
                for (Breakpoint breakpoint : this.getBreakpointManager().getRegions()) {
                    if (!breakpoint.getFile().equals(f)) continue;
                    expiredBreakpoints.add(breakpoint);
                }
                ((DocFile)f).setSavedModDate(f.lastModified());
            }
            projFiles.add(f);
        }
        for (File f : auxFiles) {
            if (f.lastModified() > ((DocFile)f).getSavedModDate()) {
                for (DocumentRegion documentRegion : this.getBookmarkManager().getRegions()) {
                    if (!documentRegion.getFile().equals(f)) continue;
                    expiredBookmarks.add(documentRegion);
                }
                for (Breakpoint breakpoint : this.getBreakpointManager().getRegions()) {
                    if (!breakpoint.getFile().equals(f)) continue;
                    expiredBreakpoints.add(breakpoint);
                }
                ((DocFile)f).setSavedModDate(f.lastModified());
            }
            projFiles.add(f);
        }
        for (DocumentRegion documentRegion : expiredBookmarks) {
            this.getBookmarkManager().removeRegion(documentRegion);
        }
        for (Breakpoint breakpoint : expiredBreakpoints) {
            this.getBreakpointManager().removeRegion(breakpoint);
        }
        if (active != null) {
            projFiles.add((File)active);
        }
        if (!(projDocs = this.getProjectDocuments()).isEmpty()) {
            for (OpenDefinitionsDocument d : projDocs) {
                try {
                    String path = this.fixPathForNavigator(d.getFile().getCanonicalPath());
                    this._documentNavigator.refreshDocument(d, path);
                }
                catch (IOException e) {}
            }
        }
        final DocFile[] docFileArray = projFiles.toArray(new DocFile[projFiles.size()]);
        this._notifier.projectOpened(projectFile, new FileOpenSelector(){

            public File[] getFiles() {
                return docFileArray;
            }
        });
        if (this._documentNavigator instanceof JTreeSortNavigator) {
            ((JTreeSortNavigator)this._documentNavigator).collapsePaths(ir.getCollapsedPaths());
        }
    }

    @Override
    public void closeProject(boolean suppressReset) {
        this.setDocumentNavigator(new AWTContainerNavigatorFactory<OpenDefinitionsDocument>().makeListNavigator(this.getDocumentNavigator()));
        this.setFileGroupingState(this.makeFlatFileGroupingState());
        if (!suppressReset) {
            this.resetInteractions(this.getWorkingDirectory());
        }
        this._notifier.projectClosed();
    }

    public void aboutToSaveFromSaveAll(OpenDefinitionsDocument doc) {
        if (doc.isUntitled()) {
            this.setActiveDocument(doc);
        }
    }

    @Override
    public boolean closeFile(OpenDefinitionsDocument doc) {
        LinkedList<OpenDefinitionsDocument> list = new LinkedList<OpenDefinitionsDocument>();
        list.add(doc);
        return this.closeFiles(list);
    }

    @Override
    public boolean closeAllFiles() {
        List<OpenDefinitionsDocument> docs = this.getOpenDefinitionsDocuments();
        boolean res = this.closeFiles(docs);
        if (res) {
            this.resetInteractions(this.getWorkingDirectory());
        }
        return res;
    }

    @Override
    public boolean closeFiles(List<OpenDefinitionsDocument> docs) {
        if (docs.size() == 0) {
            return true;
        }
        _log.log(new StringBuffer().append("closeFiles(").append(docs).append(") called").toString());
        for (OpenDefinitionsDocument doc : docs) {
            if (doc.canAbandonFile()) continue;
            return false;
        }
        if (docs.size() == this.getOpenDefinitionsDocumentsSize()) {
            this.newFile();
        }
        this._ensureNotActive(docs);
        for (OpenDefinitionsDocument doc : docs) {
            this.closeFileWithoutPrompt(doc);
        }
        return true;
    }

    protected boolean closeFileHelper(OpenDefinitionsDocument doc) {
        boolean canClose = doc.canAbandonFile();
        if (canClose) {
            return this.closeFileWithoutPrompt(doc);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeFileWithoutPrompt(final OpenDefinitionsDocument doc) {
        boolean found;
        _log.log(new StringBuffer().append("closeFileWithoutPrompt(").append(doc).append(") called; getRawFile() = ").append(doc.getRawFile()).toString());
        _log.log(new StringBuffer().append("_documentsRepos = ").append(this._documentsRepos).toString());
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            found = this._documentsRepos.remove(doc.getRawFile()) != null;
        }
        if (!found) {
            _log.log(new StringBuffer().append("Cannot close ").append(doc).append("; not found!").toString());
            return false;
        }
        doc.getBreakpointManager().clearRegions();
        doc.getBookmarkManager().clearRegions();
        for (RegionManager<MovingDocumentRegion> rm : doc.getFindResultsManagers()) {
            rm.clearRegions();
        }
        doc.getBrowserHistoryManager().clearRegions();
        if (doc.isAuxiliaryFile()) {
            this.removeAuxiliaryFile(doc);
        }
        Utilities.invokeLater(new SRunnable(){

            public void run() {
                AbstractGlobalModel.this._documentNavigator.removeDocument(doc);
            }
        });
        this._notifier.fileClosed(doc);
        doc.close();
        return true;
    }

    @Override
    public boolean closeAllFilesOnQuit() {
        List<OpenDefinitionsDocument> docs = this.getOpenDefinitionsDocuments();
        Object retainedDoc = null;
        for (OpenDefinitionsDocument doc : docs) {
            if (doc.canAbandonFile()) continue;
            return false;
        }
        this.newFile();
        this._ensureNotActive(docs);
        for (OpenDefinitionsDocument doc : docs) {
            this.closeFileWithoutPrompt(doc);
        }
        return true;
    }

    @Override
    public void quit() {
        this.quit(false);
    }

    @Override
    public void forceQuit() {
        this.quit(true);
    }

    private void quit(boolean force) {
        try {
            if (!force && !this.closeAllFilesOnQuit()) {
                return;
            }
            this.shutdown(force);
        }
        catch (Throwable t) {
            this.shutdown(true);
        }
    }

    private void shutdown(boolean force) {
        if (force) {
            Runtime.getRuntime().halt(0);
        }
        this.dispose();
        if (DrJava.getConfig().getSetting(OptionConstants.DRJAVA_USE_FORCE_QUIT).booleanValue()) {
            Runtime.getRuntime().halt(0);
        }
        Thread monitor = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(0);
            }
        });
        monitor.setDaemon(true);
        monitor.start();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            this._documentsRepos.clear();
        }
        Utilities.invokeLater(new SRunnable(){

            public void run() {
                AbstractGlobalModel.this._documentNavigator.clear();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractGlobalModel.this._notifier.removeAllListeners();
            }
        });
    }

    @Override
    public void disposeExternalResources() {
    }

    @Override
    public OpenDefinitionsDocument getDocumentForFile(File file) throws IOException {
        OpenDefinitionsDocument doc = this._getOpenDocument(file);
        if (doc == null) {
            final File f = file;
            FileOpenSelector selector = new FileOpenSelector(){

                public File[] getFiles() {
                    return new File[]{f};
                }
            };
            try {
                doc = this.openFile(selector);
            }
            catch (AlreadyOpenException e) {
                doc = e.getOpenDocument();
            }
            catch (OperationCanceledException e) {
                throw new UnexpectedException(e);
            }
        }
        return doc;
    }

    public boolean isAlreadyOpen(File file) {
        return this._getOpenDocument(file) != null;
    }

    @Override
    public OpenDefinitionsDocument getODDForDocument(AbstractDocumentInterface doc) {
        if (doc instanceof OpenDefinitionsDocument) {
            return (OpenDefinitionsDocument)doc;
        }
        if (doc instanceof DefinitionsDocument) {
            return ((DefinitionsDocument)doc).getOpenDefDoc();
        }
        throw new IllegalStateException(new StringBuffer().append("Could not get the OpenDefinitionsDocument for Document: ").append(doc).toString());
    }

    @Override
    public DocumentIterator getDocumentIterator() {
        return this;
    }

    @Override
    public OpenDefinitionsDocument getNextDocument(OpenDefinitionsDocument d) {
        OpenDefinitionsDocument nextdoc = null;
        OpenDefinitionsDocument doc = this.getODDForDocument(d);
        nextdoc = this._documentNavigator.getNext(doc);
        if (nextdoc == doc) {
            nextdoc = this._documentNavigator.getFirst();
        }
        OpenDefinitionsDocument res = this.getNextDocHelper(nextdoc);
        return res;
    }

    private OpenDefinitionsDocument getNextDocHelper(OpenDefinitionsDocument nextdoc) {
        if (nextdoc.isUntitled() || nextdoc.verifyExists()) {
            return nextdoc;
        }
        return this.getNextDocument(nextdoc);
    }

    @Override
    public OpenDefinitionsDocument getPrevDocument(OpenDefinitionsDocument d) {
        OpenDefinitionsDocument prevdoc = null;
        OpenDefinitionsDocument doc = this.getODDForDocument(d);
        prevdoc = this._documentNavigator.getPrevious(doc);
        if (prevdoc == doc) {
            prevdoc = this._documentNavigator.getLast();
        }
        return this.getPrevDocHelper(prevdoc);
    }

    private OpenDefinitionsDocument getPrevDocHelper(OpenDefinitionsDocument prevdoc) {
        if (prevdoc.isUntitled() || prevdoc.verifyExists()) {
            return prevdoc;
        }
        return this.getPrevDocument(prevdoc);
    }

    @Override
    public int getDocumentCount() {
        return this._documentsRepos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OpenDefinitionsDocument> getOpenDefinitionsDocuments() {
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            ArrayList<OpenDefinitionsDocument> docs = new ArrayList<OpenDefinitionsDocument>(this._documentsRepos.size());
            for (OpenDefinitionsDocument doc : this._documentsRepos.values()) {
                docs.add(doc);
            }
            return docs;
        }
    }

    public List<OpenDefinitionsDocument> getSortedOpenDefinitionsDocuments() {
        return this.getOpenDefinitionsDocuments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenDefinitionsDocumentsSize() {
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            return this._documentsRepos.size();
        }
    }

    @Override
    public boolean hasOutOfSyncDocuments() {
        return this.hasOutOfSyncDocuments(this.getOpenDefinitionsDocuments());
    }

    @Override
    public boolean hasOutOfSyncDocuments(List<OpenDefinitionsDocument> lod) {
        for (OpenDefinitionsDocument doc : lod) {
            if (!doc.isSourceFile() || doc.checkIfClassFileInSync()) continue;
            return true;
        }
        return false;
    }

    void setDefinitionsIndent(int indent) {
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            doc.setIndent(indent);
        }
    }

    @Override
    public void resetInteractions(File wd) {
    }

    @Override
    public void resetInteractions(File wd, boolean forceReset) {
    }

    @Override
    public void resetConsole() {
        this._consoleDoc.reset("");
        this._notifier.consoleReset();
    }

    @Override
    public void interpretCurrentInteraction() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void loadHistory(FileOpenSelector selector) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public InteractionsScriptModel loadHistoryAsScript(FileOpenSelector selector) throws IOException, OperationCanceledException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void clearHistory() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void saveHistory(FileSaveSelector selector) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public String getHistoryAsStringWithSemicolons() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public String getHistoryAsString() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    private void _registerOptionListeners() {
        DrJava.getConfig().addOptionListener(BACKUP_FILES, new BackUpFileOptionListener(null));
        Boolean makeBackups = DrJava.getConfig().getSetting(BACKUP_FILES);
        FileOps.DefaultFileSaver.setBackupsEnabled(makeBackups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _docAppend(ConsoleDocument doc, String s, String style) {
        Object systemWriterLock;
        Object object = systemWriterLock = new Object();
        synchronized (object) {
            try {
                doc.insertBeforeLastPrompt(s, style);
                systemWriterLock.wait(5L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void systemOutPrint(String s) {
        this._docAppend(this._consoleDoc, s, "System.out");
    }

    @Override
    public void systemErrPrint(String s) {
        this._docAppend(this._consoleDoc, s, "System.err");
    }

    @Override
    public void systemInEcho(String s) {
        this._docAppend(this._consoleDoc, s, "System.in");
    }

    @Override
    public void printDebugMessage(String s) {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support debugging");
    }

    @Override
    public void waitForInterpreter() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public Iterable<File> getInteractionsClassPath() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support interactions");
    }

    @Override
    public Iterable<File> getExtraClassPath() {
        return this._state.getExtraClassPath();
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @Override
    public void setExtraClassPath(Iterable_ cp) {
        this._state.setExtraClassPath(cp);
        this.setClassPathChanged(true);
    }

    @Override
    public Iterable<File> getSourceRootSet() {
        LinkedHashSet<File> roots = new LinkedHashSet<File>();
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            try {
                File root;
                if (doc.isUntitled() || (root = doc.getSourceRoot()) == null) continue;
                roots.add(root);
            }
            catch (InvalidPackageException e) {}
        }
        return roots;
    }

    @Override
    public Debugger getDebugger() {
        return NoDebuggerAvailable.ONLY;
    }

    @Override
    public int getDebugPort() throws IOException {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support debugging");
    }

    @Override
    public boolean hasModifiedDocuments() {
        return this.hasModifiedDocuments(this.getOpenDefinitionsDocuments());
    }

    @Override
    public boolean hasModifiedDocuments(List<OpenDefinitionsDocument> lod) {
        for (OpenDefinitionsDocument doc : lod) {
            if (!doc.isModifiedSinceSave()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUntitledDocuments() {
        for (OpenDefinitionsDocument doc : this.getOpenDefinitionsDocuments()) {
            if (!doc.isUntitled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getSourceFile(String fileName) {
        Iterable_ sourceRoots = this.getSourceRootSet();
        Iterator i$ = IterableMethods.iterator(sourceRoots);
        while (i$.hasNext()) {
            File s = (File)i$.next();
            File f = this._getSourceFileFromPath(fileName, s);
            if (f == null) continue;
            return f;
        }
        Vector sourcepath = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.DEBUG_SOURCEPATH));
        return this.findFileInPaths(fileName, (Iterable_)((Object)sourcepath));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @Override
    public File findFileInPaths(String fileName, Iterable_ paths) {
        Iterator i$ = IterableMethods.iterator(paths);
        while (i$.hasNext()) {
            File p = (File)i$.next();
            File f = this._getSourceFileFromPath(fileName, p);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private File _getSourceFileFromPath(String fileName, File path) {
        String root = path.getAbsolutePath();
        File f = new File(new StringBuffer().append(root).append(System.getProperty("file.separator")).append(fileName).toString());
        return f.exists() ? f : null;
    }

    @Override
    public void addToBrowserHistory() {
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        OpenDefinitionsDocument doc = this.getActiveDocument();
        int startPos = 0;
        int endPos = 0;
        File file = null;
        if (doc != null) {
            try {
                startPos = doc.createPosition(doc.getCaretPosition()).getOffset();
                endPos = doc.createPosition(doc.getLineEndPos(doc.getCaretPosition())).getOffset();
                file = doc.getFile();
            }
            catch (FileMovedException fme) {
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            this.getBrowserHistoryManager().addRegion(new SimpleDocumentRegion(doc, file, startPos, endPos));
        }
    }

    @Override
    public Iterable<File> getClassPath() {
        throw new UnsupportedOperationException("AbstractGlobalModel does not support class paths");
    }

    public static boolean isUntitled(File f) {
        return f == null || f instanceof NullFile;
    }

    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(NullFile f) {
        return new ConcreteOpenDefDoc(f);
    }

    protected ConcreteOpenDefDoc _createOpenDefinitionsDocument(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(new StringBuffer().append("file ").append(f).append(" cannot be found").toString());
        }
        return new ConcreteOpenDefDoc(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenDefinitionsDocument _getOpenDocument(File file) {
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            return this._documentsRepos.get(file);
        }
    }

    @Override
    public List<OpenDefinitionsDocument> getNonProjectDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> selectedDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument d : allDocs) {
            if (d.inProjectPath() || d.isAuxiliaryFile()) continue;
            selectedDocs.add(d);
        }
        return selectedDocs;
    }

    public List<OpenDefinitionsDocument> getAuxiliaryDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> selectedDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument d : allDocs) {
            if (!d.isAuxiliaryFile()) continue;
            selectedDocs.add(d);
        }
        return selectedDocs;
    }

    @Override
    public List<OpenDefinitionsDocument> getProjectDocuments() {
        List<OpenDefinitionsDocument> allDocs = this.getOpenDefinitionsDocuments();
        LinkedList<OpenDefinitionsDocument> projectDocs = new LinkedList<OpenDefinitionsDocument>();
        for (OpenDefinitionsDocument d : allDocs) {
            if (!d.inProjectPath() && !d.isAuxiliaryFile()) continue;
            projectDocs.add(d);
        }
        return projectDocs;
    }

    @Override
    public String fixPathForNavigator(String path) throws IOException {
        String rootPath;
        String parent = path.substring(0, path.lastIndexOf(File.separator));
        if (!parent.equals(rootPath = this.getProjectRoot().getCanonicalPath()) && !parent.startsWith(new StringBuffer().append(rootPath).append(File.separator).toString())) {
            return "";
        }
        return parent.substring(rootPath.length());
    }

    private OpenDefinitionsDocument _rawOpenFile(File file) throws IOException, AlreadyOpenException {
        OpenDefinitionsDocument openDoc = this._getOpenDocument(file);
        if (openDoc != null) {
            throw new AlreadyOpenException(openDoc);
        }
        ConcreteOpenDefDoc doc = this._createOpenDefinitionsDocument(file);
        if (file instanceof DocFile) {
            DocFile df = (DocFile)file;
            Pair<Integer, Integer> scroll = df.getScroll();
            Pair<Integer, Integer> sel = df.getSelection();
            String pkg = df.getPackage();
            doc.setPackage(pkg);
            doc.setInitialVScroll(scroll.first());
            doc.setInitialHScroll(scroll.second());
            doc.setInitialSelStart(sel.first());
            doc.setInitialSelEnd(sel.second());
        } else {
            doc.setPackage(doc.getPackageNameFromDocument());
        }
        return doc;
    }

    protected static <T> T pop(ArrayList<T> stack) {
        return stack.remove(stack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDocToNavigator(final OpenDefinitionsDocument doc) {
        Utilities.invokeLater(new SRunnable(){

            public void run() {
                try {
                    if (doc.isUntitled()) {
                        AbstractGlobalModel.this._documentNavigator.addDocument(doc);
                    } else {
                        String path = doc.getFile().getCanonicalPath();
                        AbstractGlobalModel.this._documentNavigator.addDocument(doc, AbstractGlobalModel.this.fixPathForNavigator(path));
                    }
                }
                catch (IOException e) {
                    AbstractGlobalModel.this._documentNavigator.addDocument(doc);
                }
            }
        });
        AbstractMap<File, OpenDefinitionsDocument> abstractMap = this._documentsRepos;
        synchronized (abstractMap) {
            this._documentsRepos.put(doc.getRawFile(), doc);
        }
    }

    protected void addDocToClassPath(OpenDefinitionsDocument doc) {
    }

    public OpenDefinitionsDocument _openFile(File file) throws IOException, AlreadyOpenException {
        OpenDefinitionsDocument doc = this._rawOpenFile(file);
        this._completeOpenFile(doc);
        return doc;
    }

    private void _completeOpenFile(OpenDefinitionsDocument d) {
        this.addDocToNavigator(d);
        this.addDocToClassPath(d);
        try {
            File f = d.getFile();
            if (!this.inProject(f) && this.inProjectPath(d)) {
                this.setProjectChanged(true);
            }
        }
        catch (FileMovedException fileMovedException) {
            // empty catch block
        }
        this._notifier.fileOpened(d);
    }

    @Override
    public OpenDefinitionsDocument getActiveDocument() {
        return this._activeDocument;
    }

    @Override
    public void setActiveDocument(final OpenDefinitionsDocument doc) {
        try {
            Utilities.invokeAndWait(new SRunnable(){

                public void run() {
                    AbstractGlobalModel.this._documentNavigator.setNextChangeModelInitiated(true);
                    AbstractGlobalModel.this.addToBrowserHistory();
                    AbstractGlobalModel.this._documentNavigator.setActiveDoc(doc);
                }
            });
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public Container getDocCollectionWidget() {
        return this._documentNavigator.asContainer();
    }

    @Override
    public void setActiveNextDocument() {
        OpenDefinitionsDocument key = this._activeDocument;
        OpenDefinitionsDocument nextKey = this._documentNavigator.getNext(key);
        if (key != nextKey) {
            this.setActiveDocument(nextKey);
        } else {
            this.setActiveDocument(this._documentNavigator.getFirst());
        }
    }

    @Override
    public void setActivePreviousDocument() {
        OpenDefinitionsDocument key = this._activeDocument;
        OpenDefinitionsDocument prevKey = this._documentNavigator.getPrevious(key);
        if (key != prevKey) {
            this.setActiveDocument(prevKey);
        } else {
            this.setActiveDocument(this._documentNavigator.getLast());
        }
    }

    private boolean _hasOneEmptyDocument() {
        return this.getOpenDefinitionsDocumentsSize() == 1 && this._activeDocument.isUntitled() && !this._activeDocument.isModifiedSinceSave();
    }

    private void _ensureNotEmpty() {
        if (this.getOpenDefinitionsDocumentsSize() == 0) {
            this.newFile(this.getMasterWorkingDirectory());
        }
    }

    private void _ensureNotActive(List<OpenDefinitionsDocument> docs) {
        if (docs.contains(this.getActiveDocument())) {
            OpenDefinitionsDocument item;
            IDocumentNavigator<OpenDefinitionsDocument> nav = this.getDocumentNavigator();
            OpenDefinitionsDocument nextActive = nav.getNext(item = docs.get(docs.size() - 1));
            if (!nextActive.equals(item)) {
                this.setActiveDocument(nextActive);
                return;
            }
            item = docs.get(0);
            nextActive = nav.getPrevious(item);
            if (!nextActive.equals(item)) {
                this.setActiveDocument(nextActive);
                return;
            }
            throw new RuntimeException("No document to set active before closing");
        }
    }

    @Override
    public void setActiveFirstDocument() {
        this.setActiveDocument(this.getOpenDefinitionsDocuments().get(0));
    }

    private void _setActiveDoc(INavigatorItem idoc) {
        try {
            idoc.checkIfClassFileInSync();
        }
        catch (DocumentClosedException documentClosedException) {
            // empty catch block
        }
        this._activeDocument = (OpenDefinitionsDocument)idoc;
        this.installActiveDocument();
    }

    public void installActiveDocument() {
        this._notifier.activeDocumentChanged(this._activeDocument);
    }

    @Override
    public void refreshActiveDocument() {
        this._notifier.activeDocumentRefreshed(this._activeDocument);
    }

    static void access$000(AbstractGlobalModel x0, INavigatorItem x1) {
        x0._setActiveDoc(x1);
    }

    static File access$100(AbstractGlobalModel x0) {
        return x0._activeDirectory;
    }

    static File access$102(AbstractGlobalModel x0, File x1) {
        x0._activeDirectory = x1;
        return x0._activeDirectory;
    }

    static int access$408() {
        return ID_COUNTER++;
    }

    static AbstractMap access$800(AbstractGlobalModel x0) {
        return x0._documentsRepos;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$model$AbstractGlobalModel == null ? (class$edu$rice$cs$drjava$model$AbstractGlobalModel = AbstractGlobalModel.class$("edu.rice.cs.drjava.model.AbstractGlobalModel")) : class$edu$rice$cs$drjava$model$AbstractGlobalModel).desiredAssertionStatus();
        _log = new Log("GlobalModel.txt", false);
        ID_COUNTER = 0;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackUpFileOptionListener
    implements OptionListener<Boolean> {
        private BackUpFileOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oe) {
            Boolean value = (Boolean)oe.value;
            FileOps.DefaultFileSaver.setBackupsEnabled(value);
        }

        BackUpFileOptionListener(1 x0) {
            this();
        }
    }

    private static class TrivialFSS
    implements FileSaveSelector {
        private File _file;

        private TrivialFSS(File file) {
            this._file = file;
        }

        public File getFile() throws OperationCanceledException {
            return this._file;
        }

        public boolean warnFileOpen(File f) {
            return true;
        }

        public boolean verifyOverwrite() {
            return true;
        }

        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            return true;
        }

        TrivialFSS(File x0, 1 x1) {
            this(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConcreteOpenDefDoc
    implements OpenDefinitionsDocument {
        private volatile String _image;
        private volatile File _file;
        private volatile long _timestamp;
        private volatile int _caretPosition;
        private volatile File _parentDir;
        private volatile File _classFile;
        private volatile boolean _classFileInSync = false;
        protected volatile String _packageName = "";
        private volatile DCacheAdapter _cacheAdapter;
        protected final SubsetRegionManager<Breakpoint> _breakpointManager;
        protected final SubsetRegionManager<DocumentRegion> _bookmarkManager;
        protected final LinkedList<SubsetRegionManager<MovingDocumentRegion>> _findResultsManagers;
        protected final SubsetRegionManager<DocumentRegion> _browserHistoryManager;
        private volatile int _initVScroll;
        private volatile int _initHScroll;
        private volatile int _initSelStart;
        private volatile int _initSelEnd;
        private volatile int _id;
        private volatile DrJavaBook _book;
        List<UndoableEditListener> _undoableEditListeners = new LinkedList<UndoableEditListener>();
        static final /* synthetic */ boolean $assertionsDisabled;
        private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$AbstractGlobalModel;

        ConcreteOpenDefDoc(File f) {
            this(f, f.getParentFile(), f.lastModified());
        }

        ConcreteOpenDefDoc(NullFile f) {
            this(f, null, 0L);
        }

        private ConcreteOpenDefDoc(File f, File dir, long stamp) {
            this._file = f;
            this._parentDir = dir;
            this._classFile = null;
            this._timestamp = stamp;
            this._image = null;
            this._id = AbstractGlobalModel.access$408();
            try {
                DDReconstructor ddr = this.makeReconstructor();
                this._cacheAdapter = AbstractGlobalModel.this._cache.register(this, ddr);
            }
            catch (IllegalStateException e) {
                throw new UnexpectedException(e);
            }
            this._breakpointManager = new SubsetRegionManager<Breakpoint>(AbstractGlobalModel.this.getBreakpointManager());
            this._bookmarkManager = new SubsetRegionManager<DocumentRegion>(AbstractGlobalModel.this.getBookmarkManager());
            this._findResultsManagers = new LinkedList();
            for (RegionManager<MovingDocumentRegion> rm : AbstractGlobalModel.this.getFindResultsManagers()) {
                this.addFindResultsManager(rm);
            }
            this._browserHistoryManager = new SubsetRegionManager<DocumentRegion>(AbstractGlobalModel.this.getBrowserHistoryManager());
        }

        @Override
        public File getRawFile() {
            return this._file;
        }

        @Override
        public File getFile() throws FileMovedException {
            File f = this._file;
            if (AbstractGlobalModel.isUntitled(f)) {
                return null;
            }
            if (f.exists()) {
                return f;
            }
            throw new FileMovedException(f, "This document's file has been moved or deleted.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFile(File file) {
            ConcreteOpenDefDoc concreteOpenDefDoc = this;
            synchronized (concreteOpenDefDoc) {
                this._file = file;
                this._timestamp = !AbstractGlobalModel.isUntitled(file) ? file.lastModified() : 0L;
            }
        }

        @Override
        public long getTimestamp() {
            return this._timestamp;
        }

        @Override
        public void setClassFileInSync(boolean inSync) {
            this._classFileInSync = inSync;
        }

        @Override
        public boolean getClassFileInSync() {
            return this._classFileInSync;
        }

        @Override
        public void setCachedClassFile(File classFile) {
            this._classFile = classFile;
        }

        @Override
        public File getCachedClassFile() {
            return this._classFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetModification() {
            ConcreteOpenDefDoc concreteOpenDefDoc = this;
            synchronized (concreteOpenDefDoc) {
                this.getDocument().resetModification();
                File f = this._file;
                if (!AbstractGlobalModel.isUntitled(f)) {
                    this._timestamp = f.lastModified();
                }
            }
        }

        @Override
        public File getParentDirectory() {
            return this._parentDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setParentDirectory(File pd) {
            ConcreteOpenDefDoc concreteOpenDefDoc = this;
            synchronized (concreteOpenDefDoc) {
                if (!AbstractGlobalModel.isUntitled(this._file)) {
                    throw new IllegalArgumentException("The parent directory can only be set for untitled documents");
                }
                this._parentDir = pd;
            }
        }

        @Override
        public int getInitialVerticalScroll() {
            return this._initVScroll;
        }

        @Override
        public int getInitialHorizontalScroll() {
            return this._initHScroll;
        }

        @Override
        public int getInitialSelectionStart() {
            return this._initSelStart;
        }

        @Override
        public int getInitialSelectionEnd() {
            return this._initSelEnd;
        }

        void setInitialVScroll(int i) {
            this._initVScroll = i;
        }

        void setInitialHScroll(int i) {
            this._initHScroll = i;
        }

        void setInitialSelStart(int i) {
            this._initSelStart = i;
        }

        void setInitialSelEnd(int i) {
            this._initSelEnd = i;
        }

        protected DefinitionsDocument getDocument() {
            try {
                return this._cacheAdapter.getDocument();
            }
            catch (IOException ioe) {
                try {
                    AbstractGlobalModel.this._notifier.documentNotFound(this, this._file);
                    final String path = AbstractGlobalModel.this.fixPathForNavigator(this.getFile().getCanonicalFile().getCanonicalPath());
                    Utilities.invokeLater(new SRunnable(){

                        public void run() {
                            AbstractGlobalModel.this._documentNavigator.refreshDocument(ConcreteOpenDefDoc.this, path);
                        }
                    });
                    return this._cacheAdapter.getDocument();
                }
                catch (Throwable t) {
                    throw new UnexpectedException(t);
                }
            }
        }

        @Override
        public String getFirstTopLevelClassName() throws ClassNameNotFoundException {
            return this.getDocument().getFirstTopLevelClassName();
        }

        public String getMainClassName() throws ClassNameNotFoundException {
            return this.getDocument().getMainClassName();
        }

        @Override
        public String getFileName() {
            if (this._file == null) {
                return "(Untitled)";
            }
            return this._file.getName();
        }

        @Override
        public String getName() {
            String fileName = this.getFileName();
            fileName = this.isModifiedSinceSave() ? new StringBuffer().append(fileName).append("*").toString() : new StringBuffer().append(fileName).append("  ").toString();
            return fileName;
        }

        @Override
        public String getCanonicalPath() {
            if (this.isUntitled()) {
                return "(Untitled)";
            }
            return IOUtil.attemptCanonicalFile(this.getRawFile()).getPath();
        }

        @Override
        public String getCompletePath() {
            String path = this.getCanonicalPath();
            if (this.isModifiedSinceSave()) {
                path = new StringBuffer().append(path).append(" *").toString();
            }
            return path;
        }

        @Override
        public File getSourceRoot() throws InvalidPackageException {
            if (this.isUntitled()) {
                throw new InvalidPackageException(-1, "Can not get source root for unsaved file. Please save.");
            }
            try {
                String[] packages = this._packageName.split("\\.");
                if (packages.length == 1 && packages[0].equals("")) {
                    packages = new String[]{};
                }
                File dir = this.getFile().getParentFile();
                for (String p : IterUtil.reverse(IterUtil.asIterable(packages))) {
                    if (dir == null || !dir.getName().equals(p)) {
                        String m = new StringBuffer().append("File is in the wrong directory or is declared part of the wrong package.  Directory name ").append(dir == null ? "(root)" : new StringBuffer().append("'").append(dir.getName()).append("'").toString()).append(" does not match package name '").append(p).append("'.").toString();
                        throw new InvalidPackageException(-1, m);
                    }
                    dir = dir.getParentFile();
                }
                if (dir == null) {
                    throw new InvalidPackageException(-1, "File is in a directory tree with a null root");
                }
                return dir;
            }
            catch (FileMovedException fme) {
                throw new InvalidPackageException(-1, "File has been moved or deleted from its previous location. Please save.");
            }
        }

        @Override
        public String getPackageName() {
            return this._packageName;
        }

        @Override
        public void setPackage(String name) {
            this._packageName = name;
        }

        @Override
        public String getPackageNameFromDocument() {
            return this.getDocument().getPackageName();
        }

        @Override
        public void updateModifiedSinceSave() {
            this.getDocument().updateModifiedSinceSave();
        }

        @Override
        public int id() {
            return this._id;
        }

        @Override
        public Pageable getPageable() throws IllegalStateException {
            return this._book;
        }

        @Override
        public void cleanUpPrintJob() {
            this._book = null;
        }

        @Override
        public boolean inProjectPath() {
            return AbstractGlobalModel.this._state.inProjectPath(this);
        }

        @Override
        public boolean inNewProjectPath(File projRoot) {
            try {
                return !this.isUntitled() && IOUtil.isMember(this.getFile(), projRoot);
            }
            catch (FileMovedException e) {
                return false;
            }
        }

        @Override
        public boolean inProject() {
            return !this.isUntitled() && AbstractGlobalModel.this._state.inProject(this._file);
        }

        @Override
        public boolean isEmpty() {
            return this.getLength() == 0;
        }

        @Override
        public boolean isAuxiliaryFile() {
            return !this.isUntitled() && AbstractGlobalModel.this._state.isAuxiliaryFile(this._file);
        }

        @Override
        public boolean isSourceFile() {
            if (this.isUntitled()) {
                return false;
            }
            String name = this._file.getName();
            for (String ext : CompilerModel.EXTENSIONS) {
                if (!name.endsWith(ext)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isUntitled() {
            return AbstractGlobalModel.isUntitled(this._file);
        }

        public boolean isUntitledAndEmpty() {
            return this.isUntitled() && this.getLength() == 0;
        }

        @Override
        public boolean fileExists() {
            File f = this._file;
            return !AbstractGlobalModel.isUntitled(f) && f.exists();
        }

        @Override
        public boolean verifyExists() {
            if (this.fileExists()) {
                return true;
            }
            try {
                AbstractGlobalModel.this._notifier.documentNotFound(this, this._file);
                File f = this.getFile();
                if (this.isUntitled()) {
                    return false;
                }
                String path = AbstractGlobalModel.this.fixPathForNavigator(this.getFile().getCanonicalPath());
                AbstractGlobalModel.this._documentNavigator.refreshDocument(this, path);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        protected DDReconstructor makeReconstructor() {
            return new DDReconstructor(){
                private volatile int _loc = 0;
                private volatile DocumentListener[] _list = new DocumentListener[0];
                private volatile List<FinalizationListener<DefinitionsDocument>> _finalListeners = new LinkedList<FinalizationListener<DefinitionsDocument>>();
                private volatile WeakHashMap<DefinitionsDocument.WrappedPosition, Integer> _positions = new WeakHashMap();
                static final /* synthetic */ boolean $assertionsDisabled;
                private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$AbstractGlobalModel;

                public String getText() {
                    String image = ConcreteOpenDefDoc.access$500(ConcreteOpenDefDoc.this);
                    if (image != null) {
                        return image;
                    }
                    try {
                        image = FileOps.readFileAsSwingText(ConcreteOpenDefDoc.access$600(ConcreteOpenDefDoc.this));
                    }
                    catch (IOException e) {
                        image = "";
                    }
                    ConcreteOpenDefDoc.access$502(ConcreteOpenDefDoc.this, image);
                    return ConcreteOpenDefDoc.access$500(ConcreteOpenDefDoc.this);
                }

                public DefinitionsDocument make() throws IOException, BadLocationException, FileMovedException {
                    DefinitionsDocument newDefDoc = new DefinitionsDocument(AbstractGlobalModel.this._notifier);
                    newDefDoc.setOpenDefDoc(ConcreteOpenDefDoc.this);
                    String image = this.getText();
                    if (image != null) {
                        AbstractGlobalModel.this._editorKit.read(new StringReader(image), (Document)newDefDoc, 0);
                        newDefDoc.putProperty("__EndOfLine__", StringOps.EOL);
                        _log.log("Reading from image for " + ConcreteOpenDefDoc.access$600(ConcreteOpenDefDoc.this) + " containing " + ConcreteOpenDefDoc.access$500(ConcreteOpenDefDoc.this).length() + " chars");
                    }
                    this._loc = Math.min(this._loc, image.length());
                    this._loc = Math.max(this._loc, 0);
                    newDefDoc.setCurrentLocation(this._loc);
                    DocumentListener[] arr$ = this._list;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        DocumentListener d = arr$[i$];
                        if (!(d instanceof DocumentUIListener)) continue;
                        newDefDoc.addDocumentListener(d);
                    }
                    Iterator<FinalizationListener<DefinitionsDocument>> i$ = this._finalListeners.iterator();
                    while (i$.hasNext()) {
                        FinalizationListener<DefinitionsDocument> l = i$.next();
                        newDefDoc.addFinalizationListener(l);
                    }
                    newDefDoc.setWrappedPositionOffsets(this._positions);
                    newDefDoc.resetModification();
                    if (!$assertionsDisabled && newDefDoc.isModifiedSinceSave()) {
                        throw new AssertionError();
                    }
                    ConcreteOpenDefDoc.this._packageName = newDefDoc.getPackageName();
                    return newDefDoc;
                }

                public void saveDocInfo(DefinitionsDocument doc) {
                    String text = doc.getText();
                    if (text.length() > 0) {
                        ConcreteOpenDefDoc.access$502(ConcreteOpenDefDoc.this, text);
                    }
                    this._loc = doc.getCurrentLocation();
                    this._list = doc.getDocumentListeners();
                    this._finalListeners = doc.getFinalizationListeners();
                    this._positions.clear();
                    this._positions = doc.getWrappedPositionOffsets();
                }

                public void addDocumentListener(DocumentListener dl) {
                    ArrayList<DocumentListener> tmp = new ArrayList<DocumentListener>();
                    DocumentListener[] arr$ = this._list;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        DocumentListener l = arr$[i$];
                        if (dl == l) continue;
                        tmp.add(l);
                    }
                    tmp.add(dl);
                    this._list = tmp.toArray(new DocumentListener[tmp.size()]);
                }

                public String toString() {
                    return ConcreteOpenDefDoc.this.toString();
                }

                static {
                    $assertionsDisabled = !(class$edu$rice$cs$drjava$model$AbstractGlobalModel == null ? (class$edu$rice$cs$drjava$model$AbstractGlobalModel = 2.class$("edu.rice.cs.drjava.model.AbstractGlobalModel")) : class$edu$rice$cs$drjava$model$AbstractGlobalModel).desiredAssertionStatus();
                }

                static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                        try {
                            noClassDefFoundError.initCause(classNotFoundException);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        throw noClassDefFoundError;
                    }
                    return clazz;
                }
            };
        }

        @Override
        public boolean saveFile(FileSaveSelector com) throws IOException {
            if (!this.isModifiedSinceSave()) {
                return true;
            }
            if (this.isUntitled()) {
                return this.saveFileAs(com);
            }
            this._packageName = this.getDocument().getPackageName();
            FileSaveSelector realCommand = com;
            try {
                File file = this.getFile();
                if (!this.isUntitled()) {
                    realCommand = new TrivialFSS(file, null);
                }
            }
            catch (FileMovedException fme) {
                if (com.shouldSaveAfterFileMoved(this, fme.getFile())) {
                    realCommand = com;
                }
                return false;
            }
            return this.saveFileAs(realCommand);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean saveFileAs(FileSaveSelector com) throws IOException {
            this._packageName = this.getDocument().getPackageName();
            try {
                boolean shouldOverwrite;
                boolean openInOtherDoc;
                ConcreteOpenDefDoc openDoc = this;
                File file = com.getFile().getCanonicalFile();
                _log.log(new StringBuffer().append("saveFileAs called on ").append(file).toString());
                OpenDefinitionsDocument otherDoc = AbstractGlobalModel.this._getOpenDocument(file);
                boolean bl = openInOtherDoc = otherDoc != null && openDoc != otherDoc;
                if (openInOtherDoc && !(shouldOverwrite = com.warnFileOpen(file))) {
                    return true;
                }
                if (!file.exists() || com.verifyOverwrite()) {
                    if (!file.getCanonicalFile().getName().equals(file.getName())) {
                        file.renameTo(file);
                    }
                    if (file.getAbsolutePath().indexOf("#") != -1) {
                        AbstractGlobalModel.this._notifier.filePathContainsPound();
                    }
                    FileOps.saveFile(new FileOps.DefaultFileSaver(file){

                        public void saveTo(OutputStream os) throws IOException {
                            DefinitionsDocument dd = ConcreteOpenDefDoc.this.getDocument();
                            try {
                                AbstractGlobalModel.this._editorKit.write(os, (Document)dd, 0, dd.getLength());
                            }
                            catch (BadLocationException docFailed) {
                                throw new UnexpectedException(docFailed);
                            }
                        }
                    });
                    this.resetModification();
                    AbstractMap abstractMap = AbstractGlobalModel.access$800(AbstractGlobalModel.this);
                    synchronized (abstractMap) {
                        File f = this.getRawFile();
                        AbstractGlobalModel.access$800(AbstractGlobalModel.this).remove(f);
                        AbstractGlobalModel.access$800(AbstractGlobalModel.this).put(file, this);
                    }
                    this.setFile(file);
                    this.setCachedClassFile(null);
                    this.checkIfClassFileInSync();
                    AbstractGlobalModel.this._notifier.fileSaved(openDoc);
                    AbstractGlobalModel.this.addDocToClassPath(this);
                    AbstractGlobalModel.this._documentNavigator.refreshDocument(this, AbstractGlobalModel.this.fixPathForNavigator(file.getCanonicalPath()));
                    AbstractGlobalModel.this.setProjectChanged(true);
                }
                return true;
            }
            catch (OperationCanceledException oce) {
                return false;
            }
        }

        @Override
        public void preparePrintJob() throws BadLocationException, FileMovedException {
            String fileName = "(Untitled)";
            File sourceFile = this.getFile();
            if (!AbstractGlobalModel.isUntitled(sourceFile)) {
                fileName = sourceFile.getAbsolutePath();
            }
            this._book = new DrJavaBook(this.getDocument().getText(), fileName, AbstractGlobalModel.this._pageFormat);
        }

        @Override
        public void print() throws PrinterException, BadLocationException, FileMovedException {
            this.preparePrintJob();
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPageable(this._book);
            if (printJob.printDialog()) {
                printJob.print();
            }
            this.cleanUpPrintJob();
        }

        @Override
        public void startCompile() throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support compilation");
        }

        @Override
        public void runMain() throws IOException, ClassNameNotFoundException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support running");
        }

        @Override
        public void startJUnit() throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support unit testing");
        }

        @Override
        public void generateJavadoc(FileSaveSelector saver) throws IOException {
            throw new UnsupportedOperationException("AbstractGlobalModel does not support javadoc");
        }

        @Override
        public boolean isReady() {
            return this._cacheAdapter != null && this._cacheAdapter.isReady();
        }

        @Override
        public boolean isModifiedSinceSave() {
            if (this.isReady()) {
                return this.getDocument().isModifiedSinceSave();
            }
            return false;
        }

        @Override
        public void documentSaved() {
            this._cacheAdapter.documentSaved();
        }

        @Override
        public void documentModified() {
            this._cacheAdapter.documentModified();
            this._classFileInSync = false;
        }

        @Override
        public void documentReset() {
            this._cacheAdapter.documentReset();
        }

        @Override
        public boolean modifiedOnDisk() {
            boolean ret = false;
            File f = this._file;
            if (!AbstractGlobalModel.isUntitled(f)) {
                ret = f.lastModified() > this._timestamp;
            }
            return ret;
        }

        @Override
        public boolean checkIfClassFileInSync() {
            File sourceFile;
            _log.log(new StringBuffer().append("checkIfClassFileInSync() called for ").append(this).toString());
            if (this.isEmpty()) {
                return true;
            }
            if (this.isModifiedSinceSave()) {
                this.setClassFileInSync(false);
                return false;
            }
            File classFile = this.getCachedClassFile();
            if (classFile == null) {
                classFile = this._locateClassFile();
                this.setCachedClassFile(classFile);
                if (classFile == null || !classFile.exists()) {
                    this.setClassFileInSync(false);
                    return false;
                }
            }
            try {
                sourceFile = this.getFile();
            }
            catch (FileMovedException fme) {
                this.setClassFileInSync(false);
                return false;
            }
            if (sourceFile != null) {
                _log.log(new StringBuffer().append(sourceFile).append(" has timestamp ").append(sourceFile.lastModified()).toString());
                _log.log(new StringBuffer().append(classFile).append(" has timestamp ").append(classFile.lastModified()).toString());
            }
            if (sourceFile == null || sourceFile.lastModified() > classFile.lastModified()) {
                this.setClassFileInSync(false);
                return false;
            }
            this.setClassFileInSync(true);
            return true;
        }

        private File _locateClassFile() {
            ArrayList<File> roots;
            String fileName;
            block12: {
                String className;
                if (this.isUntitled()) {
                    return null;
                }
                try {
                    className = this.getDocument().getQualifiedClassName();
                }
                catch (ClassNameNotFoundException cnnfe) {
                    _log.log(new StringBuffer().append("_locateClassFile() failed for ").append(this).append(" because getQualifedClassName returned ClassNotFound").toString());
                    return null;
                }
                _log.log(new StringBuffer().append("In _locateClassFile, className = ").append(className).toString());
                String ps = System.getProperty("file.separator");
                className = StringOps.replace(className, ".", ps);
                fileName = new StringBuffer().append(className).append(".class").toString();
                _log.log(new StringBuffer().append("In _locateClassFile, classfileName = ").append(fileName).toString());
                roots = new ArrayList<File>();
                if (AbstractGlobalModel.this.getBuildDirectory() != null) {
                    roots.add(AbstractGlobalModel.this.getBuildDirectory());
                }
                try {
                    File root = this.getSourceRoot();
                    _log.log(new StringBuffer().append("Directory ").append(root).append(" added to list of source roots").toString());
                    roots.add(root);
                }
                catch (InvalidPackageException ipe) {
                    try {
                        _log.log(new StringBuffer().append(this).append(" has no source root, using parent directory instead").toString());
                        File root = this.getFile().getParentFile();
                        if (root != null) {
                            roots.add(root);
                            _log.log(new StringBuffer().append("Added parent directory ").append(root).append(" to list of source roots").toString());
                        }
                    }
                    catch (NullPointerException e) {
                        throw new UnexpectedException(e);
                    }
                    catch (FileMovedException fme) {
                        _log.log(new StringBuffer().append("File for ").append(this).append("has moved; adding parent directory to list of roots").toString());
                        File root = fme.getFile().getParentFile();
                        if (root == null) break block12;
                        roots.add(root);
                    }
                }
            }
            File classFile = AbstractGlobalModel.this.findFileInPaths(fileName, (Iterable_)((Object)roots));
            if (classFile != null) {
                _log.log(new StringBuffer().append("Found source file ").append(classFile).append(" for ").append(this).toString());
                return classFile;
            }
            _log.log(new StringBuffer().append(this).append(" not found on path of source roots").toString());
            classFile = AbstractGlobalModel.this.findFileInPaths(fileName, (Iterable_)((Object)GlobalModel.RUNTIME_CLASS_PATH));
            if (classFile != null) {
                return classFile;
            }
            Vector cpSetting = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTRA_CLASSPATH));
            return AbstractGlobalModel.this.findFileInPaths(fileName, (Iterable_)((Object)cpSetting));
        }

        @Override
        public boolean revertIfModifiedOnDisk() throws IOException {
            ConcreteOpenDefDoc doc = this;
            if (this.modifiedOnDisk()) {
                boolean shouldRevert = AbstractGlobalModel.this._notifier.shouldRevertFile(doc);
                if (shouldRevert) {
                    doc.revertFile();
                }
                return shouldRevert;
            }
            return false;
        }

        @Override
        public void close() {
            this.removeFromDebugger();
            this._cacheAdapter.close();
        }

        @Override
        public void revertFile() throws IOException {
            ConcreteOpenDefDoc doc = this;
            this.removeFromDebugger();
            doc.getBreakpointManager().clearRegions();
            doc.getBookmarkManager().clearRegions();
            for (RegionManager<MovingDocumentRegion> rm : doc.getFindResultsManagers()) {
                rm.clearRegions();
            }
            doc.getBrowserHistoryManager().clearRegions();
            if (doc.isUntitled()) {
                throw new UnexpectedException("Cannot revert an Untitled file!");
            }
            try {
                File file = doc.getFile();
                FileReader reader = new FileReader(file);
                doc.clear();
                AbstractGlobalModel.this._editorKit.read(reader, (Document)doc, 0);
                reader.close();
                this.resetModification();
                doc.checkIfClassFileInSync();
                this.setCurrentLocation(0);
                AbstractGlobalModel.this._notifier.fileReverted(doc);
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
        }

        @Override
        public boolean canAbandonFile() {
            if (this.isUntitledAndEmpty()) {
                return true;
            }
            File f = this._file;
            if (this.isModifiedSinceSave() || !AbstractGlobalModel.isUntitled(f) && !f.exists() && this._cacheAdapter.isReady()) {
                return AbstractGlobalModel.this._notifier.canAbandonFile(this);
            }
            return true;
        }

        @Override
        public boolean quitFile() {
            if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                throw new AssertionError();
            }
            File f = this._file;
            if (this.isModifiedSinceSave() || f != null && !f.exists() && this._cacheAdapter.isReady()) {
                return AbstractGlobalModel.this._notifier.quitFile(this);
            }
            return true;
        }

        @Override
        public int gotoLine(int line) {
            DefinitionsDocument dd = this.getDocument();
            int offset = this.getOffsetOfLine(line - 1);
            this.setCurrentLocation(offset);
            return offset;
        }

        @Override
        public void setCurrentLocation(int location) {
            this._caretPosition = location;
            this.getDocument().setCurrentLocation(location);
        }

        @Override
        public int getCurrentLocation() {
            return this.getDocument().getCurrentLocation();
        }

        @Override
        public int getCaretPosition() {
            return this._caretPosition;
        }

        @Override
        public int balanceBackward() {
            return this.getDocument().balanceBackward();
        }

        @Override
        public int balanceForward() {
            return this.getDocument().balanceForward();
        }

        @Override
        public RegionManager<Breakpoint> getBreakpointManager() {
            return this._breakpointManager;
        }

        @Override
        public RegionManager<DocumentRegion> getBookmarkManager() {
            return this._bookmarkManager;
        }

        @Override
        public List<RegionManager<MovingDocumentRegion>> getFindResultsManagers() {
            LinkedList<RegionManager<MovingDocumentRegion>> newList = new LinkedList<RegionManager<MovingDocumentRegion>>();
            for (SubsetRegionManager subsetRegionManager : this._findResultsManagers) {
                newList.add(subsetRegionManager);
            }
            return newList;
        }

        @Override
        public void addFindResultsManager(RegionManager<MovingDocumentRegion> rm) {
            this._findResultsManagers.add(new SubsetRegionManager<MovingDocumentRegion>(rm));
        }

        @Override
        public void removeFindResultsManager(RegionManager<MovingDocumentRegion> rm) {
            for (SubsetRegionManager subsetRegionManager : this._findResultsManagers) {
                if (!subsetRegionManager.getSuperSetManager().equals(rm)) continue;
                this._findResultsManagers.remove(subsetRegionManager);
                break;
            }
        }

        @Override
        public RegionManager<DocumentRegion> getBrowserHistoryManager() {
            return this._browserHistoryManager;
        }

        @Override
        public void removeFromDebugger() {
        }

        public String toString() {
            return this.getFileName();
        }

        @Override
        public int compareTo(OpenDefinitionsDocument o) {
            return this._id - o.id();
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            if (this._cacheAdapter.isReady()) {
                this.getDocument().addDocumentListener(listener);
            } else {
                this._cacheAdapter.addDocumentListener(listener);
            }
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this._undoableEditListeners.add(listener);
            this.getDocument().addUndoableEditListener(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this._undoableEditListeners.remove(listener);
            this.getDocument().removeUndoableEditListener(listener);
        }

        @Override
        public UndoableEditListener[] getUndoableEditListeners() {
            return this.getDocument().getUndoableEditListeners();
        }

        @Override
        public Position createUnwrappedPosition(int offs) throws BadLocationException {
            return this.getDocument().createUnwrappedPosition(offs);
        }

        @Override
        public Position createPosition(int offs) throws BadLocationException {
            return this.getDocument().createPosition(offs);
        }

        @Override
        public Element getDefaultRootElement() {
            return this.getDocument().getDefaultRootElement();
        }

        @Override
        public Position getEndPosition() {
            return this.getDocument().getEndPosition();
        }

        @Override
        public int getLength() {
            return this._cacheAdapter.getLength();
        }

        @Override
        public Object getProperty(Object key) {
            return this.getDocument().getProperty(key);
        }

        @Override
        public Element[] getRootElements() {
            return this.getDocument().getRootElements();
        }

        @Override
        public Position getStartPosition() {
            return this.getDocument().getStartPosition();
        }

        @Override
        public String getText() {
            return this._cacheAdapter.getText();
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this._cacheAdapter.getText(offset, length);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            this.getDocument().getText(offset, length, txt);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.getDocument().insertString(offset, str, a);
        }

        @Override
        public void append(String str, AttributeSet set) {
            this.getDocument().append(str, set);
        }

        public void append(String str, Style style) {
            this.getDocument().append(str, style);
        }

        @Override
        public void putProperty(Object key, Object value) {
            this.getDocument().putProperty(key, value);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            this.getDocument().remove(offs, len);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.getDocument().removeDocumentListener(listener);
        }

        @Override
        public void render(Runnable r) {
            this.getDocument().render(r);
        }

        @Override
        public boolean undoManagerCanUndo() {
            return this._cacheAdapter.isReady() && this.getUndoManager().canUndo();
        }

        @Override
        public boolean undoManagerCanRedo() {
            return this._cacheAdapter.isReady() && this.getUndoManager().canRedo();
        }

        @Override
        public CompoundUndoManager getUndoManager() {
            return this.getDocument().getUndoManager();
        }

        @Override
        public int getLineStartPos(int pos) {
            return this.getDocument().getLineStartPos(pos);
        }

        @Override
        public int getLineEndPos(int pos) {
            return this.getDocument().getLineEndPos(pos);
        }

        @Override
        public int commentLines(int selStart, int selEnd) {
            return this.getDocument().commentLines(selStart, selEnd);
        }

        @Override
        public int uncommentLines(int selStart, int selEnd) {
            return this.getDocument().uncommentLines(selStart, selEnd);
        }

        @Override
        public void indentLines(int selStart, int selEnd) {
            this.getDocument().indentLines(selStart, selEnd);
        }

        @Override
        public int getCurrentLine() {
            return this.getDocument().getCurrentLine();
        }

        @Override
        public int getCurrentCol() {
            return this.getDocument().getCurrentCol();
        }

        @Override
        public int getIntelligentBeginLinePos(int currPos) throws BadLocationException {
            return this.getDocument().getIntelligentBeginLinePos(currPos);
        }

        @Override
        public int getOffset(int lineNum) {
            return this.getDocument().getOffset(lineNum);
        }

        @Override
        public String getQualifiedClassName() throws ClassNameNotFoundException {
            return this.getDocument().getQualifiedClassName();
        }

        @Override
        public String getQualifiedClassName(int pos) throws ClassNameNotFoundException {
            return this.getDocument().getQualifiedClassName(pos);
        }

        @Override
        public ReducedModelState getStateAtCurrent() {
            return this.getDocument().getStateAtCurrent();
        }

        @Override
        public void resetUndoManager() {
            if (this._cacheAdapter.isReady()) {
                this.getDocument().resetUndoManager();
            }
        }

        @Override
        public DocumentListener[] getDocumentListeners() {
            return this.getDocument().getDocumentListeners();
        }

        @Override
        public void setTab(String tab, int pos) {
            this.getDocument().setTab(tab, pos);
        }

        @Override
        public int getWhiteSpace() {
            return this.getDocument().getWhiteSpace();
        }

        @Override
        public boolean posInParenPhrase(int pos) {
            return this.getDocument().posInParenPhrase(pos);
        }

        @Override
        public boolean posInParenPhrase() {
            return this.getDocument().posInParenPhrase();
        }

        @Override
        public String getEnclosingClassName(int pos, boolean fullyQualified) throws BadLocationException, ClassNameNotFoundException {
            return this.getDocument().getEnclosingClassName(pos, fullyQualified);
        }

        @Override
        public int findPrevEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
            return this.getDocument().findPrevEnclosingBrace(pos, opening, closing);
        }

        @Override
        public int findNextEnclosingBrace(int pos, char opening, char closing) throws BadLocationException {
            return this.getDocument().findNextEnclosingBrace(pos, opening, closing);
        }

        @Override
        public int findPrevNonWSCharPos(int pos) throws BadLocationException {
            return this.getDocument().findPrevNonWSCharPos(pos);
        }

        @Override
        public int getFirstNonWSCharPos(int pos) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos);
        }

        @Override
        public int getFirstNonWSCharPos(int pos, boolean acceptComments) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos, acceptComments);
        }

        @Override
        public int getFirstNonWSCharPos(int pos, char[] whitespace, boolean acceptComments) throws BadLocationException {
            return this.getDocument().getFirstNonWSCharPos(pos, whitespace, acceptComments);
        }

        @Override
        public int getLineFirstCharPos(int pos) throws BadLocationException {
            return this.getDocument().getLineFirstCharPos(pos);
        }

        @Override
        public int findCharOnLine(int pos, char findChar) {
            return this.getDocument().findCharOnLine(pos, findChar);
        }

        @Override
        public String getIndentOfCurrStmt(int pos) throws BadLocationException {
            return this.getDocument().getIndentOfCurrStmt(pos);
        }

        @Override
        public String getIndentOfCurrStmt(int pos, char[] delims) throws BadLocationException {
            return this.getDocument().getIndentOfCurrStmt(pos, delims);
        }

        @Override
        public String getIndentOfCurrStmt(int pos, char[] delims, char[] whitespace) throws BadLocationException {
            return this.getDocument().getIndentOfCurrStmt(pos, delims, whitespace);
        }

        @Override
        public void indentLines(int selStart, int selEnd, Indenter.IndentReason reason, ProgressMonitor pm) throws OperationCanceledException {
            this.getDocument().indentLines(selStart, selEnd, reason, pm);
        }

        @Override
        public int findPrevCharPos(int pos, char[] whitespace) throws BadLocationException {
            return this.getDocument().findPrevCharPos(pos, whitespace);
        }

        @Override
        public boolean findCharInStmtBeforePos(char findChar, int position) {
            return this.getDocument().findCharInStmtBeforePos(findChar, position);
        }

        @Override
        public int findPrevDelimiter(int pos, char[] delims) throws BadLocationException {
            return this.getDocument().findPrevDelimiter(pos, delims);
        }

        @Override
        public int findPrevDelimiter(int pos, char[] delims, boolean skipParenPhrases) throws BadLocationException {
            return this.getDocument().findPrevDelimiter(pos, delims, skipParenPhrases);
        }

        @Override
        public void resetReducedModelLocation() {
            this.getDocument().resetReducedModelLocation();
        }

        @Override
        public ReducedModelState stateAtRelLocation(int dist) {
            return this.getDocument().stateAtRelLocation(dist);
        }

        @Override
        public IndentInfo getIndentInformation() {
            return this.getDocument().getIndentInformation();
        }

        @Override
        public void move(int dist) {
            this.getDocument().move(dist);
        }

        @Override
        public Vector<HighlightStatus> getHighlightStatus(int start, int end) {
            return this.getDocument().getHighlightStatus(start, end);
        }

        @Override
        public void setIndent(int indent) {
            this.getDocument().setIndent(indent);
        }

        @Override
        public int getIndent() {
            return this.getDocument().getIndent();
        }

        @Override
        public void addFinalizationListener(FinalizationListener<DefinitionsDocument> fl) {
            this.getDocument().addFinalizationListener(fl);
        }

        @Override
        public List<FinalizationListener<DefinitionsDocument>> getFinalizationListeners() {
            return this.getDocument().getFinalizationListeners();
        }

        @Override
        public Font getFont(AttributeSet attr) {
            return this.getDocument().getFont(attr);
        }

        @Override
        public Color getBackground(AttributeSet attr) {
            return this.getDocument().getBackground(attr);
        }

        @Override
        public Color getForeground(AttributeSet attr) {
            return this.getDocument().getForeground(attr);
        }

        @Override
        public Element getCharacterElement(int pos) {
            return this.getDocument().getCharacterElement(pos);
        }

        @Override
        public Element getParagraphElement(int pos) {
            return this.getDocument().getParagraphElement(pos);
        }

        @Override
        public Style getLogicalStyle(int p) {
            return this.getDocument().getLogicalStyle(p);
        }

        @Override
        public void setLogicalStyle(int pos, Style s) {
            this.getDocument().setLogicalStyle(pos, s);
        }

        @Override
        public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
            this.getDocument().setCharacterAttributes(offset, length, s, replace);
        }

        @Override
        public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
            this.getDocument().setParagraphAttributes(offset, length, s, replace);
        }

        @Override
        public Style getStyle(String nm) {
            return this.getDocument().getStyle(nm);
        }

        @Override
        public void removeStyle(String nm) {
            this.getDocument().removeStyle(nm);
        }

        @Override
        public Style addStyle(String nm, Style parent) {
            return this.getDocument().addStyle(nm, parent);
        }

        @Override
        public void clear() {
            this.getDocument().clear();
        }

        @Override
        public void acquireReadLock() {
            this.getDocument().acquireReadLock();
        }

        @Override
        public void releaseReadLock() {
            this.getDocument().releaseReadLock();
        }

        @Override
        public void acquireWriteLock() {
            this.getDocument().acquireWriteLock();
        }

        @Override
        public void releaseWriteLock() {
            this.getDocument().releaseWriteLock();
        }

        @Override
        public int getNumberOfLines() {
            return this.getLineOfOffset(this.getLength());
        }

        @Override
        public int getLineOfOffset(int offset) {
            return this.getDefaultRootElement().getElementIndex(offset);
        }

        @Override
        public int getOffsetOfLine(int line) {
            int count = this.getDefaultRootElement().getElementCount();
            if (line >= count) {
                line = count - 1;
            }
            return this.getDefaultRootElement().getElement(line).getStartOffset();
        }

        @Override
        public int compareTo(Object x0) {
            return this.compareTo((OpenDefinitionsDocument)x0);
        }

        static String access$500(ConcreteOpenDefDoc x0) {
            return x0._image;
        }

        static File access$600(ConcreteOpenDefDoc x0) {
            return x0._file;
        }

        static String access$502(ConcreteOpenDefDoc x0, String x1) {
            x0._image = x1;
            return x0._image;
        }

        static {
            $assertionsDisabled = !(class$edu$rice$cs$drjava$model$AbstractGlobalModel == null ? (class$edu$rice$cs$drjava$model$AbstractGlobalModel = ConcreteOpenDefDoc.class$("edu.rice.cs.drjava.model.AbstractGlobalModel")) : class$edu$rice$cs$drjava$model$AbstractGlobalModel).desiredAssertionStatus();
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class SubsetRegionManager<R extends DocumentRegion>
        extends EventNotifier<RegionManagerListener<R>>
        implements RegionManager<R> {
            private volatile RegionManager<R> _superSetManager;
            protected final LinkedList<FilteredRegionManagerListener<R>> _filters = new LinkedList();
            protected final ReaderWriterLock _lock = new ReaderWriterLock();

            public SubsetRegionManager(RegionManager<R> ssm) {
                this._superSetManager = ssm;
            }

            public RegionManager<R> getSuperSetManager() {
                return this._superSetManager;
            }

            @Override
            public R getRegionAt(OpenDefinitionsDocument odd, int offset) {
                return this._superSetManager.getRegionAt(odd, offset);
            }

            @Override
            public R getRegionOverlapping(OpenDefinitionsDocument odd, int startOffset, int endOffset) {
                return this._superSetManager.getRegionOverlapping(odd, startOffset, endOffset);
            }

            @Override
            public void addRegion(R region) {
                this._superSetManager.addRegion(region);
            }

            @Override
            public void removeRegion(R region) {
                this._superSetManager.removeRegion(region);
            }

            @Override
            public Vector<R> getRegions() {
                Vector<DocumentRegion> accum = new Vector<DocumentRegion>();
                Vector<R> regions = this._superSetManager.getRegions();
                for (DocumentRegion r : regions) {
                    if (!r.getDocument().equals(ConcreteOpenDefDoc.this)) continue;
                    accum.add(r);
                }
                return accum;
            }

            @Override
            public void clearRegions() {
                Vector<R> regions = this.getRegions();
                for (DocumentRegion r : regions) {
                    this._superSetManager.removeRegion(r);
                }
            }

            @Override
            public void changeRegion(R region, Lambda<Object, R> cmd) {
                this._superSetManager.changeRegion(region, cmd);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListener(RegionManagerListener<R> listener) {
                FilteredRegionManagerListener<R> filter = new FilteredRegionManagerListener<R>(listener);
                this._lock.startWrite();
                try {
                    this._filters.add(filter);
                }
                finally {
                    this._lock.endWrite();
                    this._superSetManager.addListener(filter);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(RegionManagerListener<R> listener) {
                this._lock.startWrite();
                try {
                    for (FilteredRegionManagerListener filteredRegionManagerListener : this._filters) {
                        if (!filteredRegionManagerListener.getDecoree().equals(listener)) continue;
                        this._listeners.remove(filteredRegionManagerListener);
                        this._superSetManager.removeListener(filteredRegionManagerListener);
                    }
                }
                finally {
                    this._lock.endWrite();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllListeners() {
                this._lock.startWrite();
                try {
                    for (FilteredRegionManagerListener filteredRegionManagerListener : this._filters) {
                        this._listeners.remove(filteredRegionManagerListener);
                        this._superSetManager.removeListener(filteredRegionManagerListener);
                    }
                }
                finally {
                    this._lock.endWrite();
                }
            }

            @Override
            public R getCurrentRegion() {
                throw new UnsupportedOperationException("SubsetRegionManager.getCurrentRegion not supported");
            }

            @Override
            public int getCurrentRegionIndex() {
                throw new UnsupportedOperationException("SubsetRegionManager.getCurrentRegionIndex not supported");
            }

            @Override
            public void setCurrentRegion(R region) {
                throw new UnsupportedOperationException("SubsetRegionManager.setCurrentRegion not supported");
            }

            @Override
            public R nextCurrentRegion() {
                throw new UnsupportedOperationException("SubsetRegionManager.nextCurrentRegion not supported");
            }

            @Override
            public R prevCurrentRegion() {
                throw new UnsupportedOperationException("SubsetRegionManager.prevCurrentRegion not supported");
            }

            @Override
            public boolean isCurrentRegionFirst() {
                throw new UnsupportedOperationException("SubsetRegionManager.isCurrentRegionFirst not supported");
            }

            @Override
            public boolean isCurrentRegionLast() {
                throw new UnsupportedOperationException("SubsetRegionManager.isCurrentRegionLast not supported");
            }

            @Override
            public void setMaximumSize(int size) {
                throw new UnsupportedOperationException("SubsetRegionManager.setMaximumSize not supported");
            }

            @Override
            public int getMaximumSize() {
                throw new UnsupportedOperationException("SubsetRegionManager.getMaximumSize not supported");
            }

            @Override
            public void removeListener(Object x0) {
                this.removeListener((RegionManagerListener)x0);
            }

            @Override
            public void addListener(Object x0) {
                this.addListener((RegionManagerListener)x0);
            }

            /*
             * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private class FilteredRegionManagerListener<R extends DocumentRegion>
            implements RegionManagerListener<R> {
                private RegionManagerListener<R> _decoree;

                public FilteredRegionManagerListener(RegionManagerListener<R> d) {
                    this._decoree = d;
                }

                public RegionManagerListener<R> getDecoree() {
                    return this._decoree;
                }

                @Override
                public void regionAdded(R r, int index) {
                    if (r.getDocument().equals(ConcreteOpenDefDoc.this)) {
                        this._decoree.regionAdded(r, index);
                    }
                }

                @Override
                public void regionChanged(R r, int index) {
                    if (r.getDocument().equals(ConcreteOpenDefDoc.this)) {
                        this._decoree.regionChanged(r, index);
                    }
                }

                @Override
                public void regionRemoved(R r) {
                    if (r.getDocument().equals(ConcreteOpenDefDoc.this)) {
                        this._decoree.regionRemoved(r);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConcreteRegionManager<R extends DocumentRegion>
    extends EventNotifier<RegionManagerListener<R>>
    implements RegionManager<R> {
        protected volatile Vector<R> _regions = new Vector();
        protected volatile R _current = null;
        protected volatile int _maxSize;

        public ConcreteRegionManager(int size) {
            this._maxSize = size;
        }

        public ConcreteRegionManager() {
            this(0);
        }

        @Override
        public R getRegionAt(OpenDefinitionsDocument odd, int offset) {
            for (DocumentRegion r : this._regions) {
                if (!r.getDocument().equals(odd) || offset < r.getStartOffset() || offset > r.getEndOffset()) continue;
                return (R)r;
            }
            return null;
        }

        @Override
        public R getRegionOverlapping(OpenDefinitionsDocument odd, int startOffset, int endOffset) {
            for (DocumentRegion r : this._regions) {
                if (!r.getDocument().equals(odd) || !(r.getStartOffset() >= startOffset && r.getEndOffset() <= endOffset || r.getStartOffset() <= startOffset && r.getEndOffset() >= endOffset || r.getStartOffset() >= startOffset && r.getStartOffset() <= endOffset) && (r.getEndOffset() < startOffset || r.getEndOffset() > endOffset)) continue;
                return (R)r;
            }
            return null;
        }

        protected int getIndexOf(R region) {
            int index = 0;
            for (DocumentRegion r : this._regions) {
                if (region == r) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public void addRegion(R region) {
            int index = this.getIndexOf(this._current);
            if (!(region.equals(this._current) || index != this._regions.size() - 1 && region.equals(this._regions.get(index + 1)) || index > 0 && region.equals(this._regions.get(index - 1)))) {
                if (this._current != null && index >= 0) {
                    this._regions.add(index + 1, region);
                } else {
                    this._regions.add(region);
                }
                this._current = region;
                int regionIndex = this.getIndexOf(region);
                String stackTrace = StringOps.getStackTrace();
                Utilities.invokeLater(new Runnable((DocumentRegion)region, regionIndex){
                    final /* synthetic */ DocumentRegion val$region;
                    final /* synthetic */ int val$regionIndex;
                    {
                        this.val$region = documentRegion;
                        this.val$regionIndex = n;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ConcreteRegionManager.this._lock.startRead();
                        try {
                            Iterator i$ = ConcreteRegionManager.this._listeners.iterator();
                            while (i$.hasNext()) {
                                RegionManagerListener l = (RegionManagerListener)i$.next();
                                l.regionAdded(this.val$region, this.val$regionIndex);
                            }
                        }
                        finally {
                            ConcreteRegionManager.this._lock.endRead();
                        }
                    }
                });
                this.shrinkManager();
            } else if (index < this._regions.size() - 1 && region.equals(this._regions.get(index + 1))) {
                this.nextCurrentRegion();
            } else if (index > 0 && region.equals(this._regions.get(index - 1))) {
                this.prevCurrentRegion();
            }
        }

        protected void removeMoreRecentThanCurrent() {
            if (this._current != null) {
                int index = this.getIndexOf(this._current);
                if (index < 0) {
                    return;
                }
                while (index < this._regions.size() - 1) {
                    this.removeRegion((DocumentRegion)this._regions.lastElement());
                }
            }
        }

        protected void shrinkManager() {
            if (this._maxSize > 0) {
                int size;
                while ((size = this._regions.size()) > this._maxSize) {
                    int index = this.getIndexOf(this._current);
                    if (index <= (size - 1) / 2) {
                        this._regions.remove(size - 1);
                        continue;
                    }
                    this._regions.remove(0);
                }
            }
        }

        @Override
        public void removeRegion(R region) {
            R cur = this._current;
            if (region == cur && this.nextCurrentRegion().equals(cur) && this.prevCurrentRegion().equals(cur)) {
                this._current = null;
            }
            for (int i = 0; i < this._regions.size(); ++i) {
                if (region != this._regions.get(i)) continue;
                this._regions.remove(i);
                break;
            }
            Utilities.invokeLater(new Runnable((DocumentRegion)region){
                final /* synthetic */ DocumentRegion val$region;
                {
                    this.val$region = documentRegion;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ConcreteRegionManager.this._lock.startRead();
                    try {
                        Iterator i$ = ConcreteRegionManager.this._listeners.iterator();
                        while (i$.hasNext()) {
                            RegionManagerListener l = (RegionManagerListener)i$.next();
                            l.regionRemoved(this.val$region);
                        }
                    }
                    finally {
                        ConcreteRegionManager.this._lock.endRead();
                    }
                }
            });
        }

        @Override
        public Vector<R> getRegions() {
            return this._regions;
        }

        @Override
        public void clearRegions() {
            this._current = null;
            while (this._regions.size() > 0) {
                this.removeRegion((DocumentRegion)this._regions.get(0));
            }
        }

        @Override
        public R getCurrentRegion() {
            if (!this._regions.contains(this._current)) {
                this._current = null;
            }
            return this._current;
        }

        @Override
        public int getCurrentRegionIndex() {
            if (this._current != null) {
                return this.getIndexOf(this._current);
            }
            return -1;
        }

        @Override
        public boolean isCurrentRegionFirst() {
            return this.getIndexOf(this._current) == 0;
        }

        @Override
        public boolean isCurrentRegionLast() {
            return this.getIndexOf(this._current) == this._regions.size() - 1;
        }

        @Override
        public void setCurrentRegion(R region) {
            this._current = region;
        }

        @Override
        public R nextCurrentRegion() {
            if (this._current != null) {
                int index = this.getIndexOf(this._current);
                if (index + 1 < this._regions.size()) {
                    this._current = (DocumentRegion)this._regions.get(index + 1);
                }
            } else {
                this._current = (DocumentRegion)this._regions.lastElement();
            }
            return this._current;
        }

        @Override
        public R prevCurrentRegion() {
            if (this._current != null) {
                int index = this.getIndexOf(this._current);
                if (index - 1 >= 0) {
                    this._current = (DocumentRegion)this._regions.get(index - 1);
                }
            } else {
                this._current = (DocumentRegion)this._regions.lastElement();
            }
            return this._current;
        }

        @Override
        public void setMaximumSize(int size) {
            this._maxSize = size;
            this.shrinkManager();
        }

        @Override
        public int getMaximumSize() {
            return this._maxSize;
        }

        @Override
        public void changeRegion(R region, Lambda<Object, R> cmd) {
            final int index = this.getIndexOf(region);
            if (index < 0) {
                return;
            }
            final DocumentRegion r = (DocumentRegion)this._regions.get(index);
            cmd.apply(r);
            Utilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ConcreteRegionManager.this._lock.startRead();
                    try {
                        Iterator i$ = ConcreteRegionManager.this._listeners.iterator();
                        while (i$.hasNext()) {
                            RegionManagerListener l = (RegionManagerListener)i$.next();
                            l.regionChanged(r, index);
                        }
                    }
                    finally {
                        ConcreteRegionManager.this._lock.endRead();
                    }
                }
            });
        }

        @Override
        public void removeAllListeners() {
            throw new UnsupportedOperationException("ConcreteRegionManager does not support removing all listeners");
        }

        @Override
        public void removeListener(RegionManagerListener x0) {
            super.removeListener(x0);
        }

        @Override
        public void addListener(RegionManagerListener x0) {
            super.addListener(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FlatFileGroupingState
    implements FileGroupingState {
        FlatFileGroupingState() {
        }

        @Override
        public File getBuildDirectory() {
            return null;
        }

        @Override
        public File getProjectRoot() {
            return this.getWorkingDirectory();
        }

        @Override
        public File getWorkingDirectory() {
            Iterable_ roots = AbstractGlobalModel.this.getSourceRootSet();
            if (!IterUtil.isEmpty(roots)) {
                return (File)IterUtil.first(roots);
            }
            File file = null;
            if (DrJava.getConfig().getSetting(OptionConstants.STICKY_INTERACTIONS_DIRECTORY).booleanValue()) {
                try {
                    file = FileOps.getValidDirectory(DrJava.getConfig().getSetting(OptionConstants.LAST_INTERACTIONS_DIRECTORY));
                }
                catch (RuntimeException e) {
                    file = null;
                }
            }
            if (file == null) {
                file = FileOps.getValidDirectory(new File(System.getProperty("user.home", ".")));
            }
            DrJava.getConfig().setSetting(OptionConstants.LAST_INTERACTIONS_DIRECTORY, file);
            return file;
        }

        @Override
        public boolean isProjectActive() {
            return false;
        }

        @Override
        public boolean inProjectPath(OpenDefinitionsDocument doc) {
            return false;
        }

        @Override
        public boolean inProjectPath(File f) {
            return false;
        }

        @Override
        public File getProjectFile() {
            return null;
        }

        @Override
        public void setBuildDirectory(File f) {
        }

        @Override
        public void setProjectFile(File f) {
        }

        @Override
        public void setProjectRoot(File f) {
        }

        @Override
        public void addAuxFile(File f) {
        }

        @Override
        public void remAuxFile(File f) {
        }

        @Override
        public void setWorkingDirectory(File f) {
        }

        @Override
        public File[] getProjectFiles() {
            return null;
        }

        @Override
        public boolean inProject(File f) {
            return false;
        }

        @Override
        public File getMainClass() {
            return null;
        }

        @Override
        public void setMainClass(File f) {
        }

        @Override
        public void setCreateJarFile(File f) {
        }

        @Override
        public File getCreateJarFile() {
            return null;
        }

        @Override
        public void setCreateJarFlags(int f) {
        }

        @Override
        public int getCreateJarFlags() {
            return 0;
        }

        @Override
        public Iterable<File> getExtraClassPath() {
            return IterUtil.empty();
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        @Override
        public void setExtraClassPath(Iterable_ cp) {
        }

        @Override
        public boolean isProjectChanged() {
            return false;
        }

        @Override
        public void setProjectChanged(boolean changed) {
        }

        @Override
        public boolean isAuxiliaryFile(File f) {
            return false;
        }

        @Override
        public void cleanBuildDirectory() {
        }

        @Override
        public List<File> getClassFiles() {
            return new LinkedList<File>();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProjectFileGroupingState
    implements FileGroupingState {
        volatile File _projRoot;
        volatile File _mainFile;
        volatile File _buildDir;
        volatile File _workDir;
        volatile File _projectFile;
        final File[] _projectFiles;
        volatile Vector<File> _auxFiles;
        volatile Iterable<File> _projExtraClassPath;
        private boolean _isProjectChanged = false;
        volatile File _createJarFile;
        volatile int _createJarFlags;
        HashSet<String> _projFilePaths = new HashSet();
        private AsyncTask<File, List<File>> _findFilesToCleanTask = new AsyncTask<File, List<File>>("Find Files to Clean"){
            private FilenameFilter _filter;
            {
                this._filter = new FilenameFilter(){

                    public boolean accept(File parent, String name) {
                        return new File(parent, name).isDirectory() || name.endsWith(".class");
                    }
                };
            }

            @Override
            public List<File> runAsync(File buildDir, IAsyncProgress monitor) throws Exception {
                LinkedList<File> accumulator = new LinkedList<File>();
                this.helper(buildDir, accumulator);
                return accumulator;
            }

            @Override
            public void complete(AsyncCompletionArgs<List<File>> args) {
                ProjectFileGroupingState.this.this$0._notifier.executeAsyncTask(ProjectFileGroupingState.access$200(ProjectFileGroupingState.this), args.getResult(), true, true);
            }

            @Override
            public String getDiscriptionMessage() {
                return "Finding files to delete...";
            }

            private void helper(File file, List<File> accumulator) {
                if (file.isDirectory()) {
                    File[] children;
                    for (File child : children = file.listFiles(this._filter)) {
                        this.helper(child, accumulator);
                        accumulator.add(file);
                    }
                } else if (file.getName().endsWith(".class")) {
                    accumulator.add(file);
                }
            }

            @Override
            public Object runAsync(Object x0, IAsyncProgress x1) throws Exception {
                return this.runAsync((File)x0, x1);
            }
        };
        private AsyncTask<List<File>, List<File>> _deleteFilesTask = new AsyncTask<List<File>, List<File>>("Delete Files"){

            @Override
            public List<File> runAsync(List<File> filesToDelete, IAsyncProgress monitor) throws Exception {
                ArrayList<File> undeletableFiles = new ArrayList<File>();
                monitor.setMinimum(0);
                monitor.setMaximum(filesToDelete.size());
                int progress = 1;
                for (File file : filesToDelete) {
                    if (monitor.isCanceled()) break;
                    monitor.setNote(file.getName());
                    boolean could = file.delete();
                    if (!could) {
                        undeletableFiles.add(file);
                    }
                    monitor.setProgress(progress++);
                }
                return undeletableFiles;
            }

            @Override
            public void complete(AsyncCompletionArgs<List<File>> args) {
            }

            @Override
            public String getDiscriptionMessage() {
                return "Deleting files...";
            }

            @Override
            public Object runAsync(Object x0, IAsyncProgress x1) throws Exception {
                return this.runAsync((List)x0, x1);
            }
        };
        final /* synthetic */ AbstractGlobalModel this$0;

        ProjectFileGroupingState(AbstractGlobalModel abstractGlobalModel, File project) {
            this(abstractGlobalModel, project.getParentFile(), null, null, null, project, new File[0], new File[0], (Iterable_)((Object)IterUtil.empty()), null, 0);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        ProjectFileGroupingState(File pr, File main, File bd, File wd, File project, File[] srcFiles, File[] auxFiles, Iterable<File> cp, File cjf, int cjflags) {
            this.this$0 = (AbstractGlobalModel)n;
            this._projRoot = pr;
            this._mainFile = main;
            this._buildDir = bd;
            this._workDir = wd;
            this._projectFile = project;
            this._projectFiles = srcFiles;
            this._auxFiles = new Vector(auxFiles.length);
            for (File f : auxFiles) {
                this._auxFiles.add(f);
            }
            this._projExtraClassPath = cp;
            if (this._projectFiles != null) {
                try {
                    for (File file : this._projectFiles) {
                        this._projFilePaths.add(file.getCanonicalPath());
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this._createJarFile = cjf;
            this._createJarFlags = cjflags;
        }

        @Override
        public boolean isProjectActive() {
            return true;
        }

        @Override
        public boolean inProjectPath(OpenDefinitionsDocument doc) {
            File f;
            if (doc.isUntitled()) {
                return false;
            }
            try {
                f = doc.getFile();
            }
            catch (FileMovedException fme) {
                f = fme.getFile();
            }
            return this.inProjectPath(f);
        }

        @Override
        public boolean inProjectPath(File f) {
            return IOUtil.isMember(f, this.getProjectRoot());
        }

        @Override
        public File getProjectFile() {
            return this._projectFile;
        }

        @Override
        public boolean inProject(File f) {
            if (AbstractGlobalModel.isUntitled(f) || !this.inProjectPath(f)) {
                return false;
            }
            try {
                String path = f.getCanonicalPath();
                return this._projFilePaths.contains(path);
            }
            catch (IOException ioe) {
                return false;
            }
        }

        @Override
        public File[] getProjectFiles() {
            return this._projectFiles;
        }

        @Override
        public File getProjectRoot() {
            if (this._projRoot == null || this._projRoot.equals(FileOption.NULL_FILE)) {
                return this._projectFile.getParentFile();
            }
            return this._projRoot;
        }

        @Override
        public File getBuildDirectory() {
            return this._buildDir;
        }

        @Override
        public File getWorkingDirectory() {
            try {
                if (this._workDir == null || this._workDir == FileOption.NULL_FILE) {
                    File parentDir = this._projectFile.getParentFile();
                    if (parentDir != null) {
                        return parentDir.getCanonicalFile();
                    }
                    return new File(System.getProperty("user.dir"));
                }
                return this._workDir.getCanonicalFile();
            }
            catch (IOException iOException) {
                return this._workDir.getAbsoluteFile();
            }
        }

        @Override
        public void setProjectFile(File f) {
            this._projectFile = f;
        }

        @Override
        public void setProjectRoot(File f) {
            this._projRoot = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addAuxFile(File f) {
            Vector<File> vector = this._auxFiles;
            synchronized (vector) {
                if (this._auxFiles.add(f)) {
                    this.setProjectChanged(true);
                }
                this.setProjectChanged(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remAuxFile(File file) {
            Vector<File> vector = this._auxFiles;
            synchronized (vector) {
                if (this._auxFiles.remove(file)) {
                    this.setProjectChanged(true);
                }
                this.setProjectChanged(true);
            }
        }

        @Override
        public void setBuildDirectory(File f) {
            this._buildDir = f;
        }

        @Override
        public void setWorkingDirectory(File f) {
            this._workDir = f;
        }

        @Override
        public File getMainClass() {
            return this._mainFile;
        }

        @Override
        public void setMainClass(File f) {
            this._mainFile = f;
        }

        @Override
        public void setCreateJarFile(File f) {
            this._createJarFile = f;
        }

        @Override
        public File getCreateJarFile() {
            return this._createJarFile;
        }

        @Override
        public void setCreateJarFlags(int f) {
            this._createJarFlags = f;
        }

        @Override
        public int getCreateJarFlags() {
            return this._createJarFlags;
        }

        @Override
        public boolean isProjectChanged() {
            return this._isProjectChanged;
        }

        @Override
        public void setProjectChanged(boolean changed) {
            this._isProjectChanged = changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAuxiliaryFile(File f) {
            String path;
            if (AbstractGlobalModel.isUntitled(f)) {
                return false;
            }
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException ioe) {
                return false;
            }
            Vector<File> vector = this._auxFiles;
            synchronized (vector) {
                for (File file : this._auxFiles) {
                    try {
                        if (!file.getCanonicalPath().equals(path)) continue;
                        return true;
                    }
                    catch (IOException ioe) {
                    }
                }
                return false;
            }
        }

        @Override
        public void cleanBuildDirectory() {
            File dir = this.getBuildDirectory();
            this.this$0._notifier.executeAsyncTask(this._findFilesToCleanTask, dir, false, true);
        }

        @Override
        public List<File> getClassFiles() {
            File dir = this.getBuildDirectory();
            LinkedList<File> acc = new LinkedList<File>();
            this.getClassFilesHelper(dir, acc);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return acc;
        }

        private void getClassFilesHelper(File f, LinkedList<File> acc) {
            if (f.isDirectory()) {
                File[] fs = f.listFiles(new FilenameFilter(){

                    public boolean accept(File parent, String name) {
                        return new File(parent, name).isDirectory() || name.endsWith(".class");
                    }
                });
                if (fs != null) {
                    for (File kid : fs) {
                        this.getClassFilesHelper(kid, acc);
                    }
                }
            } else if (f.getName().endsWith(".class")) {
                acc.add(f);
            }
        }

        @Override
        public Iterable<File> getExtraClassPath() {
            return this._projExtraClassPath;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        @Override
        public void setExtraClassPath(Iterable_ cp) {
            this._projExtraClassPath = cp;
            this.this$0.setClassPathChanged(true);
        }

        static AsyncTask access$200(ProjectFileGroupingState x0) {
            return x0._deleteFilesTask;
        }
    }
}

