/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.jpda.DocumentDebugAction;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingRequestManager {
    private JPDADebugger _manager;
    private Hashtable<String, Vector<DocumentDebugAction<?>>> _pendingActions;

    public PendingRequestManager(JPDADebugger manager) {
        this._manager = manager;
        this._pendingActions = new Hashtable();
    }

    public void addPendingRequest(DocumentDebugAction<?> action) {
        String className = action.getClassName();
        Vector<DocumentDebugAction<Object>> actions = this._pendingActions.get(className);
        if (actions == null) {
            actions = new Vector();
            ClassPrepareRequest request = this._manager.getEventRequestManager().createClassPrepareRequest();
            request.addClassFilter(new StringBuffer().append(className).append("*").toString());
            request.setSuspendPolicy(1);
            request.enable();
        }
        actions.add(action);
        this._pendingActions.put(className, actions);
    }

    public void removePendingRequest(DocumentDebugAction<?> action) {
        String className = action.getClassName();
        Vector<DocumentDebugAction<?>> actions = this._pendingActions.get(className);
        if (actions == null) {
            return;
        }
        actions.remove(action);
        if (actions.size() == 0) {
            this._pendingActions.remove(className);
        }
    }

    private boolean recursiveFindLineNumber(int lineNumber, ReferenceType rt) {
        try {
            for (Location l : rt.allLineLocations()) {
                if (l.lineNumber() != lineNumber) continue;
                return true;
            }
            for (ReferenceType nested : rt.nestedTypes()) {
                if (!this.recursiveFindLineNumber(lineNumber, nested)) continue;
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    public void classPrepared(ClassPrepareEvent event) throws DebugException {
        ReferenceType rt = event.referenceType();
        String className = rt.name();
        int indexOfDollar = className.indexOf(36);
        if (indexOfDollar > 1) {
            className = className.substring(0, indexOfDollar);
        }
        Vector<DocumentDebugAction<?>> actions = this._pendingActions.get(className);
        Vector failedActions = new Vector();
        if (actions == null) {
            return;
        }
        if (actions.isEmpty()) {
            this._manager.getEventRequestManager().deleteEventRequest(event.request());
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            DocumentDebugAction<?> a = actions.get(i);
            int lineNumber = a.getLineNumber();
            if (lineNumber != -1) {
                try {
                    List<Location> lines = rt.locationsOfLine(lineNumber);
                    if (lines.size() == 0) {
                        String exactClassName = a.getExactClassName();
                        if (exactClassName == null || !exactClassName.equals(rt.name())) continue;
                        this._manager.printMessage(new StringBuffer().append(actions.get(i).toString()).append(" not on an executable line; disabled.").toString());
                        actions.get(i).setEnabled(false);
                    }
                }
                catch (AbsentInformationException aie) {}
                continue;
            }
            try {
                Vector<ReferenceType> refTypes = new Vector<ReferenceType>();
                refTypes.add(rt);
                a.createRequests(refTypes);
                continue;
            }
            catch (DebugException e) {
                failedActions.add(a);
            }
        }
        if (failedActions.size() > 0) {
            throw new DebugException(new StringBuffer().append("Failed actions: ").append(failedActions).toString());
        }
    }
}

