/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.indent;

import edu.rice.cs.drjava.model.AbstractDJDocument;
import edu.rice.cs.drjava.model.definitions.indent.IndentRule;
import edu.rice.cs.drjava.model.definitions.indent.IndentRuleQuestion;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import javax.swing.text.BadLocationException;

public class QuestionHasCharPrecedingOpenBrace
extends IndentRuleQuestion {
    private char[] _prefix;

    public QuestionHasCharPrecedingOpenBrace(char[] prefix, IndentRule yesRule, IndentRule noRule) {
        super(yesRule, noRule);
        this._prefix = prefix;
    }

    boolean applyRule(AbstractDJDocument doc, Indenter.IndentReason reason) {
        int origin = doc.getCurrentLocation();
        int lineStart = doc.getLineStartPos(origin);
        doc.move(lineStart - origin);
        IndentInfo info = doc.getIndentInformation();
        doc.move(origin - lineStart);
        if (!info.braceType.equals("{") || info.distToBrace < 0) {
            return false;
        }
        int bracePos = lineStart - info.distToBrace;
        int prevNonWS = -1;
        try {
            prevNonWS = doc.findPrevNonWSCharPos(bracePos);
            char c = doc.getText(prevNonWS, 1).charAt(0);
            char[] arr$ = this._prefix;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                char pchar = arr$[i$];
                if (c != pchar) continue;
                return true;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return false;
    }
}

