/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.AbstractReducedModel;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Brace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;
import java.util.Stack;

public class ReducedModelBrace
extends AbstractReducedModel {
    private ReducedModelControl _parent;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace;

    public ReducedModelBrace(ReducedModelControl parent) {
        this._parent = parent;
    }

    public void insertChar(char ch) {
        switch (ch) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                this._insertBrace(String.valueOf(ch));
                break;
            }
            default: {
                this._insertGap(1);
            }
        }
    }

    private void _insertBrace(String text) {
        if (this._cursor.atStart() || this._cursor.atEnd()) {
            this._cursor.insertNewBrace(text);
        } else if (((ReducedToken)this._cursor.current()).isGap()) {
            this._cursor.insertBraceToGap(text);
        } else {
            this._cursor.insertNewBrace(text);
        }
    }

    protected void insertGapBetweenMultiCharBrace(int length) {
        throw new RuntimeException("ReducedModelBrace does not keep track of multi-character braces.");
    }

    public void move(int count) {
        this._cursor.move(count);
    }

    public void delete(int count) {
        if (count == 0) {
            return;
        }
        this._cursor.delete(count);
    }

    private boolean _isCurrentBraceMatchable() {
        return ((ReducedToken)this._cursor.current()).isMatchable();
    }

    public int previousBrace() {
        int dist = 0;
        this.resetWalkerLocationToCursor();
        TokenList.Iterator copyCursor = this._cursor._copy();
        if (!copyCursor.atStart()) {
            copyCursor.prev();
        }
        if (copyCursor.atStart()) {
            copyCursor.dispose();
            return -1;
        }
        int relDistance = dist += this._cursor.getBlockOffset();
        while (!copyCursor.atStart()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist + ((ReducedToken)copyCursor.current()).getSize();
                }
                relDistance = 0;
            }
            dist += ((ReducedToken)copyCursor.current()).getSize();
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.prev();
        }
        copyCursor.dispose();
        return -1;
    }

    public int nextBrace() {
        int relDistance = 0;
        int dist = 0;
        TokenList.Iterator copyCursor = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        if (copyCursor.atStart()) {
            copyCursor.next();
        }
        if (this._cursor.getBlockOffset() > 0) {
            relDistance = dist = ((ReducedToken)copyCursor.current()).getSize() - this._cursor.getBlockOffset();
            copyCursor.next();
        }
        while (!copyCursor.atEnd()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist;
                }
                relDistance = 0;
            }
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            dist += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.next();
        }
        copyCursor.dispose();
        return -1;
    }

    public int balanceForward() {
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        if (iter.atStart() || iter.atFirstItem() || !this.openBraceImmediatelyLeft()) {
            iter.dispose();
            return -1;
        }
        iter.prev();
        ReducedToken curToken = (ReducedToken)iter.current();
        if (!$assertionsDisabled && !(curToken instanceof Brace)) {
            throw new AssertionError();
        }
        int openBraceDistance = -curToken.getSize();
        this.moveWalkerGetState(openBraceDistance);
        braceStack.push((Brace)curToken);
        iter.next();
        this.moveWalkerGetState(-openBraceDistance);
        int relDistance = 0;
        int distance = 0;
        while (!iter.atEnd() && !braceStack.isEmpty()) {
            curToken = (ReducedToken)iter.current();
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(relDistance) == FREE) {
                    if (curBrace.isClosedBrace()) {
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            iter.next();
        }
        if (!braceStack.isEmpty()) {
            iter.dispose();
            return -1;
        }
        iter.dispose();
        return distance;
    }

    public boolean openBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        this._cursor.prev();
        boolean isLeft = this._cursor.getBlockOffset() == 0 && ((ReducedToken)this._cursor.current()).isOpen() && this._isCurrentBraceMatchable();
        this._cursor.next();
        return isLeft;
    }

    public boolean closedBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        this._cursor.prev();
        boolean isLeft = this._cursor.getBlockOffset() == 0 && ((ReducedToken)this._cursor.current()).isClosed() && this._isCurrentBraceMatchable();
        this._cursor.next();
        return isLeft;
    }

    public int balanceBackward() {
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        if (iter.atStart() || iter.atFirstItem() || !this.closedBraceImmediatelyLeft()) {
            iter.dispose();
            return -1;
        }
        iter.prev();
        if (!$assertionsDisabled && !(iter.current() instanceof Brace)) {
            throw new AssertionError();
        }
        int relDistance = 0;
        int distance = 0;
        do {
            ReducedToken curToken = (ReducedToken)iter.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    if (curBrace.isOpenBrace()) {
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            iter.prev();
        } while (!iter.atStart() && !braceStack.isEmpty());
        if (!braceStack.isEmpty()) {
            iter.dispose();
            return -1;
        }
        iter.dispose();
        return distance;
    }

    protected ReducedModelState moveWalkerGetState(int relDistance) {
        return this._parent.moveWalkerGetState(relDistance);
    }

    protected void resetWalkerLocationToCursor() {
        this._parent.resetLocation();
    }

    protected void getDistToEnclosingBrace(IndentInfo braceInfo) {
        int relDistance;
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        int distance = relDistance = braceInfo.distToNewline + 1;
        if (braceInfo.distToNewline == -1) {
            iter.dispose();
            return;
        }
        iter.move(-braceInfo.distToNewline - 1);
        relDistance += iter.getBlockOffset();
        distance += iter.getBlockOffset();
        braceInfo.distToNewline = -1;
        if (iter.atStart() || iter.atFirstItem()) {
            iter.dispose();
            return;
        }
        iter.prev();
        while (!iter.atStart()) {
            ReducedToken curToken = (ReducedToken)iter.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    if (curBrace.isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            braceInfo.braceType = curBrace.getType();
                            braceInfo.distToBrace = distance;
                            iter.dispose();
                            return;
                        }
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            iter.prev();
        }
        iter.dispose();
    }

    protected void getDistToEnclosingBraceCurrent(IndentInfo braceInfo) {
        int relDistance;
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor._copy();
        this.resetWalkerLocationToCursor();
        int distance = relDistance = 0;
        relDistance += iter.getBlockOffset();
        distance += iter.getBlockOffset();
        braceInfo.distToNewlineCurrent = -1;
        if (iter.atStart() || iter.atFirstItem()) {
            iter.dispose();
            return;
        }
        iter.prev();
        while (!iter.atStart()) {
            ReducedToken curToken = (ReducedToken)iter.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    if (curBrace.isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            braceInfo.braceTypeCurrent = curBrace.getType();
                            braceInfo.distToBraceCurrent = distance;
                            iter.dispose();
                            return;
                        }
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            iter.prev();
        }
        iter.dispose();
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace == null ? (class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace = ReducedModelBrace.class$("edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelBrace")) : class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

