/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceReduction;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Gap;
import edu.rice.cs.drjava.model.definitions.reducedmodel.HighlightStatus;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelBrace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelComment;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;
import edu.rice.cs.util.UnexpectedException;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReducedModelControl
implements BraceReduction {
    volatile ReducedModelBrace _rmb;
    volatile ReducedModelComment _rmc;
    volatile int _offset;

    private ReducedModelBrace getRMB() {
        if (this._rmb == null) {
            this._rmb = new ReducedModelBrace(this);
        }
        return this._rmb;
    }

    private ReducedModelComment getRMC() {
        if (this._rmc == null) {
            this._rmc = new ReducedModelComment();
        }
        return this._rmc;
    }

    @Override
    public void insertChar(char ch) {
        this.getRMB().insertChar(ch);
        this.getRMC().insertChar(ch);
    }

    @Override
    public void move(int count) {
        try {
            this.getRMB().move(count);
            this.getRMC().move(count);
        }
        catch (IllegalArgumentException e) {
            this.resetLocation();
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void delete(int count) {
        this.getRMB().delete(count);
        this.getRMC().delete(count);
    }

    @Override
    public int balanceForward() {
        return this.getRMB().balanceForward();
    }

    @Override
    public int balanceBackward() {
        return this.getRMB().balanceBackward();
    }

    @Override
    public ReducedModelState moveWalkerGetState(int relDistance) {
        return this.getRMC().moveWalkerGetState(relDistance);
    }

    @Override
    public void resetLocation() {
        this.getRMC().resetWalkerLocationToCursor();
    }

    @Override
    public ReducedToken currentToken() {
        ReducedToken rmcToken = this.getRMC().current();
        if (!rmcToken.isGap()) {
            return rmcToken;
        }
        ReducedToken rmbToken = this.getRMB().current();
        if (!rmbToken.isGap()) {
            rmbToken.setState(this.getRMC().getStateAtCurrent());
            return rmbToken;
        }
        int size = this.getSize(rmbToken, rmcToken);
        return new Gap(size, this.getRMC().getStateAtCurrent());
    }

    @Override
    public ReducedModelState getStateAtCurrent() {
        return this.getRMC().getStateAtCurrent();
    }

    String getType() {
        ReducedToken rmcToken = this.getRMC().current();
        if (!rmcToken.isGap()) {
            return rmcToken.getType();
        }
        ReducedToken rmbToken = this.getRMB().current();
        if (!rmbToken.isGap()) {
            return rmbToken.getType();
        }
        return "";
    }

    int getSize() {
        return this.getSize(this.getRMB().current(), this.getRMC().current());
    }

    int getSize(ReducedToken rmbToken, ReducedToken rmcToken) {
        int size;
        int rmb_offset = this.getRMB().getBlockOffset();
        int rmc_offset = this.getRMC().getBlockOffset();
        int rmb_size = rmbToken.getSize();
        int rmc_size = rmcToken.getSize();
        this._offset = rmb_offset < rmc_offset ? (size = rmb_offset) : (size = rmc_offset);
        size = rmb_size - rmb_offset < rmc_size - rmc_offset ? (size += rmb_size - rmb_offset) : (size += rmc_size - rmc_offset);
        return size;
    }

    void next() {
        if (this.getRMC()._cursor.atStart()) {
            this.getRMC().next();
            this.getRMB().next();
            return;
        }
        int size = this.getSize(this.getRMB().current(), this.getRMC().current());
        this.getRMC().move(size - this._offset);
        this.getRMB().move(size - this._offset);
    }

    void prev() {
        if (this.getRMC()._cursor.atEnd()) {
            this.getRMC().prev();
            this.getRMB().prev();
            if (this.getRMC()._cursor.atStart()) {
                return;
            }
            int size = this.getRMC().current().getSize() < this.getRMB().current().getSize() ? -this.getRMC().current().getSize() : -this.getRMB().current().getSize();
            this.getRMC().next();
            this.getRMB().next();
            this.move(size);
        } else if (this.getRMB().getBlockOffset() < this.getRMC().getBlockOffset()) {
            this.getRMB().prev();
            int size = this.getRMB().current().getSize() + this.getRMB().getBlockOffset();
            this.getRMB().next();
            if (size < this.getRMC().getBlockOffset()) {
                this.move(-size);
            } else {
                this.move(-this.getRMC().getBlockOffset());
            }
        } else if (this.getRMB().getBlockOffset() == this.getRMC().getBlockOffset()) {
            this.getRMB().prev();
            this.getRMC().prev();
            this.getRMB().setBlockOffset(0);
            this.getRMC().setBlockOffset(0);
        } else {
            this.getRMC().prev();
            int size = this.getRMC().current().getSize() + this.getRMC().getBlockOffset();
            this.getRMC().next();
            if (size < this.getRMB().getBlockOffset()) {
                this.move(-size);
            } else {
                this.move(-this.getRMB().getBlockOffset());
            }
        }
    }

    public ReducedToken prevItem() {
        int rmbOffset = this.getRMB().getBlockOffset();
        int rmcOffset = this.getRMC().getBlockOffset();
        this.prev();
        ReducedToken temp = this.currentToken();
        this.next();
        this.getRMB().setBlockOffset(rmbOffset);
        this.getRMC().setBlockOffset(rmcOffset);
        return temp;
    }

    public ReducedToken nextItem() {
        int rmbOffset = this.getRMB().getBlockOffset();
        int rmcOffset = this.getRMC().getBlockOffset();
        this.next();
        ReducedToken temp = this.currentToken();
        this.prev();
        this.getRMB().setBlockOffset(rmbOffset);
        this.getRMC().setBlockOffset(rmcOffset);
        return temp;
    }

    boolean atEnd() {
        return this.getRMB()._cursor.atEnd() || this.getRMC()._cursor.atEnd();
    }

    boolean atStart() {
        return this.getRMB()._cursor.atStart() || this.getRMC()._cursor.atStart();
    }

    int getBlockOffset() {
        if (this.getRMB().getBlockOffset() < this.getRMC().getBlockOffset()) {
            return this.getRMB().getBlockOffset();
        }
        return this.getRMC().getBlockOffset();
    }

    @Override
    public int absOffset() {
        return this.getRMC().absOffset();
    }

    @Override
    public String simpleString() {
        return new StringBuffer().append("\n********\n").append(this.getRMB().simpleString()).append("\n________\n").append(this.getRMC().simpleString()).toString();
    }

    @Override
    public IndentInfo getIndentInformation() {
        IndentInfo braceInfo = new IndentInfo();
        this.getRMC().getDistToPreviousNewline(braceInfo);
        this.getRMB().getDistToEnclosingBrace(braceInfo);
        this.getRMC().getDistToIndentNewline(braceInfo);
        this.getRMB().getDistToEnclosingBraceCurrent(braceInfo);
        this.getRMC().getDistToCurrentBraceNewline(braceInfo);
        return braceInfo;
    }

    @Override
    public int getDistToPreviousNewline(int relLoc) {
        return this.getRMC().getDistToPreviousNewline(relLoc);
    }

    @Override
    public int getDistToNextNewline() {
        return this.getRMC().getDistToNextNewline();
    }

    @Override
    public Vector<HighlightStatus> getHighlightStatus(int start, int length) {
        int requestEnd;
        int curState;
        int curLength;
        Vector<HighlightStatus> vec = new Vector<HighlightStatus>();
        TokenList.Iterator cursor = this.getRMC()._cursor._copy();
        int curLocation = start;
        if (cursor.atEnd() || cursor.atStart()) {
            curLength = length;
            curState = 0;
        } else {
            curLength = ((ReducedToken)cursor.current()).getSize() - this.getRMC().getBlockOffset();
            curState = ((ReducedToken)cursor.current()).getHighlightState();
        }
        while (curLocation + curLength < start + length) {
            cursor.next();
            if (cursor.atEnd()) break;
            int nextState = ((ReducedToken)cursor.current()).getHighlightState();
            if (nextState == curState) {
                curLength += ((ReducedToken)cursor.current()).getSize();
                continue;
            }
            vec.add(new HighlightStatus(curLocation, curLength, curState));
            curLocation += curLength;
            curLength = ((ReducedToken)cursor.current()).getSize();
            curState = nextState;
        }
        if (curLocation + curLength > (requestEnd = start + length)) {
            curLength = requestEnd - curLocation;
        }
        vec.add(new HighlightStatus(curLocation, curLength, curState));
        cursor.dispose();
        return vec;
    }
}

