/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.model.BrainClassLoader;
import edu.rice.cs.drjava.model.DeadClassLoader;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.IterUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathManager {
    private LinkedList<File> projectCP = new LinkedList();
    private LinkedList<File> buildCP = new LinkedList();
    private LinkedList<File> projectFilesCP = new LinkedList();
    private LinkedList<File> externalFilesCP = new LinkedList();
    private LinkedList<File> extraCP = new LinkedList();

    public synchronized void addProjectCP(File f) {
        this.projectCP.add(f);
    }

    public synchronized Iterable<File> getProjectCP() {
        return IterUtil.reverse(this.projectCP);
    }

    public synchronized void addBuildDirectoryCP(File f) {
        this.buildCP.add(f);
    }

    public synchronized Iterable<File> getBuildDirectoryCP() {
        return IterUtil.reverse(this.buildCP);
    }

    public synchronized void addProjectFilesCP(File f) {
        this.projectFilesCP.add(f);
    }

    public synchronized Iterable<File> getProjectFilesCP() {
        return IterUtil.reverse(this.projectFilesCP);
    }

    public void addExternalFilesCP(File f) {
        this.externalFilesCP.add(f);
    }

    public Iterable<File> getExternalFilesCP() {
        return IterUtil.reverse(this.externalFilesCP);
    }

    public synchronized void addExtraCP(File f) {
        this.extraCP.add(f);
    }

    public Iterable<File> getExtraCP() {
        return IterUtil.reverse(this.extraCP);
    }

    public synchronized ClassLoader getClassLoader() {
        return new BrainClassLoader(this.buildClassLoader(this.projectCP), this.buildClassLoader(this.buildCP), this.buildClassLoader(this.projectFilesCP), this.buildClassLoader(this.externalFilesCP), this.buildClassLoader(this.extraCP));
    }

    private ClassLoader buildClassLoader(List<File> path) {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (File f : path) {
            try {
                URL u = f.toURI().toURL();
                urls.add(u);
            }
            catch (MalformedURLException e) {
                DebugUtil.error.log("Can't convert file to URL", e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)new DeadClassLoader());
    }
}

