/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.debug.DebugModelCallback;
import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.repl.InputListener;
import edu.rice.cs.drjava.model.repl.InteractionsModelCallback;
import edu.rice.cs.drjava.model.repl.newjvm.ExceptionResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpretResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpretResultVisitor;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterBusy;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.SyntaxErrorResult;
import edu.rice.cs.drjava.model.repl.newjvm.ValueResult;
import edu.rice.cs.drjava.model.repl.newjvm.VoidResult;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.newjvm.AbstractMasterJVM;
import edu.rice.cs.util.swing.Utilities;
import java.io.File;
import java.io.IOException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.List;
import koala.dynamicjava.parser.wrapper.ParseError;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainJVM
extends AbstractMasterJVM
implements MainJVMRemoteI {
    private static final String SLAVE_CLASS_NAME = "edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVM";
    public static final String DEFAULT_INTERPRETER_NAME = "DEFAULT";
    private volatile File _workDir;
    private volatile InteractionsModelCallback _interactionsModel;
    private volatile JUnitModelCallback _junitModel;
    private volatile DebugModelCallback _debugModel;
    private final Object _interpreterLock = new Object();
    private volatile boolean _slaveJVMUsed = false;
    private volatile boolean _restart = true;
    private volatile boolean _cleanlyRestarting = false;
    private volatile int _numAttempts = 0;
    private static final int MAX_COUNT = 3;
    private final ResultHandler _handler = new ResultHandler(null);
    private volatile boolean _allowAssertions = false;
    private volatile Iterable<File> _startupClassPath;
    private volatile List<String> _optionArgs;
    private volatile String _currentInterpreterName = "DEFAULT";

    public MainJVM(File wd) throws RemoteException {
        super(SLAVE_CLASS_NAME);
        this._workDir = wd;
        this._waitForQuitThreadName = "Wait for Interactions to Exit Thread";
        this._interactionsModel = new DummyInteractionsModel();
        this._junitModel = new DummyJUnitModel();
        this._debugModel = new DummyDebugModel();
        this._startupClassPath = GlobalModel.RUNTIME_CLASS_PATH;
        this._optionArgs = new ArrayList<String>();
    }

    public boolean isInterpreterRunning() {
        return this._interpreterJVM() != null;
    }

    public boolean slaveJVMUsed() {
        return this._slaveJVMUsed;
    }

    public void setInteractionsModel(InteractionsModelCallback model) {
        this._interactionsModel = model;
    }

    public void setJUnitModel(JUnitModelCallback model) {
        this._junitModel = model;
    }

    public void setDebugModel(DebugModelCallback model) {
        this._debugModel = model;
    }

    public void setAllowAssertions(boolean allow) {
        this._allowAssertions = allow;
    }

    public void setOptionArgs(String argString) {
        this._optionArgs = ArgumentTokenizer.tokenize(argString);
    }

    public void interpret(String s) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            _log.log(new StringBuffer().append(this).append(".interpret(").append(s).append(")").toString());
            this._slaveJVMUsed = true;
            this._interactionsModel.slaveJVMUsed();
            slave.interpret(s);
        }
        catch (UnmarshalException ume) {
            _log.log(new StringBuffer().append(this).append(".interpret threw UnmarshalException, so interpreter is dead:\n").append(ume).toString());
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public String getVariableToString(String var) {
        if (!this._restart) {
            return null;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            return slave.getVariableToString(var);
        }
        catch (RemoteException re) {
            this._threwException(re);
            return null;
        }
    }

    public String getVariableClassName(String var) {
        if (!this._restart) {
            return null;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            return slave.getVariableClassName(var);
        }
        catch (RemoteException re) {
            this._threwException(re);
            return null;
        }
    }

    @Override
    public void interpretResult(InterpretResult result) throws RemoteException {
        try {
            _log.log(new StringBuffer().append(this).append(".interpretResult(").append(result).append(")").toString());
            result.apply(this.getResultHandler());
        }
        catch (Throwable t) {
            _log.log(new StringBuffer().append(this).append("interpretResult threw ").append(t.toString()).toString());
        }
    }

    public void addProjectClassPath(File f) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.addProjectClassPath(f);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addBuildDirectoryClassPath(File f) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.addBuildDirectoryClassPath(f);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addProjectFilesClassPath(File f) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.addProjectFilesClassPath(f);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addExternalFilesClassPath(File f) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.addExternalFilesClassPath(f);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addExtraClassPath(File f) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.addExtraClassPath(f);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public Iterable<File> getClassPath() {
        if (this._restart) {
            InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
            try {
                return IterUtil.compose(slave.getAugmentedClassPath(), this._startupClassPath);
            }
            catch (RemoteException re) {
                this._threwException(re);
                return IterUtil.empty();
            }
        }
        return IterUtil.empty();
    }

    public void setPackageScope(String packageName) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.setPackageScope(packageName);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void setShowMessageOnResetFailure(boolean show) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.setShowMessageOnResetFailure(show);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    @Override
    public void systemErrPrint(String s) throws RemoteException {
        this._interactionsModel.replSystemErrPrint(s);
    }

    @Override
    public void systemOutPrint(String s) throws RemoteException {
        this._interactionsModel.replSystemOutPrint(s);
    }

    public List<String> findTestClasses(List<String> classNames, List<File> files) throws RemoteException {
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        return slave.findTestClasses(classNames, files);
    }

    public boolean runTestSuite() throws RemoteException {
        return this._interpreterJVM().runTestSuite();
    }

    @Override
    public void nonTestCase(boolean isTestAll) throws RemoteException {
        this._junitModel.nonTestCase(isTestAll);
    }

    @Override
    public void classFileError(ClassFileError e) throws RemoteException {
        this._junitModel.classFileError(e);
    }

    @Override
    public void testSuiteStarted(int numTests) throws RemoteException {
        this._slaveJVMUsed = true;
        this._interactionsModel.slaveJVMUsed();
        this._junitModel.testSuiteStarted(numTests);
    }

    @Override
    public void testStarted(String testName) throws RemoteException {
        this._slaveJVMUsed = true;
        this._junitModel.testStarted(testName);
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) throws RemoteException {
        this._junitModel.testEnded(testName, wasSuccessful, causedError);
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) throws RemoteException {
        this._junitModel.testSuiteEnded(errors);
    }

    @Override
    public File getFileForClassName(String className) throws RemoteException {
        return this._junitModel.getFileForClassName(className);
    }

    private InterpreterJVMRemoteI _interpreterJVM() {
        return (InterpreterJVMRemoteI)this._slave;
    }

    public void addJavaInterpreter(String name) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.addJavaInterpreter(name);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void addDebugInterpreter(String name, String className) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.addDebugInterpreter(name, className);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public void removeInterpreter(String name) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.removeInterpreter(name);
            if (name.equals(this._currentInterpreterName)) {
                this._currentInterpreterName = null;
            }
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    public boolean setActiveInterpreter(String name) {
        if (!this._restart) {
            return false;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            boolean result = slave.setActiveInterpreter(name);
            this._currentInterpreterName = name;
            return result;
        }
        catch (RemoteException re) {
            this._threwException(re);
            return false;
        }
    }

    public boolean setToDefaultInterpreter() {
        if (!this._restart) {
            return false;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            boolean result = slave.setToDefaultInterpreter();
            this._currentInterpreterName = DEFAULT_INTERPRETER_NAME;
            return result;
        }
        catch (ConnectIOException ce) {
            _log.log(new StringBuffer().append(this).append("could not connect to the interpreterJVM after killing it.  Threw ").append(ce).toString());
            return false;
        }
        catch (RemoteException re) {
            this._threwException(re);
            return false;
        }
    }

    public String getCurrentInterpreterName() {
        return this._currentInterpreterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killInterpreter(File wd) {
        boolean restart;
        Object object = this._masterJVMLock;
        synchronized (object) {
            this._workDir = wd;
            this._restart = wd != null;
            this._cleanlyRestarting = true;
            restart = this._restart;
        }
        try {
            if (restart) {
                this._interactionsModel.interpreterResetting();
            }
            this.quitSlave();
        }
        catch (RemoteException e) {
            _log.log(new StringBuffer().append(this).append("could not connect to the interpreterJVM while trying to kill it.  Threw ").append(e).toString());
        }
    }

    public void setStartupClassPath(String classPath) {
        this._startupClassPath = IOUtil.attemptCanonicalFiles(IOUtil.parsePath((String)classPath));
    }

    public void startInterpreterJVM() {
        _log.log(new StringBuffer().append(this).append(".startInterpreterJVM() called").toString());
        if (this.isStartupInProgress() || this.isInterpreterRunning()) {
            return;
        }
        ArrayList<String> jvmArgs = new ArrayList<String>();
        if (this.allowAssertions()) {
            jvmArgs.add("-ea");
        }
        int debugPort = this.getDebugPort();
        _log.log(new StringBuffer().append("Main JVM starting with debug port: ").append(debugPort).toString());
        if (debugPort > -1) {
            jvmArgs.add(new StringBuffer().append("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=").append(debugPort).toString());
            jvmArgs.add("-Xdebug");
            jvmArgs.add("-Xnoagent");
            jvmArgs.add("-Djava.compiler=NONE");
        }
        jvmArgs.addAll(this._optionArgs);
        String[] jvmArgsArray = new String[jvmArgs.size()];
        for (int i = 0; i < jvmArgs.size(); ++i) {
            jvmArgsArray[i] = (String)jvmArgs.get(i);
        }
        this._numAttempts = 0;
        try {
            this.invokeSlave(jvmArgsArray, IOUtil.pathToString(this._startupClassPath), this._workDir);
            this._slaveJVMUsed = false;
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
        catch (IOException ioe) {
            this._threwException(ioe);
        }
    }

    @Override
    protected void handleSlaveQuit(int status) {
        if (this._restart) {
            if (!this._cleanlyRestarting) {
                this._interactionsModel.interpreterResetting();
            }
            this.startInterpreterJVM();
        }
        if (!this._cleanlyRestarting) {
            this._interactionsModel.replCalledSystemExit(status);
        }
        this._cleanlyRestarting = false;
    }

    @Override
    protected void slaveQuitDuringStartup(int status) {
        super.slaveQuitDuringStartup(status);
        ++this._numAttempts;
        if (Utilities.TEST_MODE || this._numAttempts < 3) {
            return;
        }
        this._restart = false;
        String msg = new StringBuffer().append("Interpreter JVM exited before registering, status: ").append(status).toString();
        IllegalStateException e = new IllegalStateException(msg);
        new DrJavaErrorHandler().handle(e);
    }

    @Override
    public void errorStartingSlave(Throwable cause) throws RemoteException {
        new DrJavaErrorHandler().handle(cause);
    }

    @Override
    public void quitFailed(Throwable th) throws RemoteException {
        this._interactionsModel.interpreterResetFailed(th);
        this._cleanlyRestarting = false;
    }

    @Override
    public boolean isStartupInProgress() {
        return super.isStartupInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSlaveConnected() {
        this._restart = true;
        this._cleanlyRestarting = false;
        Boolean allowAccess = DrJava.getConfig().getSetting(OptionConstants.ALLOW_PRIVATE_ACCESS);
        this.setPrivateAccessible(allowAccess);
        this._interactionsModel.interpreterReady(this._workDir);
        this._junitModel.junitJVMReady();
        _log.log(new StringBuffer().append("Main JVM Thread for slave connection is: ").append(Thread.currentThread()).toString());
        Object object = this._interpreterLock;
        synchronized (object) {
            this._interpreterLock.notifyAll();
        }
    }

    public void enableRestart() {
        this._restart = true;
    }

    protected InterpretResultVisitor<Object> getResultHandler() {
        return this._handler;
    }

    protected int getDebugPort() {
        int port = -1;
        try {
            port = this._interactionsModel.getDebugPort();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return port;
    }

    protected boolean allowAssertions() {
        String version = System.getProperty("java.version");
        return this._allowAssertions && version != null && "1.4.0".compareTo(version) <= 0;
    }

    private void _threwException(Throwable t) {
        String shortMsg = null;
        if (t instanceof ParseError && ((ParseError)t).getParseException() != null) {
            shortMsg = ((ParseError)t).getMessage();
        }
        this._interactionsModel.replThrewException(t.getClass().getName(), t.getMessage(), StringOps.getStackTrace(t), shortMsg);
    }

    public void setPrivateAccessible(boolean allow) {
        if (!this._restart) {
            return;
        }
        InterpreterJVMRemoteI slave = this.ensureInterpreterConnected();
        try {
            slave.setPrivateAccessible(allow);
        }
        catch (RemoteException re) {
            this._threwException(re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterJVMRemoteI ensureInterpreterConnected() {
        try {
            Object object = this._interpreterLock;
            synchronized (object) {
                if (!this._restart) {
                    throw new IllegalStateException("Interpreter is disabled");
                }
                InterpreterJVMRemoteI slave = this._interpreterJVM();
                while (slave == null) {
                    this._interpreterLock.wait();
                    slave = this._interpreterJVM();
                }
                return slave;
            }
        }
        catch (InterruptedException ie) {
            throw new UnexpectedException(ie);
        }
    }

    @Override
    public String getConsoleInput() {
        String s = this._interactionsModel.getConsoleInput();
        return s;
    }

    static InteractionsModelCallback access$100(MainJVM x0) {
        return x0._interactionsModel;
    }

    static class 1 {
    }

    public static class DummyDebugModel
    implements DebugModelCallback {
        public void notifyDebugInterpreterAssignment(String name) {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyJUnitModel
    implements JUnitModelCallback {
        @Override
        public void nonTestCase(boolean isTestAll) {
        }

        @Override
        public void classFileError(ClassFileError e) {
        }

        @Override
        public void testSuiteStarted(int numTests) {
        }

        @Override
        public void testStarted(String testName) {
        }

        @Override
        public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        }

        @Override
        public void testSuiteEnded(JUnitError[] errors) {
        }

        @Override
        public File getFileForClassName(String className) {
            return null;
        }

        @Override
        public Iterable<File> getClassPath() {
            return IterUtil.empty();
        }

        @Override
        public void junitJVMReady() {
        }
    }

    public static class DummyInteractionsModel
    implements InteractionsModelCallback {
        public int getDebugPort() throws IOException {
            return -1;
        }

        public void replSystemOutPrint(String s) {
        }

        public void replSystemErrPrint(String s) {
        }

        public String getConsoleInput() {
            throw new IllegalStateException("Cannot request input from dummy interactions model!");
        }

        public void setInputListener(InputListener il) {
            throw new IllegalStateException("Cannot set the input listener of dummy interactions model!");
        }

        public void changeInputListener(InputListener from, InputListener to) {
            throw new IllegalStateException("Cannot change the input listener of dummy interactions model!");
        }

        public void replReturnedVoid() {
        }

        public void replReturnedResult(String result, String style) {
        }

        public void replThrewException(String exceptionClass, String message, String stackTrace, String specialMessage) {
        }

        public void replReturnedSyntaxError(String errorMessage, String interaction, int startRow, int startCol, int endRow, int endCol) {
        }

        public void replCalledSystemExit(int status) {
        }

        public void interpreterResetting() {
        }

        public void interpreterResetFailed(Throwable th) {
        }

        public void interpreterReady(File wd) {
        }

        public void slaveJVMUsed() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultHandler
    implements InterpretResultVisitor<Object> {
        private ResultHandler() {
        }

        @Override
        public Object forVoidResult(VoidResult that) {
            MainJVM.access$100(MainJVM.this).replReturnedVoid();
            return null;
        }

        @Override
        public Object forValueResult(ValueResult that) {
            String result = that.getValueStr();
            String style = that.getStyle();
            MainJVM.access$100(MainJVM.this).replReturnedResult(result, style);
            return null;
        }

        @Override
        public Object forExceptionResult(ExceptionResult that) {
            MainJVM.access$100(MainJVM.this).replThrewException(that.getExceptionClass(), that.getExceptionMessage(), that.getStackTrace(), that.getSpecialMessage());
            return null;
        }

        @Override
        public Object forSyntaxErrorResult(SyntaxErrorResult that) {
            MainJVM.access$100(MainJVM.this).replReturnedSyntaxError(that.getErrorMessage(), that.getInteraction(), that.getStartRow(), that.getStartCol(), that.getEndRow(), that.getEndCol());
            return null;
        }

        @Override
        public Object forInterpreterBusy(InterpreterBusy that) {
            throw new UnexpectedException("MainJVM.interpret() called when InterpreterJVM was busy!");
        }

        ResultHandler(1 x1) {
            this();
        }
    }
}

