/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsTreePanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksPanel
extends RegionsTreePanel<DocumentRegion> {
    protected JButton _goToButton;
    protected JButton _removeButton;
    protected JButton _removeAllButton;

    public BookmarksPanel(MainFrame frame) {
        super(frame, "Bookmarks");
        this._model.getBookmarkManager().addListener(new RegionManagerListener<DocumentRegion>(){

            @Override
            public void regionAdded(DocumentRegion r, int index) {
                BookmarksPanel.this.addRegion(r);
            }

            @Override
            public void regionChanged(DocumentRegion r, int index) {
                this.regionRemoved(r);
                this.regionAdded(r, index);
            }

            @Override
            public void regionRemoved(DocumentRegion r) {
                BookmarksPanel.this.removeRegion(r);
            }
        });
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    @Override
    protected JComponent[] makeButtons() {
        AbstractAction goToAction = new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent ae) {
                BookmarksPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ae) {
                Iterator i$ = BookmarksPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    DocumentRegion r = (DocumentRegion)i$.next();
                    BookmarksPanel.this._model.getBookmarkManager().removeRegion(r);
                }
            }
        };
        this._removeButton = new JButton(removeAction);
        AbstractAction removeAllAction = new AbstractAction("Remove All"){

            public void actionPerformed(ActionEvent ae) {
                BookmarksPanel.this._model.getBookmarkManager().clearRegions();
            }
        };
        this._removeAllButton = new JButton(removeAllAction);
        JComponent[] buts = new JComponent[]{this._goToButton, this._removeButton, this._removeAllButton};
        return buts;
    }

    @Override
    protected void updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        this._goToButton.setEnabled(regs.size() == 1);
        this._removeButton.setEnabled(regs.size() > 0);
        this._removeAllButton.setEnabled(this._regionRootNode != null && this._regionRootNode.getDepth() > 0);
    }

    @Override
    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            public void actionPerformed(ActionEvent e) {
                BookmarksPanel.this.goToRegion();
            }
        }, new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                Iterator i$ = BookmarksPanel.this.getSelectedRegions().iterator();
                while (i$.hasNext()) {
                    DocumentRegion r = (DocumentRegion)i$.next();
                    BookmarksPanel.this._model.getBookmarkManager().removeRegion(r);
                }
            }
        }};
        return acts;
    }
}

