/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.text.SwingDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JavadocErrorPanel
extends ErrorPanel {
    protected JavadocErrorListPane _errorListPane = new JavadocErrorListPane();

    public JavadocErrorPanel(SingleDisplayModel model, MainFrame frame) {
        super(model, frame, "Javadoc Output", "Javadoc");
        this.setErrorListPane(this._errorListPane);
    }

    public JavadocErrorListPane getErrorListPane() {
        return this._errorListPane;
    }

    protected CompilerErrorModel getErrorModel() {
        return this.getModel().getJavadocModel().getJavadocErrorModel();
    }

    public void setJavadocInProgress() {
        this._errorListPane.setJavadocInProgress();
    }

    protected void _close() {
        super._close();
        this.getModel().getJavadocModel().resetJavadocErrors();
        this.reset();
    }

    public void reset() {
        CompilerErrorModel model = this.getModel().getJavadocModel().getJavadocErrorModel();
        this._numErrors = model != null ? model.getNumErrors() : 0;
        this._errorListPane.updateListPane(true);
    }

    public ErrorPanel.ErrorListPane getErrorListPane() {
        return this.getErrorListPane();
    }

    public class JavadocErrorListPane
    extends ErrorPanel.ErrorListPane {
        public void setJavadocInProgress() {
            this._errorListPositions = new Position[0];
            SwingDocument doc = new SwingDocument();
            doc.append("Generating Javadoc.  Please wait...\n", ErrorPanel.NORMAL_ATTRIBUTES);
            this.setDocument(doc);
            this.selectNothing();
        }

        protected void _updateWithErrors() throws BadLocationException {
            SwingDocument doc = new SwingDocument();
            String failureName = "error";
            if (JavadocErrorPanel.this.getErrorModel().hasOnlyWarnings()) {
                failureName = "warning";
            }
            this._updateWithErrors(failureName, "found", doc);
        }

        protected void _updateNoErrors(boolean done) throws BadLocationException {
            SwingDocument doc = new SwingDocument();
            String msg = done ? "Javadoc generated successfully." : "";
            doc.append(msg, ErrorPanel.NORMAL_ATTRIBUTES);
            this.setDocument(doc);
            this.selectNothing();
        }
    }
}

