/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.ClassPathFilter;
import edu.rice.cs.drjava.ui.DirectoryFilter;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.config.BooleanOptionComponent;
import edu.rice.cs.drjava.ui.config.ButtonComponent;
import edu.rice.cs.drjava.ui.config.ColorOptionComponent;
import edu.rice.cs.drjava.ui.config.ConfigPanel;
import edu.rice.cs.drjava.ui.config.DirectoryOptionComponent;
import edu.rice.cs.drjava.ui.config.FileOptionComponent;
import edu.rice.cs.drjava.ui.config.FontOptionComponent;
import edu.rice.cs.drjava.ui.config.ForcedChoiceOptionComponent;
import edu.rice.cs.drjava.ui.config.IntegerOptionComponent;
import edu.rice.cs.drjava.ui.config.KeyStrokeOptionComponent;
import edu.rice.cs.drjava.ui.config.LabelComponent;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.drjava.ui.config.StringOptionComponent;
import edu.rice.cs.drjava.ui.config.ToolbarOptionComponent;
import edu.rice.cs.drjava.ui.config.VectorFileOptionComponent;
import edu.rice.cs.util.swing.DirectoryChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFrame
extends JFrame {
    private static final int FRAME_WIDTH = 750;
    private static final int FRAME_HEIGHT = 500;
    private final MainFrame _mainFrame;
    private final JTree _tree;
    private final DefaultTreeModel _treeModel;
    private final PanelTreeNode _rootNode;
    private final JButton _okButton;
    private final JButton _applyButton;
    private final JButton _cancelButton;
    private final JPanel _mainPanel;
    private final JFileChooser _fileOptionChooser;
    private final JFileChooser _browserChooser;
    private final DirectoryChooser _dirChooser;
    private OptionComponent.ChangeListener _changeListener = new OptionComponent.ChangeListener(){

        public Object apply(Object oc) {
            ConfigFrame.access$000(ConfigFrame.this).setEnabled(true);
            return null;
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$ui$config$ConfigFrame;

    public ConfigFrame(MainFrame frame) {
        super("Preferences");
        this._mainFrame = frame;
        AbstractAction applyAction = new AbstractAction("Apply"){

            public void actionPerformed(ActionEvent e) {
                try {
                    ConfigFrame.this.saveSettings();
                    ConfigFrame.access$000(ConfigFrame.this).setEnabled(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this._applyButton = new JButton(applyAction);
        this._applyButton.setEnabled(false);
        AbstractAction okAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                boolean successful = true;
                try {
                    successful = ConfigFrame.this.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (successful) {
                    ConfigFrame.access$000(ConfigFrame.this).setEnabled(false);
                }
                ConfigFrame.this.setVisible(false);
            }
        };
        this._okButton = new JButton(okAction);
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this.cancel();
            }
        };
        this._cancelButton = new JButton(cancelAction);
        File workDir = this._getWorkDir();
        this._fileOptionChooser = new JFileChooser(workDir);
        this._browserChooser = new JFileChooser(workDir);
        this._dirChooser = new DirectoryChooser(this);
        this._rootNode = new PanelTreeNode("Preferences");
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree = new JTree(this._treeModel);
        this._initTree();
        this._createPanels();
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new BorderLayout());
        this._tree.addTreeSelectionListener(new PanelTreeSelectionListener(null));
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        if (this._rootNode.getChildCount() != 0) {
            PanelTreeNode firstChild = (PanelTreeNode)this._rootNode.getChildAt(0);
            Object[] firstChildPath = firstChild.getPath();
            TreePath path = new TreePath(firstChildPath);
            this._tree.expandPath(path);
            this._tree.setSelectionPath(path);
        }
        JScrollPane treeScroll = new JScrollPane(this._tree);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treeScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Categories"));
        treePanel.add((Component)treeScroll, "Center");
        cp.add((Component)treePanel, "West");
        cp.add((Component)this._mainPanel, "Center");
        JPanel bottom = new JPanel();
        bottom.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this._applyButton);
        bottom.add(this._okButton);
        bottom.add(this._cancelButton);
        bottom.add(Box.createHorizontalGlue());
        cp.add((Component)bottom, "South");
        this.setSize(750, 500);
        this._mainFrame.setPopupLoc(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigFrame.this.cancel();
            }
        });
        this._tree.expandRow(0);
        this._tree.expandRow(1);
        this._tree.expandRow(2);
    }

    public void setUp() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._fileOptionChooser.setDialogTitle("Select");
        this._fileOptionChooser.setApproveButtonText("Select");
        this._fileOptionChooser.setFileSelectionMode(2);
        this._fileOptionChooser.setFileFilter(ClassPathFilter.ONLY);
        this._browserChooser.setDialogTitle("Select Web Browser");
        this._browserChooser.setApproveButtonText("Select");
        this._browserChooser.setFileSelectionMode(0);
        this._dirChooser.setSelectedFile(this._getWorkDir());
        this._dirChooser.setDialogTitle("Select");
        this._dirChooser.setApproveButtonText("Select");
        this._dirChooser.setMultiSelectionEnabled(false);
    }

    private File _getWorkDir() {
        File workDir = this._mainFrame.getModel().getMasterWorkingDirectory();
        if (workDir.isDirectory()) {
            return workDir;
        }
        if (workDir.getParent() != null) {
            workDir = workDir.getParentFile();
        }
        return workDir;
    }

    public boolean apply() {
        return PanelTreeNode.access$200(this._rootNode);
    }

    public void resetToCurrent() {
        this._rootNode.resetToCurrent();
    }

    public void cancel() {
        this.resetToCurrent();
        this._applyButton.setEnabled(false);
        this.setVisible(false);
    }

    public boolean saveSettings() throws IOException {
        boolean successful = this.apply();
        if (successful) {
            try {
                DrJava.getConfig().saveConfiguration();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, new StringBuffer().append("Could not save changes to your '.drjava' file in your home directory. \n\n").append(ioe).toString(), "Could Not Save Changes", 0);
                throw ioe;
            }
        }
        return successful;
    }

    private void _displayPanel(ConfigPanel cf) {
        this._mainPanel.removeAll();
        this._mainPanel.add((Component)cf, "Center");
        this._mainPanel.revalidate();
        this._mainPanel.repaint();
    }

    private void _initTree() {
        this._tree.setEditable(false);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setShowsRootHandles(true);
        this._tree.setRootVisible(false);
        DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();
        dtcr.setLeafIcon(null);
        dtcr.setOpenIcon(null);
        dtcr.setClosedIcon(null);
        this._tree.setCellRenderer(dtcr);
    }

    private PanelTreeNode _createPanel(String t, PanelTreeNode parent) {
        PanelTreeNode ptNode = new PanelTreeNode(t);
        this._treeModel.insertNodeInto(ptNode, parent, parent.getChildCount());
        Object[] pathArray = ptNode.getPath();
        TreePath path = new TreePath(pathArray);
        this._tree.expandPath(path);
        return ptNode;
    }

    private PanelTreeNode _createPanel(String t) {
        return this._createPanel(t, this._rootNode);
    }

    private void _createPanels() {
        PanelTreeNode resourceLocNode = this._createPanel("Resource Locations");
        this._setupResourceLocPanel(PanelTreeNode.access$300(resourceLocNode));
        PanelTreeNode displayNode = this._createPanel("Display Options");
        this._setupDisplayPanel(PanelTreeNode.access$300(displayNode));
        PanelTreeNode fontNode = this._createPanel("Fonts", displayNode);
        this._setupFontPanel(PanelTreeNode.access$300(fontNode));
        PanelTreeNode colorNode = this._createPanel("Colors", displayNode);
        this._setupColorPanel(PanelTreeNode.access$300(colorNode));
        PanelTreeNode keystrokesNode = this._createPanel("Key Bindings");
        this._setupKeyBindingsPanel(PanelTreeNode.access$300(keystrokesNode));
        PanelTreeNode compilerOptionsNode = this._createPanel("Compiler Options");
        this._setupCompilerPanel(PanelTreeNode.access$300(compilerOptionsNode));
        PanelTreeNode debugNode = this._createPanel("Debugger");
        this._setupDebugPanel(PanelTreeNode.access$300(debugNode));
        PanelTreeNode javadocNode = this._createPanel("Javadoc");
        this._setupJavadocPanel(PanelTreeNode.access$300(javadocNode));
        PanelTreeNode notificationsNode = this._createPanel("Notifications");
        this._setupNotificationsPanel(PanelTreeNode.access$300(notificationsNode));
        PanelTreeNode miscNode = this._createPanel("Miscellaneous");
        this._setupMiscPanel(PanelTreeNode.access$300(miscNode));
    }

    public <X> void addOptionComponent(ConfigPanel panel, OptionComponent<X> oc) {
        panel.addComponent(oc);
        oc.addChangeListener(this._changeListener);
    }

    private void _setupResourceLocPanel(ConfigPanel panel) {
        FileOptionComponent browserLoc = new FileOptionComponent(OptionConstants.BROWSER_FILE, "Web Browser", this, "<html>Location of a web browser to use for Javadoc and Help links.<br>If left blank, only the Web Browser Command will be used.<br>This is not necessary if a default browser is available on your system.", this._browserChooser);
        this.addOptionComponent(panel, browserLoc);
        StringOptionComponent browserCommand = new StringOptionComponent(OptionConstants.BROWSER_STRING, "Web Browser Command", this, "<html>Command to send to the web browser to view a web location.<br>The string <code>&lt;URL&gt;</code> will be replaced with the URL address.<br>This is not necessary if a default browser is available on your system.");
        this.addOptionComponent(panel, browserCommand);
        FileOptionComponent javacLoc = new FileOptionComponent(OptionConstants.JAVAC_LOCATION, "Tools.jar Location", this, "Optional location of the JDK's tools.jar, which contains the compiler and debugger.", this._fileOptionChooser);
        javacLoc.setFileFilter(ClassPathFilter.ONLY);
        this.addOptionComponent(panel, javacLoc);
        this.addOptionComponent(panel, new VectorFileOptionComponent(OptionConstants.EXTRA_CLASSPATH, "Extra Classpath", (Frame)this, "<html>Any directories or jar files to add to the classpath<br>of the Compiler and Interactions Pane.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.STICKY_INTERACTIONS_DIRECTORY, "Restore last working directory of the Interactions pane on start up", this, new StringBuffer().append("<html>Whether to restore the last working directory of the Interaction pane on start up,<br>or to always use the value of the \"user.home\" Java property<br>(currently ").append(System.getProperty("user.home")).append(").").toString()));
        panel.displayComponents();
    }

    private void _setupDisplayPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.LOOK_AND_FEEL, "Look and Feel", this, "Changes the general appearance of DrJava."));
        this.addOptionComponent(panel, new ToolbarOptionComponent("Toolbar Buttons", this, "How to display the toolbar buttons."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.LINEENUM_ENABLED, "Show All Line Numbers", this, "Whether to show line numbers on the left side of the Definitions Pane."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WINDOW_STORE_POSITION, "Save Main Window Position", this, "Whether to save and restore the size and position of the main window."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_CLIPBOARD_HISTORY_STORE_POSITION, "Save \"Clipboard History\" Dialog Position", this, "Whether to save and restore the size and position of the \"Clipboard History\" dialog."));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.access$400(ConfigFrame.this).resetClipboardHistoryDialogPosition();
            }
        }, "Reset \"Clipboard History\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.CLIPBOARD_HISTORY_SIZE, "Size of Clipboard History", this, "Determines how many entries are kept in the clipboard history."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_GOTOFILE_STORE_POSITION, "Save \"Go to File\" Dialog Position", this, "Whether to save and restore the size and position of the \"Go to File\" dialog."));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.access$400(ConfigFrame.this).resetGotoFileDialogPosition();
            }
        }, "Reset \"Go to File\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_GOTOFILE_FULLY_QUALIFIED, "Display Fully-Qualified Class Names in \"Go to File\" Dialog", this, "<html>Whether to also display fully-qualified class names in the \"Go to File\" dialog.<br>Enabling this option on network drives might cause the dialog to display after a slight delay.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_WORD_STORE_POSITION, "Save \"Auto-Complete Word\" Dialog Position", this, "Whether to save and restore the size and position of the \"Auto-Complete Word\" dialog."));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.access$400(ConfigFrame.this).resetCompleteWordDialogPosition();
            }
        }, "Reset \"Auto-Complete Word\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_JAROPTIONS_STORE_POSITION, "Save \"Create Jar File from Project\" Dialog Position", this, "Whether to save and restore the position of the \"Create Jar File from Project\" dialog."));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.access$400(ConfigFrame.this).resetJarOptionsDialogPosition();
            }
        }, "Reset \"Create Jar File from Project\" Dialog Position", this, "This resets the dialog position to its default values."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_OPENJAVADOC_STORE_POSITION, "Save \"Open Javadoc\" Dialog Position", this, "Whether to save and restore the size and position of the \"Open Javadoc\" dialog."));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.access$400(ConfigFrame.this).resetOpenJavadocDialogPosition();
            }
        }, "Reset \"Open Javadoc\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_AUTOIMPORT_STORE_POSITION, "Save \"Auto Import\" Dialog Position", this, "Whether to save and restore the size and position of the \"Auto Import\" dialog."));
        this.addOptionComponent(panel, new ButtonComponent(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFrame.access$400(ConfigFrame.this).resetAutoImportDialogPosition();
            }
        }, "Reset \"Auto Import\" Dialog Position and Size", this, "This resets the dialog position and size to its default values."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_COMPLETE_SCAN_CLASS_FILES, "Scan Class Files After Each Compile For Auto-Completion and Auto-Import", this, "<html>Whether to scan the class files after a compile to generate class names<br>used for auto-completion and auto-import.<br>Enabling this option will slow compiles down.</html>"));
        panel.displayComponents();
    }

    private void _setupFontPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_MAIN, "Main Font", this, "The font used for most text in DrJava."));
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_LINE_NUMBERS, "Line Numbers Font", this, "<html>The font for displaying line numbers on the left side of<br>the Definitions Pane if Show All Line Numbers is enabled.<br>Cannot be displayed larger than the Main Font.</html>"));
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_DOCLIST, "Document List Font", this, "The font used in the list of open documents."));
        this.addOptionComponent(panel, new FontOptionComponent(OptionConstants.FONT_TOOLBAR, "Toolbar Font", this, "The font used in the toolbar buttons."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.TEXT_ANTIALIAS, "Use anti-aliased text", this, "Whether to graphically smooth the text."));
        panel.displayComponents();
    }

    private void _setupColorPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_NORMAL_COLOR, "Normal Color", (Frame)this, "The default color for text in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_KEYWORD_COLOR, "Keyword Color", (Frame)this, "The color for Java keywords in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_TYPE_COLOR, "Type Color", (Frame)this, "The color for classes and types in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_COMMENT_COLOR, "Comment Color", (Frame)this, "The color for comments in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_DOUBLE_QUOTED_COLOR, "Double-quoted Color", (Frame)this, "The color for quoted strings (eg. \"...\") in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_SINGLE_QUOTED_COLOR, "Single-quoted Color", (Frame)this, "The color for quoted characters (eg. 'a') in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_NUMBER_COLOR, "Number Color", (Frame)this, "The color for numbers in the Definitions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, "Background Color", (Frame)this, "The background color of the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEFINITIONS_MATCH_COLOR, "Brace-matching Color", (Frame)this, "The color for matching brace highlights in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.COMPILER_ERROR_COLOR, "Compiler Error Color", (Frame)this, "The color for compiler error highlights in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.BOOKMARK_COLOR, "Bookmark Color", (Frame)this, "The color for bookmarks in the Definitions Pane.", true));
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.FIND_RESULTS_COLORS[i], new StringBuffer().append("Find Results Color ").append(i + 1).toString(), (Frame)this, "A color for highlighting find results in the Definitions Pane.", true));
        }
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_BREAKPOINT_COLOR, "Debugger Breakpoint Color", (Frame)this, "The color for breakpoints in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, "Disabled Debugger Breakpoint Color", (Frame)this, "The color for disabled breakpoints in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_THREAD_COLOR, "Debugger Location Color", (Frame)this, "The color for the location of the current suspended thread in the Definitions Pane.", true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.SYSTEM_OUT_COLOR, "System.out Color", (Frame)this, "The color for System.out in the Interactions and Console Panes."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.SYSTEM_ERR_COLOR, "System.err Color", (Frame)this, "The color for System.err in the Interactions and Console Panes."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.SYSTEM_IN_COLOR, "System.in Color", (Frame)this, "The color for System.in in the Interactions Pane."));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.INTERACTIONS_ERROR_COLOR, "Interactions Error Color", this, "The color for interactions errors in the Interactions Pane.", false, true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DEBUG_MESSAGE_COLOR, "Debug Message Color", this, "The color for debugger messages in the Interactions Pane.", false, true));
        this.addOptionComponent(panel, new ColorOptionComponent(OptionConstants.DRJAVA_ERRORS_BUTTON_COLOR, "DrJava Errors Button Background Color", (Frame)this, "The background color of the \"Errors\" button used to show internal DrJava errors.", true));
        panel.displayComponents();
    }

    private void _setupKeyBindingsPanel(ConfigPanel panel) {
        TreeSet<KeyStrokeOptionComponent> _comps = new TreeSet<KeyStrokeOptionComponent>();
        Enumeration e = KeyBindingManager.Singleton.getKeyStrokeData();
        while (e.hasMoreElements()) {
            KeyStrokeOptionComponent tmpKsoc;
            KeyBindingManager.KeyStrokeData tmpKsd = (KeyBindingManager.KeyStrokeData)e.nextElement();
            if (tmpKsd.getOption() == null) continue;
            Action a = tmpKsd.getAction();
            String desc = (String)a.getValue("ShortDescription");
            if (desc == null || desc.equals("")) {
                desc = tmpKsd.getName();
            }
            if ((tmpKsoc = new KeyStrokeOptionComponent((KeyStrokeOption)tmpKsd.getOption(), tmpKsd.getName(), this, desc)) == null) continue;
            _comps.add(tmpKsoc);
        }
        for (KeyStrokeOptionComponent x : _comps) {
            this.addOptionComponent(panel, x);
        }
        panel.displayComponents();
    }

    private void _setupDebugPanel(ConfigPanel panel) {
        if (!this._mainFrame.getModel().getDebugger().isAvailable()) {
            String howto = "\nThe debugger is not currently active.  To use the debugger, you\nmust include Sun's tools.jar or jpda.jar on your classpath when\nstarting DrJava.  Do not use the \"-jar\" option, because it\noverrides the classpath and will not include tools.jar.\nFor example, in Windows you might type:\n\n  java -classpath drjava.jar;c:\\path\\tools.jar edu.rice.cs.drjava.DrJava\n\n(Substituting the correct path for tools.jar.)\nSee the user documentation for more details.\n";
            this.addOptionComponent(panel, new LabelComponent(howto, this));
        }
        VectorFileOptionComponent sourcePath = new VectorFileOptionComponent(OptionConstants.DEBUG_SOURCEPATH, "Sourcepath", (Frame)this, "<html>Any directories in which to search for source<br>files when stepping in the Debugger.</html>");
        sourcePath.setFileFilter(new DirectoryFilter("Source Directories"));
        this.addOptionComponent(panel, sourcePath);
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_STEP_JAVA, "Step Into Java Classes", this, "<html>Whether the Debugger should step into Java library classes,<br>including java.*, javax.*, sun.*, com.sun.*, com.apple.eawt.*, and com.apple.eio.*</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_STEP_INTERPRETER, "Step Into Interpreter Classes", this, "<html>Whether the Debugger should step into the classes<br>used by the Interactions Pane (DynamicJava).</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DEBUG_STEP_DRJAVA, "Step Into DrJava Classes", this, "Whether the Debugger should step into DrJava's own class files."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.DEBUG_STEP_EXCLUDE, "Classes/Packages To Exclude", this, "<html>Any classes that the debuggger should not step into.<br>Should be a COMMA-separated list of fully-qualified class names.<br>To exclude a package, specify <code>packagename.*</code> in the list.</html>"));
        panel.displayComponents();
    }

    private void _setupJavadocPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.JAVADOC_ACCESS_LEVEL, "Access Level", this, "<html>Fields and methods with access modifiers at this level<br>or higher will be included in the generated Javadoc.</html>"));
        this.addOptionComponent(panel, new ForcedChoiceOptionComponent(OptionConstants.JAVADOC_LINK_VERSION, "Java Version for Javadoc Links", this, "The version of Java for generating links to online Javadoc documentation."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.JAVADOC_1_3_LINK, "Javadoc 1.3 URL", this, "The URL to the Java 1.3 API, for generating links to library classes."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.JAVADOC_1_4_LINK, "Javadoc 1.4 URL", this, "The URL to the Java 1.4 API, for generating links to library classes."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.JAVADOC_1_5_LINK, "Javadoc 1.5 URL", this, "The URL to the Java 1.5 API, for generating links to library classes."));
        this.addOptionComponent(panel, new DirectoryOptionComponent(OptionConstants.JAVADOC_DESTINATION, "Default Destination Directory", this, "Optional default directory for saving Javadoc documentation.", this._dirChooser));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.JAVADOC_CUSTOM_PARAMS, "Custom Javadoc Parameters", this, "Any extra flags or parameters to pass to Javadoc."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.JAVADOC_FROM_ROOTS, "Generate Javadoc From Source Roots", this, "<html>Whether 'Javadoc All' should generate Javadoc for all packages<br>in an open document's source tree, rather than just the document's<br>own package and sub-packages.</html>"));
        panel.displayComponents();
    }

    private void _setupNotificationsPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.QUIT_PROMPT, "Prompt Before Quit", this, "Whether DrJava should prompt the user before quitting."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.INTERACTIONS_RESET_PROMPT, "Prompt Before Resetting Interactions Pane", this, "<html>Whether DrJava should prompt the user before<br>manually resetting the interactions pane.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.INTERACTIONS_EXIT_PROMPT, "Prompt if Interactions Pane Exits Unexpectedly", this, "<html>Whether DrJava should show a dialog box if a program<br>in the Interactions Pane exits without the user clicking Reset.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.JAVADOC_PROMPT_FOR_DESTINATION, "Prompt for Javadoc Destination", this, "<html>Whether Javadoc should always prompt the user<br>to select a destination directory.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.PROMPT_BEFORE_CLEAN, "Prompt before Cleaning Build Directory", this, "<html>Whether DrJava should prompt before cleaning the<br>build directory of a project</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_COMPILE, "Automatically Save Before Compiling", this, "<html>Whether DrJava should automatically save before<br>recompiling or ask the user each time.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALWAYS_COMPILE_BEFORE_JUNIT, "Automatically Compile Before Testing", this, "<html>Whether DrJava should automatically compile before<br>testing with JUnit or ask the user each time.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALWAYS_SAVE_BEFORE_JAVADOC, "Automatically Save Before Generating Javadoc", this, "<html>Whether DrJava should automatically save before<br>generating Javadoc or ask the user each time.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_BREAKPOINT_OUT_OF_SYNC, "Warn on Breakpoint if Out of Sync", this, "<html>Whether DrJava should warn the user if the class file<br>is out of sync before setting a breakpoint in that file.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_DEBUG_MODIFIED_FILE, "Warn if Debugging Modified File", this, "<html>Whether DrJava should warn the user if the file being<br>debugged has been modified since its last save.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_CHANGE_LAF, "Warn to Restart to Change Look and Feel", this, "<html>Whether DrJava should warn the user that look and feel.<br>(Changes will not be applied until DrJava is restarted.)</html>."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.WARN_PATH_CONTAINS_POUND, "Warn if File's Path Contains a '#' Symbol", this, "<html>Whether DrJava should warn the user if the file being<br>saved has a path that contains a '#' symbol.<br>Users cannot use such files in the Interactions Pane<br>because of a bug in Java.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED, "Show a notification window when the first DrJava error occurs", this, "<html>Whether to show a notification window when the first DrJava error occurs.<br>If this is disabled, only the \"DrJava Error\" button will appear.</html>"));
        panel.displayComponents();
    }

    private void _setupMiscPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.INDENT_LEVEL, "Indent Level", this, "The number of spaces to use for each level of indentation."));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.HISTORY_MAX_SIZE, "Size of Interactions History", this, "The number of interactions to remember in the history."));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.RECENT_FILES_MAX_SIZE, "Recent Files List Size", this, "<html>The number of files to remember in<br>the recently used files list in the File menu.</html>"));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.MASTER_JVM_ARGS, "JVM Args for Main JVM", this, "The command-line arguments to pass to the Main JVM."));
        this.addOptionComponent(panel, new StringOptionComponent(OptionConstants.SLAVE_JVM_ARGS, "JVM Args for Interactions JVM", this, "The command-line arguments to pass to the Interactions JVM."));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.BROWSER_HISTORY_MAX_SIZE, "Maximum Size of Browser History", this, "Determines how many entries are kept in the browser history."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.AUTO_CLOSE_COMMENTS, "Automatically Close Block Comments", this, "<html>Whether to automatically insert a closing comment tag (\"*/\")<br>when the enter key is pressed after typing a new block comment<br>tag (\"/*\" or \"/**\").</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.RUN_WITH_ASSERT, "Enable Assert Statement Execution", this, "<html>Whether to execute <code>assert</code> statements in classes running in the interactions pane.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.BACKUP_FILES, "Keep Emacs-style Backup Files", this, "<html>Whether DrJava should keep a backup copy of each file that<br>the user modifies, saved with a '~' at the end of the filename.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.RESET_CLEAR_CONSOLE, "Clear Console After Interactions Reset", this, "Whether to clear the Console output after resetting the Interactions Pane."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.ALLOW_PRIVATE_ACCESS, "Allow Access of Private Members in Interactions Pane", this, "Whether to allow users to access private (and protected) fields and methods."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_SOURCE_WHEN_SWITCHING, "Show sample of source code when fast switching", this, "Whether to show a sample of the source code under the document's filename when fast switching documents."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.FORCE_TEST_SUFFIX, "Require test classes in projects to end in \"Test\"", this, "Whether to force test classes in projects to end in \"Test\"."));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.FIND_REPLACE_FOCUS_IN_DEFPANE, "Put the focus in the definitions pane after find/replace", this, "<html>Whether to put the focus in the definitions pane after doing a find or replace operation.<br>If this is not selected, the focus will be in the Find/Replace pane.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_CODE_PREVIEW_POPUPS, "Show Code Preview Popups", this, "<html>Whether to show a popup window with a code preview when the mouse is hovering<br>over an item in the Breakpoints, Bookmarks and Find All panes.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DRJAVA_USE_FORCE_QUIT, "Forcefully Quit DrJava", this, "<html>On some platforms, DrJava does not shut down properly when files are open<br>(namely tablet PCs). Check this option to force DrJava to close.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.REMOTE_CONTROL_ENABLED, "Enable Remote Control", this, "<html>Whether DrJava should listen to a socket (see below) so it<br>can be remote controlled and told to open files.<br>(Changes will not be applied until DrJava is restarted.)</html>"));
        this.addOptionComponent(panel, new IntegerOptionComponent(OptionConstants.REMOTE_CONTROL_PORT, "Remote Control Port", this, "<html>A running instance of DrJava can be remote controlled and<br>told to open files. This specifies the port used for remote control.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.DIALOG_AUTOIMPORT_ENABLED, "Enable the \"Auto Import\" Dialog", this, "<html>Whether DrJava should open the \"Auto Import\" dialog when<br>an undefined class is encountered in the Interactions Pane.</html>"));
        panel.displayComponents();
    }

    private void _setupCompilerPanel(ConfigPanel panel) {
        this.addOptionComponent(panel, new LabelComponent("Note: Compiler warnings not shown if compiling any Java language level files", this));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_UNCHECKED_WARNINGS, "Show Unchecked Warnings", this, "<html>Warn about unchecked conversions involving parameterized types.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_DEPRECATION_WARNINGS, "Show Deprecation Warnings", this, "<html>Warn about each use or override of a deprecated method, field, or class.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_PATH_WARNINGS, "Show Path Warnings", this, "<html>Warn about nonexistent members of the classpath and sourcepath.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_SERIAL_WARNINGS, "Show Serial Warnings", this, "<html>Warn about missing <code>serialVersionUID</code> definitions on serializable classes.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_FINALLY_WARNINGS, "Show Finally Warnings", this, "<html>Warn about <code>finally</code> clauses that cannot complete normally.</html>"));
        this.addOptionComponent(panel, new BooleanOptionComponent(OptionConstants.SHOW_FALLTHROUGH_WARNINGS, "Show Fall-Through Warnings", this, "<html>Warn about <code>switch</code> block cases that fall through to the next case.</html>"));
        panel.displayComponents();
    }

    static JButton access$000(ConfigFrame x0) {
        return x0._applyButton;
    }

    static MainFrame access$400(ConfigFrame x0) {
        return x0._mainFrame;
    }

    static JTree access$500(ConfigFrame x0) {
        return x0._tree;
    }

    static void access$600(ConfigFrame x0, ConfigPanel x1) {
        x0._displayPanel(x1);
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$ui$config$ConfigFrame == null ? (class$edu$rice$cs$drjava$ui$config$ConfigFrame = ConfigFrame.class$("edu.rice.cs.drjava.ui.config.ConfigFrame")) : class$edu$rice$cs$drjava$ui$config$ConfigFrame).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private class PanelTreeSelectionListener
    implements TreeSelectionListener {
        private PanelTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Object o = ConfigFrame.access$500(ConfigFrame.this).getLastSelectedPathComponent();
            if (o instanceof PanelTreeNode) {
                PanelTreeNode child = (PanelTreeNode)ConfigFrame.access$500(ConfigFrame.this).getLastSelectedPathComponent();
                ConfigFrame.access$600(ConfigFrame.this, PanelTreeNode.access$300(child));
            }
        }

        PanelTreeSelectionListener(1 x1) {
            this();
        }
    }

    private class PanelTreeNode
    extends DefaultMutableTreeNode {
        private final ConfigPanel _panel;

        public PanelTreeNode(String t) {
            super(t);
            this._panel = new ConfigPanel(t);
        }

        public PanelTreeNode(ConfigPanel c) {
            super(c.getTitle());
            this._panel = c;
        }

        private ConfigPanel getPanel() {
            return this._panel;
        }

        private boolean update() {
            boolean isValidUpdate = this._panel.update();
            if (!isValidUpdate) {
                Object[] nodes = this.getPath();
                TreePath path = new TreePath(nodes);
                ConfigFrame.access$500(ConfigFrame.this).expandPath(path);
                ConfigFrame.access$500(ConfigFrame.this).setSelectionPath(path);
                return false;
            }
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                boolean isValidUpdateChildren = ((PanelTreeNode)childNodes.nextElement()).update();
                if (isValidUpdateChildren) continue;
                return false;
            }
            return true;
        }

        public void resetToCurrent() {
            this._panel.resetToCurrent();
            Enumeration<TreeNode> childNodes = this.children();
            while (childNodes.hasMoreElements()) {
                ((PanelTreeNode)childNodes.nextElement()).resetToCurrent();
            }
        }

        static boolean access$200(PanelTreeNode x0) {
            return x0.update();
        }

        static ConfigPanel access$300(PanelTreeNode x0) {
            return x0.getPanel();
        }
    }
}

