/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FontOption;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.FontChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontOptionComponent
extends OptionComponent<Font> {
    private JButton _button = new JButton();
    private JTextField _fontField;
    private JPanel _panel;
    private Font _font;

    public FontOptionComponent(FontOption opt, String text, Frame parent) {
        super(opt, text, parent);
        this._button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontOptionComponent.this.chooseFont();
            }
        });
        this._button.setText("...");
        this._button.setMaximumSize(new Dimension(10, 10));
        this._button.setMinimumSize(new Dimension(10, 10));
        this._fontField = new JTextField();
        this._fontField.setEditable(false);
        this._fontField.setBackground(Color.white);
        this._fontField.setHorizontalAlignment(0);
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this._fontField, "Center");
        this._panel.add((Component)this._button, "East");
        this._font = (Font)DrJava.getConfig().getSetting(this._option);
        this._updateField(this._font);
    }

    public FontOptionComponent(FontOption opt, String text, Frame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._panel.setToolTipText(description);
        this._fontField.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    private void _updateField(Font f) {
        this._fontField.setFont(f);
        this._fontField.setText(this._option.format(f));
    }

    @Override
    public JComponent getComponent() {
        return this._panel;
    }

    public void chooseFont() {
        String oldText = this._fontField.getText();
        Font f = FontChooser.showDialog(this._parent, new StringBuffer().append("Choose '").append(this.getLabelText()).append("'").toString(), this._font);
        if (f != null) {
            this._font = f;
            this._updateField(this._font);
            if (!oldText.equals(this._fontField.getText())) {
                this.notifyChangeListeners();
            }
        }
    }

    @Override
    public boolean updateConfig() {
        if (!this._font.equals(DrJava.getConfig().getSetting(this._option))) {
            DrJava.getConfig().setSetting(this._option, this._font);
        }
        return true;
    }

    @Override
    public void setValue(Font value) {
        this._font = value;
        this._updateField(value);
    }

    @Override
    public void setValue(Object x0) {
        this.setValue((Font)x0);
    }
}

