/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.ui.ClassPathFilter;
import edu.rice.cs.drjava.ui.config.VectorOptionComponent;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorFileOptionComponent
extends VectorOptionComponent<File>
implements OptionConstants {
    private FileFilter _fileFilter;
    private JFileChooser _jfc;

    public VectorFileOptionComponent(VectorOption<File> opt, String text, Frame parent) {
        super(opt, text, parent);
        File workDir = new File(System.getProperty("user.home"));
        this._jfc = new JFileChooser(workDir);
        this._jfc.setDialogTitle("Select");
        this._jfc.setApproveButtonText("Select");
        this._jfc.setFileSelectionMode(2);
        this._jfc.setMultiSelectionEnabled(true);
        this._fileFilter = ClassPathFilter.ONLY;
    }

    public VectorFileOptionComponent(VectorOption<File> opt, String text, Frame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    protected void _addButtons() {
        super._addButtons();
        this._buttonPanel.add(this._moveUpButton);
        this._buttonPanel.add(this._moveDownButton);
    }

    @Override
    public void setValue(ArrayList<File> files) {
        this._listModel.clear();
        for (File f : files) {
            this._listModel.addElement(f);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
    }

    public void chooseFile() {
        File parent;
        File selection = (File)this._list.getSelectedValue();
        if (selection != null && (parent = selection.getParentFile()) != null) {
            this._jfc.setCurrentDirectory(parent);
        }
        this._jfc.setFileFilter(this._fileFilter);
        File[] c = null;
        int returnValue = this._jfc.showDialog(this._parent, null);
        if (returnValue == 0) {
            c = this._jfc.getSelectedFiles();
        }
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                this._listModel.addElement(c[i]);
            }
        }
    }

    @Override
    protected Action _getAddAction() {
        return new AbstractAction("Add"){

            public void actionPerformed(ActionEvent ae) {
                VectorFileOptionComponent.this.chooseFile();
                VectorFileOptionComponent.this._list.setSelectedIndex(VectorFileOptionComponent.this._listModel.getSize() - 1);
                VectorFileOptionComponent.this.notifyChangeListeners();
            }
        };
    }
}

