/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.collect.Multiset;
import edu.rice.cs.plt.iter.IterUtil;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMultiset<T>
implements Multiset<T> {
    private HashMap<T, Integer> _counts = new HashMap();
    private int _size;

    public HashMultiset() {
    }

    public HashMultiset(Collection<? extends T> coll) {
        this();
        this.addAll(coll);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean contains(Object obj) {
        return this._counts.containsKey(obj);
    }

    @Override
    public int count(Object value) {
        if (this._counts.containsKey(value)) {
            return this._counts.get(value);
        }
        return 0;
    }

    @Override
    public Set<T> asSet() {
        return this._counts.keySet();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Map.Entry<T, Integer>> mapIter = this._counts.entrySet().iterator();
        return new Iterator<T>(){
            private Map.Entry<T, Integer> currentEntry = null;
            private int i;
            private boolean removed = false;

            @Override
            public boolean hasNext() {
                return mapIter.hasNext() || this.currentEntry != null && this.i < this.currentEntry.getValue();
            }

            @Override
            public T next() {
                if (this.currentEntry == null || this.i >= this.currentEntry.getValue()) {
                    this.currentEntry = (Map.Entry)mapIter.next();
                    this.i = 0;
                }
                this.removed = false;
                ++this.i;
                return this.currentEntry.getKey();
            }

            @Override
            public void remove() {
                if (this.currentEntry == null || this.removed) {
                    throw new IllegalStateException();
                }
                this.removed = true;
                HashMultiset.access$010(HashMultiset.this);
                int oldCount = this.currentEntry.getValue();
                if (oldCount == 1) {
                    this.currentEntry = null;
                    mapIter.remove();
                } else {
                    this.currentEntry.setValue(Autobox.valueOf(oldCount - 1));
                    --this.i;
                }
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this._size];
        int i = 0;
        for (T obj : this) {
            result[i] = obj;
            ++i;
        }
        return result;
    }

    @Override
    public <E> E[] toArray(E[] fill) {
        if (fill.length < this._size) {
            Object[] newFill = (Object[])Array.newInstance(fill.getClass().getComponentType(), this._size);
            fill = newFill;
        }
        int i = 0;
        Iterator<T> i$ = this.iterator();
        while (i$.hasNext()) {
            T elt;
            T asE = elt = i$.next();
            fill[i] = asE;
            ++i;
        }
        if (i < fill.length) {
            fill[i] = null;
            ++i;
        }
        return fill;
    }

    @Override
    public boolean add(T val) {
        this._counts.put(val, Autobox.valueOf(this.count(val) + 1));
        ++this._size;
        return true;
    }

    @Override
    public boolean add(T val, int instances) {
        this._counts.put(val, Autobox.valueOf(this.count(val) + instances));
        this._size += instances;
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (!this.contains(obj)) {
            return false;
        }
        this.doRemove(obj, 1);
        return true;
    }

    @Override
    public boolean remove(Object obj, int instances) {
        if (!this.contains(obj)) {
            return false;
        }
        this.doRemove(obj, instances);
        return true;
    }

    @Override
    public boolean removeAllInstances(Object obj) {
        if (!this.contains(obj)) {
            return false;
        }
        this.doRemove(obj, this.count(obj));
        return true;
    }

    private void doRemove(Object key, int instances) {
        int newCount = this.count(key) - instances;
        if (newCount <= 0) {
            this._counts.remove(key);
            int actualInstances = instances - newCount;
            this._size -= actualInstances;
        } else {
            Object keyAsT = key;
            this._counts.put(keyAsT, Autobox.valueOf(newCount));
            this._size -= instances;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : this.asMultiset(c).asSet()) {
            if (this.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        boolean result = false;
        Multiset<T> collMultiset = this.asMultiset(coll);
        for (T entry : collMultiset.asSet()) {
            result |= this.add(entry, collMultiset.count(entry));
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        if (coll instanceof Multiset && coll.size() > this._size) {
            return this.removeAllByThis(coll);
        }
        return this.removeAllByThat(coll);
    }

    private boolean removeAllByThis(Collection<?> coll) {
        boolean result = false;
        Multiset<?> collMultiset = this.asMultiset(coll);
        Iterator<Map.Entry<T, Integer>> iter = this._counts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<T, Integer> entry = iter.next();
            if (!collMultiset.contains(entry.getKey())) continue;
            int delta = collMultiset.count(entry.getKey());
            int newCount = entry.getValue() - delta;
            if (newCount > 0) continue;
            iter.remove();
            int actualDelta = delta - newCount;
            this._size -= actualDelta;
            result = true;
        }
        return result;
    }

    private boolean removeAllByThat(Collection<?> coll) {
        boolean result = false;
        Multiset<?> collMultiset = this.asMultiset(coll);
        for (Object obj : collMultiset.asSet()) {
            result |= this.remove(obj, collMultiset.count(obj));
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean result = false;
        Multiset<?> collMultiset = this.asMultiset(coll);
        Iterator<Map.Entry<T, Integer>> iter = this._counts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<T, Integer> entry = iter.next();
            if (collMultiset.contains(entry.getKey())) {
                int newCount = collMultiset.count(entry.getKey());
                if (entry.getValue() <= newCount) continue;
                this._size -= entry.getValue() - newCount;
                entry.setValue(Autobox.valueOf(newCount));
                result = true;
                continue;
            }
            this._size -= entry.getValue().intValue();
            iter.remove();
            result = true;
        }
        return result;
    }

    @Override
    public void clear() {
        this._counts.clear();
    }

    public String toString() {
        return IterUtil.toString((Iterable_)((Object)this));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Multiset)) {
            return false;
        }
        Multiset cast = (Multiset)obj;
        if (this._size == cast.size()) {
            for (Object elt : cast.asSet()) {
                if (this.count(elt) == cast.count(elt)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (T elt : this.asSet()) {
            result ^= (elt == null ? 0 : elt.hashCode()) ^ this.count(elt);
        }
        return result;
    }

    private <T> Multiset<T> asMultiset(Collection<T> coll) {
        if (coll instanceof Multiset) {
            return (Multiset)coll;
        }
        return new HashMultiset<T>(coll);
    }

    static int access$010(HashMultiset x0) {
        return x0._size--;
    }
}

