/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LambdaUtil;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TotalMap<K, V> {
    private final Lambda<? super K, ? extends V> _lambda;
    private final Map<? super K, V> _overrides;
    private final boolean _cache;

    public TotalMap() {
        this(LambdaUtil.nullLambda(), new HashMap(), false);
    }

    public TotalMap(Lambda<? super K, ? extends V> lambda) {
        this(lambda, new HashMap(), false);
    }

    public TotalMap(Lambda<? super K, ? extends V> lambda, boolean cache) {
        this(lambda, new HashMap(), cache);
    }

    public TotalMap(Map<? super K, V> overrides) {
        this(LambdaUtil.nullLambda(), overrides, false);
    }

    public TotalMap(Lambda<? super K, ? extends V> lambda, Map<? super K, V> overrides) {
        this(lambda, overrides, false);
    }

    public TotalMap(Lambda<? super K, ? extends V> lambda, Map<? super K, V> overrides, boolean cache) {
        this._lambda = lambda;
        this._overrides = overrides;
        this._cache = cache;
    }

    public V get(K key) {
        if (this._overrides.containsKey(key)) {
            return this._overrides.get(key);
        }
        V result = this._lambda.value(key);
        if (this._cache) {
            this._overrides.put(key, result);
        }
        return result;
    }

    public void override(K key, V value) {
        this._overrides.put(key, value);
    }

    public boolean containsOverride(Object key) {
        return this._overrides.containsKey(key);
    }

    public V revert(K key) {
        return this._overrides.remove(key);
    }

    public void overrideAll(Map<? extends K, ? extends V> map) {
        this._overrides.putAll(map);
    }

    public void revertAll() {
        this._overrides.clear();
    }

    public int cacheSize() {
        return this._overrides.size();
    }

    public static <K, V> TotalMap<K, V> make() {
        return new TotalMap<K, V>();
    }

    public static <K, V> TotalMap<K, V> make(Lambda<? super K, ? extends V> lambda) {
        return new TotalMap<K, V>(lambda);
    }

    public static <K, V> TotalMap<K, V> make(Lambda<? super K, ? extends V> lambda, boolean cache) {
        return new TotalMap<K, V>(lambda, cache);
    }

    public static <K, V> TotalMap<K, V> make(Map<? super K, V> overrides) {
        return new TotalMap<K, V>(overrides);
    }

    public static <K, V> TotalMap<K, V> make(Lambda<? super K, ? extends V> lambda, Map<? super K, V> overrides) {
        return new TotalMap<K, V>(lambda, overrides);
    }

    public static <K, V> TotalMap<K, V> make(Lambda<? super K, ? extends V> lambda, Map<? super K, V> overrides, boolean cache) {
        return new TotalMap<K, V>(lambda, overrides, cache);
    }
}

