/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.Lambda3;
import edu.rice.cs.plt.lambda.Lambda4;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.reflect.PathClassLoader;
import edu.rice.cs.plt.reflect.PreemptingClassLoader;
import edu.rice.cs.plt.reflect.ReflectException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectUtil {
    private static final ClassLoader CURRENT_LOADER = (class$edu$rice$cs$plt$reflect$ReflectUtil == null ? (class$edu$rice$cs$plt$reflect$ReflectUtil = ReflectUtil.class$("edu.rice.cs.plt.reflect.ReflectUtil")) : class$edu$rice$cs$plt$reflect$ReflectUtil).getClassLoader();
    private static final /* synthetic */ Class class$java$lang$Integer;
    private static final /* synthetic */ Class class$java$lang$Long;
    private static final /* synthetic */ Class class$edu$rice$cs$plt$reflect$ReflectUtil;
    private static final /* synthetic */ Class class$java$lang$Void;
    private static final /* synthetic */ Class class$java$lang$Double;
    private static final /* synthetic */ Class class$java$lang$Float;
    private static final /* synthetic */ Class class$java$lang$Byte;
    private static final /* synthetic */ Class class$java$lang$Boolean;
    private static final /* synthetic */ Class class$java$lang$Short;
    private static final /* synthetic */ Class class$java$lang$Character;

    private ReflectUtil() {
    }

    public static String simpleName(Class<?> c) {
        if (c.isArray()) {
            return new StringBuffer().append(ReflectUtil.simpleName(c.getComponentType())).append("[]").toString();
        }
        if (ReflectUtil.isAnonymousClass(c)) {
            if (c.getInterfaces().length > 0) {
                return new StringBuffer().append("anonymous ").append(ReflectUtil.simpleName(c.getInterfaces()[0])).toString();
            }
            return new StringBuffer().append("anonymous ").append(ReflectUtil.simpleName(c.getSuperclass())).toString();
        }
        String fullName = c.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public static boolean isAnonymousClass(Class<?> c) {
        String name = c.getName();
        String nameEnd = name.substring(name.lastIndexOf(36) + 1);
        for (int i = 0; i < nameEnd.length(); ++i) {
            if (!Character.isJavaIdentifierStart(nameEnd.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> T cast(Class<? extends T> c, Object o) throws ClassCastException {
        if (ReflectUtil.box(c).isInstance(o)) {
            Object result = o;
            return (T)result;
        }
        throw new ClassCastException(new StringBuffer().append("Casting to ").append(c.getName()).append(" from ").append(o.getClass().getName()).toString());
    }

    public static <T> Class<? extends T> getClass(T obj) {
        return obj.getClass();
    }

    public static <T> Class<T> box(Class<T> c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (c == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = ReflectUtil.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (c == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectUtil.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (c == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = ReflectUtil.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (c == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (c == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = ReflectUtil.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (c == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = ReflectUtil.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (c == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = ReflectUtil.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (c == Void.TYPE) {
                return class$java$lang$Void == null ? (class$java$lang$Void = ReflectUtil.class$("java.lang.Void")) : class$java$lang$Void;
            }
        }
        return c;
    }

    private static Class<?>[] getClasses(Object[] args) {
        if (args.length > 0) {
            Class[] sig = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                sig[i] = args[i].getClass();
            }
            return sig;
        }
        return null;
    }

    public static Object loadObject(String className, Object ... constructorArgs) throws ReflectException {
        return ReflectUtil.loadObject(CURRENT_LOADER, className, ReflectUtil.getClasses(constructorArgs), constructorArgs);
    }

    public static Object loadObject(String className, Class[] constructorSig, Object ... constructorArgs) throws ReflectException {
        return ReflectUtil.loadObject(CURRENT_LOADER, className, constructorSig, constructorArgs);
    }

    public static Object loadObject(ClassLoader loader, String className, Object ... constructorArgs) throws ReflectException {
        return ReflectUtil.loadObject(loader, className, ReflectUtil.getClasses(constructorArgs), constructorArgs);
    }

    public static Object loadObject(ClassLoader loader, String className, Class[] constructorSig, Object ... constructorArgs) throws ReflectException {
        try {
            Class<?> c = Class.forName(className, true, loader);
            Constructor<?> k = c.getConstructor(constructorSig);
            return k.newInstance(constructorArgs);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException.ClassNotFoundReflectException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectException.NoSuchMethodReflectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectException.IllegalArgumentReflectException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectException.InvocationTargetReflectException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectException.InstantiationReflectException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException.IllegalAccessReflectException(e);
        }
        catch (SecurityException e) {
            throw new ReflectException.SecurityReflectException(e);
        }
    }

    public static Object getStaticField(String className, String fieldName) throws ReflectException {
        return ReflectUtil.getStaticField(CURRENT_LOADER, className, fieldName);
    }

    public static Object getStaticField(ClassLoader loader, String className, String fieldName) throws ReflectException {
        try {
            Class<?> c = Class.forName(className, true, loader);
            Field f = c.getField(fieldName);
            try {
                return f.get(null);
            }
            catch (NullPointerException e) {
                throw new ReflectException.NullPointerReflectException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException.ClassNotFoundReflectException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectException.NoSuchFieldReflectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectException.IllegalArgumentReflectException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException.IllegalAccessReflectException(e);
        }
        catch (SecurityException e) {
            throw new ReflectException.SecurityReflectException(e);
        }
    }

    public static Object invokeStaticMethod(String className, String methodName, Object ... args) throws ReflectException {
        return ReflectUtil.invokeStaticMethod(CURRENT_LOADER, className, methodName, ReflectUtil.getClasses(args), args);
    }

    public static Object invokeStaticMethod(ClassLoader loader, String className, String methodName, Object ... args) throws ReflectException {
        return ReflectUtil.invokeStaticMethod(loader, className, methodName, ReflectUtil.getClasses(args), args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Class[] signature, Object ... args) throws ReflectException {
        return ReflectUtil.invokeStaticMethod(CURRENT_LOADER, className, methodName, signature, args);
    }

    public static Object invokeStaticMethod(ClassLoader loader, String className, String methodName, Class[] signature, Object ... args) throws ReflectException {
        try {
            Class<?> c = Class.forName(className, true, loader);
            Method m = c.getMethod(methodName, signature);
            try {
                return m.invoke(null, args);
            }
            catch (NullPointerException e) {
                throw new ReflectException.NullPointerReflectException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException.ClassNotFoundReflectException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectException.NoSuchMethodReflectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectException.IllegalArgumentReflectException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectException.InvocationTargetReflectException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException.IllegalAccessReflectException(e);
        }
        catch (SecurityException e) {
            throw new ReflectException.SecurityReflectException(e);
        }
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Object loadLibraryAdapter(Iterable_ libraryPath, String adapterName, Object ... constructorArgs) throws ReflectException {
        return ReflectUtil.loadLibraryAdapter(CURRENT_LOADER, libraryPath, adapterName, ReflectUtil.getClasses(constructorArgs), constructorArgs);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Object loadLibraryAdapter(Iterable_ libraryPath, String adapterName, Class[] constructorSig, Object ... constructorArgs) throws ReflectException {
        return ReflectUtil.loadLibraryAdapter(CURRENT_LOADER, libraryPath, adapterName, constructorSig, constructorArgs);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Object loadLibraryAdapter(ClassLoader baseLoader, Iterable_ libraryPath, String adapterName, Object ... constructorArgs) throws ReflectException {
        return ReflectUtil.loadLibraryAdapter(baseLoader, libraryPath, adapterName, ReflectUtil.getClasses(constructorArgs), constructorArgs);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Object loadLibraryAdapter(ClassLoader baseLoader, Iterable_ libraryPath, String adapterName, Class[] constructorSig, Object ... constructorArgs) throws ReflectException {
        PathClassLoader libraryLoader = new PathClassLoader(baseLoader, libraryPath);
        PreemptingClassLoader adapterLoader = new PreemptingClassLoader((ClassLoader)libraryLoader, adapterName);
        return ReflectUtil.loadObject((ClassLoader)adapterLoader, adapterName, constructorSig, constructorArgs);
    }

    public static <T> Box<T> staticFieldAsBox(Class<?> c, String fieldName, Class<T> fieldType) {
        return new FieldBox<T>(c, fieldName, fieldType, null);
    }

    public static <T> Box<T> fieldAsBox(Object object, String fieldName, Class<T> fieldType) {
        return new FieldBox<T>(object.getClass(), fieldName, fieldType, object);
    }

    public static <O, R> Thunk<R> staticMethodAsThunk(Class<? super O> c, String methodName, Class<? extends R> retT) {
        return LambdaUtil.bindFirst(new MethodLambda<O, R>(c, methodName, retT), null);
    }

    public static <R> Thunk<R> methodAsThunk(Object object, String methodName, Class<? extends R> retT) {
        return new ObjectMethodThunk<R>(object, methodName, retT);
    }

    public static <O, R> Lambda<O, R> methodAsLambda(Class<? super O> c, String methodName, Class<? extends R> retT) {
        return new MethodLambda<O, R>(c, methodName, retT);
    }

    public static <O, T, R> Lambda<T, R> staticMethodAsLambda(Class<? super O> c, String methodName, Class<? super T> argT, Class<? extends R> retT) {
        return LambdaUtil.bindFirst(new MethodLambda2<O, T, R>(c, methodName, argT, retT), null);
    }

    public static <T, R> Lambda<T, R> methodAsLambda(Object object, String methodName, Class<? super T> argT, Class<? extends R> retT) {
        return new ObjectMethodLambda<T, R>(object, methodName, argT, retT);
    }

    public static <O, T, R> Lambda2<O, T, R> methodAsLambda2(Class<? super O> c, String methodName, Class<? super T> argT, Class<? extends R> retT) {
        return new MethodLambda2<O, T, R>(c, methodName, argT, retT);
    }

    public static <O, T1, T2, R> Lambda2<T1, T2, R> staticMethodAsLambda2(Class<? super O> c, String methodName, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? extends R> retT) {
        return LambdaUtil.bindFirst(new MethodLambda3<O, T1, T2, R>(c, methodName, arg1T, arg2T, retT), null);
    }

    public static <T1, T2, R> Lambda2<T1, T2, R> methodAsLambda2(Object object, String methodName, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? extends R> retT) {
        return new ObjectMethodLambda2<T1, T2, R>(object, methodName, arg1T, arg2T, retT);
    }

    public static <O, T1, T2, R> Lambda3<O, T1, T2, R> methodAsLambda3(Class<? super O> c, String methodName, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? extends R> retT) {
        return new MethodLambda3<O, T1, T2, R>(c, methodName, arg1T, arg2T, retT);
    }

    public static <O, T1, T2, T3, R> Lambda3<T1, T2, T3, R> staticMethodAsLambda3(Class<? super O> c, String methodName, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T, Class<? extends R> retT) {
        return LambdaUtil.bindFirst(new MethodLambda4<O, T1, T2, T3, R>(c, methodName, arg1T, arg2T, arg3T, retT), null);
    }

    public static <T1, T2, T3, R> Lambda3<T1, T2, T3, R> methodAsLambda3(Object object, String methodName, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T, Class<? extends R> retT) {
        return new ObjectMethodLambda3<T1, T2, T3, R>(object, methodName, arg1T, arg2T, arg3T, retT);
    }

    public static <O, T1, T2, T3, R> Lambda4<O, T1, T2, T3, R> methodAsLambda4(Class<? super O> c, String methodName, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T, Class<? extends R> retT) {
        return new MethodLambda4<O, T1, T2, T3, R>(c, methodName, arg1T, arg2T, arg3T, retT);
    }

    public static <R> Thunk<R> constructorAsThunk(Class<? extends R> c) {
        return new ConstructorThunk<R>(c);
    }

    public static <T, R> Lambda<T, R> constructorAsLambda(Class<? extends R> c, Class<? super T> argT) {
        return new ConstructorLambda<T, R>(c, argT);
    }

    public static <T1, T2, R> Lambda2<T1, T2, R> constructorAsLambda2(Class<? extends R> c, Class<? super T1> arg1T, Class<? super T2> arg2T) {
        return new ConstructorLambda2<T1, T2, R>(c, arg1T, arg2T);
    }

    public static <T1, T2, T3, R> Lambda3<T1, T2, T3, R> constructorAsLambda3(Class<? extends R> c, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T) {
        return new ConstructorLambda3<T1, T2, T3, R>(c, arg1T, arg2T, arg3T);
    }

    public static <T1, T2, T3, T4, R> Lambda4<T1, T2, T3, T4, R> constructorAsLambda4(Class<? extends R> c, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T, Class<? super T4> arg4T) {
        return new ConstructorLambda4<T1, T2, T3, T4, R>(c, arg1T, arg2T, arg3T, arg4T);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstructorLambda4<T1, T2, T3, T4, R>
    extends ConstructorWrapper<R>
    implements Lambda4<T1, T2, T3, T4, R> {
        public ConstructorLambda4(Class<? extends R> c, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T, Class<? super T4> arg4T) {
            super(c, arg1T, arg2T, arg3T, arg4T);
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3, T4 arg4) {
            return this.invoke(arg1, arg2, arg3, arg4);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstructorLambda3<T1, T2, T3, R>
    extends ConstructorWrapper<R>
    implements Lambda3<T1, T2, T3, R> {
        public ConstructorLambda3(Class<? extends R> c, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T) {
            super(c, arg1T, arg2T, arg3T);
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3) {
            return this.invoke(arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstructorLambda2<T1, T2, R>
    extends ConstructorWrapper<R>
    implements Lambda2<T1, T2, R> {
        public ConstructorLambda2(Class<? extends R> c, Class<? super T1> arg1T, Class<? super T2> arg2T) {
            super(c, arg1T, arg2T);
        }

        @Override
        public R value(T1 arg1, T2 arg2) {
            return this.invoke(arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstructorLambda<T, R>
    extends ConstructorWrapper<R>
    implements Lambda<T, R> {
        public ConstructorLambda(Class<? extends R> c, Class<? super T> argT) {
            super(c, argT);
        }

        @Override
        public R value(T arg) {
            return this.invoke(arg);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConstructorThunk<R>
    extends ConstructorWrapper<R>
    implements Thunk<R> {
        public ConstructorThunk(Class<? extends R> c) {
            super(c, new Class[0]);
        }

        @Override
        public R value() {
            return this.invoke(new Object[0]);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ConstructorWrapper<R>
    implements Serializable {
        private final Class<? extends R> _c;
        private final Class<?>[] _signature;
        private transient Constructor<? extends R> _k;

        protected ConstructorWrapper(Class<? extends R> c, Class<?> ... signature) {
            this._c = c;
            this._signature = signature;
            this._k = null;
        }

        protected R invoke(Object ... args) {
            try {
                if (this._k == null) {
                    this._k = this._c.getConstructor(this._signature);
                }
                return this._k.newInstance(args);
            }
            catch (NoSuchMethodException e) {
                throw new WrappedException(new ReflectException.NoSuchMethodReflectException(e));
            }
            catch (IllegalArgumentException e) {
                throw new WrappedException(new ReflectException.IllegalArgumentReflectException(e));
            }
            catch (InvocationTargetException e) {
                throw new WrappedException(new ReflectException.InvocationTargetReflectException(e));
            }
            catch (IllegalAccessException e) {
                throw new WrappedException(new ReflectException.IllegalAccessReflectException(e));
            }
            catch (InstantiationException e) {
                throw new WrappedException(new ReflectException.InstantiationReflectException(e));
            }
            catch (SecurityException e) {
                throw new WrappedException(new ReflectException.SecurityReflectException(e));
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodLambda4<O, T1, T2, T3, R>
    extends MethodWrapper<R>
    implements Lambda4<O, T1, T2, T3, R> {
        public MethodLambda4(Class<? super O> objT, String name, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T, Class<? extends R> returnT) {
            super(objT, name, returnT, arg1T, arg2T, arg3T);
        }

        @Override
        public R value(O obj, T1 arg1, T2 arg2, T3 arg3) {
            return this.invoke(obj, arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectMethodLambda3<T1, T2, T3, R>
    extends MethodWrapper<R>
    implements Lambda3<T1, T2, T3, R> {
        private final Object _obj;

        public ObjectMethodLambda3(Object obj, String name, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? super T3> arg3T, Class<? extends R> returnT) {
            super(obj.getClass(), name, returnT, arg1T, arg2T, arg3T);
            this._obj = obj;
        }

        @Override
        public R value(T1 arg1, T2 arg2, T3 arg3) {
            return this.invoke(this._obj, arg1, arg2, arg3);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodLambda3<O, T1, T2, R>
    extends MethodWrapper<R>
    implements Lambda3<O, T1, T2, R> {
        public MethodLambda3(Class<? super O> objT, String name, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? extends R> returnT) {
            super(objT, name, returnT, arg1T, arg2T);
        }

        @Override
        public R value(O obj, T1 arg1, T2 arg2) {
            return this.invoke(obj, arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectMethodLambda2<T1, T2, R>
    extends MethodWrapper<R>
    implements Lambda2<T1, T2, R> {
        private final Object _obj;

        public ObjectMethodLambda2(Object obj, String name, Class<? super T1> arg1T, Class<? super T2> arg2T, Class<? extends R> returnT) {
            super(obj.getClass(), name, returnT, arg1T, arg2T);
            this._obj = obj;
        }

        @Override
        public R value(T1 arg1, T2 arg2) {
            return this.invoke(this._obj, arg1, arg2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodLambda2<O, T, R>
    extends MethodWrapper<R>
    implements Lambda2<O, T, R> {
        public MethodLambda2(Class<? super O> objT, String name, Class<? super T> argT, Class<? extends R> returnT) {
            super(objT, name, returnT, argT);
        }

        @Override
        public R value(O obj, T arg) {
            return this.invoke(obj, arg);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectMethodLambda<T, R>
    extends MethodWrapper<R>
    implements Lambda<T, R> {
        private final Object _obj;

        public ObjectMethodLambda(Object obj, String name, Class<? super T> argT, Class<? extends R> returnT) {
            super(obj.getClass(), name, returnT, argT);
            this._obj = obj;
        }

        @Override
        public R value(T arg) {
            return this.invoke(this._obj, arg);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodLambda<O, R>
    extends MethodWrapper<R>
    implements Lambda<O, R> {
        public MethodLambda(Class<? super O> objT, String name, Class<? extends R> returnT) {
            super(objT, name, returnT, new Class[0]);
        }

        @Override
        public R value(O obj) {
            return this.invoke(obj, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectMethodThunk<R>
    extends MethodWrapper<R>
    implements Thunk<R> {
        private final Object _obj;

        public ObjectMethodThunk(Object obj, String name, Class<? extends R> returnT) {
            super(obj.getClass(), name, returnT, new Class[0]);
            this._obj = obj;
        }

        @Override
        public R value() {
            return this.invoke(this._obj, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MethodWrapper<R>
    implements Serializable {
        private final Class<?> _objClass;
        private final String _name;
        private final Class<? extends R> _returnType;
        private final Class<?>[] _signature;
        private transient Method _method;

        protected MethodWrapper(Class<?> objClass, String name, Class<? extends R> returnType, Class<?> ... signature) {
            this._objClass = objClass;
            this._name = name;
            this._returnType = returnType;
            this._signature = signature;
            this._method = null;
        }

        protected R invoke(Object obj, Object ... args) {
            try {
                if (this._method == null) {
                    this._method = this._objClass.getMethod(this._name, this._signature);
                }
                try {
                    return ReflectUtil.cast(this._returnType, this._method.invoke(obj, args));
                }
                catch (NullPointerException e) {
                    throw new WrappedException(new ReflectException.NullPointerReflectException(e));
                }
            }
            catch (NoSuchMethodException e) {
                throw new WrappedException(new ReflectException.NoSuchMethodReflectException(e));
            }
            catch (IllegalArgumentException e) {
                throw new WrappedException(new ReflectException.IllegalArgumentReflectException(e));
            }
            catch (InvocationTargetException e) {
                throw new WrappedException(new ReflectException.InvocationTargetReflectException(e));
            }
            catch (IllegalAccessException e) {
                throw new WrappedException(new ReflectException.IllegalAccessReflectException(e));
            }
            catch (ClassCastException e) {
                throw new WrappedException(new ReflectException.ClassCastReflectException(e));
            }
            catch (SecurityException e) {
                throw new WrappedException(new ReflectException.SecurityReflectException(e));
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FieldBox<T>
    implements Box<T>,
    Serializable {
        private final Class<?> _objClass;
        private final String _name;
        private final Class<T> _type;
        private final Object _obj;
        private transient Field _field;

        public FieldBox(Class<?> objClass, String name, Class<T> type, Object obj) {
            this._objClass = objClass;
            this._name = name;
            this._type = type;
            this._obj = obj;
            this._field = null;
        }

        @Override
        public T value() {
            try {
                if (this._field == null) {
                    this._field = this._objClass.getField(this._name);
                }
                try {
                    return ReflectUtil.cast(this._type, this._field.get(this._obj));
                }
                catch (NullPointerException e) {
                    throw new WrappedException(new ReflectException.NullPointerReflectException(e));
                }
            }
            catch (NoSuchFieldException e) {
                throw new WrappedException(new ReflectException.NoSuchFieldReflectException(e));
            }
            catch (IllegalArgumentException e) {
                throw new WrappedException(new ReflectException.IllegalArgumentReflectException(e));
            }
            catch (IllegalAccessException e) {
                throw new WrappedException(new ReflectException.IllegalAccessReflectException(e));
            }
            catch (ClassCastException e) {
                throw new WrappedException(new ReflectException.ClassCastReflectException(e));
            }
            catch (SecurityException e) {
                throw new WrappedException(new ReflectException.SecurityReflectException(e));
            }
        }

        @Override
        public void set(T value) {
            try {
                if (this._field == null) {
                    this._field = this._objClass.getField(this._name);
                }
                this._field.set(this._obj, value);
            }
            catch (NoSuchFieldException e) {
                throw new WrappedException(new ReflectException.NoSuchFieldReflectException(e));
            }
            catch (IllegalArgumentException e) {
                throw new WrappedException(new ReflectException.IllegalArgumentReflectException(e));
            }
            catch (IllegalAccessException e) {
                throw new WrappedException(new ReflectException.IllegalAccessReflectException(e));
            }
            catch (SecurityException e) {
                throw new WrappedException(new ReflectException.SecurityReflectException(e));
            }
        }
    }
}

