/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.JavaConstructorInfo;
import koala.dynamicjava.classinfo.JavaFieldInfo;
import koala.dynamicjava.classinfo.JavaMethodInfo;
import koala.dynamicjava.classinfo.MethodInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassInfo
implements ClassInfo {
    public static final JavaClassInfo BOOLEAN = new JavaClassInfo(Boolean.TYPE);
    public static final JavaClassInfo INT = new JavaClassInfo(Integer.TYPE);
    public static final JavaClassInfo LONG = new JavaClassInfo(Long.TYPE);
    public static final JavaClassInfo FLOAT = new JavaClassInfo(Float.TYPE);
    public static final JavaClassInfo DOUBLE = new JavaClassInfo(Double.TYPE);
    public static final JavaClassInfo STRING = new JavaClassInfo(class$java$lang$String == null ? (class$java$lang$String = JavaClassInfo.class$("java.lang.String")) : class$java$lang$String);
    public static final JavaClassInfo CLASS = new JavaClassInfo(class$java$lang$Class == null ? (class$java$lang$Class = JavaClassInfo.class$("java.lang.Class")) : class$java$lang$Class);
    private Class<?> javaClass;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public JavaClassInfo(Class<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        this.javaClass = c;
    }

    public JavaClassInfo(JavaClassInfo c) {
        this.javaClass = Array.newInstance(c.javaClass, 0).getClass();
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isCompilable() {
        return false;
    }

    @Override
    public void setCompilable(boolean b) {
        throw new IllegalStateException();
    }

    @Override
    public ClassInfo getDeclaringClass() {
        Class<?> c = this.javaClass.getDeclaringClass();
        return c == null ? null : new JavaClassInfo(c);
    }

    @Override
    public ClassInfo getAnonymousDeclaringClass() {
        return null;
    }

    @Override
    public int getModifiers() {
        return this.javaClass.getModifiers();
    }

    @Override
    public String getName() {
        return this.javaClass.getName();
    }

    @Override
    public ClassInfo getSuperclass() {
        Class<?> c = this.javaClass.getSuperclass();
        return c == null ? null : new JavaClassInfo(c);
    }

    @Override
    public ClassInfo[] getInterfaces() {
        Class<?>[] interfaces = this.javaClass.getInterfaces();
        ClassInfo[] result = new ClassInfo[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            result[i] = new JavaClassInfo(interfaces[i]);
        }
        return result;
    }

    @Override
    public FieldInfo[] getFields() {
        Field[] fields = this.javaClass.getDeclaredFields();
        FieldInfo[] result = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = new JavaFieldInfo(fields[i]);
        }
        return result;
    }

    @Override
    public ConstructorInfo[] getConstructors() {
        Constructor<?>[] constructors = this.javaClass.getDeclaredConstructors();
        ConstructorInfo[] result = new ConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new JavaConstructorInfo(constructors[i]);
        }
        return result;
    }

    @Override
    public MethodInfo[] getMethods() {
        Method[] methods = this.javaClass.getDeclaredMethods();
        MethodInfo[] result = new MethodInfo[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new JavaMethodInfo(methods[i]);
        }
        return result;
    }

    @Override
    public ClassInfo[] getDeclaredClasses() {
        Class<?>[] classes = this.javaClass.getDeclaredClasses();
        ClassInfo[] result = new ClassInfo[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = new JavaClassInfo(classes[i]);
        }
        return result;
    }

    @Override
    public ClassInfo getArrayType() {
        return new JavaClassInfo(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassInfo)) {
            return false;
        }
        return this.javaClass.getName().equals(((ClassInfo)obj).getName());
    }

    @Override
    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    @Override
    public boolean isArray() {
        return this.javaClass.isArray();
    }

    @Override
    public boolean isPrimitive() {
        return this.javaClass.isPrimitive();
    }

    @Override
    public ClassInfo getComponentType() {
        if (!this.isArray()) {
            throw new IllegalStateException();
        }
        return new JavaClassInfo(this.javaClass.getComponentType());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

