/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.SourceInfo;
import koala.dynamicjava.classfile.InnerClassesEntry;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ClassInfoUtilities;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.classinfo.TreeClassInfo;
import koala.dynamicjava.classinfo.TreeConstructorInfo;
import koala.dynamicjava.interpreter.ClassFactory;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TreeClassFinder;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.interpreter.context.VariableContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BooleanLiteral;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.DoubleLiteral;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldAccess;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FloatLiteral;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.IntegerLiteral;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.LongLiteral;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.VoidType;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.ListUtilities;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoCompiler {
    protected TreeClassInfo classInfo;
    protected TypeDeclaration typeDeclaration;
    protected ClassFactory classFactory;
    protected TreeClassFinder classFinder;
    protected TreeInterpreter interpreter;
    protected boolean isInterface;
    protected boolean hasAbstractMethod;
    protected List<Node> classInitializer = new LinkedList<Node>();
    protected List<Node> instanceInitializer = new LinkedList<Node>();
    protected MembersVisitor membersVisitor = new MembersVisitor();
    protected ImportationManager importationManager;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public ClassInfoCompiler(ClassInfo ci) {
        this.classInfo = (TreeClassInfo)ci;
        this.typeDeclaration = this.classInfo.getTypeDeclaration();
        this.classFinder = (TreeClassFinder)this.classInfo.getClassFinder();
        this.importationManager = ci.getDeclaringClass() != null ? this.classFinder.getImportationManager() : (ImportationManager)this.classFinder.getImportationManager().clone();
        this.interpreter = (TreeInterpreter)this.classFinder.getInterpreter();
        this.isInterface = this.classInfo.isInterface();
    }

    public Class<?> compile() {
        ClassInfo dc = this.classInfo.getDeclaringClass();
        String outer = dc != null ? dc.getName() : null;
        int af = this.typeDeclaration.getAccessFlags();
        String name = this.classInfo.getName();
        if (this.isInterface) {
            af |= 0x200;
        }
        this.classFactory = new ClassFactory(af, name, this.classInfo.getSuperclass().getName(), this.interpreter.getClass(), this.interpreter.getExceptionClass(), this.interpreter.getClassLoader().toString());
        if (dc != null) {
            this.addInnerClassesAttribute(this.classInfo);
        }
        ClassInfo[] inners = this.classInfo.getDeclaredClasses();
        for (int i = 0; i < inners.length; ++i) {
            String ciname = inners[i].getName();
            InnerClassesEntry ice = this.classFactory.addInnerClassesEntry();
            ice.setInnerClassInfo(ciname);
            ice.setOuterClassInfo(name);
            ice.setInnerName(ciname.substring(name.length() + 1, ciname.length()));
            ice.setInnerClassAccessFlags((short)inners[i].getModifiers());
        }
        ClassInfo[] ci = this.classInfo.getInterfaces();
        for (int i = 0; i < ci.length; ++i) {
            this.classFactory.addInterface(ci[i].getName());
        }
        Iterator<Node> it = this.typeDeclaration.getMembers().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this.membersVisitor);
        }
        if (!this.isInterface && this.hasAbstractMethod && !Modifier.isAbstract(af)) {
            this.typeDeclaration.setProperty("errorStrings", new String[]{name});
            throw new ExecutionError("misplaced.abstract", this.typeDeclaration);
        }
        if (!this.isInterface) {
            ConstructorInfo[] cons = this.classInfo.getConstructors();
            for (int i = 0; i < cons.length; ++i) {
                this.addConstructor((TreeConstructorInfo)cons[i]);
            }
        }
        if (this.classInitializer.size() > 0) {
            this.interpreter.registerMethod(this.classFactory.createClassInitializer(), new MethodDeclaration(1, new VoidType(), "<clinit>", new LinkedList<FormalParameter>(), new LinkedList(), new BlockStatement(this.classInitializer)), this.importationManager);
        }
        TreeClassLoader classLoader = (TreeClassLoader)this.interpreter.getClassLoader();
        Class<?> result = classLoader.defineClass(name, this.classFactory.getByteCode());
        return result;
    }

    protected void addConstructor(TreeConstructorInfo ci) {
        ClassInfo[] cinf = ci.getParameterTypes();
        String[] params = new String[cinf.length];
        for (int i = 0; i < cinf.length; ++i) {
            params[i] = cinf[i].getName();
        }
        cinf = ci.getExceptionTypes();
        String[] ex = new String[cinf.length];
        for (int i = 0; i < cinf.length; ++i) {
            ex[i] = cinf[i].getName();
        }
        String sig = ClassFactory.getMethodIdentifier(this.classInfo.getName(), "<init>", params, this.interpreter.getClassLoader().toString());
        ConstructorDeclaration cd = ci.getConstructorDeclaration();
        if (!cd.getName().equals(this.typeDeclaration.getName())) {
            cd.setProperty("errorStrings", new String[]{cd.getName()});
            throw new ExecutionError("constructor.name", cd);
        }
        ConstructorInvocation civ = cd.getConstructorInvocation();
        ConstructorVisitor cv = new ConstructorVisitor();
        if (civ != null) {
            Iterator<FormalParameter> it = cd.getParameters().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(cv);
            }
            civ.acceptVisitor(cv);
            this.interpreter.registerConstructorArguments(sig, cd.getParameters(), civ.getArguments(), this.importationManager);
        } else {
            this.interpreter.registerConstructorArguments(sig, new LinkedList<FormalParameter>(), new LinkedList<Expression>(), this.importationManager);
        }
        MethodDeclaration md = new MethodDeclaration(cd.getAccessFlags(), new VoidType(), "<init>", cd.getParameters(), new LinkedList(), new BlockStatement(cd.getStatements()));
        this.interpreter.registerMethod(sig, md, this.importationManager);
        if (!cv.superConstructor.equals(this.classInfo.getName())) {
            ListIterator<Node> lit = cd.getStatements().listIterator();
            Iterator<Node> it = this.instanceInitializer.iterator();
            while (it.hasNext()) {
                lit.add(it.next());
            }
        }
        this.classFactory.addConstructor(cd.getAccessFlags(), params, ex, cv.superConstructor, cv.constructorParameters);
    }

    protected void addInnerClassesAttribute(ClassInfo ci) {
        for (ClassInfo dc = ci.getDeclaringClass(); dc != null; dc = dc.getDeclaringClass()) {
            String ciname = ci.getName();
            String dcname = dc.getName();
            InnerClassesEntry ice = this.classFactory.addInnerClassesEntry();
            ice.setInnerClassInfo(ciname);
            ice.setOuterClassInfo(dcname);
            ice.setInnerName(ciname.substring(dcname.length() + 1, ciname.length()));
            ice.setInnerClassAccessFlags((short)ci.getModifiers());
            ci = dc;
        }
    }

    protected void addToClassInitializer(Node n) {
        this.classInitializer.add(n);
    }

    protected void addToInstanceInitializer(Node n) {
        this.instanceInitializer.add(n);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MembersVisitor
    extends VisitorObject<Void> {
        protected MembersVisitor() {
        }

        @Override
        public Void visit(ClassInitializer node) {
            Iterator<Node> it = node.getBlock().getStatements().iterator();
            while (it.hasNext()) {
                ClassInfoCompiler.this.addToClassInitializer(it.next());
            }
            return null;
        }

        @Override
        public Void visit(InstanceInitializer node) {
            Iterator<Node> it = node.getBlock().getStatements().iterator();
            while (it.hasNext()) {
                ClassInfoCompiler.this.addToInstanceInitializer(it.next());
            }
            return null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void visit(FieldDeclaration node) {
            Expression init;
            FieldInfo fi = ClassInfoCompiler.this.classInfo.getField(node);
            int af = node.getAccessFlags();
            String rt = fi.getType().getName();
            String fn = node.getName();
            if (ClassInfoCompiler.this.isInterface) {
                if (Modifier.isPrivate(af) || Modifier.isProtected(af)) {
                    node.setProperty("errorStrings", new String[]{fn, ClassInfoCompiler.this.classInfo.getName()});
                    throw new ExecutionError("interface.field.modifier", node);
                }
                af |= 0x19;
            }
            if ((init = node.getInitializer()) != null) {
                if (init instanceof Literal && Modifier.isFinal(af) && Modifier.isStatic(af)) {
                    if (init instanceof IntegerLiteral) {
                        Integer n = (Integer)((Literal)init).getValue();
                        if (rt.equals("byte")) {
                            if (n.intValue() != n.byteValue()) {
                                throw new ExecutionError("invalid.constant", node);
                            }
                            ClassInfoCompiler.this.classFactory.addConstantIntField(af, rt, fn, n);
                            return null;
                        } else if (rt.equals("short")) {
                            if (n.intValue() != n.shortValue()) {
                                throw new ExecutionError("invalid.constant", node);
                            }
                            ClassInfoCompiler.this.classFactory.addConstantIntField(af, rt, fn, n);
                            return null;
                        } else if (rt.equals("int")) {
                            ClassInfoCompiler.this.classFactory.addConstantIntField(af, rt, fn, n);
                            return null;
                        } else if (rt.equals("long")) {
                            ClassInfoCompiler.this.classFactory.addConstantLongField(af, rt, fn, new Long(n.longValue()));
                            return null;
                        } else if (rt.equals("float")) {
                            ClassInfoCompiler.this.classFactory.addConstantFloatField(af, rt, fn, new Float(n.floatValue()));
                            return null;
                        } else {
                            if (!rt.equals("double")) throw new ExecutionError("invalid.constant", node);
                            ClassInfoCompiler.this.classFactory.addConstantDoubleField(af, rt, fn, new Double(n.doubleValue()));
                        }
                        return null;
                    } else if (init instanceof LongLiteral) {
                        Long l = (Long)((Literal)init).getValue();
                        if (rt.equals("long")) {
                            ClassInfoCompiler.this.classFactory.addConstantLongField(af, rt, fn, new Long(l));
                            return null;
                        } else if (rt.equals("float")) {
                            ClassInfoCompiler.this.classFactory.addConstantFloatField(af, rt, fn, new Float(l.floatValue()));
                            return null;
                        } else {
                            if (!rt.equals("double")) throw new ExecutionError("invalid.constant", node);
                            ClassInfoCompiler.this.classFactory.addConstantDoubleField(af, rt, fn, new Double(l.doubleValue()));
                        }
                        return null;
                    } else if (init instanceof FloatLiteral) {
                        Float f = (Float)((Literal)init).getValue();
                        if (rt.equals("float")) {
                            ClassInfoCompiler.this.classFactory.addConstantFloatField(af, rt, fn, new Float(f.floatValue()));
                            return null;
                        } else {
                            if (!rt.equals("double")) throw new ExecutionError("invalid.constant", node);
                            ClassInfoCompiler.this.classFactory.addConstantDoubleField(af, rt, fn, new Double(f.doubleValue()));
                        }
                        return null;
                    } else if (init instanceof DoubleLiteral) {
                        Double d = (Double)((Literal)init).getValue();
                        if (!rt.equals("double")) throw new ExecutionError("invalid.constant", node);
                        ClassInfoCompiler.this.classFactory.addConstantDoubleField(af, rt, fn, new Double(d));
                        return null;
                    } else if (init instanceof BooleanLiteral) {
                        Boolean bl = (Boolean)((Literal)init).getValue();
                        if (!rt.equals("boolean")) throw new ExecutionError("invalid.constant", node);
                        ClassInfoCompiler.this.classFactory.addConstantBooleanField(af, rt, fn, bl);
                        return null;
                    } else {
                        String string = (String)((Literal)init).getValue();
                        ClassInfoCompiler.this.classFactory.addConstantStringField(af, rt, fn, string);
                    }
                    return null;
                } else {
                    void var7_17;
                    ClassInfoCompiler.this.classFactory.addField(af & 0xFFFFFFEF, rt, fn);
                    Object var7_13 = null;
                    if (Modifier.isStatic(af)) {
                        ReferenceType typ = new ReferenceType(ClassInfoCompiler.this.classInfo.getName());
                        StaticFieldAccess staticFieldAccess = new StaticFieldAccess(typ, fn);
                    } else {
                        Identifier t = new Identifier("this");
                        LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
                        l.add(t);
                        QualifiedName qualifiedName = new QualifiedName(l);
                        ObjectFieldAccess objectFieldAccess = new ObjectFieldAccess(qualifiedName, fn);
                    }
                    SimpleAssignExpression exp = new SimpleAssignExpression((Expression)var7_17, init);
                    if (Modifier.isStatic(af)) {
                        ClassInfoCompiler.this.addToClassInitializer(exp);
                        return null;
                    } else {
                        exp.setProperty("instanceInitializer", null);
                        ClassInfoCompiler.this.addToInstanceInitializer(exp);
                    }
                }
                return null;
            } else {
                ClassInfoCompiler.this.classFactory.addField(af, rt, fn);
            }
            return null;
        }

        @Override
        public Void visit(MethodDeclaration node) {
            boolean isAbstract;
            if (node.isVarArgs()) {
                TigerUtilities.assertTigerEnabled("Methods with variable arguments are only allowed in Java 1.5 or higher");
            }
            MethodInfo mi = ClassInfoCompiler.this.classInfo.getMethod(node);
            int af = mi.getModifiers();
            String mn = node.getName();
            String rt = mi.getReturnType().getName();
            if (ClassInfoCompiler.this.isInterface) {
                if (Modifier.isPrivate(af) || Modifier.isProtected(af) || Modifier.isFinal(af) || Modifier.isStatic(af)) {
                    node.setProperty("errorStrings", new String[]{node.getName(), ClassInfoCompiler.this.classInfo.getName()});
                    throw new ExecutionError("interface.method.modifier", node);
                }
                af |= 0x401;
                isAbstract = true;
            } else {
                isAbstract = Modifier.isAbstract(af);
            }
            ClassInfoCompiler.this.hasAbstractMethod |= isAbstract;
            ClassInfo[] cia = mi.getParameterTypes();
            String[] params = new String[cia.length];
            for (int i = 0; i < cia.length; ++i) {
                params[i] = cia[i].getName();
            }
            cia = mi.getExceptionTypes();
            String[] except = new String[cia.length];
            for (int i = 0; i < cia.length; ++i) {
                except[i] = cia[i].getName();
            }
            ClassInfoCompiler.this.classFactory.addMethod(af, rt, mn, params, except);
            if (!ClassInfoCompiler.this.isInterface && !isAbstract && this.isRedefinedMethod(mi)) {
                ClassInfoCompiler.this.classFactory.addSuperMethodAccessor(af, rt, mn, params, except);
            }
            BlockStatement body = node.getBody();
            if (isAbstract && body != null || ClassInfoCompiler.this.isInterface && body != null) {
                node.setProperty("errorStrings", new String[]{node.getName()});
                throw new ExecutionError("abstract.method.body", node);
            }
            if (!isAbstract && body == null) {
                node.setProperty("errorStrings", new String[]{node.getName()});
                throw new ExecutionError("missing.method.body", node);
            }
            if (body != null) {
                String sig = ClassFactory.getMethodIdentifier(ClassInfoCompiler.this.classInfo.getName(), mn, params, ClassInfoCompiler.this.interpreter.getClassLoader().toString());
                ClassInfoCompiler.this.interpreter.registerMethod(sig, node, ClassInfoCompiler.this.importationManager);
            }
            return null;
        }

        protected boolean isRedefinedMethod(MethodInfo m) {
            String name = m.getName();
            ClassInfo[] params = m.getParameterTypes();
            for (ClassInfo sc = ClassInfoCompiler.this.classInfo.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
                MethodInfo[] ms = sc.getMethods();
                block1: for (int i = 0; i < ms.length; ++i) {
                    ClassInfo[] pt;
                    if (!ms[i].getName().equals(name) || (pt = ms[i].getParameterTypes()).length != params.length) continue;
                    for (int j = 0; j < pt.length; ++j) {
                        if (!pt[j].equals(params[j])) continue block1;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public /* synthetic */ Object visit(InstanceInitializer x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassInitializer x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(VariableDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FieldDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FormalParameter x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MethodDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InterfaceDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BlockStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConditionalExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(OrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InstanceOfExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MinusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PlusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ComplementExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CastExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TypeExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReferenceType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PrimitiveType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorInvocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FunctionCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(QualifiedName x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThisExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(Literal x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AssertStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenElseStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ContinueStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SynchronizedStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReturnStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThrowStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CatchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TryStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BreakStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LabeledStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchBlock x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DoStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForEachStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(WhileStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EmptyStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ImportDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PackageDeclaration x0) {
            return super.visit(x0);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConstructorVisitor
    extends VisitorObject<Object> {
        String superConstructor;
        String[] constructorParameters = new String[0];
        VariableContext context;

        protected ConstructorVisitor() {
            this.context = new VariableContext(ClassInfoCompiler.this.importationManager);
        }

        @Override
        public Object visit(ConstructorInvocation node) {
            Expression exp = node.getExpression();
            if (exp == null) {
                LinkedList<IdentifierToken> l;
                ClassInfo sc = ClassInfoCompiler.this.classInfo.getSuperclass();
                ClassInfo sdc = sc.getDeclaringClass();
                ClassInfo dc = ClassInfoCompiler.this.classInfo.getDeclaringClass();
                if (dc != null && dc.equals(sdc) && !Modifier.isStatic(sc.getModifiers())) {
                    l = new LinkedList<IdentifierToken>();
                    l.add(new Identifier("param$0"));
                    exp = new QualifiedName(l);
                    node.setExpression(exp);
                } else if (sdc != null && sdc.equals(ClassInfoCompiler.this.classInfo.getAnonymousDeclaringClass()) && !Modifier.isStatic(sc.getModifiers())) {
                    l = new LinkedList();
                    l.add(new Identifier("param$0"));
                    exp = new QualifiedName(l);
                    node.setExpression(exp);
                }
            }
            List<Expression> args = node.getArguments();
            if (exp != null) {
                if (args == null) {
                    args = new LinkedList<Expression>();
                    node.setArguments(args);
                }
                args.add(0, exp);
            }
            if (args != null) {
                int i;
                ListIterator<Expression> it = args.listIterator();
                while (it.hasNext()) {
                    Object o = it.next().acceptVisitor(this);
                    if (o == null) continue;
                    if (o instanceof Expression) {
                        it.set((Expression)o);
                        continue;
                    }
                    throw new ExecutionError("malformed.argument", node);
                }
                ConstructorInfo cons = null;
                try {
                    ClassInfo[] params = null;
                    it = args.listIterator();
                    i = 0;
                    params = new ClassInfo[args.size()];
                    while (it.hasNext()) {
                        params[i++] = NodeProperties.getClassInfo(it.next());
                    }
                    if (node.isSuper()) {
                        ClassInfo sc = ClassInfoCompiler.this.classInfo.getSuperclass();
                        cons = ClassInfoUtilities.lookupConstructor(sc, params);
                        this.superConstructor = sc.getName();
                    } else {
                        cons = ClassInfoUtilities.lookupConstructor(ClassInfoCompiler.this.classInfo, params);
                        this.superConstructor = ClassInfoCompiler.this.classInfo.getName();
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                ClassInfo[] pt = cons.getParameterTypes();
                this.constructorParameters = new String[pt.length];
                for (i = 0; i < pt.length; ++i) {
                    this.constructorParameters[i] = pt[i].getName();
                }
            }
            if (this.superConstructor == null) {
                ClassInfo sc = ClassInfoCompiler.this.classInfo.getSuperclass();
                this.superConstructor = sc.getName();
            }
            return null;
        }

        @Override
        public Object visit(PrimitiveType node) {
            JavaClassInfo result = new JavaClassInfo(node.getValue());
            node.setProperty("type", result);
            return result;
        }

        @Override
        public Object visit(ReferenceType node) {
            ClassInfo c = null;
            String s = node.getRepresentation();
            try {
                c = ClassInfoCompiler.this.classFinder.lookupClass(s, ClassInfoCompiler.this.classInfo);
            }
            catch (ClassNotFoundException e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
            node.setProperty("type", c);
            return c;
        }

        @Override
        public Object visit(ArrayType node) {
            Type eType = node.getElementType();
            eType.acceptVisitor(this);
            ClassInfo c = NodeProperties.getClassInfo(eType);
            ClassInfo ac = c instanceof JavaClassInfo ? new JavaClassInfo((JavaClassInfo)c) : new TreeClassInfo((TreeClassInfo)c);
            node.setProperty("type", ac);
            return ac;
        }

        @Override
        public Object visit(FormalParameter node) {
            ClassInfo ci = (ClassInfo)node.getType().acceptVisitor(this);
            if (node.isFinal()) {
                this.context.defineConstant(node.getName(), ci);
            } else {
                this.context.define(node.getName(), ci);
            }
            return null;
        }

        @Override
        public Object visit(Literal node) {
            Class<?> c = node.getType();
            node.setProperty("type", c == null ? null : new JavaClassInfo(c));
            return null;
        }

        @Override
        public Object visit(SimpleAssignExpression node) {
            Expression left = node.getLeftExpression();
            Object o = left.acceptVisitor(this);
            if (o != null) {
                if (o instanceof Expression) {
                    Expression exp;
                    left = exp = (Expression)o;
                    node.setLeftExpression(exp);
                } else {
                    throw new ExecutionError("left.expression", node);
                }
            }
            node.setProperty("type", NodeProperties.getClassInfo(left));
            return null;
        }

        @Override
        public Object visit(ObjectFieldAccess node) {
            ClassInfo c;
            Object o = node.getExpression().acceptVisitor(this);
            if (o != null) {
                if (o instanceof Expression) {
                    node.setExpression((Expression)o);
                } else {
                    StaticFieldAccess result = new StaticFieldAccess((ReferenceType)o, node.getFieldName());
                    ((Node)result).acceptVisitor(this);
                    return result;
                }
            }
            if (!(c = NodeProperties.getClassInfo(node.getExpression())).isArray()) {
                FieldInfo f = null;
                try {
                    f = ClassInfoUtilities.getField(c, node.getFieldName());
                }
                catch (Exception e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                node.setProperty("type", f.getType());
            } else {
                if (!node.getFieldName().equals("length")) {
                    String s0 = "length";
                    String s1 = new StringBuffer().append(c.getComponentType().getName()).append(" array").toString();
                    node.setProperty("errorStrings", new String[]{s0, s1});
                    throw new ExecutionError("no.such.field", node);
                }
                node.setProperty("type", JavaClassInfo.INT);
            }
            return null;
        }

        @Override
        public Object visit(StaticFieldAccess node) {
            ClassInfo c = (ClassInfo)node.getFieldType().acceptVisitor(this);
            FieldInfo f = null;
            try {
                f = ClassInfoUtilities.getField(c, node.getFieldName());
            }
            catch (Exception e) {
                try {
                    f = ClassInfoUtilities.getOuterField(c, node.getFieldName());
                }
                catch (Exception ex) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
            }
            node.setProperty("type", f.getType());
            return null;
        }

        @Override
        public Object visit(SuperFieldAccess node) {
            TreeClassInfo c = ClassInfoCompiler.this.classInfo;
            FieldInfo f = null;
            try {
                f = ClassInfoUtilities.getField(c.getSuperclass(), node.getFieldName());
            }
            catch (Exception e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
            node.setProperty("type", f.getType());
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object visit(ObjectMethodCall node) {
            ClassInfo c;
            if (node.getExpression() == null) {
                Identifier t = new Identifier(ClassInfoCompiler.this.classInfo.getName());
                LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
                l.add(t);
                ReferenceType rt = new ReferenceType(l);
                rt.acceptVisitor(this);
                StaticMethodCall result = new StaticMethodCall(rt, node.getMethodName(), node.getArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
                ((Node)result).acceptVisitor(this);
                return result;
            }
            Object o = node.getExpression().acceptVisitor(this);
            if (o != null) {
                if (!(o instanceof Expression)) {
                    StaticMethodCall result = new StaticMethodCall((ReferenceType)o, node.getMethodName(), node.getArguments(), node.getFilename(), node.getBeginLine(), node.getBeginColumn(), node.getEndLine(), node.getEndColumn());
                    ((Node)result).acceptVisitor(this);
                    return result;
                }
                node.setExpression((Expression)o);
            }
            if (!(c = NodeProperties.getClassInfo(node.getExpression())).isArray() || c.isArray() && !node.getMethodName().equals("clone")) {
                ClassInfo[] cargs = new ClassInfo[]{};
                List<Expression> args = node.getArguments();
                if (args != null) {
                    this.checkList(args, "malformed.argument", node);
                    cargs = new ClassInfo[args.size()];
                    ListIterator<Expression> it = args.listIterator();
                    int i = 0;
                    while (it.hasNext()) {
                        cargs[i++] = NodeProperties.getClassInfo(it.next());
                    }
                }
                MethodInfo m = null;
                try {
                    m = ClassInfoUtilities.lookupMethod(c, node.getMethodName(), cargs);
                }
                catch (NoSuchMethodException e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                node.setProperty("type", m.getReturnType());
                return null;
            }
            if (!node.getMethodName().equals("clone") || node.getArguments() != null) {
                String s0 = "clone";
                String s1 = new StringBuffer().append(c.getComponentType().getName()).append(" array").toString();
                node.setProperty("errorStrings", new String[]{s0, s1});
                throw new ExecutionError("no.such.method", node);
            }
            node.setProperty("type", new JavaClassInfo(class$java$lang$Object == null ? (class$java$lang$Object = ClassInfoCompiler.class$("java.lang.Object")) : class$java$lang$Object));
            return null;
        }

        @Override
        public Object visit(StaticMethodCall node) {
            List<Expression> args = node.getArguments();
            ClassInfo[] cargs = new ClassInfo[]{};
            if (args != null) {
                this.checkList(args, "malformed.argument", node);
                cargs = new ClassInfo[args.size()];
                ListIterator<Expression> it = args.listIterator();
                int i = 0;
                while (it.hasNext()) {
                    cargs[i++] = NodeProperties.getClassInfo(it.next());
                }
            }
            MethodInfo m = null;
            Type n = node.getMethodType();
            ClassInfo c = NodeProperties.getClassInfo(n);
            try {
                m = ClassInfoUtilities.lookupMethod(c, node.getMethodName(), cargs);
            }
            catch (NoSuchMethodException e) {
                SourceInfo si = n.getSourceInfo();
                if (si.getStartLine() == si.getEndLine() && si.getStartColumn() == si.getEndLine()) {
                    try {
                        m = ClassInfoUtilities.lookupOuterMethod(c, node.getMethodName(), cargs);
                    }
                    catch (NoSuchMethodException ex) {
                        throw new CatchedExceptionError(ex, (Node)node);
                    }
                } else {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                throw new CatchedExceptionError(e, (Node)node);
            }
            node.setProperty("type", m.getReturnType());
            return null;
        }

        @Override
        public Object visit(SuperMethodCall node) {
            ClassInfo c = ClassInfoCompiler.this.classInfo.getSuperclass();
            List<Expression> args = node.getArguments();
            ClassInfo[] pt = new ClassInfo[]{};
            if (args != null) {
                this.checkList(args, "malformed.argument", node);
                pt = new ClassInfo[args.size()];
                ListIterator<Expression> it = args.listIterator();
                int i = 0;
                while (it.hasNext()) {
                    pt[i++] = NodeProperties.getClassInfo(it.next());
                }
            }
            MethodInfo m = null;
            try {
                m = ClassInfoUtilities.lookupMethod(c, node.getMethodName(), pt);
            }
            catch (Exception e) {
                throw new CatchedExceptionError(e, (Node)node);
            }
            node.setProperty("type", m.getReturnType());
            return null;
        }

        @Override
        public Object visit(QualifiedName node) {
            List<IdentifierToken> ids = node.getIdentifiers();
            IdentifierToken t = ids.get(0);
            if (this.context.isDefinedVariable(t.image()) || this.fieldExists(ClassInfoCompiler.this.classInfo, t.image())) {
                PrimaryExpression result = null;
                if (this.context.isDefinedVariable(t.image())) {
                    if (ids.size() == 1) {
                        ClassInfo c = (ClassInfo)this.context.get(t.image());
                        node.setProperty("type", c);
                        return null;
                    }
                    LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
                    l.add(t);
                    result = new QualifiedName(l);
                } else {
                    result = new StaticFieldAccess(new ReferenceType(ClassInfoCompiler.this.classInfo.getName()), t.image());
                }
                Iterator<IdentifierToken> it = ids.iterator();
                it.next();
                while (it.hasNext()) {
                    IdentifierToken t2 = it.next();
                    result = new ObjectFieldAccess(result, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
                }
                result.acceptVisitor(this);
                return result;
            }
            LinkedList<IdentifierToken> l = ListUtilities.listCopy(ids);
            boolean b = false;
            while (l.size() > 0) {
                String s = TreeUtilities.listToName(l);
                try {
                    ClassInfoCompiler.this.classFinder.lookupClass(s, ClassInfoCompiler.this.classInfo);
                    b = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    l.remove(l.size() - 1);
                }
            }
            if (!b) {
                node.setProperty("errorStrings", new String[]{t.image()});
                throw new ExecutionError("undefined.class", node);
            }
            IdentifierToken t2 = (IdentifierToken)l.get(l.size() - 1);
            ReferenceType rt = new ReferenceType(l, node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
            if (l.size() != ids.size()) {
                ListIterator<IdentifierToken> it = ids.listIterator(l.size());
                t2 = it.next();
                FieldAccess result = new StaticFieldAccess(rt, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
                while (it.hasNext()) {
                    t2 = it.next();
                    result = new ObjectFieldAccess(result, t2.image(), node.getFilename(), t.beginLine(), t.beginColumn(), t2.endLine(), t2.endColumn());
                }
                ((Node)result).acceptVisitor(this);
                return result;
            }
            rt.acceptVisitor(this);
            return rt;
        }

        @Override
        public Object visit(ThisExpression node) {
            throw new ExecutionError("this.undefined", node);
        }

        @Override
        public Object visit(SimpleAllocation node) {
            Type type = node.getCreationType();
            node.setProperty("type", type.acceptVisitor(this));
            return null;
        }

        @Override
        public Object visit(ArrayAllocation node) {
            Type type = node.getCreationType();
            ClassInfo c = (ClassInfo)type.acceptVisitor(this);
            for (int i = 0; i < node.getDimension(); ++i) {
                c = c instanceof JavaClassInfo ? new JavaClassInfo((JavaClassInfo)c) : new TreeClassInfo((TreeClassInfo)c);
            }
            node.setProperty("type", c);
            return null;
        }

        @Override
        public Object visit(ArrayAccess node) {
            ClassInfo c;
            Object o = node.getExpression().acceptVisitor(this);
            if (o != null) {
                if (o instanceof Expression) {
                    node.setExpression((Expression)o);
                } else {
                    throw new ExecutionError("malformed.expression", node);
                }
            }
            if (!(c = NodeProperties.getClassInfo(node.getExpression())).isArray()) {
                node.setProperty("errorStrings", new String[]{c.getName()});
                throw new ExecutionError("array.required", node);
            }
            node.setProperty("type", c.getComponentType());
            return null;
        }

        @Override
        public Object visit(TypeExpression node) {
            node.setProperty("type", JavaClassInfo.CLASS);
            return null;
        }

        @Override
        public Object visit(NotExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object visit(ComplementExpression node) {
            this.visitUnaryExpression(node);
            Expression n = node.getExpression();
            ClassInfo ci = NodeProperties.getClassInfo(n);
            if (!(ci instanceof JavaClassInfo)) throw new ExecutionError("malformed.expression", node);
            Class<?> c = ((JavaClassInfo)ci).getJavaClass();
            if (c == Character.TYPE || c == Byte.TYPE || c == Short.TYPE) {
                node.setProperty("type", JavaClassInfo.INT);
                return null;
            } else {
                if (c != Integer.TYPE && c != Long.TYPE) throw new ExecutionError("malformed.expression", node);
                node.setProperty("type", new JavaClassInfo(c));
            }
            return null;
        }

        @Override
        public Object visit(PlusExpression node) {
            this.visitUnaryExpression(node);
            this.visitUnaryOperation(node, "malformed.expression");
            return null;
        }

        @Override
        public Object visit(MinusExpression node) {
            this.visitUnaryExpression(node);
            this.visitUnaryOperation(node, "malformed.expression");
            return null;
        }

        @Override
        public Object visit(AddExpression node) {
            this.visitBinaryExpression(node);
            Expression ln = node.getLeftExpression();
            Expression rn = node.getRightExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            ClassInfo rci = NodeProperties.getClassInfo(rn);
            Class<?> lc = null;
            Class<?> rc = null;
            if (!(lci instanceof JavaClassInfo) || !(rci instanceof JavaClassInfo)) {
                throw new ExecutionError("addition.type", node);
            }
            lc = lci.getJavaClass();
            rc = rci.getJavaClass();
            if (lc == (class$java$lang$String == null ? (class$java$lang$String = ClassInfoCompiler.class$("java.lang.String")) : class$java$lang$String) || rc == (class$java$lang$String == null ? (class$java$lang$String = ClassInfoCompiler.class$("java.lang.String")) : class$java$lang$String)) {
                node.setProperty("type", JavaClassInfo.STRING);
            } else {
                this.visitNumericExpression(node, "addition.type");
            }
            return null;
        }

        @Override
        public Object visit(AddAssignExpression node) {
            this.visitBinaryExpression(node);
            Expression ln = node.getLeftExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            node.setProperty("type", lci);
            return null;
        }

        @Override
        public Object visit(SubtractExpression node) {
            this.visitBinaryExpression(node);
            this.visitNumericExpression(node, "subtraction.type");
            return null;
        }

        @Override
        public Object visit(SubtractAssignExpression node) {
            this.visitBinaryExpression(node);
            Expression ln = node.getLeftExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            node.setProperty("type", lci);
            return null;
        }

        @Override
        public Object visit(MultiplyExpression node) {
            this.visitBinaryExpression(node);
            this.visitNumericExpression(node, "multiplication.type");
            return null;
        }

        @Override
        public Object visit(MultiplyAssignExpression node) {
            this.visitBinaryExpression(node);
            Expression ln = node.getLeftExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            node.setProperty("type", lci);
            return null;
        }

        @Override
        public Object visit(DivideExpression node) {
            this.visitBinaryExpression(node);
            this.visitNumericExpression(node, "division.type");
            return null;
        }

        @Override
        public Object visit(DivideAssignExpression node) {
            this.visitBinaryExpression(node);
            Expression ln = node.getLeftExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            node.setProperty("type", lci);
            return null;
        }

        @Override
        public Object visit(RemainderExpression node) {
            this.visitBinaryExpression(node);
            this.visitNumericExpression(node, "remainder.type");
            return null;
        }

        @Override
        public Object visit(RemainderAssignExpression node) {
            this.visitBinaryExpression(node);
            Expression ln = node.getLeftExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            node.setProperty("type", lci);
            return null;
        }

        @Override
        public Object visit(EqualExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(NotEqualExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(LessExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(LessOrEqualExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(GreaterExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(GreaterOrEqualExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(BitAndExpression node) {
            this.visitBinaryExpression(node);
            this.visitBitwiseExpression(node, "bit.and.type");
            return null;
        }

        @Override
        public Object visit(BitAndAssignExpression node) {
            this.visitBinaryExpression(node);
            node.setProperty("type", NodeProperties.getClassInfo(node.getLeftExpression()));
            return null;
        }

        @Override
        public Object visit(ExclusiveOrExpression node) {
            this.visitBinaryExpression(node);
            this.visitBitwiseExpression(node, "xor.type");
            return null;
        }

        @Override
        public Object visit(ExclusiveOrAssignExpression node) {
            this.visitBinaryExpression(node);
            node.setProperty("type", NodeProperties.getClassInfo(node.getLeftExpression()));
            return null;
        }

        @Override
        public Object visit(BitOrExpression node) {
            this.visitBinaryExpression(node);
            this.visitBitwiseExpression(node, "bit.or.type");
            return null;
        }

        @Override
        public Object visit(BitOrAssignExpression node) {
            this.visitBinaryExpression(node);
            node.setProperty("type", NodeProperties.getClassInfo(node.getLeftExpression()));
            return null;
        }

        @Override
        public Object visit(ShiftLeftExpression node) {
            this.visitBinaryExpression(node);
            this.visitShiftExpression(node, "shift.left.type");
            return null;
        }

        @Override
        public Object visit(ShiftLeftAssignExpression node) {
            this.visitBinaryExpression(node);
            this.visitShiftExpression(node, "shift.left.type");
            return null;
        }

        @Override
        public Object visit(ShiftRightExpression node) {
            this.visitBinaryExpression(node);
            this.visitShiftExpression(node, "shift.right.type");
            return null;
        }

        @Override
        public Object visit(ShiftRightAssignExpression node) {
            this.visitBinaryExpression(node);
            this.visitShiftExpression(node, "shift.right.type");
            return null;
        }

        @Override
        public Object visit(UnsignedShiftRightExpression node) {
            this.visitBinaryExpression(node);
            this.visitShiftExpression(node, "unsigned.shift.right.type");
            return null;
        }

        @Override
        public Object visit(UnsignedShiftRightAssignExpression node) {
            this.visitBinaryExpression(node);
            this.visitShiftExpression(node, "unsigned.shift.right.type");
            return null;
        }

        @Override
        public Object visit(AndExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(OrExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(InstanceOfExpression node) {
            node.setProperty("type", JavaClassInfo.BOOLEAN);
            return null;
        }

        @Override
        public Object visit(ConditionalExpression node) {
            Object o = node.getIfTrueExpression().acceptVisitor(this);
            if (o != null) {
                if (o instanceof ReferenceType) {
                    throw new ExecutionError("malformed.second.operand", node);
                }
                node.setIfTrueExpression((Expression)o);
            }
            if ((o = node.getIfFalseExpression().acceptVisitor(this)) != null) {
                if (o instanceof ReferenceType) {
                    throw new ExecutionError("malformed.third.operand", node);
                }
                node.setIfFalseExpression((Expression)o);
            }
            Expression n1 = node.getIfTrueExpression();
            Expression n2 = node.getIfFalseExpression();
            ClassInfo c1 = NodeProperties.getClassInfo(n1);
            ClassInfo c2 = NodeProperties.getClassInfo(n2);
            ClassInfo ec = null;
            if (c1 == null) {
                ec = c2;
            } else if (c2 == null) {
                ec = c1;
            } else if (c1.equals(c2)) {
                ec = c1;
            } else if (ClassInfoUtilities.isAssignableFrom(c1, c2)) {
                ec = c1;
            } else if (ClassInfoUtilities.isAssignableFrom(c2, c1)) {
                ec = c2;
            } else {
                throw new ExecutionError("conditional.type", node);
            }
            node.setProperty("type", ec);
            return null;
        }

        @Override
        public Object visit(PostIncrement node) {
            this.visitUnaryExpression(node);
            Expression exp = node.getExpression();
            ClassInfo ci = NodeProperties.getClassInfo(exp);
            if (!(ci instanceof JavaClassInfo)) {
                throw new ExecutionError("post.increment.type", node);
            }
            node.setProperty("type", ci);
            return null;
        }

        @Override
        public Object visit(PreIncrement node) {
            this.visitUnaryExpression(node);
            Expression exp = node.getExpression();
            ClassInfo ci = NodeProperties.getClassInfo(exp);
            if (!(ci instanceof JavaClassInfo)) {
                throw new ExecutionError("pre.increment.type", node);
            }
            node.setProperty("type", ci);
            return null;
        }

        @Override
        public Object visit(PostDecrement node) {
            this.visitUnaryExpression(node);
            Expression exp = node.getExpression();
            ClassInfo ci = NodeProperties.getClassInfo(exp);
            if (!(ci instanceof JavaClassInfo)) {
                throw new ExecutionError("post.decrement.type", node);
            }
            node.setProperty("type", ci);
            return null;
        }

        @Override
        public Object visit(PreDecrement node) {
            this.visitUnaryExpression(node);
            Expression exp = node.getExpression();
            ClassInfo ci = NodeProperties.getClassInfo(exp);
            if (!(ci instanceof JavaClassInfo)) {
                throw new ExecutionError("pre.decrement.type", node);
            }
            node.setProperty("type", ci);
            return null;
        }

        @Override
        public Object visit(CastExpression node) {
            Type n = node.getTargetType();
            node.setProperty("type", n.acceptVisitor(this));
            return null;
        }

        protected void visitUnaryExpression(UnaryExpression node) {
            Object o = node.getExpression().acceptVisitor(this);
            if (o != null) {
                if (o instanceof ReferenceType) {
                    throw new ExecutionError("malformed.expression", node);
                }
                node.setExpression((Expression)o);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void visitUnaryOperation(UnaryExpression node, String s) {
            Expression n = node.getExpression();
            ClassInfo ci = NodeProperties.getClassInfo(n);
            if (!ci.isPrimitive()) throw new ExecutionError(s, node);
            Class<?> c = ci.getJavaClass();
            if (c == Character.TYPE || c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE) {
                node.setProperty("type", JavaClassInfo.INT);
                return;
            } else {
                if (c != Long.TYPE && c != Float.TYPE && c != Double.TYPE) throw new ExecutionError(s, node);
                node.setProperty("type", new JavaClassInfo(c));
            }
        }

        protected void visitBinaryExpression(BinaryExpression node) {
            Object o = node.getLeftExpression().acceptVisitor(this);
            if (o != null) {
                if (o instanceof ReferenceType) {
                    throw new ExecutionError("left.operand", node);
                }
                node.setLeftExpression((Expression)o);
            }
            if ((o = node.getRightExpression().acceptVisitor(this)) != null) {
                if (o instanceof ReferenceType) {
                    throw new ExecutionError("right.operand", node);
                }
                node.setRightExpression((Expression)o);
            }
        }

        protected void visitNumericExpression(BinaryExpression node, String s) {
            ClassInfo lci = NodeProperties.getClassInfo(node.getLeftExpression());
            ClassInfo rci = NodeProperties.getClassInfo(node.getRightExpression());
            Class<?> lc = lci.getJavaClass();
            Class<?> rc = rci.getJavaClass();
            if (lc == null || rc == null || lc == Boolean.TYPE || rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive() || lc == Void.TYPE || rc == Void.TYPE) {
                throw new ExecutionError(s, node);
            }
            if (lc == Double.TYPE || rc == Double.TYPE) {
                node.setProperty("type", JavaClassInfo.DOUBLE);
            } else if (lc == Float.TYPE || rc == Float.TYPE) {
                node.setProperty("type", JavaClassInfo.FLOAT);
            } else if (lc == Long.TYPE || rc == Long.TYPE) {
                node.setProperty("type", JavaClassInfo.LONG);
            } else {
                node.setProperty("type", JavaClassInfo.INT);
            }
        }

        protected void visitBitwiseExpression(BinaryExpression node, String s) {
            Expression ln = node.getLeftExpression();
            Expression rn = node.getRightExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            ClassInfo rci = NodeProperties.getClassInfo(rn);
            Class<?> lc = null;
            Class<?> rc = null;
            if (!(lci instanceof JavaClassInfo) || !(rci instanceof JavaClassInfo)) {
                throw new ExecutionError(s, node);
            }
            lc = lci.getJavaClass();
            rc = rci.getJavaClass();
            if (lc == null || rc == null || lc == Void.TYPE || rc == Void.TYPE || lc == Float.TYPE || rc == Float.TYPE || lc == Double.TYPE || rc == Double.TYPE || lc == Boolean.TYPE ^ rc == Boolean.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
                throw new ExecutionError(s, node);
            }
            if (lc == Long.TYPE || rc == Long.TYPE) {
                node.setProperty("type", JavaClassInfo.LONG);
            } else if (lc == Boolean.TYPE) {
                node.setProperty("type", JavaClassInfo.BOOLEAN);
            } else {
                node.setProperty("type", JavaClassInfo.INT);
            }
        }

        protected void visitShiftExpression(BinaryExpression node, String s) {
            Expression ln = node.getLeftExpression();
            Expression rn = node.getRightExpression();
            ClassInfo lci = NodeProperties.getClassInfo(ln);
            ClassInfo rci = NodeProperties.getClassInfo(rn);
            Class<?> lc = null;
            Class<?> rc = null;
            if (!(lci instanceof JavaClassInfo) || !(rci instanceof JavaClassInfo)) {
                throw new ExecutionError(s, node);
            }
            lc = lci.getJavaClass();
            rc = rci.getJavaClass();
            if (lc == null || rc == null || lc == Boolean.TYPE || rc == Boolean.TYPE || lc == Void.TYPE || rc == Void.TYPE || lc == Float.TYPE || rc == Float.TYPE || lc == Double.TYPE || rc == Double.TYPE || !lc.isPrimitive() || !rc.isPrimitive()) {
                throw new ExecutionError(s, node);
            }
            if (lc == Long.TYPE) {
                node.setProperty("type", JavaClassInfo.LONG);
            } else {
                node.setProperty("type", JavaClassInfo.INT);
            }
        }

        protected void checkList(List<Expression> l, String s, Node n) {
            ListIterator<Expression> it = l.listIterator();
            while (it.hasNext()) {
                Object o = it.next().acceptVisitor(this);
                if (o == null) continue;
                if (o instanceof ReferenceType) {
                    throw new ExecutionError(s, n);
                }
                it.set((Expression)o);
            }
        }

        protected boolean fieldExists(ClassInfo dc, String name) {
            boolean result = false;
            try {
                ClassInfoUtilities.getField(dc, name);
                result = true;
            }
            catch (NoSuchFieldException e) {
                try {
                    ClassInfoUtilities.getOuterField(dc, name);
                    result = true;
                }
                catch (NoSuchFieldException ex) {
                }
                catch (AmbiguousFieldException ex) {
                    result = true;
                }
            }
            catch (AmbiguousFieldException e) {
                result = true;
            }
            return result;
        }
    }
}

