/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.interpreter.ClassLoaderContainer;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.TreeCompiler;
import koala.dynamicjava.interpreter.context.AbstractVariable;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.NoSuchFunctionException;
import koala.dynamicjava.interpreter.context.VariableContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.FinalVariableModifier;
import koala.dynamicjava.interpreter.modifier.InvalidModifier;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.interpreter.modifier.ObjectFieldModifier;
import koala.dynamicjava.interpreter.modifier.StaticFieldModifier;
import koala.dynamicjava.interpreter.modifier.VariableModifier;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.interpreter.throwable.WrongVersionException;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.AssertStatement;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.StringLiteral;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.BufferedImportationManager;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;
import koala.dynamicjava.util.ReflectionUtilities;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalContext
extends VariableContext
implements Context {
    protected static final ReferenceType CLASS_TYPE = new ReferenceType("java.lang.Class");
    protected static final ReferenceType MAP_TYPE = new ReferenceType("java.util.Map");
    protected static final ReferenceType OBJECT_TYPE = new ReferenceType("java.lang.Object");
    protected static final ArrayType OBJECT_ARRAY_ARRAY = new ArrayType(OBJECT_TYPE, 2);
    protected static final TypeExpression OBJECT_CLASS = new TypeExpression(OBJECT_TYPE);
    protected static final String LOCALS_NAME = "local$Variables$Reference$0";
    protected static final FieldDeclaration LOCALS = new FieldDeclaration(1, MAP_TYPE, "local$Variables$Reference$0", null);
    protected static int classCount = 0;
    protected Interpreter interpreter;
    protected ClassLoader classLoader;
    protected ClassLoaderContainer clc;
    protected List<MethodDeclaration> functions = new LinkedList<MethodDeclaration>();
    protected boolean accessible = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public GlobalContext(Interpreter i) {
        this.importationManager = new BufferedImportationManager(i.getClassLoader());
        this.interpreter = i;
    }

    public GlobalContext(Interpreter i, ClassLoader cl) {
        super(new BufferedImportationManager(cl));
        this.interpreter = i;
        this.classLoader = cl;
    }

    public GlobalContext(Interpreter i, Set<AbstractVariable> entries) {
        super(entries);
        this.interpreter = i;
    }

    @Override
    public void setAdditionalClassLoaderContainer(ClassLoaderContainer clc) {
        this.clc = clc;
    }

    @Override
    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    @Override
    public boolean getAccessible() {
        return this.accessible;
    }

    protected ClassLoader getAdditionalClassLoader() {
        if (this.clc != null) {
            return this.clc.getClassLoader();
        }
        return null;
    }

    @Override
    public void setFunctions(List<MethodDeclaration> l) {
        this.functions = l;
    }

    @Override
    public List<MethodDeclaration> getFunctions() {
        return this.functions;
    }

    @Override
    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public ImportationManager getImportationManager() {
        return this.importationManager;
    }

    @Override
    public void setImportationManager(ImportationManager im) {
        this.importationManager = im;
    }

    @Override
    public boolean exists(String name) {
        return this.isDefined(name) || this.classExists(name) || this.isFieldImported(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean classExists(String name) {
        boolean result = false;
        this.importationManager.setClassLoader(new PseudoClassLoader());
        try {
            this.lookupClass(name);
            result = true;
        }
        catch (ClassNotFoundException e) {
        }
        catch (PseudoError e) {
            result = true;
        }
        finally {
            if (this.classLoader == null) {
                this.importationManager.setClassLoader(this.interpreter.getClassLoader());
            } else {
                this.importationManager.setClassLoader(this.classLoader);
            }
        }
        return result;
    }

    @Override
    public void defineFunction(MethodDeclaration node) {
        this.functions.add(0, node);
    }

    @Override
    public void defineClass(TypeDeclaration node) {
        new TreeCompiler(this.interpreter).compileTree(this, node);
    }

    @Override
    public boolean isDefined(String name) {
        return this.isDefinedVariable(name);
    }

    @Override
    public void setCurrentPackage(String pkg) {
        this.importationManager.setCurrentPackage(pkg);
    }

    @Override
    public String getCurrentPackage() {
        return this.importationManager.getCurrentPackage();
    }

    @Override
    public void declarePackageImport(String pkg) {
        this.importationManager.declarePackageImport(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void declareClassImport(String cname) throws ClassNotFoundException {
        this.importationManager.setClassLoader(new PseudoClassLoader());
        try {
            this.importationManager.declareClassImport(cname);
        }
        catch (PseudoError pseudoError) {
        }
        finally {
            if (this.classLoader == null) {
                this.importationManager.setClassLoader(this.interpreter.getClassLoader());
            } else {
                this.importationManager.setClassLoader(this.classLoader);
            }
        }
    }

    @Override
    public void declareClassStaticImport(String cname) throws ClassNotFoundException {
        this.importationManager.declareClassStaticImport(cname);
    }

    @Override
    public void declareMemberStaticImport(String member) throws ClassNotFoundException {
        this.importationManager.declareMemberStaticImport(member);
    }

    @Override
    public Node getDefaultQualifier(Node node) {
        return this.getDefaultQualifier(node, "");
    }

    @Override
    public Node getDefaultQualifier(Node node, String tname) {
        return null;
    }

    @Override
    public String getQualifiedName(String methodName, Class<?>[] args) throws NoSuchMethodException {
        return this.importationManager.getQualifiedName(methodName, args);
    }

    @Override
    public List<IdentifierToken> getQualifiedName(String fieldName) throws NoSuchFieldException {
        return this.importationManager.getQualifiedName(fieldName);
    }

    @Override
    public boolean isFieldImported(String name) {
        return this.importationManager.fieldExists(name);
    }

    @Override
    public LeftHandSideModifier getModifier(QualifiedName node) {
        if (this.isFinal(node.getRepresentation())) {
            return new FinalVariableModifier(node, NodeProperties.getType(node));
        }
        return new VariableModifier(node, NodeProperties.getType(node));
    }

    @Override
    public LeftHandSideModifier getModifier(ObjectFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        if (f.isAccessible()) {
            return new ObjectFieldModifier(f, node);
        }
        return new InvalidModifier(node);
    }

    @Override
    public LeftHandSideModifier getModifier(StaticFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        if (f.isAccessible()) {
            return new StaticFieldModifier(f, node);
        }
        return new InvalidModifier(node);
    }

    @Override
    public LeftHandSideModifier getModifier(SuperFieldAccess node) {
        throw new IllegalStateException("internal.error");
    }

    @Override
    public Object getHiddenArgument() {
        return null;
    }

    @Override
    public Expression createName(Node node, IdentifierToken name) {
        if (!this.isDefined(name.image())) {
            throw new IllegalStateException();
        }
        LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
        l.add(name);
        return new QualifiedName(l);
    }

    @Override
    public Class<?> lookupClass(String cname) throws ClassNotFoundException {
        return this.importationManager.lookupClass(cname, null);
    }

    @Override
    public Class<?> lookupClass(String cname, String ccname) throws ClassNotFoundException {
        return this.importationManager.lookupClass(cname, ccname);
    }

    @Override
    public Class<?> setProperties(SimpleAllocation node, Class<?> c, Class<?>[] cargs) {
        Constructor cons = null;
        try {
            cons = this.lookupConstructor(c, cargs);
        }
        catch (WrongVersionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("type", c);
        node.setProperty("constructor", cons);
        return c;
    }

    @Override
    public Class<?> setProperties(ClassAllocation node, Class<?> c, Class<?>[] args, List<Node> memb) {
        String cname = new StringBuffer().append("TopLevel$").append(classCount++).toString();
        FieldDeclaration fd = new FieldDeclaration(9, CLASS_TYPE, "declaring$Class$Reference$0", OBJECT_CLASS);
        memb.add(fd);
        memb.add(LOCALS);
        fd = new FieldDeclaration(9, OBJECT_ARRAY_ARRAY, "local$Variables$Class$0", this.createClassArrayInitializer());
        memb.add(fd);
        LinkedList<FormalParameter> params = new LinkedList<FormalParameter>();
        LinkedList<Node> stmts = new LinkedList<Node>();
        params.add(new FormalParameter(false, MAP_TYPE, "param$0"));
        LinkedList<Expression> superArgs = new LinkedList<Expression>();
        for (int i = 0; i < args.length; ++i) {
            params.add(new FormalParameter(false, TreeUtilities.classToType(args[i]), new StringBuffer().append("param$").append(i + 1).toString()));
            LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
            l.add(new Identifier(new StringBuffer().append("param$").append(i + 1).toString()));
            superArgs.add(new QualifiedName(l));
        }
        ConstructorInvocation ci = null;
        if (superArgs.size() > 0) {
            ci = new ConstructorInvocation(null, superArgs, true);
        }
        LinkedList<IdentifierToken> p1 = new LinkedList<IdentifierToken>();
        p1.add(new Identifier(LOCALS_NAME));
        LinkedList<IdentifierToken> p2 = new LinkedList<IdentifierToken>();
        p2.add(new Identifier("param$0"));
        stmts.add(new SimpleAssignExpression(new QualifiedName(p1), new QualifiedName(p2)));
        ConstructorDeclaration csd = new ConstructorDeclaration(1, cname, params, new LinkedList(), ci, stmts);
        memb.add(csd);
        ReferenceType ext = null;
        LinkedList<ReferenceType> impl = null;
        if (c.isInterface()) {
            impl = new LinkedList<ReferenceType>();
            LinkedList<IdentifierToken> intf = new LinkedList<IdentifierToken>();
            intf.add(new Identifier(c.getName()));
            impl.add(new ReferenceType(intf));
        } else {
            LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
            l.add(new Identifier(c.getName()));
            ext = new ReferenceType(l);
        }
        ClassDeclaration type = new ClassDeclaration(1, cname, ext, impl, memb);
        type.setProperty("anonymousDeclaringClass", new JavaClassInfo(class$java$lang$Object == null ? (class$java$lang$Object = GlobalContext.class$("java.lang.Object")) : class$java$lang$Object));
        Class<?> cl = new TreeCompiler(this.interpreter).compileTree(this, type);
        Class[] tmp = new Class[args.length + 1];
        tmp[0] = class$java$util$Map == null ? (class$java$util$Map = GlobalContext.class$("java.util.Map")) : class$java$util$Map;
        for (int i = 1; i < tmp.length; ++i) {
            tmp[i] = args[i - 1];
        }
        args = tmp;
        try {
            node.setProperty("constructor", this.lookupConstructor(cl, args));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        node.setProperty("type", cl);
        return cl;
    }

    protected ArrayInitializer createClassArrayInitializer() {
        LinkedList<Expression> cells = new LinkedList<Expression>();
        Type tp = new ReferenceType((class$java$lang$Object == null ? (class$java$lang$Object = GlobalContext.class$("java.lang.Object")) : class$java$lang$Object).getName());
        Map<String, Object> m = this.getConstants();
        for (String s : m.keySet()) {
            LinkedList<Expression> pair = new LinkedList<Expression>();
            pair.add(new StringLiteral(new StringBuffer().append('\"').append(s).append('\"').toString()));
            Class c = (Class)m.get(s);
            pair.add(new TypeExpression(TreeUtilities.classToType(c)));
            ArrayInitializer cell = new ArrayInitializer(pair);
            cell.setElementType(tp);
            cells.add(cell);
        }
        tp = new ArrayType(tp, 1);
        ArrayInitializer ai = new ArrayInitializer(cells);
        ai.setElementType(tp);
        return ai;
    }

    @Override
    public Constructor lookupConstructor(Class<?> c, Class<?>[] params) throws NoSuchMethodException {
        Constructor cons = ReflectionUtilities.lookupConstructor(c, params);
        this.setAccessFlag(cons);
        return cons;
    }

    @Override
    public Object invokeConstructor(SimpleAllocation node, Object[] args) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        try {
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    public Object invokeConstructor(ClassAllocation node, Object[] args) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        Object[] t = new Object[args.length + 1];
        t[0] = this.getConstants();
        for (int i = 1; i < t.length; ++i) {
            t[i] = args[i - 1];
        }
        args = t;
        try {
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    public Method lookupMethod(Node prefix, String mname, Class<?>[] params) throws NoSuchMethodException {
        Class<?> c = NodeProperties.getType(prefix);
        Method m = ReflectionUtilities.lookupMethod(c, mname, params);
        this.setAccessFlag(m);
        if (m.getName().equals("clone")) {
            m.setAccessible(true);
        }
        return m;
    }

    @Override
    public MethodDeclaration lookupFunction(String mname, Class<?>[] params) throws NoSuchFunctionException {
        ReflectionUtilities.TigerUsage tu;
        int i;
        Iterator<FormalParameter> it2;
        Class[] p;
        List<FormalParameter> l;
        Iterator<MethodDeclaration> it = this.functions.iterator();
        LinkedList<MethodDeclaration> f = new LinkedList<MethodDeclaration>();
        LinkedList<MethodDeclaration> compatible = new LinkedList<MethodDeclaration>();
        while (it.hasNext()) {
            MethodDeclaration md = it.next();
            if (!md.getName().equals(mname)) continue;
            f.add(md);
        }
        for (MethodDeclaration md : f) {
            l = md.getParameters();
            if (l.size() != params.length) {
                // empty if block
            }
            p = new Class[l.size()];
            it2 = l.iterator();
            i = 0;
            while (it2.hasNext()) {
                p[i++] = NodeProperties.getType(it2.next());
            }
            if (!ReflectionUtilities.hasCompatibleSignatures(p, params)) continue;
            compatible.add(md);
        }
        if (!compatible.isEmpty()) {
            return ReflectionUtilities.selectTheMostSpecificFunction(compatible);
        }
        for (MethodDeclaration md : f) {
            l = md.getParameters();
            if (l.size() != params.length) continue;
            p = new Class[l.size()];
            it2 = l.iterator();
            i = 0;
            while (it2.hasNext()) {
                p[i++] = NodeProperties.getType(it2.next());
            }
            tu = new ReflectionUtilities.TigerUsage();
            if (!ReflectionUtilities.hasAutoBoxingCompatibleSignatures(p, params, tu)) continue;
            compatible.add(md);
        }
        if (!compatible.isEmpty()) {
            return ReflectionUtilities.selectTheMostSpecificBoxingFunction(compatible);
        }
        for (MethodDeclaration md : f) {
            l = md.getParameters();
            p = new Class[l.size()];
            it2 = l.iterator();
            i = 0;
            while (it2.hasNext()) {
                p[i++] = NodeProperties.getType(it2.next());
            }
            tu = new ReflectionUtilities.TigerUsage();
            if (!ReflectionUtilities.hasVarArgsCompatibleSignatures(p, params, tu)) continue;
            tu.checkForCompatibleUsage();
            compatible.add(md);
        }
        if (compatible.isEmpty()) {
            throw new NoSuchFunctionException(new StringBuffer().append("No such function: ").append(mname).toString());
        }
        if (compatible.size() == 1) {
            return (MethodDeclaration)compatible.get(0);
        }
        throw new NoSuchFunctionException(new StringBuffer().append("Ambiguous Methods: ").append(mname).append(" ").append(((MethodDeclaration)compatible.get(0)).getParameters()).append(",  ").append(((MethodDeclaration)compatible.get(1)).getParameters()).toString());
    }

    @Override
    public Method lookupSuperMethod(Node node, String mname, Class<?>[] params) throws NoSuchMethodException {
        throw new ExecutionError("super.method", node);
    }

    @Override
    public Field getField(Class<?> fc, String fn) throws NoSuchFieldException, AmbiguousFieldException {
        Field f = ReflectionUtilities.getField(fc, fn);
        this.setAccessFlag(f);
        return f;
    }

    @Override
    public Field getSuperField(Node node, String fn) throws NoSuchFieldException, AmbiguousFieldException {
        throw new ExecutionError("super.field", node);
    }

    protected void setAccessFlag(Member m) {
        int mods = m.getModifiers();
        Class<?> c = m.getDeclaringClass();
        int cmods = c.getModifiers();
        String pkg = this.importationManager.getCurrentPackage();
        String mp = this.getPackageName(c);
        boolean samePkg = pkg.equals(mp);
        if (this.getAccessible()) {
            ((AccessibleObject)((Object)m)).setAccessible(true);
        }
        if (Modifier.isPublic(cmods) || samePkg) {
            if (Modifier.isPublic(mods)) {
                ((AccessibleObject)((Object)m)).setAccessible(true);
            } else if (Modifier.isProtected(mods)) {
                if (samePkg) {
                    ((AccessibleObject)((Object)m)).setAccessible(true);
                }
            } else if (!Modifier.isPrivate(mods) && samePkg) {
                ((AccessibleObject)((Object)m)).setAccessible(true);
            }
        }
    }

    protected String getPackageName(Class<?> c) {
        String s = c.getName();
        int i = s.lastIndexOf(46);
        return i == -1 ? "" : s.substring(0, i);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompilationUnitVisitor
    extends VisitorObject<Boolean> {
        private String className;
        private String currentPackage;
        private ImportationManager importationManager;
        private TreeClassLoader classLoader;

        public CompilationUnitVisitor(String cname) {
            this.className = cname;
            this.importationManager = new BufferedImportationManager(new PseudoClassLoader());
            this.classLoader = (TreeClassLoader)GlobalContext.this.interpreter.getClassLoader();
        }

        public CompilationUnitVisitor(String cname, ImportationManager im) {
            this.className = cname;
            this.importationManager = im;
            this.importationManager.setClassLoader(new PseudoClassLoader());
            this.classLoader = (TreeClassLoader)GlobalContext.this.interpreter.getClassLoader();
        }

        @Override
        public Boolean visit(PackageDeclaration node) {
            this.importationManager.setCurrentPackage(node.getName());
            return null;
        }

        @Override
        public Boolean visit(ImportDeclaration node) {
            if (node.isStatic()) {
                try {
                    TigerUtilities.assertTigerEnabled("Static Import is not supported before Java 1.5");
                    if (node.isStaticImportClass()) {
                        this.importationManager.declareClassStaticImport(node.getName());
                    }
                    this.importationManager.declareMemberStaticImport(node.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(new StringBuffer().append("Uncaught ClassNotFoundException has been thrown: ").append(e.toString()).toString());
                }
            } else if (node.isPackage()) {
                this.importationManager.declarePackageImport(node.getName());
            } else {
                try {
                    this.importationManager.declareClassImport(node.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                catch (PseudoError pseudoError) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Boolean visit(ClassDeclaration node) {
            return this.visitType(node);
        }

        @Override
        public Boolean visit(InterfaceDeclaration node) {
            return this.visitType(node);
        }

        private Boolean visitType(TypeDeclaration node) {
            String cname = this.importationManager.getCurrentPackage();
            cname = new StringBuffer().append(cname.equals("") ? "" : new StringBuffer().append(cname).append(".").toString()).append(node.getName()).toString();
            this.classLoader.addTree(cname, node);
            node.setProperty("importationManager", this.importationManager);
            if (this.className.equals(cname)) {
                return Boolean.TRUE;
            }
            MembersVisitor v = new MembersVisitor(cname);
            Iterator<Node> it = node.getMembers().iterator();
            while (it.hasNext()) {
                Boolean b = it.next().acceptVisitor(v);
                if (!b.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public /* synthetic */ Object visit(InstanceInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(VariableDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FieldDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FormalParameter x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MethodDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorDeclaration x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InterfaceDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BlockStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAssignExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConditionalExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(OrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ExclusiveOrExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BitAndExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InstanceOfExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessOrEqualExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(GreaterExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LessExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(UnsignedShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftRightExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ShiftLeftExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SubtractExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AddExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(RemainderExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DivideExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MultiplyExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(MinusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PlusExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ComplementExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(NotExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CastExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(InnerAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ClassAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SimpleAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAllocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayInitializer x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PreIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostDecrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PostIncrement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TypeExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReferenceType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PrimitiveType x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ConstructorInvocation x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(FunctionCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectMethodCall x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SuperFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ArrayAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(StaticFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ObjectFieldAccess x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(QualifiedName x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThisExpression x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(Literal x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(AssertStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenElseStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(IfThenStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ContinueStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SynchronizedStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ReturnStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ThrowStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(CatchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(TryStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(BreakStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(LabeledStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchBlock x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(SwitchStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(DoStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForEachStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ForStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(WhileStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(EmptyStatement x0) {
            return super.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(ImportDeclaration x0) {
            return this.visit(x0);
        }

        @Override
        public /* synthetic */ Object visit(PackageDeclaration x0) {
            return this.visit(x0);
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MembersVisitor
        extends VisitorObject<Boolean> {
            private String outerName;

            public MembersVisitor(String cname) {
                this.outerName = cname;
            }

            @Override
            public Boolean visit(ClassDeclaration node) {
                return this.visitType(node);
            }

            @Override
            public Boolean visit(InterfaceDeclaration node) {
                return this.visitType(node);
            }

            private Boolean visitType(TypeDeclaration node) {
                if (CompilationUnitVisitor.this.className.equals(new StringBuffer().append(this.outerName).append("$").append(node.getName()).toString())) {
                    return Boolean.TRUE;
                }
                MembersVisitor v = new MembersVisitor(new StringBuffer().append(this.outerName).append("$").append(node.getName()).toString());
                Iterator<Node> it = node.getMembers().iterator();
                while (it.hasNext()) {
                    Boolean b = it.next().acceptVisitor(v);
                    if (!b.booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public /* synthetic */ Object visit(InstanceInitializer x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ClassInitializer x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(VariableDeclaration x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(FieldDeclaration x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(FormalParameter x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(MethodDeclaration x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ConstructorDeclaration x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(InterfaceDeclaration x0) {
                return this.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ClassDeclaration x0) {
                return this.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(BlockStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(BitOrAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ExclusiveOrAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(BitAndAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(UnsignedShiftRightAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ShiftRightAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ShiftLeftAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SubtractAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(AddAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(RemainderAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(DivideAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(MultiplyAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SimpleAssignExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ConditionalExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(OrExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(AndExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(BitOrExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ExclusiveOrExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(BitAndExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(NotEqualExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(EqualExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(InstanceOfExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(GreaterOrEqualExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(LessOrEqualExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(GreaterExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(LessExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(UnsignedShiftRightExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ShiftRightExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ShiftLeftExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SubtractExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(AddExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(RemainderExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(DivideExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(MultiplyExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(MinusExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(PlusExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ComplementExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(NotExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(CastExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(InnerClassAllocation x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(InnerAllocation x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ClassAllocation x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SimpleAllocation x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ArrayAllocation x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ArrayInitializer x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(PreDecrement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(PreIncrement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(PostDecrement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(PostIncrement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(TypeExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ArrayType x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ReferenceType x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(PrimitiveType x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SuperMethodCall x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ConstructorInvocation x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(StaticMethodCall x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(FunctionCall x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ObjectMethodCall x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SuperFieldAccess x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ArrayAccess x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(StaticFieldAccess x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ObjectFieldAccess x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(QualifiedName x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ThisExpression x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(Literal x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(AssertStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(IfThenElseStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(IfThenStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ContinueStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SynchronizedStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ReturnStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ThrowStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(CatchStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(TryStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(BreakStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(LabeledStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SwitchBlock x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(SwitchStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(DoStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ForEachStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ForStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(WhileStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(EmptyStatement x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(ImportDeclaration x0) {
                return super.visit(x0);
            }

            @Override
            public /* synthetic */ Object visit(PackageDeclaration x0) {
                return super.visit(x0);
            }
        }
    }

    protected class PseudoError
    extends Error {
        protected PseudoError() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PseudoClassLoader
    extends ClassLoader {
        protected PseudoClassLoader() {
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            ImportationManager im;
            CompilationUnitVisitor v;
            ClassLoader cl;
            try {
                if (GlobalContext.this.getAdditionalClassLoader() != null) {
                    return Class.forName(name, true, GlobalContext.this.getAdditionalClassLoader());
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            ClassLoader classLoader = cl = GlobalContext.this.classLoader == null ? GlobalContext.this.interpreter.getClassLoader() : GlobalContext.this.classLoader;
            if (cl instanceof TreeClassLoader && ((TreeClassLoader)cl).hasDefined(name)) {
                throw new PseudoError();
            }
            TreeClassLoader cld = (TreeClassLoader)GlobalContext.this.interpreter.getClassLoader();
            TypeDeclaration td = cld.getTree(name);
            if (td != null && td.acceptVisitor(v = new CompilationUnitVisitor(name, im = (ImportationManager)td.getProperty("importationManager"))).equals(Boolean.TRUE)) {
                throw new PseudoError();
            }
            LibraryFinder lf = GlobalContext.this.interpreter.getLibraryFinder();
            try {
                ImportationManager im2;
                CompilationUnitVisitor v2;
                String cun = lf.findCompilationUnitName(name);
                td = cld.getTree(cun);
                if (td != null && td.acceptVisitor(v2 = new CompilationUnitVisitor(name, im2 = (ImportationManager)td.getProperty("importationManager"))).equals(Boolean.TRUE)) {
                    throw new PseudoError();
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                File f = lf.findCompilationUnit(name);
                FileInputStream fis = new FileInputStream(f);
                ParserFactory pf = GlobalContext.this.interpreter.getParserFactory();
                SourceCodeParser p = pf.createParser(fis, f.getCanonicalPath());
                List<Node> stmts = p.parseCompilationUnit();
                Iterator<Node> it = stmts.iterator();
                CompilationUnitVisitor v3 = new CompilationUnitVisitor(name);
                boolean classFound = false;
                while (it.hasNext()) {
                    if (!Boolean.TRUE.equals(it.next().acceptVisitor(v3))) continue;
                    classFound = true;
                }
                if (classFound) {
                    throw new PseudoError();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new ClassNotFoundException(name);
        }
    }
}

