/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.context;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TreeCompiler;
import koala.dynamicjava.interpreter.context.AbstractVariable;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.interpreter.modifier.SuperFieldModifier;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.ReflectionUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticContext
extends GlobalContext {
    protected Class<?> declaringClass;
    protected Node defaultQualifier;
    static /* synthetic */ Class class$java$util$Map;

    public StaticContext(Interpreter i, Class<?> c, ImportationManager im) {
        super(i);
        this.declaringClass = c;
        this.importationManager = im;
        this.defaultQualifier = new ReferenceType(c.getName());
    }

    public StaticContext(Interpreter i, Class<?> c, Set<AbstractVariable> fp) {
        super(i, fp);
        this.declaringClass = c;
        this.defaultQualifier = new ReferenceType(c.getName());
    }

    @Override
    public boolean isDefined(String name) {
        return this.isDefinedVariable(name) || this.fieldExists(name);
    }

    @Override
    public Field getField(Class<?> fc, String fn) throws NoSuchFieldException, AmbiguousFieldException {
        Field f;
        try {
            f = ReflectionUtilities.getField(fc, fn);
        }
        catch (Exception e) {
            f = InterpreterUtilities.getOuterField(fc, fn);
        }
        this.setAccessFlag(f);
        return f;
    }

    @Override
    public Expression createName(Node node, IdentifierToken name) {
        if (this.isDefinedVariable(name.image())) {
            return super.createName(node, name);
        }
        String fname = name.image();
        try {
            ReflectionUtilities.getField(this.declaringClass, fname);
            return new StaticFieldAccess((ReferenceType)this.defaultQualifier, fname);
        }
        catch (Exception e) {
            try {
                Field f = InterpreterUtilities.getOuterField(this.declaringClass, fname);
                Class<?> c = f.getDeclaringClass();
                return new StaticFieldAccess(new ReferenceType(c.getName()), fname);
            }
            catch (Exception ex) {
                throw new CatchedExceptionError(ex, node);
            }
        }
    }

    @Override
    public Node getDefaultQualifier(Node node) {
        return this.defaultQualifier;
    }

    @Override
    public LeftHandSideModifier getModifier(SuperFieldAccess node) {
        return new SuperFieldModifier((Field)node.getProperty("field"), node);
    }

    @Override
    public Method lookupMethod(Node prefix, String mname, Class<?>[] params) throws NoSuchMethodException {
        Class<?> c = NodeProperties.getType(prefix);
        Method m = null;
        try {
            m = ReflectionUtilities.lookupMethod(c, mname, params);
            this.setAccessFlag(m);
            if (m.getName().equals("clone")) {
                m.setAccessible(true);
            }
            return m;
        }
        catch (NoSuchMethodException e) {
            if (prefix instanceof ReferenceType && c == this.declaringClass) {
                m = InterpreterUtilities.lookupOuterMethod(c, mname, params);
                m.setAccessible(true);
                return m;
            }
            throw e;
        }
    }

    @Override
    public Field getSuperField(Node node, String fn) throws NoSuchFieldException, AmbiguousFieldException {
        Class<?> sc = this.declaringClass.getSuperclass();
        Field result = ReflectionUtilities.getField(sc, fn);
        this.setAccessFlag(result);
        return result;
    }

    @Override
    public Class<?> lookupClass(String cname) throws ClassNotFoundException {
        try {
            return this.importationManager.lookupClass(cname, this.declaringClass.getName());
        }
        catch (ClassNotFoundException e) {
            Class<?> dc = this.declaringClass.getDeclaringClass();
            if (dc != null) {
                try {
                    return this.importationManager.lookupClass(cname, dc.getName());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            for (dc = this.declaringClass.getSuperclass(); dc != null; dc = dc.getSuperclass()) {
                try {
                    return this.importationManager.lookupClass(cname, dc.getName());
                }
                catch (Exception ex) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void defineFunction(MethodDeclaration node) {
        throw new IllegalStateException("internal.error");
    }

    @Override
    public void defineClass(TypeDeclaration node) {
        throw new ExecutionError("not.implemented");
    }

    @Override
    public Class<?> setProperties(ClassAllocation node, Class<?> c, Class<?>[] args, List<Node> memb) {
        String dname = this.declaringClass.getName();
        String cname = new StringBuffer().append(dname).append("$").append(classCount++).toString();
        FieldDeclaration fd = new FieldDeclaration(9, CLASS_TYPE, "declaring$Class$Reference$0", new TypeExpression(new ReferenceType(dname)));
        memb.add(fd);
        memb.add(LOCALS);
        fd = new FieldDeclaration(9, OBJECT_ARRAY_ARRAY, "local$Variables$Class$0", this.createClassArrayInitializer());
        memb.add(fd);
        LinkedList<FormalParameter> params = new LinkedList<FormalParameter>();
        LinkedList<Node> stmts = new LinkedList<Node>();
        params.add(new FormalParameter(false, MAP_TYPE, "param$0"));
        LinkedList<Expression> superArgs = new LinkedList<Expression>();
        for (int i = 0; i < args.length; ++i) {
            params.add(new FormalParameter(false, TreeUtilities.classToType(args[i]), new StringBuffer().append("param$").append(i + 1).toString()));
            LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
            l.add(new Identifier(new StringBuffer().append("param$").append(i + 1).toString()));
            superArgs.add(new QualifiedName(l));
        }
        ConstructorInvocation ci = null;
        if (superArgs.size() > 0) {
            ci = new ConstructorInvocation(null, superArgs, true);
        }
        LinkedList<IdentifierToken> p1 = new LinkedList<IdentifierToken>();
        p1.add(new Identifier("local$Variables$Reference$0"));
        LinkedList<IdentifierToken> p2 = new LinkedList<IdentifierToken>();
        p2.add(new Identifier("param$0"));
        stmts.add(new SimpleAssignExpression(new QualifiedName(p1), new QualifiedName(p2)));
        ConstructorDeclaration csd = new ConstructorDeclaration(1, cname, params, new LinkedList(), ci, stmts);
        memb.add(csd);
        ReferenceType ext = null;
        LinkedList<ReferenceType> impl = null;
        if (c.isInterface()) {
            impl = new LinkedList<ReferenceType>();
            LinkedList<IdentifierToken> intf = new LinkedList<IdentifierToken>();
            intf.add(new Identifier(c.getName()));
            impl.add(new ReferenceType(intf));
        } else {
            LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
            l.add(new Identifier(c.getName()));
            ext = new ReferenceType(l);
        }
        ClassDeclaration type = new ClassDeclaration(1, cname, ext, impl, memb);
        type.setProperty("anonymousDeclaringClass", new JavaClassInfo(this.declaringClass));
        Class<?> cl = new TreeCompiler(this.interpreter).compileTree(this, type);
        Class[] tmp = new Class[args.length + 1];
        tmp[0] = class$java$util$Map == null ? (class$java$util$Map = StaticContext.class$("java.util.Map")) : class$java$util$Map;
        for (int i = 1; i < tmp.length; ++i) {
            tmp[i] = args[i - 1];
        }
        args = tmp;
        try {
            node.setProperty("constructor", this.lookupConstructor(cl, args));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        node.setProperty("type", cl);
        return cl;
    }

    @Override
    public Method lookupSuperMethod(Node node, String mname, Class<?>[] params) throws NoSuchMethodException {
        Method m = null;
        try {
            m = ReflectionUtilities.lookupMethod(this.declaringClass, new StringBuffer().append("super$").append(mname).toString(), params);
        }
        catch (NoSuchMethodException e) {
            m = ReflectionUtilities.lookupMethod(this.declaringClass, mname, params);
        }
        this.setAccessFlag(m);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean classExists(String name) {
        boolean result = false;
        this.importationManager.setClassLoader(new GlobalContext.PseudoClassLoader());
        try {
            this.importationManager.lookupClass(name, this.declaringClass.getName());
            result = true;
        }
        catch (ClassNotFoundException e) {
        }
        catch (GlobalContext.PseudoError e) {
            result = true;
        }
        finally {
            if (this.classLoader == null) {
                this.importationManager.setClassLoader(this.interpreter.getClassLoader());
            } else {
                this.importationManager.setClassLoader(this.classLoader);
            }
        }
        return result;
    }

    @Override
    protected void setAccessFlag(Member m) {
        int mods = m.getModifiers();
        Class<?> c = m.getDeclaringClass();
        int cmods = c.getModifiers();
        String pkg = this.importationManager.getCurrentPackage();
        String mp = this.getPackageName(c);
        boolean samePkg = pkg.equals(mp);
        if (Modifier.isPublic(cmods) || samePkg) {
            if (Modifier.isPublic(mods)) {
                ((AccessibleObject)((Object)m)).setAccessible(true);
            } else if (Modifier.isProtected(mods)) {
                if (c.isAssignableFrom(this.declaringClass.getSuperclass()) || samePkg) {
                    ((AccessibleObject)((Object)m)).setAccessible(true);
                }
            } else if (!Modifier.isPrivate(mods)) {
                if (samePkg) {
                    ((AccessibleObject)((Object)m)).setAccessible(true);
                }
            } else if (this.declaringClass == c || this.isInnerClass(this.declaringClass, c)) {
                ((AccessibleObject)((Object)m)).setAccessible(true);
            }
        }
    }

    protected boolean isInnerClass(Class<?> c1, Class<?> c2) {
        Field f;
        Class c = c1.getDeclaringClass();
        if (c == null) {
            try {
                f = c1.getField("declaring$Class$Reference$0");
                c = (Class)f.get(null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        c1 = c;
        while (c != null) {
            if (c == c2) {
                return true;
            }
            if ((c = c.getDeclaringClass()) == null) {
                try {
                    f = c1.getField("declaring$Class$Reference$0");
                    c = (Class)f.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            c1 = c;
        }
        return false;
    }

    protected boolean fieldExists(String name) {
        boolean result = false;
        try {
            ReflectionUtilities.getField(this.declaringClass, name);
            result = true;
        }
        catch (NoSuchFieldException e) {
            try {
                InterpreterUtilities.getOuterField(this.declaringClass, name);
                result = true;
            }
            catch (NoSuchFieldException ex) {
            }
            catch (AmbiguousFieldException ex) {
                result = true;
            }
        }
        catch (AmbiguousFieldException e) {
            result = true;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

