/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class WindowsTableHeaderUI
extends com.sun.java.swing.plaf.windows.WindowsTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent h) {
        return new WindowsTableHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.originalHeaderRenderer = this.header.getDefaultRenderer();
        if (this.originalHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new PatchedTableCellRenderer());
        }
    }

    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof PatchedTableCellRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(c);
    }

    private static class PatchedTableCellRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private PatchedTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            String txtValue = value == null ? " " : value.toString();
            this.setText(txtValue.length() > 0 ? txtValue : " ");
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

