/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.util.Types;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ASingleAnnotationsAttributeInfo
extends AAnnotationsAttributeInfo {
    public ASingleAnnotationsAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) {
        super(name, data, cp);
    }

    public int getAnnotationCount() throws ClassFormatError {
        int res = Types.ushortFromBytes(this._data, 0);
        assert (res <= 65535);
        return res;
    }

    public AAnnotationsAttributeInfo.Annotation[] getAnnotations() throws ClassFormatError {
        int count = this.getAnnotationCount();
        AAnnotationsAttributeInfo.Annotation[] ann = new AAnnotationsAttributeInfo.Annotation[count];
        int index = 2;
        for (int i = 0; i < count; i = (int)((short)(i + 1))) {
            ann[i] = new AAnnotationsAttributeInfo.Annotation(this._constantPool, this._data, index);
            index += ann[i].getSize();
        }
        return ann;
    }

    public void setAnnotations(AAnnotationsAttributeInfo.Annotation[] ann) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(Types.bytesFromShort((short)ann.length));
        for (int i = 0; i < ann.length; ++i) {
            ann[i].writeToByteArrayOutputStream(this._constantPool, baos);
        }
        this.setData(baos.toByteArray());
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name + " <" + this.getAnnotationCount() + " annotations { ");
        boolean first = true;
        for (AAnnotationsAttributeInfo.Annotation ann : this.getAnnotations()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            x.append(ann.toString());
        }
        x.append(" } >");
        return x.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

