/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.IAttributeVisitor;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.NameAndTypePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckClassVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckNameAndTypeVisitor;
import edu.rice.cs.cunit.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnclosingMethodAttributeInfo
extends AAttributeInfo {
    public EnclosingMethodAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    public ClassPoolInfo getEnclosingClass() throws ClassFormatError {
        return ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 0))).execute(CheckClassVisitor.singleton(), null);
    }

    public void setSourceFileName(ClassPoolInfo newClass) {
        Types.bytesFromShort(this._constantPool.indexOf(newClass), this._data, 0);
    }

    public NameAndTypePoolInfo getEnclosingMethod() throws ClassFormatError {
        return ((APoolInfo)this._constantPool.get(Types.ushortFromBytes(this._data, 2))).execute(CheckNameAndTypeVisitor.singleton(), null);
    }

    public void setEnclosinMethod(ClassPoolInfo newMethod) {
        Types.bytesFromShort(this._constantPool.indexOf(newMethod), this._data, 2);
    }

    @Override
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.enclosingMethodCase(this, param);
    }

    @Override
    public void adjustPC(int startPC, int deltaPC) {
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        try {
            return "EnclosingMethod <Class = " + this.getEnclosingClass().toString() + ", Method = " + this.getEnclosingMethod().toStringVerbose() + " >";
        }
        catch (ClassFormatError cfe) {
            if (cfe.getMessage().startsWith("Info is of type ") && cfe.getMessage().endsWith(", needs to be NameAndType")) {
                return "EnclosingMethod: <unknown; encountered EmptyPoolInfo>";
            }
            throw cfe;
        }
    }

    public static String getAttributeName() {
        return "EnclosingMethod";
    }
}

